/*
 * Decompiled with CFR 0.152.
 */
package com.sas.scheduler.schmgr;

import com.sas.plugins.PluginResourceBundle;
import com.sas.scheduler.model.SchedulerException;
import com.sas.scheduler.schmgr.FlowNode;
import com.sas.scheduler.schmgr.FlowPFDScrollView;
import com.sas.scheduler.schmgr.ScheduleManager;
import com.sas.scheduler.schmgr.visuals.AddJobDialog;
import com.sas.scheduler.server.ServerFlowInfo;
import com.sas.scheduler.server.ServerJobInfo;
import com.sas.scheduler.visuals.swing.IconUtil;
import com.sas.scheduler.visuals.swing.MessageUtil;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.Workspace;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;

public class AddJobAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final PluginResourceBundle m_bundle = new PluginResourceBundle(AddJobAction.class);
    private ServerFlowInfo m_info;
    private ScheduleManager m_schmgr;
    private FlowNode m_node;

    public AddJobAction(ServerFlowInfo flow, ScheduleManager plugin, FlowNode node) {
        this.m_info = flow;
        this.m_schmgr = plugin;
        this.m_node = node;
        String nameText = m_bundle.getString("AddJobAction.Name.txt");
        this.putValue("Name", Util.getLabelWithoutMnemonic((String)nameText));
        this.putValue("MnemonicKey", Util.getDisplayedMnemonic((String)nameText));
        this.putValue("SmallIcon", IconUtil.getIcon((String)IconUtil.ACTION_AddJob));
        this.putValue("ShortDescription", m_bundle.getString("AddJobAction.ShortDescription.txt"));
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            List jobs = this.m_info.getJobs();
            int nodeCount = jobs.size();
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 0; i < nodeCount; ++i) {
                list.add(jobs.get(i).toString());
            }
            AddJobDialog dlg = new AddJobDialog(this.m_schmgr, this.m_info, list);
            dlg.makeVisible();
            List<ServerJobInfo> addedJobs = dlg.getAddedJobs();
            if (dlg.isJobAdded() && addedJobs != null && addedJobs.size() > 0) {
                for (int i = 0; i < addedJobs.size(); ++i) {
                    ServerJobInfo job = addedJobs.get(i);
                    this.m_node.addJobNode(job);
                }
                if (this.m_info.isFlowSubmitted() && this.m_schmgr.isAutoReschedule() && !this.m_schmgr.interactiveAutoSubmit(this.m_info)) {
                    MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)m_bundle.messageString("AddJobAction.ReSubmitFlowFailed.msg.fmt", (Object)this.m_info.getName()), (String)m_bundle.getString("AddJobAction.Title.txt"), (int)2);
                }
                if (this.m_node.getCustomView() instanceof FlowPFDScrollView) {
                    ((FlowPFDScrollView)this.m_node.getCustomView()).updateFlowList();
                }
            }
        }
        catch (SchedulerException ex) {
            Workspace.getDefaultLogger().debug((Object)ex.getMessage());
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("AddJobAction.Title.txt"), (int)0);
        }
        catch (RemoteException ex) {
            Workspace.handleRemoteException((RemoteException)ex);
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)ex.getLocalizedMessage(), (String)m_bundle.getString("AddJobAction.Title.txt"), (int)0);
        }
        catch (Exception e) {
            Workspace.getDefaultLogger().debug((Object)e.getMessage());
            MessageUtil.displayMessage((Frame)this.m_schmgr.getMainFrame(), (String)e.getLocalizedMessage(), (String)m_bundle.getString("AddJobAction.Title.txt"), (int)0);
        }
    }
}

