/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.ssl;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.net.rmi.RMIExportConfiguration;
import com.sas.net.ssl.GetPropertyAction;
import com.sas.net.ssl.RB;
import com.sas.net.ssl.SSLRMIClientSocketFactory;
import com.sas.net.ssl.SSLRMIConfigurationException;
import com.sas.net.ssl.SSLRMIException;
import com.sas.net.ssl.SSLRMIServerSocketFactory;
import com.sas.net.ssl.SecurityKeyStore;
import com.sas.net.ssl.SocketFactoryConfig;
import com.sas.text.Message;
import com.sas.util.SasPasswordEncodingException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.net.ssl.KeyManagerFactory;
import org.apache.logging.log4j.LogManager;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public final class SSLRMIConfiguration
implements RMIExportConfiguration {
    public static final String PROPERTY_NAME_SSL_MODE = "com.sas.net.ssl.mode";
    public static final String PROPERTY_NAME_PLATFORM_PORT = "com.sas.net.rmi.platformPort";
    public static final String PROPERTY_NAME_SSL_PLATFORM_PORT = "com.sas.net.ssl.platformPort";
    public static final String PROPERTY_NAME_SERVER_SOCKET_FACTORY_CLASS = "com.sas.net.rmi.RMIServerSocketFactory";
    public static final String PROPERTY_NAME_CLIENT_SOCKET_FACTORY_CLASS = "com.sas.net.rmi.RMIClientSocketFactory";
    public static final String PROPERTY_NAME_SSL_IS_AUTHENTICATING_CLIENTS = "com.sas.net.ssl.isAuthenticatingClients";
    public static final String PROPERTY_NAME_JSSE_KEYSTORE_FILE = "javax.net.ssl.keyStore";
    public static final String PROPERTY_NAME_JSSE_KEYSTORE_PASSWORD = "javax.net.ssl.keyStorePassword";
    public static final String PROPERTY_NAME_JSSE_TRUSTSTORE_FILE = "javax.net.ssl.trustStore";
    public static final String PROPERTY_NAME_JSSE_TRUSTSTORE_PASSWORD = "javax.net.ssl.trustStorePassword";
    public static final String PROPERTY_NAME_SSL_IS_OK_TO_RELAX_SELECTION_POLICY = "com.sas.net.ssl.isOKToRelaxSelectionPolicy";
    public static final String PROPERTY_NAME_SSL_SELECTION_CONFIG_FILE = "com.sas.net.ssl.selectionConfigFile";
    public static final String PROPERTY_NAME_SSL_PROTOCOL = "com.sas.net.ssl.protocol";
    private static final String PROTOCOL_SSL_TLS = "SSL_TLS";
    private static final String PROTOCOL_TLS = "TLS";
    public static final String PROPERTY_NAME_IS_REUSE_SERVERSOCKET = "com.sas.net.ssl.isReuseServerSocket";
    public static final String PROPERTY_NAME_IS_REUSE_SOCKET = "com.sas.net.ssl.isReuseSocket";
    private static final String SSL_SELECTION_DEFAULT_CONFIG_FILE = "sas_ssl_rmi_selection.config";
    public static final String SSL_SELECTION_MODE_NONE = "None";
    public static final String SSL_SELECTION_MODE_ALL = "All";
    public static final String SSL_SELECTION_MODE_SOME = "Some";
    public static final String SYSTEM_PROPERTY_NAME_SSL_RMI_CONFIG_FILE_URL = "com.sas.net.ssl.configurationURL";
    private String _sslControlMode = "None";
    private boolean _isOKToRelaxSelectionPolicy;
    private boolean _isAuthenticatingServer;
    private boolean _isAuthenticatingClients;
    private Boolean _isReuseServerSocket;
    private Boolean _isReuseSocket;
    private static final int TYPICAL_MAP_SIZE = 200;
    private final Map<String, Boolean> classNameBooleanMap = new HashMap<String, Boolean>(200);
    private final SocketFactoryConfig _socketFactoryConfigDefault = new SocketFactoryConfig(0, null, null);
    private final SocketFactoryConfig _socketFactoryConfigSSL = new SocketFactoryConfig(0, null, null);

    public SSLRMIConfiguration() {
        try {
            this.initialize(new Properties(), false);
        }
        catch (SSLRMIConfigurationException e) {
            LogManager.getLogger(SSLRMIConfiguration.class).error(RB.getStringResource("SSLRMIConfiguration.initialize.ex.txt"), (Throwable)e);
            throw new IllegalArgumentException(e.getLocalizedMessage());
        }
    }

    public SSLRMIConfiguration(InputStream configurationInputStream) throws SSLRMIConfigurationException, IllegalArgumentException {
        if (configurationInputStream == null) {
            throw new IllegalArgumentException(RB.getStringResource("SSLRMIConfiguration.nullInputStream.ex.txt"));
        }
        try {
            Properties properties = new Properties();
            properties.load(configurationInputStream);
            this.initialize(properties, false);
        }
        catch (IOException e) {
            String cause = e.getLocalizedMessage();
            if (cause == null) {
                cause = "";
            }
            throw new SSLRMIConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.loadProperties.ex.fmt.txt", (Object)cause));
        }
        finally {
            try {
                configurationInputStream.close();
            }
            catch (IOException e) {
                LogManager.getLogger(SSLRMIConfiguration.class).warn(RB.getStringResource("SSLRMIConfiguration.closeStream.ex.log"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getSystemConfigurationProperties() throws SSLRMIConfigurationException {
        Properties properties;
        block17: {
            properties = null;
            InputStream inputStream = null;
            String systemConfigurationURL = null;
            IOException exception = null;
            try {
                systemConfigurationURL = AccessController.doPrivileged(new GetPropertyAction(SYSTEM_PROPERTY_NAME_SSL_RMI_CONFIG_FILE_URL));
                if (null != systemConfigurationURL) {
                    inputStream = new URL(systemConfigurationURL).openStream();
                    properties = new Properties();
                    properties.load(inputStream);
                }
            }
            catch (MalformedURLException e) {
                exception = e;
                return exception;
            }
            catch (IOException e) {
                exception = e;
                return exception;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LogManager.getLogger(SSLRMIConfiguration.class).warn(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.closeInputStream.ex.fmt.log", (Object)systemConfigurationURL), (Throwable)e);
                    }
                }
                if (exception == null) break block17;
                throw new SSLRMIConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.invalidSystemConfiguration.ex.fmt.txt", (Object)systemConfigurationURL), exception);
            }
        }
        return properties;
    }

    public SSLRMIConfiguration(Properties configurationProperties) throws SSLRMIConfigurationException, IllegalArgumentException {
        this.initialize(configurationProperties, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSSLAuthentication(SecurityKeyStore sslKeyStore, boolean isAuthenticatingClients, SecurityKeyStore sslTrustStore) throws SSLRMIConfigurationException, IllegalArgumentException {
        block10: {
            Throwable exception = null;
            try {
                SSLRMIServerSocketFactory serverSocketFactory = new SSLRMIServerSocketFactory(sslKeyStore, sslTrustStore, KeyManagerFactory.getDefaultAlgorithm(), KeyStore.getDefaultType(), SSLRMIConfiguration.getDefaultSocketProtocol(), null, isAuthenticatingClients, this._isReuseServerSocket);
                this._socketFactoryConfigSSL.setRMIServerSocketFactory(serverSocketFactory);
                this._socketFactoryConfigSSL.setRMIClientSocketFactory(new SSLRMIClientSocketFactory(this._isReuseSocket));
            }
            catch (GeneralSecurityException e) {
                exception = e;
            }
            catch (SasPasswordEncodingException e) {
                exception = e;
            }
            catch (IOException e) {
                exception = e;
            }
            finally {
                if (exception == null) break block10;
                String cause = exception.getLocalizedMessage();
                if (cause == null) {
                    cause = "";
                }
                throw new SSLRMIConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.initializeRMIServerSocketFactory.ex.fmt.txt", (Object)cause), exception);
            }
        }
    }

    static String getDefaultSocketProtocol() {
        String protocol = PROTOCOL_TLS;
        String javaVmVendor = AccessController.doPrivileged(new GetPropertyAction("java.vm.vendor"));
        if ("IBM Corporation".equals(javaVmVendor)) {
            protocol = PROTOCOL_SSL_TLS;
        }
        return protocol;
    }

    public void updateSelectionPolicy(InputStream selectionControlInputStream) throws SSLRMIConfigurationException, IllegalArgumentException {
        if (null != selectionControlInputStream) {
            try {
                Properties properties = new Properties();
                properties.load(selectionControlInputStream);
                this.updateSelectionPolicy(properties);
            }
            catch (IOException e) {
                String cause = e.getLocalizedMessage();
                if (null == cause) {
                    cause = "";
                }
                throw new SSLRMIConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.IOExceptionSSLControlFile.ex.fmt.txt", (Object)cause), e);
            }
            finally {
                try {
                    selectionControlInputStream.close();
                }
                catch (IOException e) {
                    LogManager.getLogger(SSLRMIConfiguration.class).warn(RB.getStringResource("SSLRMIConfiguration.closeSelectionPolicyStrem.ex.log"), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSelectionPolicy(Properties selectionControlProperties) throws SSLRMIConfigurationException, IllegalArgumentException {
        if (null == selectionControlProperties) {
            throw new IllegalArgumentException(RB.getStringResource("SSLRMIConfiguration.specifySelectionProperties.ex.txt"));
        }
        if (selectionControlProperties.size() > 0) {
            try {
                Iterator<Map.Entry<Object, Object>> iter = null;
                String key = null;
                Map<String, Boolean> map = this.classNameBooleanMap;
                synchronized (map) {
                    if (!this._isOKToRelaxSelectionPolicy && !this.classNameBooleanMap.isEmpty()) {
                        iter = selectionControlProperties.entrySet().iterator();
                        Object newPreference = null;
                        Boolean currentPreference = null;
                        Map.Entry<Object, Object> mapEntry = null;
                        while (iter.hasNext()) {
                            mapEntry = iter.next();
                            key = (String)mapEntry.getKey();
                            currentPreference = this.classNameBooleanMap.get(key);
                            newPreference = mapEntry.getValue();
                            if (!Boolean.TRUE.equals(currentPreference) || !Boolean.FALSE.equals(newPreference)) continue;
                            throw new SSLRMIConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.notAllowedToRelaxSecurityPreference.ex.fmt.txt", (Object)key));
                        }
                    }
                    iter = selectionControlProperties.entrySet().iterator();
                    Object value = null;
                    Map.Entry<Object, Object> mapEntry = null;
                    while (iter.hasNext()) {
                        mapEntry = iter.next();
                        key = (String)mapEntry.getKey();
                        value = mapEntry.getValue();
                        if (Boolean.TRUE.toString().equals(value)) {
                            this.classNameBooleanMap.put(key, Boolean.TRUE);
                            continue;
                        }
                        if (!Boolean.TRUE.toString().equals(this.classNameBooleanMap.get(key))) {
                            this.classNameBooleanMap.put(key, Boolean.FALSE);
                            continue;
                        }
                        if (!this._isOKToRelaxSelectionPolicy) continue;
                        this.classNameBooleanMap.put(key, Boolean.FALSE);
                    }
                }
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMISocketFactories.invalidProperties.ex.fmt.txt", (Object)e.getLocalizedMessage()));
            }
        }
    }

    @Override
    public RMIClientSocketFactory getRMIClientSocketFactory() {
        return this._socketFactoryConfigSSL.getRMIClientSocketFactory();
    }

    @Override
    public RMIClientSocketFactory getRMIClientSocketFactoryForClass(Class javaClass) {
        if (null == javaClass) {
            throw new IllegalArgumentException(RB.getStringResource("SSLRMIConfiguration.specifyNonNullClass.ex.txt"));
        }
        RMIClientSocketFactory rmiClientSocketFactory = null;
        if (this.isModeToSecureSome()) {
            rmiClientSocketFactory = this.getClientSocketFactoryFromMap(javaClass.getName());
        } else if (this.isModeToSecureAll()) {
            rmiClientSocketFactory = this._socketFactoryConfigSSL.getRMIClientSocketFactory();
        }
        if (null == rmiClientSocketFactory) {
            rmiClientSocketFactory = this._socketFactoryConfigDefault.getRMIClientSocketFactory();
        }
        return rmiClientSocketFactory;
    }

    @Override
    public RMIServerSocketFactory getRMIServerSocketFactory() {
        return this._socketFactoryConfigSSL.getRMIServerSocketFactory();
    }

    @Override
    public RMIServerSocketFactory getRMIServerSocketFactoryForClass(Class javaClass) {
        if (null == javaClass) {
            throw new IllegalArgumentException(RB.getStringResource("SSLRMIConfiguration.specifyNonNullClass.ex.txt"));
        }
        RMIServerSocketFactory rmiServerSocketFactory = null;
        if (this.isModeToSecureSome()) {
            rmiServerSocketFactory = this.getServerSocketFactoryFromMap(javaClass.getName());
            if (rmiServerSocketFactory == null) {
                rmiServerSocketFactory = this._socketFactoryConfigDefault.getRMIServerSocketFactory();
            }
        } else if (this.isModeToSecureAll()) {
            rmiServerSocketFactory = this._socketFactoryConfigSSL.getRMIServerSocketFactory();
        }
        if (rmiServerSocketFactory == null) {
            rmiServerSocketFactory = this._socketFactoryConfigDefault.getRMIServerSocketFactory();
        }
        return rmiServerSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getSelectionPolicyMap() {
        HashMap<String, Boolean> map = null;
        Map<String, Boolean> map2 = this.classNameBooleanMap;
        synchronized (map2) {
            map = new HashMap<String, Boolean>(this.classNameBooleanMap);
        }
        return map;
    }

    private RMIClientSocketFactory getClientSocketFactoryFromMap(String javaClassName) {
        RMIClientSocketFactory rmiClientSocketFactory = null;
        try {
            SocketFactoryConfig socketFactoryConfig = this.getSocketFactoryConfigFromMap(javaClassName, javaClassName);
            rmiClientSocketFactory = socketFactoryConfig == null ? this._socketFactoryConfigDefault.getRMIClientSocketFactory() : socketFactoryConfig.getRMIClientSocketFactory();
        }
        catch (ClassCastException e) {
            rmiClientSocketFactory = null;
        }
        return rmiClientSocketFactory;
    }

    private RMIServerSocketFactory getServerSocketFactoryFromMap(String javaClassName) {
        RMIServerSocketFactory rmiServerSocketFactory = null;
        try {
            SocketFactoryConfig socketFactoryConfig = this.getSocketFactoryConfigFromMap(javaClassName, javaClassName);
            rmiServerSocketFactory = socketFactoryConfig == null ? this._socketFactoryConfigDefault.getRMIServerSocketFactory() : socketFactoryConfig.getRMIServerSocketFactory();
        }
        catch (ClassCastException e) {
            rmiServerSocketFactory = null;
        }
        return rmiServerSocketFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SocketFactoryConfig getSocketFactoryConfigFromMap(String javaClassNameOriginal, String javaClassName) {
        if (javaClassNameOriginal == null) {
            throw new IllegalArgumentException();
        }
        SocketFactoryConfig socketFactoryConfig = null;
        if (!this.isModeToSecureNone()) {
            Boolean o = null;
            Map<String, Boolean> map = this.classNameBooleanMap;
            synchronized (map) {
                o = this.classNameBooleanMap.get(javaClassName);
            }
            if (null == o) {
                int lastPackageTokenIndex = javaClassName.lastIndexOf(46);
                if (lastPackageTokenIndex > 0) {
                    socketFactoryConfig = this.getSocketFactoryConfigFromMap(javaClassNameOriginal, javaClassName.substring(0, lastPackageTokenIndex));
                }
            } else {
                Boolean isUsingCustom = o;
                if (isUsingCustom.booleanValue()) {
                    socketFactoryConfig = this._socketFactoryConfigSSL;
                }
            }
        }
        if (null == socketFactoryConfig && javaClassNameOriginal.equals(javaClassName)) {
            socketFactoryConfig = this._socketFactoryConfigDefault;
        }
        return socketFactoryConfig;
    }

    public boolean isModeToSecureNone() {
        return this.isModeToSecure(SSL_SELECTION_MODE_NONE);
    }

    public boolean isModeToSecureAll() {
        return this.isModeToSecure(SSL_SELECTION_MODE_ALL);
    }

    public boolean isModeToSecureSome() {
        return this.isModeToSecure(SSL_SELECTION_MODE_SOME);
    }

    private boolean isModeToSecure(String mode) {
        boolean isModeSecuring = false;
        if (null != this._sslControlMode) {
            isModeSecuring = this._sslControlMode.equalsIgnoreCase(mode);
        }
        return isModeSecuring;
    }

    public void initializeUsingSystemProperty() throws SSLRMIException {
        Properties systemProperties = this.getSystemConfigurationProperties();
        if (null == systemProperties) {
            throw new SSLRMIException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.systemPropertyConfigFileURLUndefined.ex.fmt.txt", (Object)SYSTEM_PROPERTY_NAME_SSL_RMI_CONFIG_FILE_URL));
        }
        this.initialize(systemProperties, true);
    }

    private void initialize(Properties configurationProperties, boolean isSystemProperties) throws SSLRMIConfigurationException, IllegalArgumentException {
        Properties systemProperties;
        Properties properties = configurationProperties;
        if (!isSystemProperties && (systemProperties = this.getSystemConfigurationProperties()) != null) {
            properties = systemProperties;
        }
        if (null == properties) {
            throw new IllegalArgumentException(RB.getStringResource("SSLRMIConfiguration.mustSpecifyConfiguration.ex.txt"));
        }
        String controlMode = AccessController.doPrivileged(new GetPropertyAction(PROPERTY_NAME_SSL_MODE));
        if (controlMode == null) {
            controlMode = properties.getProperty(PROPERTY_NAME_SSL_MODE);
        }
        if (controlMode == null) {
            controlMode = SSL_SELECTION_MODE_NONE;
        }
        this.setControlMode(controlMode);
        this.setInitialSelectionPolicy(properties);
        this._socketFactoryConfigDefault.setPort(SSLRMIConfiguration.getPlatformPort(properties, PROPERTY_NAME_PLATFORM_PORT));
        this._socketFactoryConfigSSL.setPort(SSLRMIConfiguration.getPlatformPort(properties, PROPERTY_NAME_SSL_PLATFORM_PORT));
        String rmiClientSocketFactoryClassName = (String)properties.get(PROPERTY_NAME_CLIENT_SOCKET_FACTORY_CLASS);
        String rmiServerSocketFactoryClassName = (String)properties.get(PROPERTY_NAME_SERVER_SOCKET_FACTORY_CLASS);
        this.setDefaultRMIServerSocketFactory(rmiServerSocketFactoryClassName == null ? null : SSLRMIConfiguration.createRMIServerSocketFactory(rmiServerSocketFactoryClassName));
        this.setDefaultRMIClientSocketFactory(rmiClientSocketFactoryClassName == null ? null : SSLRMIConfiguration.createRMIClientSocketFactory(rmiClientSocketFactoryClassName));
        boolean bl = this._isAuthenticatingServer = !this.isModeToSecureNone();
        if (this._isAuthenticatingServer) {
            String isReuseSocket;
            String isAuthenticatingClientString = AccessController.doPrivileged(new GetPropertyAction(PROPERTY_NAME_SSL_IS_AUTHENTICATING_CLIENTS));
            if (isAuthenticatingClientString == null) {
                isAuthenticatingClientString = properties.getProperty(PROPERTY_NAME_SSL_IS_AUTHENTICATING_CLIENTS);
            }
            this._isAuthenticatingClients = Boolean.valueOf(isAuthenticatingClientString);
            String isReuseServerSocket = AccessController.doPrivileged(new GetPropertyAction(PROPERTY_NAME_IS_REUSE_SERVERSOCKET));
            if (isReuseServerSocket != null) {
                this._isReuseServerSocket = Boolean.valueOf(isReuseServerSocket);
            }
            if ((isReuseSocket = AccessController.doPrivileged(new GetPropertyAction(PROPERTY_NAME_IS_REUSE_SOCKET))) != null) {
                this._isReuseSocket = Boolean.valueOf(isReuseSocket);
            }
            this.initializeSSLAuthentication(this._isAuthenticatingServer ? SSLRMIConfiguration.newSSLKeyStore(properties) : null, this._isAuthenticatingClients, this._isAuthenticatingClients ? SSLRMIConfiguration.newSSLTrustStore(properties) : null);
        }
    }

    public void setDefaultRMIServerSocketFactory(RMIServerSocketFactory rmiServerSocketFactory) throws SSLRMIConfigurationException {
        String socketFactoryClass = AccessController.doPrivileged(new GetPropertyAction(PROPERTY_NAME_SERVER_SOCKET_FACTORY_CLASS));
        this._socketFactoryConfigDefault.setRMIServerSocketFactory(socketFactoryClass == null ? rmiServerSocketFactory : SSLRMIConfiguration.createRMIServerSocketFactory(socketFactoryClass));
    }

    public void setDefaultRMIClientSocketFactory(RMIClientSocketFactory rmiClientSocketFactory) throws SSLRMIConfigurationException {
        String socketFactoryClass = AccessController.doPrivileged(new GetPropertyAction(PROPERTY_NAME_CLIENT_SOCKET_FACTORY_CLASS));
        this._socketFactoryConfigDefault.setRMIClientSocketFactory(socketFactoryClass == null ? rmiClientSocketFactory : SSLRMIConfiguration.createRMIClientSocketFactory(socketFactoryClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object createSocketFactory(String socketFactoryClass) throws SSLRMIConfigurationException {
        Object socketFactory;
        block10: {
            socketFactory = null;
            if (socketFactoryClass != null) {
                ReflectiveOperationException exception = null;
                try {
                    socketFactory = SSLRMIConfiguration.class.getClassLoader().loadClass(socketFactoryClass).newInstance();
                }
                catch (ClassNotFoundException e) {
                    exception = e;
                    return exception;
                }
                catch (InstantiationException e) {
                    exception = e;
                    return exception;
                }
                catch (IllegalAccessException e) {
                    exception = e;
                    return exception;
                }
                finally {
                    if (exception == null) break block10;
                    String msg = Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.loadClass.ex.fmt.log", (Object)socketFactoryClass);
                    LogManager.getLogger(SSLRMIConfiguration.class).error(msg, (Throwable)exception);
                    throw new SSLRMIConfigurationException(msg, exception);
                }
            }
        }
        return socketFactory;
    }

    private void setControlMode(String controlMode) throws IllegalArgumentException {
        if (controlMode == null || !SSL_SELECTION_MODE_NONE.equalsIgnoreCase(controlMode) && !SSL_SELECTION_MODE_ALL.equalsIgnoreCase(controlMode) && !SSL_SELECTION_MODE_SOME.equalsIgnoreCase(controlMode)) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.invalidControlMode.ex.fmt.txt", (Object)controlMode, (Object)SSL_SELECTION_MODE_NONE, (Object)SSL_SELECTION_MODE_ALL, (Object)SSL_SELECTION_MODE_SOME));
        }
        this._sslControlMode = controlMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInitialSelectionPolicy(Properties sslConfiguration) throws SSLRMIConfigurationException, IllegalArgumentException {
        String sslControlFileName = AccessController.doPrivileged(new GetPropertyAction(PROPERTY_NAME_SSL_SELECTION_CONFIG_FILE));
        if (null == sslControlFileName) {
            sslControlFileName = sslConfiguration.getProperty(PROPERTY_NAME_SSL_SELECTION_CONFIG_FILE);
        }
        InputStream inputStream = null;
        if (null == sslControlFileName) {
            sslControlFileName = SSL_SELECTION_DEFAULT_CONFIG_FILE;
            inputStream = SSLRMIConfiguration.class.getResourceAsStream(sslControlFileName);
        } else {
            try {
                inputStream = new FileInputStream(sslControlFileName);
            }
            catch (FileNotFoundException e) {
                throw new SSLRMIConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.selectionPolicyFileNotFound.ex.fmt.txt", (Object)sslControlFileName), e);
            }
        }
        if (null != inputStream) {
            try {
                this.updateSelectionPolicy(inputStream);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LogManager.getLogger(SSLRMIConfiguration.class).warn(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.closeInputStream.ex.fmt.log", (Object)sslControlFileName), (Throwable)e);
                }
            }
        }
        if (this.isModeToSecureSome()) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.mustSpecifyControlFile.ex.fmt.txt", (Object)PROPERTY_NAME_SSL_SELECTION_CONFIG_FILE));
        }
    }

    public boolean isAuthenticatingClients() {
        return this._isAuthenticatingClients;
    }

    public boolean isAuthenticatingServer() {
        return this._isAuthenticatingServer;
    }

    public boolean isOKToRelaxSelectionPolicy() {
        return this._isOKToRelaxSelectionPolicy;
    }

    private static SecurityKeyStore newSSLTrustStore(Properties properties) throws IllegalArgumentException {
        String trustStorePassword;
        SecurityKeyStore trustStore = null;
        String trustStoreFile = AccessController.doPrivileged(new GetPropertyAction(PROPERTY_NAME_JSSE_TRUSTSTORE_FILE));
        if (trustStoreFile == null) {
            trustStoreFile = properties.getProperty(PROPERTY_NAME_JSSE_TRUSTSTORE_FILE);
        }
        if ((trustStorePassword = AccessController.doPrivileged(new GetPropertyAction(PROPERTY_NAME_JSSE_TRUSTSTORE_PASSWORD))) == null) {
            trustStorePassword = properties.getProperty(PROPERTY_NAME_JSSE_TRUSTSTORE_PASSWORD);
        }
        try {
            trustStore = new SecurityKeyStore(trustStoreFile, trustStorePassword);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.unableToCreateKeyStore.ex.fmt.txt", (Object)trustStoreFile));
        }
        return trustStore;
    }

    private static SecurityKeyStore newSSLKeyStore(Properties properties) throws IllegalArgumentException {
        SecurityKeyStore sslKeyStore = null;
        String keyStoreFile = AccessController.doPrivileged(new GetPropertyAction(PROPERTY_NAME_JSSE_KEYSTORE_FILE));
        String keyStorePassword = AccessController.doPrivileged(new GetPropertyAction(PROPERTY_NAME_JSSE_KEYSTORE_PASSWORD));
        if (keyStoreFile == null) {
            if (properties == null) {
                throw new IllegalArgumentException(RB.getStringResource("SSLRMIConfiguration.mustSpecifyConfigurationProperties.ex.txt"));
            }
            keyStoreFile = properties.getProperty(PROPERTY_NAME_JSSE_KEYSTORE_FILE);
        }
        if (keyStorePassword == null) {
            if (properties == null) {
                throw new IllegalArgumentException(RB.getStringResource("SSLRMIConfiguration.mustSpecifyConfigurationProperties.ex.txt"));
            }
            keyStorePassword = properties.getProperty(PROPERTY_NAME_JSSE_KEYSTORE_PASSWORD);
        }
        if (keyStoreFile != null) {
            if (keyStorePassword == null) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.keyStorePasswordMustBeSpecified.ex.fmt.txt", (Object)keyStoreFile, (Object)PROPERTY_NAME_JSSE_KEYSTORE_PASSWORD));
            }
            try {
                sslKeyStore = new SecurityKeyStore(keyStoreFile, keyStorePassword);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.unableToCreateKeyStore.ex.fmt.txt", (Object)keyStoreFile));
            }
        }
        return sslKeyStore;
    }

    @Override
    public int getPortForClass(int requestedPort, Class javaClass) {
        int port = requestedPort;
        if (requestedPort == 0) {
            if (javaClass == null) {
                port = this._socketFactoryConfigDefault.getPort();
            } else {
                SocketFactoryConfig socketFactoryConfig = null;
                if (this.isModeToSecureSome()) {
                    String javaClassName = javaClass.getName();
                    socketFactoryConfig = this.getSocketFactoryConfigFromMap(javaClassName, javaClassName);
                } else if (this.isModeToSecureAll()) {
                    socketFactoryConfig = this._socketFactoryConfigSSL;
                }
                port = socketFactoryConfig == null ? this._socketFactoryConfigDefault.getPort() : socketFactoryConfig.getPort();
            }
        }
        return port;
    }

    private static int getPlatformPort(Properties properties, String propertyNamePort) throws SSLRMIConfigurationException {
        int platformPort = 0;
        String platformPortString = AccessController.doPrivileged(new GetPropertyAction(propertyNamePort));
        if (null == platformPortString && null != properties) {
            platformPortString = properties.getProperty(propertyNamePort);
        }
        if (null != platformPortString) {
            try {
                platformPort = Integer.parseInt(platformPortString);
            }
            catch (NumberFormatException e) {
                throw new SSLRMIConfigurationException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.platformPort.ex.fmt.txt", (Object)propertyNamePort, (Object)platformPortString), e);
            }
        }
        return platformPort;
    }

    private static RMIClientSocketFactory createRMIClientSocketFactory(String rmiClientSocketFactoryClassName) throws SSLRMIConfigurationException {
        if (rmiClientSocketFactoryClassName == null) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.specifyRMISocketFactoryClass.ex.fmt.txt", (Object)RMIClientSocketFactory.class.getName()));
        }
        RMIClientSocketFactory socketFactory = null;
        try {
            socketFactory = (RMIClientSocketFactory)SSLRMIConfiguration.createSocketFactory(rmiClientSocketFactoryClassName);
        }
        catch (ClassCastException e) {
            throw new SSLRMIConfigurationException(e);
        }
        return socketFactory;
    }

    private static RMIServerSocketFactory createRMIServerSocketFactory(String rmiServerSocketFactoryClassName) throws SSLRMIConfigurationException {
        if (null == rmiServerSocketFactoryClassName) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"SSLRMIConfiguration.specifyRMISocketFactoryClass.ex.fmt.txt", (Object)RMIServerSocketFactory.class.getName()));
        }
        RMIServerSocketFactory socketFactory = null;
        try {
            socketFactory = (RMIServerSocketFactory)SSLRMIConfiguration.createSocketFactory(rmiServerSocketFactoryClassName);
        }
        catch (ClassCastException e) {
            throw new SSLRMIConfigurationException(e);
        }
        return socketFactory;
    }
}

