/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net.rmi;

import com.sas.codepolicy.BinaryCompatibilityOnly;
import com.sas.codepolicy.SASScope;
import com.sas.net.rmi.RB;
import com.sas.net.rmi.RemoteObjectExporterInterface;
import com.sas.text.Message;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.util.ResourceBundle;

@SASScope(value="ALL")
@BinaryCompatibilityOnly
public abstract class AbstractRemoteObjectExporter
implements RemoteObjectExporterInterface {
    private static final boolean IS_FORCE_UNEXPORT_DEFAULT = true;
    private Remote _remoteObject;
    private Remote _exportedRemoteObjectStub;
    private int _portNumber = 0;
    private RMIClientSocketFactory _rmiClientSocketFactory;
    private RMIServerSocketFactory _rmiServerSocketFactory;
    private boolean _isForcibleUnexport = true;

    public AbstractRemoteObjectExporter(Remote remoteObject, int portNumber, RMIClientSocketFactory rmiClientSocketFactory, RMIServerSocketFactory rmiServerSocketFactory, boolean isForcibleUnexport) throws IllegalArgumentException {
        this.setRemoteObject(remoteObject);
        this.setPortNumber(portNumber);
        this.setRMIClientSocketFactory(rmiClientSocketFactory);
        this.setRMIServerSocketFactory(rmiServerSocketFactory);
        this._isForcibleUnexport = isForcibleUnexport;
    }

    @Override
    public final Remote exportObject() throws RemoteException {
        if (this._remoteObject == null) {
            throw new IllegalStateException(RB.getStringResource("AbstractRemoteObjectExporter.mustSpecifyRemoteObjectToExport.ex.txt"));
        }
        this._exportedRemoteObjectStub = this.exportObject(this._remoteObject, this._portNumber, this._rmiClientSocketFactory, this._rmiServerSocketFactory);
        return this._exportedRemoteObjectStub;
    }

    @Override
    public final boolean unexportObject() throws NoSuchObjectException {
        boolean wasSuccessful = false;
        if (this._exportedRemoteObjectStub != null && (wasSuccessful = this.unexportObject(this._remoteObject, this._isForcibleUnexport))) {
            this._exportedRemoteObjectStub = null;
        }
        return wasSuccessful;
    }

    protected abstract Remote exportObject(Remote var1, int var2, RMIClientSocketFactory var3, RMIServerSocketFactory var4) throws RemoteException;

    protected abstract boolean unexportObject(Remote var1, boolean var2) throws NoSuchObjectException;

    public final Remote getRemotableObject() {
        return this._remoteObject;
    }

    public final int getPortNumber() {
        return this._portNumber;
    }

    @Override
    public final boolean isExported() {
        return null != this._exportedRemoteObjectStub;
    }

    public final boolean isForcibleUnexport() {
        return this._isForcibleUnexport;
    }

    public final void setIsForcibleUnexport(boolean isForcibleUnexport) {
        this._isForcibleUnexport = isForcibleUnexport;
    }

    @Override
    public final Remote getExportedRemoteObjectStub() {
        return this._exportedRemoteObjectStub;
    }

    private final void setPortNumber(int portNumber) throws IllegalArgumentException {
        if (portNumber < 0) {
            throw new IllegalArgumentException(Message.format((ResourceBundle)RB.getResources(), (String)"AbstractRemoteObjectExporter.invalidPort.ex.fmt.txt", (Object)portNumber));
        }
        this._portNumber = portNumber;
    }

    private final void setRemoteObject(Remote remoteObject) throws IllegalArgumentException {
        if (null == remoteObject) {
            throw new IllegalArgumentException(RB.getStringResource("AbstractRemoteObjectExporter.mustSpecifyRemoteObjectToExport.ex.txt"));
        }
        this._remoteObject = remoteObject;
    }

    private void setRMIClientSocketFactory(RMIClientSocketFactory rmiClientSocketFactory) {
        this._rmiClientSocketFactory = rmiClientSocketFactory;
    }

    public final RMIClientSocketFactory getRMIClientSocketFactory() {
        return this._rmiClientSocketFactory;
    }

    private void setRMIServerSocketFactory(RMIServerSocketFactory rmiServerSocketFactory) {
        this._rmiServerSocketFactory = rmiServerSocketFactory;
    }

    public final RMIServerSocketFactory getRMIServerSocketFactory() {
        return this._rmiServerSocketFactory;
    }
}

