/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.Shape;
import com.sas.graphics.util.gl.State;
import com.sas.graphics.util.gl.TransInfo;
import java.awt.Color;
import java.awt.Rectangle;

abstract class VertexSet
extends Shape {
    private int vertexAllocIncrement;
    protected int vertexAlloc;
    protected int vertexCount = 0;
    protected Point4[] vertex;
    protected Color[] colorPerVertex;
    protected float[] alphaPerVertex;
    protected int[] falseEdgeFlagIndex;
    protected int falseEdgeFlagCount = 0;
    protected int falseEdgeFlagAlloc = 0;
    protected int[] xpoints;
    protected int[] ypoints;
    protected double[] xpointsD;
    protected double[] ypointsD;
    static double[] discard = new double[2];

    VertexSet() {
        this(4, 10);
    }

    VertexSet(int initialVertexAlloc, int vertexAllocIncrement) {
        this.vertexAlloc = initialVertexAlloc;
        this.vertexAllocIncrement = vertexAllocIncrement;
        this.vertex = new Point4[this.vertexAlloc];
        this.colorPerVertex = new Color[this.vertexAlloc];
        this.alphaPerVertex = new float[this.vertexAlloc];
    }

    public void setVertexAllocIncrement(int vertexAllocIncrement) {
        this.vertexAllocIncrement = vertexAllocIncrement;
    }

    @Override
    public int getVertexCount(State state) {
        return this.vertexCount;
    }

    public void removeAll() {
        this.vertexCount = 0;
        this.falseEdgeFlagCount = 0;
    }

    @Override
    void copyInit(Shape s) {
        super.copyInit(s);
        VertexSet vs = (VertexSet)s;
        vs.dscr = new Point4[this.vertexCount];
        vs.vertex = new Point4[this.vertexCount];
        vs.colorPerVertex = new Color[this.vertexCount];
        vs.alphaPerVertex = new float[this.vertexCount];
        vs.vertexAlloc = this.vertexCount;
        for (int i = 0; i < this.vertexCount; ++i) {
            vs.dscr[i] = this.dscr != null && this.dscr.length > i && this.dscr[i] != null ? this.dscr[i].copy() : new Point4();
            vs.vertex[i] = this.vertex[i].copy();
            vs.colorPerVertex[i] = this.colorPerVertex[i];
            vs.alphaPerVertex[i] = this.alphaPerVertex[i];
        }
        vs.ypoints = new int[this.vertexCount];
        vs.xpoints = new int[this.vertexCount];
        vs.ypointsD = new double[this.vertexCount];
        vs.xpointsD = new double[this.vertexCount];
        if (this.xpoints != null && this.xpoints.length == this.vertexCount) {
            System.arraycopy(this.xpoints, 0, vs.xpoints, 0, this.vertexCount);
            System.arraycopy(this.ypoints, 0, vs.ypoints, 0, this.vertexCount);
        }
        if (this.xpointsD != null && this.xpointsD.length == this.vertexCount) {
            System.arraycopy(this.xpointsD, 0, vs.xpointsD, 0, this.vertexCount);
            System.arraycopy(this.ypointsD, 0, vs.ypointsD, 0, this.vertexCount);
        }
        if (this.falseEdgeFlagCount > 0) {
            vs.falseEdgeFlagIndex = new int[this.falseEdgeFlagCount];
            vs.falseEdgeFlagAlloc = this.falseEdgeFlagCount;
            System.arraycopy(this.falseEdgeFlagIndex, 0, vs.falseEdgeFlagIndex, 0, this.falseEdgeFlagCount);
        }
    }

    protected void allocScreen() {
        if (this.dscr == null || this.dscr.length < this.vertexCount) {
            this.dscr = new Point4[this.vertexCount];
            this.xpoints = new int[this.vertexCount];
            this.ypoints = new int[this.vertexCount];
            this.xpointsD = new double[this.vertexCount];
            this.ypointsD = new double[this.vertexCount];
            for (int i = 0; i < this.vertexCount; ++i) {
                this.dscr[i] = new Point4();
            }
        }
    }

    void end(Channel ch) {
        this.allocScreen();
    }

    @Override
    public void computeScreen(Channel ch) {
        super.computeScreen(ch);
        State state = ch.state;
        TransInfo tr = ch.trans;
        this.color = state.color;
        this.alpha = state.alpha;
        int xmax = -2147483647;
        int ymax = -2147483647;
        int xmin = Integer.MAX_VALUE;
        int ymin = Integer.MAX_VALUE;
        this.zmin = Double.MAX_VALUE;
        this.zmax = -1.7976931348623157E308;
        this.clip = false;
        for (int i = 0; i < this.vertexCount; ++i) {
            this.dscr[i].set(this.vertex[i]);
            tr.Object2Window(this.dscr[i]);
            this.xpoints[i] = (int)(this.dscr[i].x + 0.5);
            this.ypoints[i] = (int)(this.dscr[i].y + 0.5);
            if (state.subpixelRendering) {
                this.xpointsD[i] = this.dscr[i].x;
                this.ypointsD[i] = this.dscr[i].y;
            }
            xmax = Math.max(xmax, this.xpoints[i]);
            xmin = Math.min(xmin, this.xpoints[i]);
            ymax = Math.max(ymax, this.ypoints[i]);
            ymin = Math.min(ymin, this.ypoints[i]);
            this.zmax = Math.max(this.zmax, this.dscr[i].z);
            this.zmin = Math.min(this.zmin, this.dscr[i].z);
        }
        this.bbox.setBounds(xmin, ymin, xmax - xmin + 1, ymax - ymin + 1);
        if (this.zmin < 0.0 || this.zmax > 1.0) {
            this.clip = true;
            return;
        }
        if (state.capabilities[5]) {
            int xo = this.bbox.x;
            int yo = this.bbox.y;
            int x1 = xo + this.bbox.width;
            int y1 = yo + this.bbox.height;
            boolean bl = this.clip = (double)x1 < tr.getLeft() || (double)xo > tr.getRight() || (double)y1 < tr.getUp() || (double)yo > tr.getDown();
            if (this.clip) {
                return;
            }
        }
    }

    private void reallocVertex() {
        if (this.vertexCount + 1 > this.vertexAlloc) {
            Point4[] newVertexArray = new Point4[this.vertexAlloc + this.vertexAllocIncrement];
            System.arraycopy(this.vertex, 0, newVertexArray, 0, this.vertexAlloc);
            this.vertex = newVertexArray;
            Color[] newColorPerVertexArray = new Color[this.vertexAlloc + this.vertexAllocIncrement];
            System.arraycopy(this.colorPerVertex, 0, newColorPerVertexArray, 0, this.vertexAlloc);
            this.colorPerVertex = newColorPerVertexArray;
            float[] newAlphaPerVertexArray = new float[this.vertexAlloc + this.vertexAllocIncrement];
            System.arraycopy(this.alphaPerVertex, 0, newAlphaPerVertexArray, 0, this.vertexAlloc);
            this.alphaPerVertex = newAlphaPerVertexArray;
            this.vertexAlloc += this.vertexAllocIncrement;
        }
    }

    void vertex(Channel ch, double x, double y, double z) {
        State state = ch.state;
        if (this.vertexCount + 1 > this.vertexAlloc) {
            this.reallocVertex();
        }
        Point4 p = this.vertex[this.vertexCount];
        if (this.vertex[this.vertexCount] == null) {
            p = this.vertex[this.vertexCount] = new Point4();
        }
        p.x = x;
        p.y = y;
        p.z = z;
        p.t = 1.0;
        this.colorPerVertex[this.vertexCount] = state.color;
        this.alphaPerVertex[this.vertexCount] = state.alpha;
        if (!state.edgeFlag) {
            if (this.falseEdgeFlagIndex == null) {
                this.falseEdgeFlagAlloc = this.vertexAllocIncrement;
                this.falseEdgeFlagIndex = new int[this.falseEdgeFlagAlloc];
            }
            if (this.falseEdgeFlagCount + 1 > this.falseEdgeFlagAlloc) {
                int[] newArray = new int[this.falseEdgeFlagAlloc + this.vertexAllocIncrement];
                System.arraycopy(this.falseEdgeFlagIndex, 0, newArray, 0, this.falseEdgeFlagAlloc);
                this.falseEdgeFlagAlloc += this.vertexAllocIncrement;
                this.falseEdgeFlagIndex = newArray;
            }
            this.falseEdgeFlagIndex[this.falseEdgeFlagCount++] = this.vertexCount;
        }
        ++this.vertexCount;
    }

    static boolean inside(int x, int y, int[] xpoints, int[] ypoints, int vertexCount, int[] falseEdges, int falseEdgeCount, State state) {
        int hits = 0;
        int ei = 0;
        if (state.capabilities[8]) {
            falseEdges = null;
            falseEdgeCount = 0;
        }
        for (int i = 0; i < vertexCount; ++i) {
            if (falseEdges != null && ei < falseEdges.length && falseEdges[ei] == i) {
                ++ei;
                continue;
            }
            int j = (i + 1) % vertexCount;
            int dy = ypoints[j] - ypoints[i];
            if (dy == 0) {
                if (y != ypoints[i] || x < Math.min(xpoints[i], xpoints[j]) || x > Math.max(xpoints[i], xpoints[j])) continue;
                return true;
            }
            if (ypoints[i] == y) {
                if (xpoints[i] == x) {
                    return true;
                }
                if (xpoints[i] <= x || ypoints[j] >= y) continue;
                ++hits;
                continue;
            }
            if (ypoints[j] == y) {
                if (xpoints[j] == x) {
                    return true;
                }
                if (xpoints[j] <= x || ypoints[i] >= y) continue;
                ++hits;
                continue;
            }
            double s = (double)(y - ypoints[i]) / (double)dy;
            if (!(s >= 0.0) || !(s <= 1.0) || (int)Math.ceil(s * (double)(xpoints[j] - xpoints[i])) < x - xpoints[i]) continue;
            ++hits;
        }
        return hits % 2 != 0;
    }

    protected static boolean apertureIntersectsPolygon(State state, Rectangle aperture, int[] xpoints, int[] ypoints, int vertexCount, int[] falseEdges, int falseEdgeCount) {
        if (aperture.width == 1 && aperture.height == 1) {
            return VertexSet.inside(aperture.x, aperture.y, xpoints, ypoints, vertexCount, falseEdges, falseEdgeCount, state);
        }
        for (int i = 0; i < vertexCount; ++i) {
            if (!aperture.contains(xpoints[i], ypoints[i])) continue;
            return true;
        }
        if (VertexSet.inside(aperture.x, aperture.y, xpoints, ypoints, vertexCount, falseEdges, falseEdgeCount, state)) {
            return true;
        }
        return VertexSet.apertureIntersectsEdges(aperture, xpoints, ypoints, vertexCount, falseEdges, falseEdgeCount);
    }

    protected static boolean apertureIntersectsEdges(Rectangle aperture, int[] xpoints, int[] ypoints, int vertexCount, int[] falseEdges, int falseEdgeCount) {
        double xo = aperture.x;
        double yo = aperture.y;
        double x1 = xo + (double)aperture.width;
        double y1 = yo + (double)aperture.height;
        if (VertexSet.lineIntersectsEdges(xo, yo, x1, yo, xpoints, ypoints, vertexCount, falseEdges, falseEdgeCount)) {
            return true;
        }
        if (VertexSet.lineIntersectsEdges(x1, yo, x1, y1, xpoints, ypoints, vertexCount, falseEdges, falseEdgeCount)) {
            return true;
        }
        if (VertexSet.lineIntersectsEdges(x1, y1, xo, y1, xpoints, ypoints, vertexCount, falseEdges, falseEdgeCount)) {
            return true;
        }
        return VertexSet.lineIntersectsEdges(xo, y1, xo, yo, xpoints, ypoints, vertexCount, falseEdges, falseEdgeCount);
    }

    protected static boolean lineIntersectsEdges(double xo, double yo, double x1, double y1, int[] xpoints, int[] ypoints, int vertexCount, int[] falseEdges, int falseEdgeCount) {
        double startX = xpoints[0];
        double startY = ypoints[0];
        int ei = 0;
        for (int i = 1; i < vertexCount; ++i) {
            if (falseEdges != null && ei < falseEdgeCount && falseEdges[ei] == i - 1) {
                ++ei;
                startX = xpoints[i];
                startY = ypoints[i];
                continue;
            }
            double endX = xpoints[i];
            double endY = ypoints[i];
            if (VertexSet.edgesIntersect(xo, yo, x1, y1, startX, startY, endX, endY, discard)) {
                return true;
            }
            startX = endX;
            startY = endY;
        }
        return false;
    }
}

