/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.Debug;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.Matrix4;
import com.sas.graphics.util.gl.MatrixStack;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.State;
import com.sas.graphics.util.gl.Transformation;
import com.sas.graphics.util.gl.Viewport;
import java.awt.geom.AffineTransform;

class TransInfo {
    private MatrixStack modelStack;
    private MatrixStack modelNormalStack;
    private int proj_mode;
    private Matrix4 proj;
    private Matrix4 view;
    private Matrix4 model;
    private Matrix4 modelNormal;
    private Viewport viewport;
    private Matrix4 object2Window;
    private Matrix4 window2Object;
    private boolean object2WindowDirty;
    private boolean object2WindowInverted;
    private final Point4 tpnt = new Point4();
    private final Matrix4 temp = new Matrix4();
    private State state;
    private static final double DEG2RAD = 0.01745329252;
    private final Point4 viewZ = new Point4(0.0, 0.0, 1.0, 0.0);
    private double EPSILON = 1.0E-10;
    private static final int MAX_SCREEN_POSITION = 2147483547;

    TransInfo(Channel ch) {
        this.state = ch.state;
        this.modelStack = new MatrixStack();
        this.modelNormalStack = new MatrixStack();
        this.model = this.modelStack.peek();
        this.modelNormal = this.modelNormalStack.peek();
        this.proj = new Matrix4();
        this.view = new Matrix4();
        this.object2Window = new Matrix4();
        this.window2Object = new Matrix4();
        this.object2WindowInverted = false;
        this.object2WindowDirty = true;
        this.viewport = new Viewport(0, 0, 640, 480);
        this.LookAt(0.0, 0.0, 0.0, 100.0, 0.0, 0.0, 0.0);
        this.Perspective(45.0, 1.0, 1.0, 101.0);
    }

    public int getProjectionMode() {
        return this.proj_mode;
    }

    public double[] getViewport() {
        double[] r = new double[]{this.viewport.xo, this.viewport.yo, this.viewport.width, this.viewport.height};
        return r;
    }

    public void Frustum(double left, double right, double bottom, double top, double near, double far) {
        double div1 = right - left;
        double div2 = top - bottom;
        double div3 = far - near;
        this.object2WindowDirty = true;
        this.temp.set(this.proj);
        this.proj.setIdentity();
        try {
            this.proj.set(0, 0, 2.0 * near / div1);
            this.proj.set(1, 1, 2.0 * near / div2);
            this.proj.set(2, 2, -(far + near) / div3);
            this.proj.set(3, 3, 0.0);
            this.proj.set(2, 0, (right + left) / div1);
            this.proj.set(2, 1, (bottom + top) / div2);
            this.proj.set(3, 2, -2.0 * near * far / div3);
            this.proj.set(2, 3, -1.0);
            this.viewport.setDepth(near, far);
            this.proj_mode = 1;
        }
        catch (ArithmeticException e) {
            Debug.println((String)"Bad parameter passed to gluFrustum.");
            Debug.println((String)"Projection matrix not modified");
            this.proj.set(this.temp);
        }
    }

    public double getNear() {
        return this.viewport.zo;
    }

    public double getFar() {
        return this.viewport.zo + this.viewport.depth;
    }

    public double getLeft() {
        return this.viewport.xo;
    }

    public double getRight() {
        return this.viewport.xo + this.viewport.width;
    }

    public double getUp() {
        return this.viewport.yo;
    }

    public double getDown() {
        return this.viewport.yo + this.viewport.height;
    }

    void GetMatrix(double[] matrix) {
        if (matrix.length < 16) {
            Debug.println((String)"Matrix should have 16 elements.");
            return;
        }
        for (int i = 0; i < 16; ++i) {
            matrix[i] = this.model.e[i % 4][i / 4];
        }
    }

    public double[] getWindow(double x, double y, double z) {
        Point4 p = this.tpnt;
        p.set(x, y, z, 0.0);
        this.makeObject2Window();
        p.postMultiply(this.window2Object);
        p.normalize();
        double[] w = new double[]{p.x, p.y, p.z};
        return w;
    }

    public void LoadIdentity(int render_mode, State state) {
        if (state.isDisplayListOpen()) {
            Transformation t1 = new Transformation(1, null);
            state.getOpenDisplayList().addElement(t1);
        } else {
            this.object2WindowDirty = true;
            this.model.setIdentity();
            this.modelNormal.setIdentity();
        }
    }

    public void LoadMatrix(double[] matrix, int render_mode, State state) {
        if (matrix.length < 16) {
            Debug.println((String)"Matrix should have 16 elements.");
            return;
        }
        if (state.isDisplayListOpen()) {
            Transformation t1 = new Transformation(8, matrix);
            state.getOpenDisplayList().addElement(t1);
        } else {
            this.object2WindowDirty = true;
            this.model.set(matrix);
            this.modelNormal.set(matrix);
        }
    }

    public Viewport GetViewport() {
        return this.viewport;
    }

    public void LookAt(double eyex, double eyey, double eyez, double centerx, double centery, double centerz, double upx, double upy, double upz) {
        Point4 w = this.viewZ;
        w.x = eyex - centerx;
        w.y = eyey - centery;
        w.z = eyez - centerz;
        w.normalize();
        Point4 v = new Point4(upx, upy, upz, 0.0);
        Point4 u = new Point4(v);
        u.cross(w);
        v.set(w);
        v.cross(u);
        v.normalize();
        u.set(v);
        u.cross(w);
        u.normalize();
        this.view.set(u.x, u.y, u.z, 0.0, v.x, v.y, v.z, 0.0, w.x, w.y, w.z, 0.0, 0.0, 0.0, 0.0, 1.0);
        this.view.translate(-eyex, -eyey, -eyez);
        this.object2WindowDirty = true;
    }

    public void LookAt(double centerx, double centery, double centerz, double dist, double azim, double inc, double twist) {
        this.view.setIdentity();
        this.view.translate(0.0, 0.0, -dist);
        this.view.rotate(0.0, 0.0, 1.0, -twist);
        this.view.rotate(1.0, 0.0, 0.0, -inc);
        this.view.rotate(0.0, 1.0, 0.0, -azim);
        this.view.translate(-centerx, -centery, -centerz);
        this.object2WindowDirty = true;
    }

    public Point4 Model2View(Point4 obj) {
        obj.postMultiply(this.view);
        double t = obj.t;
        if (t == 0.0) {
            return obj;
        }
        if (Math.abs(t) <= (double)1.4E-45f) {
            Debug.println((String)"Bad t value in Model2View");
            t = t > 0.0 ? 2.147483647E9 : -2.147483647E9;
        } else {
            t = 1.0 / t;
        }
        obj.scale(t);
        return obj;
    }

    public void Ortho(double left, double right, double bottom, double top, double near, double far) {
        double div1 = right - left;
        double div2 = top - bottom;
        double div3 = far - near;
        this.temp.set(this.proj);
        this.object2WindowDirty = true;
        this.proj.setIdentity();
        try {
            this.proj.set(0, 0, 2.0 / div1);
            this.proj.set(1, 1, 2.0 / div2);
            this.proj.set(2, 2, -2.0 / div3);
            this.proj.set(3, 0, -(right + left) / div1);
            this.proj.set(3, 1, -(top + bottom) / div2);
            this.proj.set(3, 2, -(far + near) / div3);
            this.viewport.setDepth(near, far);
            this.proj_mode = 0;
        }
        catch (ArithmeticException e) {
            Debug.println((String)"Bad parameter passed to glortho.");
            Debug.println((String)"Projection matrix not modified");
            this.proj.set(this.temp);
        }
    }

    public void Oblique(double left, double right, double bottom, double top, double near, double far, double zlength, double angle) {
        double div1 = right - left;
        double div2 = top - bottom;
        double div3 = far - near;
        double sina = Math.sin(angle * 0.01745329252);
        double cosa = Math.cos(angle * 0.01745329252);
        this.temp.set(this.proj);
        this.object2WindowDirty = true;
        this.proj.setIdentity();
        try {
            this.proj.set(0, 0, 2.0 / div1);
            this.proj.set(1, 1, 2.0 / div2);
            this.proj.set(2, 2, -2.0 / div3);
            this.proj.set(3, 0, -(right + left) / div1);
            this.proj.set(3, 1, -(top + bottom) / div2);
            this.proj.set(3, 2, -(far + near) / div3);
            this.proj.set(2, 0, -zlength * cosa * 2.0 / div1);
            this.proj.set(2, 1, -zlength * sina * 2.0 / div2);
            this.viewport.setDepth(near, far);
            this.proj_mode = 2;
        }
        catch (ArithmeticException e) {
            Debug.println((String)"Bad parameter passed to glortho.");
            Debug.println((String)"Projection matrix not modified");
            this.proj.set(this.temp);
        }
    }

    public void Perspective(double fov, double aspect, double near, double far) {
        if (near < 0.0 || far < near) {
            Debug.println((String)"Error: glPerspective(): near and far should be positive.");
            return;
        }
        this.object2WindowDirty = true;
        near = Math.max(near, 1.0E-6);
        this.temp.set(this.proj);
        this.proj.setIdentity();
        try {
            double cotan = 1.0 / Math.tan(fov * 0.5 * 0.01745329252);
            this.proj.set(0, 0, cotan / aspect);
            this.proj.set(1, 1, cotan);
            this.proj.set(2, 2, -(far + near) / (far - near));
            this.proj.set(2, 3, -1.0);
            this.proj.set(3, 2, -2.0 * far * near / (far - near));
            this.proj.set(3, 3, 0.0);
            this.viewport.setDepth(near, far);
            this.proj_mode = 1;
        }
        catch (ArithmeticException e) {
            Debug.println((String)"Bad parameter passed to gluPerspective.");
            Debug.println((String)"Projection matrix not modified");
            this.proj.set(this.temp);
        }
    }

    public void PopMatrix(int render_mode, State state) {
        this.object2WindowDirty = true;
        this.model = this.modelStack.pop();
        this.modelNormal = this.modelNormalStack.pop();
        if (state.isDisplayListOpen()) {
            Transformation t1 = new Transformation(7, null);
            state.getOpenDisplayList().addElement(t1);
        }
    }

    public void PushMatrix(int render_mode, State state) {
        this.model = this.modelStack.push();
        this.modelNormal = this.modelNormalStack.push();
        if (state.isDisplayListOpen()) {
            Transformation t1 = new Transformation(6, null);
            state.getOpenDisplayList().addElement(t1);
        }
    }

    public void Rotate(double angle, double dirx, double diry, double dirz, State state) {
        this.object2WindowDirty = true;
        this.model.rotate(dirx, diry, dirz, angle);
        this.modelNormal.rotate(dirx, diry, dirz, angle);
        if (state.isDisplayListOpen()) {
            double[] darr = new double[]{angle, dirx, diry, dirz};
            Transformation t1 = new Transformation(3, darr);
            state.getOpenDisplayList().addElement(t1);
        }
    }

    public void Rotate(double centerx, double centery, double centerz, double dirx, double diry, double dirz, double angle, State state) {
        this.object2WindowDirty = true;
        this.model.translate(centerx, centery, centerz);
        this.Rotate(angle, dirx, diry, dirz, state);
        this.model.translate(-centerx, -centery, -centerz);
        if (state.isDisplayListOpen()) {
            double[] darr = new double[]{centerx, centery, centerz, dirx, diry, dirz, angle};
            Transformation t1 = new Transformation(4, darr);
            state.getOpenDisplayList().addElement(t1);
        }
    }

    public void Scale(double x, double y, double z, int render_mode, State state) {
        if (x > -this.EPSILON && x < this.EPSILON) {
            x = this.EPSILON;
        }
        if (y > -this.EPSILON && y < this.EPSILON) {
            y = this.EPSILON;
        }
        if (z > -this.EPSILON && z < this.EPSILON) {
            z = this.EPSILON;
        }
        this.object2WindowDirty = true;
        this.modelNormal.scale(1.0 / x, 1.0 / y, 1.0 / z);
        this.model.scale(x, y, z);
        if (state.isDisplayListOpen()) {
            double[] darr = new double[]{x, y, z};
            Transformation t1 = new Transformation(2, darr);
            state.getOpenDisplayList().addElement(t1);
        }
    }

    public void Translate(double x, double y, double z, State state) {
        this.object2WindowDirty = true;
        this.model.translate(x, y, z);
        if (state.isDisplayListOpen()) {
            double[] darr = new double[]{x, y, z};
            Transformation t1 = new Transformation(5, darr);
            state.getOpenDisplayList().addElement(t1);
        }
    }

    public void Viewport(int x, int y, int width, int height) {
        this.object2WindowDirty = true;
        this.viewport.reset(x, y, width, height);
    }

    void Window2Object(Point4 window) {
        this.makeWindow2Object();
        double xa = window.x - (double)this.viewport.xo;
        double ya = (double)this.viewport.height - (window.y - (double)this.viewport.yo);
        double za = window.z;
        xa = xa / this.viewport.wby2 - 1.0;
        ya = ya / this.viewport.hby2 - 1.0;
        za = za / 0.5 - 1.0;
        window.set(xa, ya, za, 1.0);
        this.window2Object.preMultiply(window);
        if (Math.abs(window.t) <= (double)1.4E-45f) {
            Debug.println((String)"Bad t value in Screen2World");
        } else {
            window.scale(1.0 / window.t);
        }
    }

    void Object2Window(Point4 object) {
        this.makeObject2Window();
        object.t = 1.0;
        this.object2Window.preMultiply(object);
        double t = object.t;
        double tinv = t >= (double)-1.4E-45f && t <= (double)1.4E-45f ? (t >= 0.0 ? 3.4028234663852886E38 : -3.4028234663852886E38) : 1.0 / t;
        object.x *= tinv;
        object.y *= tinv;
        object.z *= tinv;
        object.x = (double)this.viewport.xo + (1.0 + object.x) * this.viewport.wby2;
        object.y = (double)this.viewport.yo + (1.0 - object.y) * this.viewport.hby2;
        object.z = (1.0 - object.z) * 0.5;
        if (object.x > 2.147483547E9) {
            object.x = 2.147483547E9;
            this.state.setVertexHasBeenClamped(true);
        }
        if (object.y > 2.147483547E9) {
            object.y = 2.147483547E9;
            this.state.setVertexHasBeenClamped(true);
        }
    }

    public void Object2Eye(Point4 p) {
        p.postMultiply(this.model);
        p.postMultiply(this.view);
    }

    public void Object2EyeNormal(Point4 p) {
        p.postMultiply(this.modelNormal);
        p.postMultiply(this.view);
    }

    private void makeWindow2Object() {
        this.makeObject2Window();
        if (!this.object2WindowInverted) {
            this.object2Window.inverse(this.window2Object);
            this.object2WindowInverted = true;
        }
    }

    private void makeObject2Window() {
        if (this.object2WindowDirty) {
            this.object2Window.set(this.proj);
            this.object2Window.preMultiply(this.view);
            this.object2Window.preMultiply(this.model);
            this.object2WindowDirty = false;
            this.object2WindowInverted = false;
        }
    }

    void Object2Window2(Point4 object) {
        this.makeObject2Window();
        object.t = 1.0;
        this.object2Window.preMultiply(object);
        double t = object.t;
        double tinv = t >= (double)-1.4E-45f && t <= (double)1.4E-45f ? (t >= 0.0 ? 3.4028234663852886E38 : -3.4028234663852886E38) : 1.0 / t;
        object.scale(tinv);
        object.x = (double)this.viewport.xo + (1.0 + object.x) * this.viewport.wby2;
        object.y = (double)this.viewport.yo + (1.0 - object.y) * this.viewport.hby2;
        object.z = (1.0 + object.z) * 0.5;
    }

    public double getViewportWidth() {
        return this.viewport.width;
    }

    public double getViewportHeight() {
        return this.viewport.height;
    }

    void setMinScaleValue(double d) {
        this.EPSILON = d;
    }

    double getMinScaleValue() {
        return this.EPSILON;
    }

    AffineTransform getAffineTransform() {
        this.makeObject2Window();
        AffineTransform af = new AffineTransform(this.object2Window.e[0][0], this.object2Window.e[0][1], this.object2Window.e[1][0], this.object2Window.e[1][1], this.object2Window.e[3][0], this.object2Window.e[3][1]);
        AffineTransform af2 = new AffineTransform(this.viewport.wby2, 0.0, 0.0, -this.viewport.hby2, (double)this.viewport.xo + this.viewport.wby2, (double)this.viewport.yo + this.viewport.hby2);
        af.preConcatenate(af2);
        return af;
    }
}

