/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.gl.J3Line;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.ScanConvert;
import com.sas.graphics.util.gl.State;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Map;

class SoftGraphics
extends Graphics2D {
    private static final BasicStroke defaultStroke = new BasicStroke(1.0f);
    private State state;
    private BufferedImage tinyImage = new BufferedImage(1, 1, 1);
    private Graphics2D delegateGraphics = (Graphics2D)this.tinyImage.getGraphics();
    private Color color = Color.black;
    private Point4[] dscr;
    private ScanConvert.Appearance appearance = new ScanConvert.Appearance();
    private double currentZ;
    private float currentAlpha;
    private Stroke stroke = defaultStroke;
    private int lineWidth = (int)defaultStroke.getLineWidth();
    private int endCap = defaultStroke.getEndCap();
    private int lineJoin = defaultStroke.getLineJoin();
    private HashMap renderinghints = new HashMap();
    private int shadeSave;

    public SoftGraphics(State state) {
        this.state = state;
        this.renderinghints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public Graphics2D getDelegateGraphics() {
        return this.delegateGraphics;
    }

    private void reallocVertexBuffer(int size) {
        if (this.dscr == null || this.dscr.length < size) {
            this.dscr = new Point4[size];
            for (int i = 0; i < size; ++i) {
                this.dscr[i] = new Point4();
            }
        }
    }

    public void setZ(double z) {
        this.currentZ = z;
    }

    @Override
    public Color getColor() {
        return this.color;
    }

    @Override
    public void setColor(Color c) {
        this.color = c;
        this.currentAlpha = (float)c.getAlpha() / 255.0f;
        this.setupAppearance();
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.state.ch.setPixelType(1);
        this.doDrawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.state.ch.setPixelType(1);
        this.doDrawLine(x, y + 1, x, y + height - 1);
        this.doDrawLine(x + width, y + 1, x + width, y + height - 1);
        this.doDrawLine(x + 1, y + height, x + width - 1, y);
        this.doDrawLine(x + 1, y + height, x + width - 1, y + height);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        this.reallocVertexBuffer(4);
        this.dscr[0].x = x;
        this.dscr[0].y = y;
        this.dscr[1].x = x + --width;
        this.dscr[1].y = y;
        this.dscr[2].x = x + width;
        this.dscr[2].y = y + height;
        this.dscr[3].x = x;
        this.dscr[3].y = y + height;
        this.drawFlatShadedPolygon(4);
    }

    private void setupAppearance() {
        this.appearance.color = this.color;
        this.appearance.alpha = this.currentAlpha;
        this.appearance.litColor = this.color;
    }

    private void applyCurrentDepth(int vertexCount) {
        for (int i = 0; i < vertexCount; ++i) {
            this.dscr[i].z = this.currentZ;
        }
    }

    private void stateSetupAndSave() {
        this.setupAppearance();
        this.shadeSave = this.state.shadeModel;
        this.state.shadeModel = 1;
        this.state.ch.setPixelType(0);
    }

    private void stateRestore() {
        this.state.shadeModel = this.shadeSave;
    }

    private void drawFlatShadedPolygon(int vertexCount) {
        this.applyCurrentDepth(vertexCount);
        this.stateSetupAndSave();
        this.state.scanConvert.drawConcavePolygon(this.state, vertexCount, this.dscr, this.appearance);
        this.stateRestore();
    }

    @Override
    public void drawPolyline(int[] x, int[] y, int nPoints) {
        this.state.ch.setPixelType(1);
        for (int i = 0; i < nPoints - 1; ++i) {
            this.doDrawLine(x[i], y[i], x[i + 1], y[i + 1]);
            if (this.lineJoin != 1 || i <= 0 || i >= nPoints - 2) continue;
            this.doDrawCircle(x[i], y[i], this.lineWidth);
        }
    }

    private void doDrawLine(int x1, int y1, int x2, int y2) {
        if (this.lineWidth == 1) {
            ScanConvert.bresenhamLine(this.state, this.lineWidth, x1, y1, this.currentZ, this.color, this.currentAlpha, x2, y2, this.currentZ, this.color, this.currentAlpha);
        } else {
            this.reallocVertexBuffer(4);
            J3Line.makeWideLine(this.state, this.lineWidth, this.dscr, x1, y1, this.currentZ, x2, y2, this.currentZ, null, this.endCap == 2);
            this.drawFlatShadedPolygon(4);
            if (this.endCap == 1) {
                this.doDrawCircle(x1, y1, this.lineWidth);
                this.doDrawCircle(x2, y2, this.lineWidth);
            }
        }
    }

    @Override
    public void drawPolygon(int[] x, int[] y, int nPoints) {
        for (int i = 0; i < nPoints - 1; ++i) {
            this.doDrawLine(x[i], y[i], x[i + 1], y[i + 1]);
            if (this.lineJoin != 1) continue;
            this.doDrawCircle(x[i], y[i], this.lineWidth);
        }
        this.doDrawLine(x[0], y[0], x[nPoints - 1], y[nPoints - 1]);
    }

    @Override
    public void fillPolygon(int[] x, int[] y, int nPoints) {
        this.reallocVertexBuffer(nPoints);
        for (int i = 0; i < nPoints; ++i) {
            this.dscr[i].x = x[i];
            this.dscr[i].y = y[i];
            this.dscr[i].z = this.currentZ;
        }
        this.drawFlatShadedPolygon(nPoints);
    }

    private void doDrawCircle(int centerX, int centerY, int size) {
        this.stateSetupAndSave();
        this.state.scanConvert.drawCircle(this.state, centerX, centerY, this.currentZ, size, this.appearance);
        this.stateRestore();
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.doDrawCircle(x + width / 2, y + width / 2, width);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.state.ch.setPixelType(0);
        ScanConvert.drawCircle(this.state, x + width / 2, y + height / 2, this.currentZ, width / 2, 8, this.appearance);
    }

    @Override
    public Stroke getStroke() {
        return this.stroke;
    }

    @Override
    public void setStroke(Stroke s) {
        if (s != null) {
            this.stroke = s;
            if (this.stroke instanceof BasicStroke) {
                BasicStroke bs = (BasicStroke)this.stroke;
                this.lineWidth = (int)bs.getLineWidth();
                this.endCap = bs.getEndCap();
                this.lineJoin = bs.getLineJoin();
            }
        }
    }

    @Override
    public Graphics create() {
        return this.delegateGraphics.create();
    }

    @Override
    public void translate(int x, int y) {
    }

    @Override
    public void setPaintMode() {
    }

    @Override
    public void setXORMode(Color c1) {
    }

    @Override
    public Font getFont() {
        return this.delegateGraphics.getFont();
    }

    @Override
    public void setFont(Font font) {
        this.delegateGraphics.setFont(font);
    }

    @Override
    public FontMetrics getFontMetrics(Font f) {
        return this.delegateGraphics.getFontMetrics(f);
    }

    @Override
    public Rectangle getClipBounds() {
        return this.delegateGraphics.getClipBounds();
    }

    @Override
    public void clipRect(int x, int y, int width, int height) {
        this.delegateGraphics.clipRect(x, y, width, height);
    }

    @Override
    public void setClip(int x, int y, int width, int height) {
        this.delegateGraphics.setClip(x, y, width, height);
    }

    @Override
    public Shape getClip() {
        return this.delegateGraphics.getClip();
    }

    @Override
    public void setClip(Shape clip) {
        this.delegateGraphics.setClip(clip);
    }

    @Override
    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
    }

    @Override
    public void clearRect(int x, int y, int width, int height) {
    }

    @Override
    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
    }

    @Override
    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
    }

    @Override
    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
    }

    @Override
    public void drawString(String str, int x, int y) {
    }

    @Override
    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return true;
    }

    @Override
    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public Rectangle getClipRect() {
        return this.getClipBounds();
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
    }

    @Override
    public void rotate(double theta) {
    }

    @Override
    public void scale(double sx, double sy) {
    }

    @Override
    public void shear(double shx, double shy) {
    }

    @Override
    public void translate(double tx, double ty) {
    }

    @Override
    public void rotate(double theta, double x, double y) {
    }

    @Override
    public Color getBackground() {
        return this.delegateGraphics.getBackground();
    }

    @Override
    public void setBackground(Color color) {
        this.delegateGraphics.setBackground(color);
    }

    @Override
    public Composite getComposite() {
        return this.delegateGraphics.getComposite();
    }

    @Override
    public void setComposite(Composite comp) {
        this.delegateGraphics.setComposite(comp);
    }

    @Override
    public GraphicsConfiguration getDeviceConfiguration() {
        return this.delegateGraphics.getDeviceConfiguration();
    }

    @Override
    public Paint getPaint() {
        return this.delegateGraphics.getPaint();
    }

    @Override
    public void setPaint(Paint paint) {
    }

    @Override
    public RenderingHints getRenderingHints() {
        return null;
    }

    @Override
    public void clip(Shape s) {
    }

    @Override
    public void draw(Shape s) {
    }

    @Override
    public void fill(Shape s) {
    }

    @Override
    public FontRenderContext getFontRenderContext() {
        return this.delegateGraphics.getFontRenderContext();
    }

    @Override
    public void drawGlyphVector(GlyphVector g, float x, float y) {
    }

    @Override
    public AffineTransform getTransform() {
        return this.delegateGraphics.getTransform();
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.delegateGraphics.setTransform(Tx);
    }

    @Override
    public void transform(AffineTransform Tx) {
        this.delegateGraphics.transform(Tx);
    }

    @Override
    public void drawString(String s, float x, float y) {
    }

    @Override
    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
    }

    @Override
    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    @Override
    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    @Override
    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    @Override
    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
    }

    public void addRenderingHints(Map hints) {
        this.renderinghints.putAll(hints);
    }

    public void setRenderingHints(Map hints) {
        this.renderinghints.clear();
        this.renderinghints.putAll(hints);
    }

    @Override
    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.renderinghints.get(hintKey);
    }

    @Override
    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.renderinghints.put(hintKey, hintValue);
    }

    @Override
    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }
}

