/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.gl.J3Polygon;
import com.sas.graphics.util.gl.Point4;

final class Ray {
    Point4 origin;
    Point4 direction;

    Ray() {
        this(new Point4(0.0, 0.0, 0.0, 1.0), new Point4(0.0, 0.0, -1.0, 0.0));
    }

    Ray(Point4 org, Point4 dir) {
        this.origin = org;
        this.origin.t = 1.0;
        this.direction = dir;
        this.direction.t = 0.0;
        this.direction.normalize();
    }

    double distance(J3Polygon p, Point4 temp) {
        double dist;
        Point4 intersect = temp;
        Point4 normal = p.getNormal();
        double cangle = this.direction.dot(normal);
        if (Math.abs(cangle) < (double)1.4E-45f) {
            dist = Double.NaN;
        } else {
            intersect.set(p.center);
            intersect.sub(this.origin);
            dist = intersect.dot(normal) / cangle;
        }
        return dist;
    }

    void intersectPoint(J3Polygon p, Point4 point, Point4 temp) {
        double dist = this.distance(p, temp);
        if (dist == Double.NaN) {
            point.x = Double.NaN;
        } else {
            point.x = this.direction.x;
            point.y = this.direction.y;
            point.z = this.direction.z;
            point.scale(dist);
            point.add(this.origin);
        }
    }

    double distanceToPlane(Point4 normal, double distanceToOrigin) {
        double cosTheta = normal.dot(this.direction);
        double numerator = normal.dot(this.origin) + distanceToOrigin;
        double distance = numerator / cosTheta;
        return distance;
    }

    void setOrigin(Point4 org) {
        this.origin.x = org.x;
        this.origin.y = org.y;
        this.origin.z = org.z;
    }

    void setOrigin(double x, double y, double z) {
        this.origin.x = x;
        this.origin.y = y;
        this.origin.z = z;
    }

    void setDirection(Point4 dir) {
        this.direction.x = dir.x;
        this.direction.y = dir.y;
        this.direction.z = dir.z;
        this.direction.normalize();
    }

    void setDirection(double x, double y, double z) {
        this.direction.x = x;
        this.direction.y = y;
        this.direction.z = z;
        this.direction.normalize();
    }
}

