/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.gl.Matrix4;

final class Point4
implements Cloneable {
    double x;
    double y;
    double z;
    double t;

    public Point4(double x, double y, double z, double t) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.t = t;
    }

    public Point4() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public Point4(Point4 p) {
        this(p.x, p.y, p.z, p.t);
    }

    public void set(double x, double y, double z, double t) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.t = t;
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.t = 0.0;
    }

    public void set(Point4 p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
        this.t = p.t;
    }

    public Point4 copy() {
        Point4 p = null;
        try {
            p = (Point4)this.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return p;
    }

    void normalize() {
        double length = this.length();
        if (length != 0.0) {
            this.x /= length;
            this.y /= length;
            this.z /= length;
        }
    }

    double dot(Point4 p) {
        double rc = p.x * this.x + p.y * this.y + p.z * this.z;
        return rc;
    }

    double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    void add(Point4 p) {
        this.x += p.x;
        this.y += p.y;
        this.z += p.z;
        this.t = 0.0;
    }

    void sub(Point4 p) {
        this.x -= p.x;
        this.y -= p.y;
        this.z -= p.z;
        this.t = 0.0;
    }

    void scale(double s) {
        this.x *= s;
        this.y *= s;
        this.z *= s;
        this.t *= s;
    }

    void cross(Point4 p) {
        double tx = this.x;
        double ty = this.y;
        double tz = this.z;
        this.x = ty * p.z - tz * p.y;
        this.y = tz * p.x - tx * p.z;
        this.z = tx * p.y - ty * p.x;
    }

    void postMultiply(Matrix4 m) {
        double tx = this.x;
        double ty = this.y;
        double tz = this.z;
        double tt = this.t;
        this.x = tx * m.e[0][0] + ty * m.e[1][0] + tz * m.e[2][0] + tt * m.e[3][0];
        this.y = tx * m.e[0][1] + ty * m.e[1][1] + tz * m.e[2][1] + tt * m.e[3][1];
        this.z = tx * m.e[0][2] + ty * m.e[1][2] + tz * m.e[2][2] + tt * m.e[3][2];
        this.t = tx * m.e[0][3] + ty * m.e[1][3] + tz * m.e[2][3] + tt * m.e[3][3];
    }

    static double gradient(Point4 v1, Point4 v2) {
        return Math.abs(v1.x - v2.x) + Math.abs(v1.y - v2.y) + Math.abs(v1.z - v2.z);
    }

    public String toString() {
        return "[" + this.x + "\t" + this.y + "\t" + this.z + "\t" + this.t + "]";
    }
}

