/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.gl.Matrix4;

final class MatrixStack {
    private static final int initialDepth = 3;
    private static final int depthIncrement = 3;
    private int stackDepth = 3;
    private Matrix4[] stack = MatrixStack.alloc(this.stackDepth, 0, this.stackDepth);
    private int top = 0;

    private static Matrix4[] alloc(int size, int initStart, int initStop) {
        Matrix4[] stack = new Matrix4[size];
        for (int i = initStart; i < initStop; ++i) {
            stack[i] = new Matrix4();
        }
        return stack;
    }

    private void realloc(int newDepth) {
        Matrix4[] newStack = MatrixStack.alloc(newDepth, this.stackDepth, newDepth);
        System.arraycopy(this.stack, 0, newStack, 0, this.stackDepth);
        this.stackDepth = newDepth;
        this.stack = newStack;
    }

    public Matrix4 push() {
        ++this.top;
        if (this.top > this.stackDepth - 1) {
            this.realloc(this.stackDepth + 3);
        }
        this.stack[this.top].set(this.stack[this.top - 1]);
        return this.stack[this.top];
    }

    public Matrix4 pop() {
        --this.top;
        if (this.top < 0) {
            throw new RuntimeException("Matrix stack underflow.");
        }
        return this.stack[this.top];
    }

    public Matrix4 peek() {
        return this.stack[this.top];
    }
}

