/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

final class Matrix3 {
    private static final double[] e0 = new double[]{1.0, 0.0, 0.0};
    private static final double[] e1 = new double[]{0.0, 1.0, 0.0};
    private static final double[] e2 = new double[]{0.0, 0.0, 1.0};
    double[][] e;
    double[] t = new double[3];

    Matrix3() {
        this(1.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 1.0);
    }

    Matrix3(double x1, double y1, double z1, double x2, double y2, double z2, double x3, double y3, double z3) {
        this.e = new double[3][];
        this.e[0] = new double[3];
        this.e[1] = new double[3];
        this.e[2] = new double[3];
        this.e[0][0] = x1;
        this.e[0][1] = x2;
        this.e[0][2] = x3;
        this.e[1][0] = y1;
        this.e[1][1] = y2;
        this.e[1][2] = y3;
        this.e[2][0] = z1;
        this.e[2][1] = z2;
        this.e[2][2] = z3;
    }

    Matrix3 add(Matrix3 m) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double[] dArray = this.e[i];
                int n = j;
                dArray[n] = dArray[n] + m.e[i][j];
            }
        }
        return this;
    }

    Matrix3 sub(Matrix3 m) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                double[] dArray = this.e[i];
                int n = j;
                dArray[n] = dArray[n] - m.e[i][j];
            }
        }
        return this;
    }

    Matrix3 scale(double s) {
        for (int i = 0; i < 3; ++i) {
            int j = 0;
            while (j < 3) {
                double[] dArray = this.e[i];
                int n = j++;
                dArray[n] = dArray[n] * s;
            }
        }
        return this;
    }

    void setIdentity() {
        System.arraycopy(e0, 0, this.e[0], 0, e0.length);
        System.arraycopy(e1, 0, this.e[1], 0, e1.length);
        System.arraycopy(e2, 0, this.e[2], 0, e2.length);
    }
}

