/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.image.BevelFilter;
import com.sas.graphics.image.DropShadowFilter;
import com.sas.graphics.image.GlowFilter;
import com.sas.graphics.util.Markers;
import com.sas.graphics.util.UserDefinedMarkerInterface;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.CustomMarkerInterface;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.Shape;
import com.sas.graphics.util.gl.SoftGraphics;
import com.sas.graphics.util.gl.State;
import com.sas.graphics.util.gl.TransInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

class Marker
extends Shape {
    private Point4 vertex = new Point4();
    private Point4 screen = new Point4();
    private Rectangle2D.Double bounds = new Rectangle2D.Double();
    private static int MAX_CACHE_SIZE = 200;
    private static int MAX_CACHE_MARKER_SIZE = 150;

    Marker() {
    }

    @Override
    public int getVertexCount(State state) {
        return 4;
    }

    @Override
    public Point4[] getScreenCoords(State state) {
        Point4[] t = state.ptArray;
        double half = (double)state.markerSize / 2.0 - 1.0;
        this.bounds.x = this.screen.x - half;
        this.bounds.y = this.screen.y - half;
        this.bounds.width = state.markerSize;
        this.bounds.height = state.markerSize;
        t[0].x = this.screen.x - half;
        t[0].y = this.screen.y - half;
        t[0].z = 0.0;
        t[1].x = this.screen.x + half;
        t[1].y = this.screen.y - half;
        t[1].z = 0.0;
        t[2].x = this.screen.x + half;
        t[2].y = this.screen.y + half;
        t[2].z = 0.0;
        t[3].x = this.screen.x - half;
        t[3].y = this.screen.y + half;
        t[3].z = 0.0;
        return t;
    }

    public void setVertex(double x, double y, double z) {
        this.vertex.x = x;
        this.vertex.y = y;
        this.vertex.z = z;
    }

    @Override
    public void render(State state, Graphics bgc) {
        boolean subpixel;
        TransInfo tr = state.ch.trans;
        this.screen.set(this.vertex);
        tr.Object2Window(this.screen);
        this.zmin = this.screen.z;
        this.zmax = this.screen.z;
        int x = (int)(this.screen.x + 0.5);
        int y = (int)(this.screen.y + 0.5);
        if (Marker.isMarkerOutsideOfRange(x, y, state.markerSize)) {
            return;
        }
        this.clipRect = state.clipRect;
        Rectangle originalClip = state.applyWorldClip(bgc, this.clipRect);
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        boolean bl = subpixel = state.subpixelRendering && !(bgc instanceof SoftGraphics);
        if (subpixel) {
            ((Graphics2D)bgc).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
        if (state.fillmode != 5) {
            state.softGraphics.setZ(this.screen.z);
            if (state.markerType < 189) {
                if (subpixel) {
                    if (state.skinType == 0) {
                        Markers.draw((Graphics)bgc, (Color)state.color, (Color)state.edgecolor, (int)state.markerType, (double)state.markerSize, (double)this.screen.x, (double)this.screen.y, (boolean)state.capabilities[28], (int)state.edgeWeight, (int)state.lineWidth, (boolean)state.capabilities[13], (Image)state.markerSkin);
                    } else {
                        this.drawSkin(state, bgc, this.screen.x, this.screen.y);
                    }
                } else if (state.skinType == 0) {
                    Markers.draw((Graphics)bgc, (Color)state.color, (Color)state.edgecolor, (int)state.markerType, (int)state.markerSize, (int)x, (int)y, (boolean)state.capabilities[28], (int)state.edgeWeight, (int)state.lineWidth, (boolean)state.capabilities[13], (Image)state.markerSkin);
                } else {
                    this.drawSkin(state, bgc, x, y);
                }
            } else if (Markers.isUserDefinedMarker((int)state.markerType)) {
                UserDefinedMarkerInterface udm = Markers.getUserDefinedMarker((int)state.markerType);
                if (subpixel) {
                    double dx = this.screen.x + udm.getMarkerOffsetX() * (double)state.markerSize;
                    double dy = this.screen.y - udm.getMarkerOffsetY() * (double)state.markerSize;
                    if (state.skinType == 0) {
                        Markers.draw((Graphics)bgc, (Color)state.color, (Color)state.edgecolor, (int)state.markerType, (double)state.markerSize, (double)dx, (double)dy, (boolean)state.capabilities[28], (int)state.edgeWeight, (int)state.lineWidth, (boolean)state.capabilities[13], (Image)state.markerSkin);
                    } else {
                        this.drawSkin(state, bgc, dx, dy);
                    }
                } else {
                    x += (int)(udm.getMarkerOffsetX() * (double)state.markerSize + 0.5);
                    y -= (int)(udm.getMarkerOffsetY() * (double)state.markerSize + 0.5);
                    if (state.skinType == 0) {
                        Markers.draw((Graphics)bgc, (Color)state.color, (Color)state.edgecolor, (int)state.markerType, (int)state.markerSize, (int)x, (int)y, (boolean)state.capabilities[28], (int)state.edgeWeight, (int)state.lineWidth, (boolean)state.capabilities[13], (Image)state.markerSkin);
                    } else {
                        this.drawSkin(state, bgc, x, y);
                    }
                }
            } else {
                CustomMarkerInterface marker = (CustomMarkerInterface)state.customMarkers.elementAt(state.markerType - 189 - 1);
                bgc.setColor(state.color);
                marker.paint(bgc, state.color, state.edgecolor, x - (state.markerSize - 1) / 2, y - (state.markerSize - 1) / 2, state.markerSize, state.markerSize);
            }
        }
        if (subpixel) {
            ((Graphics2D)bgc).setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        }
        state.clearWorldClip(bgc, this.clipRect, originalClip);
    }

    private static boolean isMarkerOutsideOfRange(int x0, int y0, int markerSize) {
        if (markerSize == Integer.MAX_VALUE) {
            return true;
        }
        int minScreenValue = Integer.MIN_VALUE + markerSize;
        int maxScreenValue = Integer.MAX_VALUE - markerSize;
        return x0 <= minScreenValue || y0 <= minScreenValue || x0 >= maxScreenValue || y0 >= maxScreenValue;
    }

    private void drawSkin(State state, Graphics bgc, double x, double y) {
        this.drawSkin(state, bgc, x, y, true);
    }

    private void drawSkin(State state, Graphics bgc, int x, int y) {
        this.drawSkin(state, bgc, x, y, false);
    }

    private void drawSkin(State state, Graphics bgc, double x, double y, boolean subpixel) {
        int xo;
        if (state.markerSize <= 0) {
            return;
        }
        BufferedImage filteredImage = null;
        MarkerProperties mp = null;
        if (state.cacheSkinFilters && state.skinFilterMap.get(mp = new MarkerProperties(state.markerType, state.markerSize, state.color, state.edgecolor, state.lineWidth)) != null) {
            filteredImage = (BufferedImage)state.skinFilterMap.get(mp);
        }
        boolean filled = Markers.isFilled((int)state.markerType);
        int adjustedMS = Markers.getAdjustedSize((int)state.markerType, (int)state.markerSize, (boolean)true);
        if (state.lineWidth > 1) {
            adjustedMS += state.lineWidth;
        }
        if (Markers.isUserDefinedMarker((int)state.markerType)) {
            UserDefinedMarkerInterface udm = Markers.getUserDefinedMarker((int)state.markerType);
            adjustedMS = (int)((double)adjustedMS * Math.max(udm.getMarkerScaleX(), udm.getMarkerScaleY()));
        }
        BufferedImage[] actualSizeImages = null;
        if (filteredImage == null && filled && state.pixelBenderImages != null) {
            actualSizeImages = new BufferedImage[state.pixelBenderImages.length];
            for (int i = 0; i < state.pixelBenderImages.length; ++i) {
                actualSizeImages[i] = new BufferedImage(adjustedMS, adjustedMS, 2);
                Graphics2D g2 = actualSizeImages[i].createGraphics();
                g2.drawImage(state.pixelBenderImages[i], 0, 0, adjustedMS, adjustedMS, null);
                g2.dispose();
            }
        }
        int margin = Marker.getBlurringMargin(3.0f * state.DPIScaleFactor, 4.0f * state.DPIScaleFactor, 3);
        int size = adjustedMS + margin * 2;
        int yo = xo = (int)((double)size * 0.5);
        int r = state.color.getRed();
        int g = state.color.getGreen();
        int b = state.color.getBlue();
        int a = state.color.getAlpha();
        float alpha = (float)a / 255.0f;
        Color c = new Color(r, g, b, 255);
        Color ec = state.edgecolor == null ? null : state.edgecolor;
        boolean outline = ec != null && !ec.equals(c);
        int ms = state.markerSize;
        int ew = state.lineWidth;
        if (state.lineWidth > 1 && filled && !outline) {
            ms += state.lineWidth;
            ew = 1;
        }
        BufferedImage src = null;
        if (filteredImage == null) {
            src = new BufferedImage(size, size, 2);
            Graphics2D g2 = (Graphics2D)src.getGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            if (subpixel) {
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
                double mk_xo = (double)xo + (x - (double)((int)x));
                double mk_yo = (double)yo + (y - (double)((int)y));
                Markers.draw((Graphics)g2, (Color)c, (Color)ec, (int)state.markerType, (double)ms, (double)mk_xo, (double)mk_yo, (boolean)state.capabilities[28], (int)state.edgeWeight, (int)ew, (boolean)state.capabilities[13], null);
            } else {
                Markers.draw((Graphics)g2, (Color)c, (Color)ec, (int)state.markerType, (int)ms, (int)xo, (int)yo, (boolean)state.capabilities[28], (int)state.edgeWeight, (int)ew, (boolean)state.capabilities[13], null);
            }
            g2.dispose();
        }
        int dx = (int)x - xo;
        int dy = (int)y - yo;
        Composite saveComposite = ((Graphics2D)bgc).getComposite();
        Graphics gc = bgc;
        int DX = dx;
        int DY = dy;
        BufferedImage combined = null;
        if (alpha < 1.0f) {
            combined = new BufferedImage(size, size, 2);
            bgc = combined.getGraphics();
            ((Graphics2D)bgc).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            dx = 0;
            dy = 0;
        }
        boolean borderOn = (double)ms >= 5.0 * (double)state.DPIScaleFactor;
        Color borderColor = outline ? ec : Color.black;
        float fac = (float)adjustedMS / 50.0f;
        if (filteredImage == null) {
            boolean addEntry = state.cacheSkinFilters && state.skinFilterMap.size() < MAX_CACHE_SIZE && state.markerSize <= MAX_CACHE_MARKER_SIZE;
            Graphics2D f_g2 = null;
            if (addEntry) {
                filteredImage = new BufferedImage(size, size, 2);
                f_g2 = (Graphics2D)filteredImage.getGraphics();
                f_g2.setRenderingHints(((Graphics2D)bgc).getRenderingHints());
                f_g2.setComposite(((Graphics2D)bgc).getComposite());
            }
            if (filled && actualSizeImages != null) {
                src = this.blendImages(src, actualSizeImages, state.skinCategory, state.skinType, margin, margin);
            }
            switch (state.skinType) {
                case 5: {
                    BufferedImage s_img = src;
                    DropShadowFilter shadow = new DropShadowFilter();
                    shadow.setHideObject(false);
                    shadow.setInner(false);
                    shadow.setAngle(45.0f);
                    shadow.setColor(Color.black);
                    shadow.setBlurX(4.0f * state.DPIScaleFactor);
                    shadow.setBlurY(4.0f * state.DPIScaleFactor);
                    shadow.setDistance(filled ? 2.0f * state.DPIScaleFactor : 2.5f * state.DPIScaleFactor);
                    shadow.setAlpha(filled ? 0.25f : 0.2f);
                    shadow.setQuality(0);
                    shadow.setStrength(1.0f);
                    s_img = shadow.filter(s_img, null);
                    bgc.drawImage(s_img, dx, dy, null);
                    if (addEntry) {
                        f_g2.drawImage((Image)s_img, 0, 0, null);
                    }
                    if (!filled) break;
                    BufferedImage b_img = src;
                    BevelFilter bevel = new BevelFilter();
                    bevel.setKnockout(true);
                    bevel.setAngle(45.0f);
                    bevel.setBlurX(0.0f);
                    bevel.setBlurY(0.0f);
                    bevel.setDistance(3.5f * state.DPIScaleFactor);
                    bevel.setHighlightAlpha(0.3f);
                    bevel.setHighlightColor(Color.white);
                    bevel.setShadowAlpha(0.2f);
                    bevel.setShadowColor(Color.black);
                    bevel.setQuality(0);
                    bevel.setStrength(1.0f);
                    bevel.setExtendEdge(true);
                    b_img = bevel.filter(b_img, null);
                    bgc.drawImage(b_img, dx, dy, null);
                    if (addEntry) {
                        f_g2.drawImage((Image)b_img, 0, 0, null);
                    }
                    if (!borderOn) break;
                    BufferedImage gi_img = src;
                    GlowFilter glowInner = new GlowFilter();
                    glowInner.setKnockout(true);
                    glowInner.setBlurX(1.1f * state.DPIScaleFactor);
                    glowInner.setBlurY(1.1f * state.DPIScaleFactor);
                    glowInner.setAlpha(0.8f);
                    glowInner.setColor(borderColor);
                    glowInner.setQuality(3);
                    glowInner.setStrength(15.0f);
                    glowInner.setInner(true);
                    gi_img = glowInner.filter(gi_img, null);
                    bgc.drawImage(gi_img, dx, dy, null);
                    if (!addEntry) break;
                    f_g2.drawImage((Image)gi_img, 0, 0, null);
                    break;
                }
                case 6: {
                    if (filled) {
                        BufferedImage gi_img = src;
                        GlowFilter glowInner = new GlowFilter();
                        glowInner.setKnockout(false);
                        glowInner.setBlurX(3.5f * state.DPIScaleFactor);
                        glowInner.setBlurY(3.5f * state.DPIScaleFactor);
                        glowInner.setAlpha(0.45f);
                        glowInner.setColor(Color.black);
                        glowInner.setQuality(3);
                        glowInner.setStrength(2.0f);
                        glowInner.setInner(true);
                        gi_img = glowInner.filter(gi_img, null);
                        bgc.drawImage(gi_img, dx, dy, null);
                        if (addEntry) {
                            f_g2.drawImage((Image)gi_img, 0, 0, null);
                        }
                        BufferedImage b1_img = src;
                        BevelFilter bevel1 = new BevelFilter();
                        bevel1.setKnockout(true);
                        bevel1.setAngle(0.0f);
                        bevel1.setBlurX(20.0f * fac * state.DPIScaleFactor);
                        bevel1.setBlurY(0.0f);
                        bevel1.setDistance(4.0f * (fac + 1.0f) / 2.0f * state.DPIScaleFactor);
                        bevel1.setHighlightAlpha(0.5f);
                        bevel1.setHighlightColor(Color.white);
                        bevel1.setShadowAlpha(0.0f);
                        bevel1.setShadowColor(Color.black);
                        bevel1.setQuality(2);
                        bevel1.setStrength(2.0f);
                        bevel1.setExtendEdge(true);
                        b1_img = bevel1.filter(b1_img, null);
                        bgc.drawImage(b1_img, dx, dy, null);
                        if (addEntry) {
                            f_g2.drawImage((Image)b1_img, 0, 0, null);
                        }
                        BufferedImage b2_img = src;
                        BevelFilter bevel2 = new BevelFilter();
                        bevel2.setKnockout(true);
                        bevel2.setAngle(0.0f);
                        bevel2.setBlurX(10.0f * fac * state.DPIScaleFactor);
                        bevel2.setBlurY(0.0f);
                        bevel2.setDistance(3.0f * (fac + 1.0f) / 2.0f * state.DPIScaleFactor);
                        bevel2.setHighlightAlpha(0.5f);
                        bevel2.setHighlightColor(Color.white);
                        bevel2.setShadowAlpha(0.0f);
                        bevel2.setShadowColor(Color.black);
                        bevel2.setQuality(2);
                        bevel2.setStrength(2.0f);
                        bevel2.setExtendEdge(true);
                        b2_img = bevel2.filter(b2_img, null);
                        bgc.drawImage(b2_img, dx, dy, null);
                        if (addEntry) {
                            f_g2.drawImage((Image)b2_img, 0, 0, null);
                        }
                        if (!borderOn) break;
                        BufferedImage g_img = src;
                        GlowFilter glow = new GlowFilter();
                        glow.setKnockout(true);
                        glow.setBlurX(1.1f * state.DPIScaleFactor);
                        glow.setBlurY(1.1f * state.DPIScaleFactor);
                        glow.setAlpha(0.6f);
                        glow.setColor(borderColor);
                        glow.setQuality(3);
                        glow.setStrength(8.0f);
                        glow.setInner(true);
                        g_img = glow.filter(g_img, null);
                        bgc.drawImage(g_img, dx, dy, null);
                        if (!addEntry) break;
                        f_g2.drawImage((Image)g_img, 0, 0, null);
                        break;
                    }
                    BufferedImage b2_img = src;
                    bgc.drawImage(b2_img, dx, dy, null);
                    if (!addEntry) break;
                    f_g2.drawImage((Image)b2_img, 0, 0, null);
                    break;
                }
                case 7: {
                    BufferedImage s_img = src;
                    DropShadowFilter shadow = new DropShadowFilter();
                    shadow.setHideObject(false);
                    shadow.setInner(false);
                    shadow.setAngle(45.0f);
                    shadow.setColor(Color.black);
                    shadow.setBlurX(3.0f * state.DPIScaleFactor);
                    shadow.setBlurY(3.0f * state.DPIScaleFactor);
                    shadow.setDistance(filled ? 1.7f * state.DPIScaleFactor : 2.0f * state.DPIScaleFactor);
                    shadow.setAlpha(0.4f);
                    shadow.setQuality(3);
                    shadow.setStrength(1.0f);
                    s_img = shadow.filter(s_img, null);
                    bgc.drawImage(s_img, dx, dy, null);
                    if (addEntry) {
                        f_g2.drawImage((Image)s_img, 0, 0, null);
                    }
                    if (!filled) break;
                    BufferedImage b_img = src;
                    BevelFilter bevel = new BevelFilter();
                    bevel.setKnockout(true);
                    bevel.setAngle(45.0f);
                    bevel.setBlurX(25.0f * fac * state.DPIScaleFactor);
                    bevel.setBlurY(25.0f * fac * state.DPIScaleFactor);
                    bevel.setDistance(20.0f * fac * state.DPIScaleFactor);
                    bevel.setHighlightAlpha(0.4f);
                    bevel.setHighlightColor(Color.white);
                    bevel.setShadowAlpha(0.3f);
                    bevel.setShadowColor(Color.black);
                    bevel.setQuality(3);
                    bevel.setStrength(1.0f);
                    bevel.setExtendEdge(true);
                    b_img = bevel.filter(b_img, null);
                    bgc.drawImage(b_img, dx, dy, null);
                    if (addEntry) {
                        f_g2.drawImage((Image)b_img, 0, 0, null);
                    }
                    if (!borderOn) break;
                    BufferedImage gi_img = src;
                    GlowFilter glowInner = new GlowFilter();
                    glowInner.setKnockout(true);
                    glowInner.setBlurX(1.5f * state.DPIScaleFactor);
                    glowInner.setBlurY(1.5f * state.DPIScaleFactor);
                    glowInner.setAlpha(0.6f);
                    glowInner.setColor(borderColor);
                    glowInner.setQuality(3);
                    glowInner.setStrength(3.0f);
                    glowInner.setInner(true);
                    gi_img = glowInner.filter(gi_img, null);
                    bgc.drawImage(gi_img, dx, dy, null);
                    if (!addEntry) break;
                    f_g2.drawImage((Image)gi_img, 0, 0, null);
                    break;
                }
                case 3: {
                    if (filled) {
                        BufferedImage gi_img = src;
                        GlowFilter glowInner = new GlowFilter();
                        glowInner.setKnockout(false);
                        glowInner.setBlurX(12.0f * fac * state.DPIScaleFactor);
                        glowInner.setBlurY(12.0f * fac * state.DPIScaleFactor);
                        glowInner.setAlpha(0.4f);
                        glowInner.setColor(Color.black);
                        glowInner.setQuality(2);
                        glowInner.setStrength(1.0f);
                        glowInner.setInner(true);
                        gi_img = glowInner.filter(gi_img, null);
                        bgc.drawImage(gi_img, dx, dy, null);
                        if (addEntry) {
                            f_g2.drawImage((Image)gi_img, 0, 0, null);
                        }
                        if (!borderOn) break;
                        BufferedImage g_img = src;
                        GlowFilter glow = new GlowFilter();
                        glow.setKnockout(true);
                        glow.setBlurX(1.5f * state.DPIScaleFactor);
                        glow.setBlurY(1.5f * state.DPIScaleFactor);
                        glow.setAlpha(0.6f);
                        glow.setColor(borderColor);
                        glow.setQuality(3);
                        glow.setStrength(3.0f);
                        glow.setInner(true);
                        g_img = glow.filter(g_img, null);
                        bgc.drawImage(g_img, dx, dy, null);
                        if (!addEntry) break;
                        f_g2.drawImage((Image)g_img, 0, 0, null);
                        break;
                    }
                    BufferedImage g_img = src;
                    GlowFilter glow = new GlowFilter();
                    glow.setKnockout(false);
                    glow.setBlurX(1.1f * state.DPIScaleFactor);
                    glow.setBlurY(1.1f * state.DPIScaleFactor);
                    glow.setAlpha(0.3f);
                    glow.setColor(Color.black);
                    glow.setQuality(3);
                    glow.setStrength(5.0f);
                    glow.setInner(false);
                    g_img = glow.filter(g_img, null);
                    bgc.drawImage(g_img, dx, dy, null);
                    if (!addEntry) break;
                    f_g2.drawImage((Image)g_img, 0, 0, null);
                    break;
                }
                case 4: {
                    BufferedImage s_img = src;
                    DropShadowFilter shadow = new DropShadowFilter();
                    shadow.setHideObject(false);
                    shadow.setInner(false);
                    shadow.setAngle(45.0f);
                    shadow.setColor(Color.black);
                    shadow.setBlurX(3.0f * state.DPIScaleFactor);
                    shadow.setBlurY(3.0f * state.DPIScaleFactor);
                    shadow.setDistance(3.0f * state.DPIScaleFactor);
                    shadow.setAlpha(0.25f);
                    shadow.setQuality(3);
                    shadow.setStrength(1.0f);
                    s_img = shadow.filter(s_img, null);
                    bgc.drawImage(s_img, dx, dy, null);
                    if (addEntry) {
                        f_g2.drawImage((Image)s_img, 0, 0, null);
                    }
                    if (!filled || !borderOn) break;
                    BufferedImage g_img = src;
                    GlowFilter glow = new GlowFilter();
                    glow.setKnockout(true);
                    glow.setBlurX(1.5f * state.DPIScaleFactor);
                    glow.setBlurY(1.5f * state.DPIScaleFactor);
                    glow.setAlpha(0.5f);
                    glow.setColor(borderColor);
                    glow.setQuality(3);
                    glow.setStrength(3.0f);
                    glow.setInner(true);
                    g_img = glow.filter(g_img, null);
                    bgc.drawImage(g_img, dx, dy, null);
                    if (!addEntry) break;
                    f_g2.drawImage((Image)g_img, 0, 0, null);
                    break;
                }
                default: {
                    bgc.drawImage(src, dx, dy, null);
                    if (!addEntry) break;
                    f_g2.drawImage((Image)src, 0, 0, null);
                }
            }
            if (addEntry) {
                state.skinFilterMap.put(mp, filteredImage);
                f_g2.dispose();
            }
        } else {
            bgc.drawImage(filteredImage, dx, dy, null);
        }
        if (alpha < 1.0f) {
            bgc.dispose();
            ((Graphics2D)gc).setComposite(AlphaComposite.getInstance(3, alpha));
            gc.drawImage(combined, DX, DY, null);
            ((Graphics2D)gc).setComposite(saveComposite);
        }
    }

    @Override
    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        double half = (double)state.markerSize / 2.0;
        this.bounds.x = this.screen.x - half;
        this.bounds.y = this.screen.y - half;
        this.bounds.width = state.markerSize;
        this.bounds.height = state.markerSize;
        return aperture.intersects(this.bounds);
    }

    @Override
    public void computeScreen(Channel ch) {
    }

    @Override
    public boolean isClipped() {
        return false;
    }

    @Override
    public void insertToSortlist(State state) {
    }

    private class MarkerProperties {
        int type;
        int size;
        Color color;
        Color outlineColor;
        int outlineWidth;

        MarkerProperties(int type, int size, Color c, Color ec, int ew) {
            this.type = type;
            this.size = size;
            this.color = c;
            this.outlineColor = ec;
            this.outlineWidth = ew;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MarkerProperties)) {
                return false;
            }
            MarkerProperties mp = (MarkerProperties)o;
            return this.type == mp.type && this.size == mp.size && this.outlineWidth == mp.outlineWidth && this.color.equals(mp.color) && (this.outlineColor == null && mp.outlineColor == null || this.outlineColor != null && mp.outlineColor != null && this.outlineColor.equals(mp.outlineColor));
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + this.type;
            hash = 31 * hash + this.size;
            hash = 31 * hash + this.outlineWidth;
            hash = 31 * hash + (this.color == null ? 0 : this.color.hashCode());
            hash = 31 * hash + (this.outlineColor == null ? 0 : this.outlineColor.hashCode());
            return hash;
        }
    }
}

