/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.TransInfo;

final class Light {
    public Point4 ambient = new Point4(0.0, 0.0, 0.0, 1.0);
    public Point4 diffuse = new Point4(0.0, 0.0, 0.0, 1.0);
    public Point4 specular = new Point4(0.0, 0.0, 0.0, 1.0);
    public Point4 position = new Point4(0.0, 0.0, 1.0, 0.0);
    public double constantAttenuation = 1.0;
    public double linearAttenuation = 0.0;
    public double quadraticAttenuation = 0.0;
    public Point4 spotDirection = new Point4(0.0, 0.0, -1.0, 0.0);
    public double spotExponent = 0.0;
    public double spotCutoff = 180.0;
    boolean isEnabled = false;

    Light() {
    }

    public void setParam(int paramName, Point4 param) {
        switch (paramName) {
            case 0: {
                this.ambient.set(param);
                break;
            }
            case 1: {
                this.diffuse.set(param);
                break;
            }
            case 2: {
                this.specular.set(param);
                break;
            }
            case 3: {
                this.position.set(param);
                break;
            }
            case 4: {
                this.spotDirection.set(param);
                break;
            }
            case 5: {
                this.spotExponent = param.x;
                break;
            }
            case 6: {
                this.spotCutoff = param.x;
                break;
            }
            case 7: {
                this.constantAttenuation = param.x;
                break;
            }
            case 8: {
                this.linearAttenuation = param.x;
                break;
            }
            case 9: {
                this.quadraticAttenuation = param.x;
            }
        }
    }

    public void setParam(int paramName, double param) {
        switch (paramName) {
            case 5: {
                this.spotExponent = param;
                break;
            }
            case 6: {
                this.spotCutoff = param;
                break;
            }
            case 7: {
                this.constantAttenuation = param;
                break;
            }
            case 8: {
                this.linearAttenuation = param;
                break;
            }
            case 9: {
                this.quadraticAttenuation = param;
            }
        }
    }

    public void setEnabled(boolean b) {
        this.isEnabled = b;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public void applyTransformations(TransInfo trans, int pname) {
        if (pname == 3) {
            double t = this.position.t;
            if (t > 0.0) {
                trans.Object2Eye(this.position);
            } else {
                trans.Object2EyeNormal(this.position);
            }
            this.position.t = t;
        }
        if (pname == 4) {
            trans.Object2EyeNormal(this.spotDirection);
        }
    }
}

