/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.image.BevelFilter;
import com.sas.graphics.image.DropShadowFilter;
import com.sas.graphics.image.Filter;
import com.sas.graphics.image.GlowFilter;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.ColorGradient;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.ScanConvert;
import com.sas.graphics.util.gl.Shape;
import com.sas.graphics.util.gl.State;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;

class J3Rectangle
extends Shape {
    protected Point4[] world = new Point4[2];
    protected Point4[] screen = new Point4[2];
    protected int fillmode;
    protected boolean gradientFill;
    protected ColorGradient colorGradient = null;
    protected Color edgeColor;
    protected Image texImage;
    protected int texEnvMode;
    protected int texEnvStyle;
    protected int[] stipplePattern;
    protected Rectangle2D.Double bboxD = null;

    public J3Rectangle() {
        this.world[0] = new Point4();
        this.world[1] = new Point4();
        this.screen[0] = new Point4();
        this.screen[1] = new Point4();
    }

    @Override
    public int getVertexCount(State state) {
        return 4;
    }

    @Override
    public Point4 getScreenCenter() {
        return this.screen[0];
    }

    @Override
    public Point4[] getScreenCoords(State state) {
        Point4[] t = state.ptArray;
        t[0].x = this.bbox.x;
        t[0].y = this.bbox.y;
        t[0].z = 0.0;
        t[1].x = this.bbox.x + this.bbox.width;
        t[1].y = this.bbox.y;
        t[1].z = 0.0;
        t[2].x = this.bbox.x + this.bbox.width;
        t[2].y = this.bbox.y + this.bbox.height;
        t[2].z = 0.0;
        t[3].x = this.bbox.x;
        t[3].y = this.bbox.y + this.bbox.height;
        t[3].z = 0.0;
        return t;
    }

    @Override
    public final void render(State state, Graphics bgc) {
        if (this.clip) {
            return;
        }
        if (bgc == null) {
            return;
        }
        Rectangle originalClip = state.applyWorldClip(bgc, this.clipRect);
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        if (state.isSoftwareRender()) {
            this.softwareRender(state, bgc);
        } else if (state.skinType == 0) {
            this.awtRender(state, bgc);
        } else {
            this.drawSkin(state, bgc);
        }
        state.clearWorldClip(bgc, this.clipRect, originalClip);
    }

    private void softwareRender(State state, Graphics bgc) {
        switch (this.fillmode) {
            default: {
                this.drawSoftwareFill(state, bgc);
                this.drawSoftwareTexture(state, bgc);
                this.drawSoftwareShadow(state, bgc);
                break;
            }
            case 2: {
                this.drawSoftwareOutline(state, bgc, this.color);
                break;
            }
            case 4: {
                this.drawSoftwareFill(state, bgc);
                this.drawSoftwareTexture(state, bgc);
                this.drawSoftwareShadow(state, bgc);
                this.drawSoftwareOutline(state, bgc, this.edgeColor);
            }
            case 5: 
        }
    }

    private void drawSoftwareShadow(State state, Graphics bgc) {
        if (this.shadowEnabled) {
            int x;
            int extra;
            int y;
            float aInitial = 0.8f;
            float aEnd = 0.01f;
            int width = this.bbox.width;
            int height = this.shadowOffsetY;
            float aInc = (aEnd - aInitial) / (float)height;
            float a = aInitial;
            float r = (float)state.shadowColor.getRed() / 256.0f;
            float g = (float)state.shadowColor.getGreen() / 256.0f;
            float b = (float)state.shadowColor.getBlue() / 256.0f;
            for (y = 0; y < height; ++y) {
                extra = y > this.shadowOffsetX ? this.shadowOffsetX : y;
                for (x = 0; x < width - this.shadowOffsetX + extra; ++x) {
                    state.ch.plant(this.bbox.x + this.shadowOffsetX + x, this.bbox.y + this.bbox.height + y, 0.0, a, r, g, b);
                }
                a += aInc;
            }
            width = this.shadowOffsetX;
            height = this.bbox.height;
            aInc = (aEnd - aInitial) / (float)width;
            a = aInitial;
            for (x = 0; x < width; ++x) {
                extra = x > this.shadowOffsetY - 1 ? this.shadowOffsetY - 1 : x;
                for (y = 0; y < height - this.shadowOffsetY + 1 + extra; ++y) {
                    state.ch.plant(this.bbox.x + this.bbox.width + x, this.bbox.y + this.shadowOffsetY + y, 0.0, a, r, g, b);
                }
                a += aInc;
            }
        }
    }

    private void drawSoftwareFill(State state, Graphics bgc) {
        block11: {
            block12: {
                if (this.texImage != null && this.texEnvMode != 3) break block11;
                if (!this.gradientFill) break block12;
                float r1 = (float)this.colorGradient.color1.getRed() / 255.0f;
                float g1 = (float)this.colorGradient.color1.getGreen() / 255.0f;
                float b1 = (float)this.colorGradient.color1.getBlue() / 255.0f;
                float a1 = this.colorGradient.alpha1;
                float r2 = (float)this.colorGradient.color2.getRed() / 255.0f;
                float g2 = (float)this.colorGradient.color2.getGreen() / 255.0f;
                float b2 = (float)this.colorGradient.color2.getBlue() / 255.0f;
                float a2 = this.colorGradient.alpha2;
                switch (this.colorGradient.direction) {
                    case 0: {
                        for (int x = this.bbox.x; x < this.bbox.x + this.bbox.width; ++x) {
                            float factor = (float)(x - this.bbox.x) / (float)this.bbox.width;
                            float r = r1 + factor * (r2 - r1);
                            float g = g1 + factor * (g2 - g1);
                            float b = b1 + factor * (b2 - b1);
                            float a = a1 + factor * (a2 - a1);
                            for (int y = this.bbox.y; y < this.bbox.y + this.bbox.height; ++y) {
                                state.ch.plant(x, y, 0.0, a, r, g, b);
                            }
                        }
                        break block11;
                    }
                    default: {
                        for (int y = this.bbox.y; y < this.bbox.y + this.bbox.height; ++y) {
                            float factor = (float)(y - this.bbox.y) / (float)this.bbox.height;
                            float r = r1 + factor * (r2 - r1);
                            float g = g1 + factor * (g2 - g1);
                            float b = b1 + factor * (b2 - b1);
                            float a = a1 + factor * (a2 - a1);
                            for (int x = this.bbox.x; x < this.bbox.x + this.bbox.width; ++x) {
                                state.ch.plant(x, y, 0.0, a, r, g, b);
                            }
                        }
                        break block11;
                    }
                    case 2: 
                    case 3: {
                        break;
                    }
                }
                break block11;
            }
            float r = (float)this.color.getRed() / 255.0f;
            float g = (float)this.color.getGreen() / 255.0f;
            float b = (float)this.color.getBlue() / 255.0f;
            float a = this.alpha;
            int argb = this.color.getRGB();
            for (int y = this.bbox.y; y < this.bbox.y + this.bbox.height; ++y) {
                for (int x = this.bbox.x; x < this.bbox.x + this.bbox.width; ++x) {
                    if (state.capabilities[12]) {
                        state.ch.plant(x, y, 0.0, a, r, g, b);
                        continue;
                    }
                    state.ch.plant(x, y, 0.0, argb);
                }
            }
        }
    }

    private void drawSoftwareOutline(State state, Graphics bgc, Color col) {
        int[] x = new int[]{this.bbox.x, this.bbox.x + this.bbox.width - 1, this.bbox.x + this.bbox.width - 1, this.bbox.x, this.bbox.x};
        int[] y = new int[]{this.bbox.y, this.bbox.y, this.bbox.y + this.bbox.height - 1, this.bbox.y + this.bbox.height - 1, this.bbox.y};
        for (int i = 0; i < 5; ++i) {
            int nextI = (i + 1) % 5;
            ScanConvert.bresenhamLine(state, state.lineWidth, x[i], y[i], 0.0, col, 1.0f, x[nextI], y[nextI], 0.0, col, 1.0f);
        }
    }

    private void drawSoftwareTexture(State state, Graphics bgc) {
        if (this.texImage != null) {
            state.ch.setTexturePlant(true);
            switch (this.texEnvStyle) {
                case 5: 
                case 6: {
                    this.drawSoftwareTiledTexture(state, bgc);
                    break;
                }
                case 4: {
                    this.drawSoftwareScaledTexture(state, bgc);
                    break;
                }
            }
            state.ch.setTexturePlant(false);
        }
    }

    private void drawSoftwareTiledTexture(State state, Graphics bgc) {
        Image tex;
        int texImageHeight = this.texImage.getHeight(state.ch.component);
        int texImageWidth = this.texImage.getWidth(state.ch.component);
        if (this.texEnvStyle == 5) {
            int height = (int)((double)this.bbox.width * (double)texImageHeight / (double)texImageWidth);
            tex = this.texImage.getScaledInstance(this.bbox.width, height, 1);
            texImageWidth = this.bbox.width;
            texImageHeight = height;
        } else {
            int width = (int)((double)this.bbox.height * (double)texImageWidth / (double)texImageHeight);
            tex = this.texImage.getScaledInstance(width, this.bbox.height, 1);
            texImageWidth = width;
            texImageHeight = this.bbox.height;
        }
        int[] texPixels = state.getTempPixelBuffer(texImageWidth * texImageHeight);
        PixelGrabber pg = new PixelGrabber(tex, 0, 0, texImageWidth, texImageHeight, texPixels, 0, texImageWidth);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.texEnvStyle == 5) {
            int verticalTileCount = (int)Math.ceil((double)this.bbox.height / (double)texImageHeight);
            int startRow = this.bbox.y + this.bbox.height - 1;
            for (int i = 0; i < verticalTileCount; ++i) {
                int rowsToCopy = startRow - this.bbox.y > texImageHeight ? texImageHeight : startRow - this.bbox.y + 1;
                for (int y = 0; y < rowsToCopy; ++y) {
                    for (int x = 0; x < texImageWidth; ++x) {
                        int pixelIndex = x + (texImageHeight - 1 - y) * texImageWidth;
                        if (pixelIndex < 0 || pixelIndex >= texPixels.length) continue;
                        int argb = texPixels[pixelIndex];
                        this.plantTexPixel(this.bbox.x + x, startRow - y, argb, this.texEnvMode, state);
                    }
                }
                startRow -= texImageHeight;
            }
        } else {
            int horizontalTileCount = (int)Math.ceil((double)this.bbox.width / (double)texImageWidth);
            int startCol = this.bbox.x + this.bbox.width - 1;
            for (int i = 0; i < horizontalTileCount; ++i) {
                int colsToCopy = startCol - this.bbox.x > texImageWidth ? texImageWidth : startCol - this.bbox.x + 1;
                for (int x = 0; x < colsToCopy; ++x) {
                    for (int y = 0; y < texImageHeight; ++y) {
                        int pixelIndex = texImageWidth - x + y * texImageWidth;
                        if (pixelIndex < 0 || pixelIndex >= texPixels.length) continue;
                        int argb = texPixels[pixelIndex];
                        this.plantTexPixel(startCol - x, this.bbox.y + y, argb, this.texEnvMode, state);
                    }
                }
                startCol -= texImageWidth;
            }
        }
    }

    private void drawSoftwareScaledTexture(State state, Graphics bgc) {
        Image tex = this.texImage.getScaledInstance(this.bbox.width, this.bbox.height, 1);
        int[] texPixels = state.getTempPixelBuffer(this.bbox.width * this.bbox.height);
        PixelGrabber pg = new PixelGrabber(tex, 0, 0, this.bbox.width, this.bbox.height, texPixels, 0, this.bbox.width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        for (int y = 0; y < this.bbox.height; ++y) {
            for (int x = 0; x < this.bbox.width; ++x) {
                int argb = texPixels[x + y * this.bbox.width];
                this.plantTexPixel(this.bbox.x + x, this.bbox.y + y, argb, this.texEnvMode, state);
            }
        }
    }

    private void plantTexPixel(int x, int y, int argb, int mode, State state) {
        if (mode == 3) {
            float a = this.alpha;
            float r = (float)(argb >> 16 & 0xFF) / 255.0f;
            float g = (float)(argb >> 8 & 0xFF) / 255.0f;
            float b = (float)(argb & 0xFF) / 255.0f;
            state.ch.plant(x, y, 0.0, a, r, g, b);
        } else {
            state.ch.plant(x, y, 0.0, argb);
        }
    }

    public void setCorners(double x1, double y1, double x2, double y2) {
        this.world[0].x = x1;
        this.world[0].y = y1;
        this.world[0].z = 0.0;
        this.world[1].x = x2;
        this.world[1].y = y2;
        this.world[1].z = 0.0;
    }

    public void setColorGradient(ColorGradient gradient) {
        boolean bl = this.gradientFill = gradient != null;
        if (gradient == null) {
            return;
        }
        if (this.colorGradient == null) {
            this.colorGradient = new ColorGradient();
        }
        this.colorGradient.color1 = gradient.color1;
        this.colorGradient.alpha1 = gradient.alpha1;
        this.colorGradient.color2 = gradient.color2;
        this.colorGradient.alpha2 = gradient.alpha2;
        this.colorGradient.direction = gradient.direction;
        if (this.colorGradient.alpha1 != 1.0f) {
            this.colorGradient.color1 = new Color(gradient.color1.getRed(), gradient.color1.getGreen(), gradient.color1.getBlue(), (int)(gradient.alpha1 * 255.0f));
        }
        if (this.colorGradient.alpha2 != 1.0f) {
            this.colorGradient.color2 = new Color(gradient.color2.getRed(), gradient.color2.getGreen(), gradient.color2.getBlue(), (int)(gradient.alpha2 * 255.0f));
        }
    }

    @Override
    public void computeScreen(Channel ch) {
        int ymax;
        int ymin;
        int xmax;
        int xmin;
        super.computeScreen(ch);
        this.stipplePattern = (int[])(ch.state.capabilities[6] && ch.state.getStipplePattern() != null ? ch.state.getStipplePattern() : null);
        this.edgeColor = ch.state.edgecolor;
        this.fillmode = ch.state.fillmode;
        this.texImage = null;
        if (ch.state.capabilities[10]) {
            this.texImage = ch.state.texImage;
            this.texEnvMode = ch.state.texEnvMode;
            this.texEnvStyle = ch.state.texEnvStyle;
        }
        this.screen[0].set(this.world[0]);
        ch.trans.Object2Window(this.screen[0]);
        this.screen[1].set(this.world[1]);
        ch.trans.Object2Window(this.screen[1]);
        Rectangle maxArea = ch.getMaximumProjectionArea();
        if (maxArea == null) {
            xmin = (int)(Math.min(this.screen[0].x, this.screen[1].x) + 0.5);
            xmax = (int)(Math.max(this.screen[0].x, this.screen[1].x) + 0.5);
            ymin = (int)(Math.min(this.screen[0].y, this.screen[1].y) + 0.5);
            ymax = (int)(Math.max(this.screen[0].y, this.screen[1].y) + 0.5);
        } else {
            double dxmin = Math.min(this.screen[0].x, this.screen[1].x) + 0.5;
            double dxmax = Math.max(this.screen[0].x, this.screen[1].x) + 0.5;
            double dymin = Math.min(this.screen[0].y, this.screen[1].y) + 0.5;
            double dymax = Math.max(this.screen[0].y, this.screen[1].y) + 0.5;
            int x1 = maxArea.x;
            int x2 = maxArea.x + maxArea.width;
            int y1 = maxArea.y;
            int y2 = maxArea.y + maxArea.height;
            xmin = (int)Math.min(Math.max(dxmin, (double)x1), (double)x2);
            xmax = (int)Math.max(Math.min(dxmax, (double)x2), (double)x1);
            ymin = (int)Math.min(Math.max(dymin, (double)y1), (double)y2);
            ymax = (int)Math.max(Math.min(dymax, (double)y2), (double)y1);
        }
        this.bbox.x = xmin;
        this.bbox.y = ymin;
        this.bbox.width = xmax - xmin + 1;
        this.bbox.height = ymax - ymin + 1;
        if (ch.state.subpixelRendering) {
            double ymax_d;
            double ymin_d;
            double xmax_d;
            double xmin_d;
            if (this.bboxD == null) {
                this.bboxD = new Rectangle2D.Double();
            }
            if (maxArea == null) {
                xmin_d = Math.min(this.screen[0].x, this.screen[1].x);
                xmax_d = Math.max(this.screen[0].x, this.screen[1].x);
                ymin_d = Math.min(this.screen[0].y, this.screen[1].y);
                ymax_d = Math.max(this.screen[0].y, this.screen[1].y);
            } else {
                xmin_d = Math.max(Math.min(this.screen[0].x, this.screen[1].x), (double)maxArea.x);
                xmax_d = Math.min(Math.max(this.screen[0].x, this.screen[1].x), (double)(maxArea.x + maxArea.width));
                ymin_d = Math.max(Math.min(this.screen[0].y, this.screen[1].y), (double)maxArea.y);
                ymax_d = Math.min(Math.max(this.screen[0].y, this.screen[1].y), (double)(maxArea.y + maxArea.height));
            }
            this.bboxD.x = xmin_d;
            this.bboxD.y = ymin_d;
            this.bboxD.width = xmax_d - xmin_d + 1.0;
            this.bboxD.height = ymax_d - ymin_d + 1.0;
        }
        this.clip = false;
        if (this.texImage != null && !(this.texImage instanceof BufferedImage)) {
            int w = this.texImage.getWidth(null);
            int h = this.texImage.getHeight(null);
            BufferedImage bufferedImage = new BufferedImage(w, h, 1);
            bufferedImage.getGraphics().drawImage(this.texImage, 0, 0, null);
            this.texImage = bufferedImage;
            ch.state.texImage = bufferedImage;
        }
    }

    @Override
    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        if (this.clip) {
            return false;
        }
        Rectangle bounds = state.rt1;
        bounds.setBounds(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        Rectangle clippedBounds = state.ApplyClip(this.clipRect, bounds);
        return aperture.intersects(clippedBounds);
    }

    protected void awtRender(State state, Graphics bgc) {
        Graphics2D g2 = (Graphics2D)bgc;
        switch (this.fillmode) {
            default: {
                this.drawFill(state, bgc);
                break;
            }
            case 6: 
            case 7: {
                bgc.setColor(this.color);
                if (this.fillmode == 6) {
                    this.drawOutline(state, bgc);
                }
                if (this.bbox.width <= 4) break;
                Paint save = g2.getPaint();
                g2.setPaint(state.fillPattern.getHatch45(this.color));
                bgc.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                g2.setPaint(save);
                break;
            }
            case 2: {
                bgc.setColor(this.color);
                this.drawOutline(state, bgc);
                break;
            }
            case 4: {
                this.drawFill(state, bgc);
                bgc.setColor(this.edgeColor);
                this.drawOutline(state, bgc);
                break;
            }
            case 8: {
                bgc.setColor(this.color);
                if (state.subpixelRendering) {
                    this.drawSubpixelFillPattern(state, bgc);
                    break;
                }
                this.drawFillPattern(state, bgc);
            }
            case 5: 
        }
    }

    protected void drawSkin(State state, Graphics bgc) {
        Filter[] filters;
        boolean borderOn;
        if (this.bbox.width <= 0 || this.bbox.height <= 0) {
            this.awtRender(state, bgc);
            return;
        }
        BufferedImage[] actualSizeImages = null;
        if (state.pixelBenderImages != null) {
            actualSizeImages = new BufferedImage[state.pixelBenderImages.length];
            for (int i = 0; i < state.pixelBenderImages.length; ++i) {
                actualSizeImages[i] = new BufferedImage(this.bbox.width, this.bbox.height, 2);
                Graphics2D g2 = actualSizeImages[i].createGraphics();
                g2.drawImage(state.pixelBenderImages[i], 0, 0, this.bbox.width, this.bbox.height, null);
                g2.dispose();
            }
        }
        int margin = state.lineWidth + J3Rectangle.getBlurringMargin(state.skinCategory, state.skinType, state.DPIScaleFactor);
        int img_w = this.bbox.width + margin * 2;
        int img_h = this.bbox.height + margin * 2;
        BufferedImage src = new BufferedImage(img_w, img_h, 2);
        Graphics2D g2 = (Graphics2D)src.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.translate(-this.bbox.x + margin, -this.bbox.y + margin);
        Color saveColor = this.color;
        int r = this.color.getRed();
        int g = this.color.getGreen();
        int b = this.color.getBlue();
        int a = this.color.getAlpha();
        this.alpha = (float)a / 255.0f;
        this.color = new Color(r, g, b, 255);
        this.awtRender(state, g2);
        this.color = saveColor;
        g2.dispose();
        int dx = this.bbox.x - margin;
        int dy = this.bbox.y - margin;
        Composite saveComposite = ((Graphics2D)bgc).getComposite();
        Graphics gc = bgc;
        int DX = dx;
        int DY = dy;
        BufferedImage combined = null;
        if (this.alpha < 1.0f) {
            combined = new BufferedImage(img_w, img_h, 2);
            bgc = combined.getGraphics();
            ((Graphics2D)bgc).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            dx = 0;
            dy = 0;
        }
        if (actualSizeImages != null) {
            src = this.blendImages(src, actualSizeImages, state.skinCategory, state.skinType, margin, margin);
        }
        boolean graphRendered = false;
        if ((state.skinRenderMode & 2) != 0 || (state.skinRenderMode & 0x10) != 0) {
            BufferedImage s_img = src;
            DropShadowFilter shadow = J3Rectangle.createDropShadowFilter(state.skinCategory, state.skinType, state.DPIScaleFactor);
            if (shadow != null) {
                if ((state.skinRenderMode & 0x10) != 0) {
                    shadow.setKnockout(true);
                    shadow.setHideObject(true);
                }
                s_img = shadow.filter(s_img, null);
                bgc.drawImage(s_img, dx, dy, null);
                graphRendered = true;
            }
        }
        if ((state.skinRenderMode & 1) != 0 && !graphRendered) {
            bgc.drawImage(src, dx, dy, null);
        }
        if ((state.skinRenderMode & 4) != 0) {
            BufferedImage b_img = src;
            BevelFilter bevel = J3Rectangle.createBevelFilter(state.skinCategory, state.skinType, this.bbox, state.DPIScaleFactor);
            if (bevel != null) {
                b_img = bevel.filter(b_img, null);
                bgc.drawImage(b_img, dx, dy, null);
            }
        }
        boolean bl = borderOn = state.skinCategory == 1 && (float)this.bbox.width >= 5.0f * state.DPIScaleFactor || state.skinCategory == 2 && (float)this.bbox.height >= 5.0f * state.DPIScaleFactor;
        if ((state.skinRenderMode & 8) != 0 && borderOn) {
            BufferedImage g_img = src;
            GlowFilter glow = J3Rectangle.createGlowFilter(state.skinCategory, state.skinType, state.DPIScaleFactor);
            if (glow != null) {
                g_img = glow.filter(g_img, null);
                bgc.drawImage(g_img, dx, dy, null);
            }
        }
        if ((filters = this.createAdditionalFilters(state.skinCategory, state.skinType, state.DPIScaleFactor)) != null) {
            for (int i = 0; i < filters.length; ++i) {
                BufferedImage img = src;
                img = filters[i].filter(img, null);
                bgc.drawImage(img, dx, dy, null);
            }
        }
        if (this.alpha < 1.0f) {
            bgc.dispose();
            ((Graphics2D)gc).setComposite(AlphaComposite.getInstance(3, this.alpha));
            gc.drawImage(combined, DX, DY, null);
            ((Graphics2D)gc).setComposite(saveComposite);
        }
    }

    private void drawSubpixelRect(Graphics2D g2, Rectangle2D.Double rect, boolean fill) {
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        if (fill) {
            g2.fill(rect);
        } else {
            g2.draw(new Rectangle2D.Double(rect.x, rect.y, rect.width - 1.0, rect.height - 1.0));
        }
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
    }

    private void drawOutline(State state, Graphics bgc) {
        Graphics2D g2 = (Graphics2D)bgc;
        Stroke save = g2.getStroke();
        BasicStroke bs = state.getStroke(state.lineWidth, 0, 1, this.stipplePattern);
        g2.setStroke(bs);
        if (state.subpixelRendering) {
            this.drawSubpixelRect(g2, this.bboxD, false);
        } else {
            g2.drawRect(this.bbox.x, this.bbox.y, this.bbox.width - 1, this.bbox.height - 1);
        }
        g2.setStroke(save);
    }

    private void drawFill(State state, Graphics bgc) {
        Graphics2D g2;
        if (!this.isDecalTexture()) {
            if (!this.gradientFill) {
                bgc.setColor(this.color);
                if (state.subpixelRendering) {
                    this.drawSubpixelRect((Graphics2D)bgc, this.bboxD, true);
                } else {
                    bgc.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                }
            } else {
                GradientPaint gp;
                g2 = (Graphics2D)bgc;
                Paint save = g2.getPaint();
                switch (this.colorGradient.direction) {
                    case 0: {
                        gp = new GradientPaint(this.bbox.x, this.bbox.y, this.colorGradient.color1, this.bbox.x + this.bbox.width, this.bbox.y, this.colorGradient.color2);
                        break;
                    }
                    default: {
                        gp = new GradientPaint(this.bbox.x, this.bbox.y, this.colorGradient.color1, this.bbox.x, this.bbox.y + this.bbox.height, this.colorGradient.color2);
                        break;
                    }
                    case 2: {
                        gp = new GradientPaint(this.bbox.x, this.bbox.y + this.bbox.height, this.colorGradient.color1, this.bbox.x + this.bbox.width, this.bbox.y, this.colorGradient.color2);
                        break;
                    }
                    case 3: {
                        gp = new GradientPaint(this.bbox.x, this.bbox.y, this.colorGradient.color1, this.bbox.x + this.bbox.width, this.bbox.y + this.bbox.height, this.colorGradient.color2);
                    }
                }
                g2.setPaint(gp);
                bgc.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                g2.setPaint(save);
            }
        }
        if (this.texImage != null) {
            Rectangle2D.Double tr;
            g2 = (Graphics2D)bgc;
            Paint savePaint = g2.getPaint();
            Composite saveComposite = g2.getComposite();
            if (!(this.texImage instanceof BufferedImage)) {
                throw new RuntimeException("Texture images must be of type BufferImage.");
            }
            BufferedImage i = (BufferedImage)this.texImage;
            if (this.texEnvStyle == 4) {
                tr = new Rectangle2D.Double(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
            } else {
                int w = this.texImage.getWidth(null);
                int h = this.texImage.getHeight(null);
                tr = new Rectangle2D.Double(this.bbox.x, this.bbox.y, w, h);
            }
            TexturePaint tp = new TexturePaint(i, tr);
            if (this.isModulatedTexture()) {
                AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
                g2.setComposite(ac);
            }
            g2.setPaint(tp);
            bgc.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
            g2.setPaint(savePaint);
            g2.setComposite(saveComposite);
        }
    }

    private void drawFillPattern(State state, Graphics bgc) {
        boolean doubleLine;
        int gap = 0;
        int step = 0;
        int thickness = state.fillPatternWidth;
        boolean bl = doubleLine = state.fillPatternWidth == 4 || state.fillPatternWidth == 5;
        if (doubleLine) {
            gap = state.fillPatternWidth == 4 ? 3 : 5;
            thickness = state.fillPatternWidth == 4 ? 1 : 2;
            step = gap + thickness;
        }
        int stride = 5 + state.fillPatternWidth * 3;
        thickness = (int)Math.round((double)thickness * state.fillPatternScaleFactor);
        gap = (int)Math.round((double)gap * state.fillPatternScaleFactor);
        step = (int)Math.round((double)step * state.fillPatternScaleFactor);
        stride = (int)Math.round((double)stride * state.fillPatternScaleFactor);
        Graphics2D g2 = (Graphics2D)bgc;
        Stroke save = g2.getStroke();
        Rectangle clip = g2.getClipBounds();
        g2.setStroke(new BasicStroke(thickness));
        if (clip == null) {
            g2.setClip(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
        } else {
            int clip_x1 = Math.max(clip.x, this.bbox.x);
            int clip_y1 = Math.max(clip.y, this.bbox.y);
            int clip_x2 = Math.min(clip.x + clip.width, this.bbox.x + this.bbox.width);
            int clip_y2 = Math.min(clip.y + clip.height, this.bbox.y + this.bbox.height);
            g2.setClip(clip_x1, clip_y1, clip_x2 - clip_x1, clip_y2 - clip_y1);
        }
        int w = this.bbox.width - 1;
        int x2 = this.bbox.x + w;
        int y2 = this.bbox.y + this.bbox.height - 1;
        switch (state.fillPatternType) {
            case 0: {
                for (int y = this.bbox.y; y < y2; y += stride) {
                    g2.drawLine(this.bbox.x, y, x2, y + w);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step, x2, y + step + w);
                }
                int x = this.bbox.x;
                for (int y = this.bbox.y + w - stride; y >= this.bbox.y; y -= stride) {
                    g2.drawLine(x += stride, this.bbox.y, x2, y);
                    if (!doubleLine) continue;
                    g2.drawLine(x - step, this.bbox.y, x2, y + step);
                }
                break;
            }
            case 1: {
                int y;
                for (y = this.bbox.y; y < y2; y += stride) {
                    g2.drawLine(this.bbox.x, y + w, x2, y);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step + w, x2, y + step);
                }
                int x = x2;
                for (y = this.bbox.y + w - stride; y >= this.bbox.y; y -= stride) {
                    g2.drawLine(this.bbox.x, y, x -= stride, this.bbox.y);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step, x + step, this.bbox.y);
                }
                break;
            }
            case 2: {
                for (int y = this.bbox.y; y < y2; y += stride) {
                    g2.drawLine(this.bbox.x, y, x2, y + w);
                    if (doubleLine) {
                        g2.drawLine(this.bbox.x, y + step, x2, y + step + w);
                    }
                    g2.drawLine(this.bbox.x, y + w, x2, y);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step + w, x2, y + step);
                }
                int xl = this.bbox.x;
                int xr = x2;
                for (int y = this.bbox.y + w - stride; y >= this.bbox.y; y -= stride) {
                    g2.drawLine(xl += stride, this.bbox.y, x2, y);
                    if (doubleLine) {
                        g2.drawLine(xl - step, this.bbox.y, x2, y + step);
                    }
                    g2.drawLine(this.bbox.x, y, xr -= stride, this.bbox.y);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step, xr + step, this.bbox.y);
                }
                break;
            }
            case 3: {
                g2.fillRect(this.bbox.x, this.bbox.y, this.bbox.width, this.bbox.height);
                break;
            }
        }
        g2.setClip(clip);
        g2.setStroke(save);
    }

    private void drawSubpixelFillPattern(State state, Graphics bgc) {
        boolean doubleLine;
        int gap = 0;
        int step = 0;
        int thickness = state.fillPatternWidth;
        boolean bl = doubleLine = state.fillPatternWidth == 4 || state.fillPatternWidth == 5;
        if (doubleLine) {
            gap = state.fillPatternWidth == 4 ? 3 : 5;
            thickness = state.fillPatternWidth == 4 ? 1 : 2;
            step = gap + thickness;
        }
        int stride = 5 + state.fillPatternWidth * 3;
        thickness = (int)Math.round((double)thickness * state.fillPatternScaleFactor);
        gap = (int)Math.round((double)gap * state.fillPatternScaleFactor);
        step = (int)Math.round((double)step * state.fillPatternScaleFactor);
        stride = (int)Math.round((double)stride * state.fillPatternScaleFactor);
        Graphics2D g2 = (Graphics2D)bgc;
        Stroke save = g2.getStroke();
        Rectangle clip = g2.getClipBounds();
        g2.setStroke(new BasicStroke(thickness));
        if (clip == null) {
            g2.setClip(new Rectangle2D.Double(this.bboxD.x, this.bboxD.y, this.bboxD.width - 1.0, this.bboxD.height - 1.0));
        } else {
            double clip_x1 = Math.max((double)clip.x, this.bboxD.x);
            double clip_y1 = Math.max((double)clip.y, this.bboxD.y);
            double clip_x2 = Math.min((double)(clip.x + clip.width), this.bboxD.x + this.bboxD.width - 1.0);
            double clip_y2 = Math.min((double)(clip.y + clip.height), this.bboxD.y + this.bboxD.height - 1.0);
            g2.setClip(new Rectangle2D.Double(clip_x1, clip_y1, clip_x2 - clip_x1, clip_y2 - clip_y1));
        }
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        double w = this.bboxD.width - 1.0;
        double x2 = this.bboxD.x + w;
        double y2 = this.bboxD.y + this.bboxD.height - 1.0;
        switch (state.fillPatternType) {
            case 0: {
                for (double y = this.bboxD.y; y < y2; y += (double)stride) {
                    g2.draw(new Line2D.Double(this.bboxD.x, y, x2, y + w));
                    if (!doubleLine) continue;
                    g2.draw(new Line2D.Double(this.bboxD.x, y + (double)step, x2, y + (double)step + w));
                }
                double x = this.bboxD.x;
                for (double y = this.bboxD.y + w - (double)stride; y >= this.bboxD.y; y -= (double)stride) {
                    g2.draw(new Line2D.Double(x += (double)stride, this.bboxD.y, x2, y));
                    if (!doubleLine) continue;
                    g2.draw(new Line2D.Double(x - (double)step, this.bboxD.y, x2, y + (double)step));
                }
                break;
            }
            case 1: {
                double y;
                for (y = this.bboxD.y; y < y2; y += (double)stride) {
                    g2.draw(new Line2D.Double(this.bboxD.x, y + w, x2, y));
                    if (!doubleLine) continue;
                    g2.draw(new Line2D.Double(this.bboxD.x, y + (double)step + w, x2, y + (double)step));
                }
                double x = x2;
                for (y = this.bboxD.y + w - (double)stride; y >= this.bboxD.y; y -= (double)stride) {
                    g2.draw(new Line2D.Double(this.bboxD.x, y, x -= (double)stride, this.bboxD.y));
                    if (!doubleLine) continue;
                    g2.draw(new Line2D.Double(this.bboxD.x, y + (double)step, x + (double)step, this.bboxD.y));
                }
                break;
            }
            case 2: {
                for (double y = this.bboxD.y; y < y2; y += (double)stride) {
                    g2.draw(new Line2D.Double(this.bboxD.x, y, x2, y + w));
                    if (doubleLine) {
                        g2.draw(new Line2D.Double(this.bboxD.x, y + (double)step, x2, y + (double)step + w));
                    }
                    g2.draw(new Line2D.Double(this.bboxD.x, y + w, x2, y));
                    if (!doubleLine) continue;
                    g2.draw(new Line2D.Double(this.bboxD.x, y + (double)step + w, x2, y + (double)step));
                }
                double xl = this.bboxD.x;
                double xr = x2;
                for (double y = this.bboxD.y + w - (double)stride; y >= this.bboxD.y; y -= (double)stride) {
                    g2.draw(new Line2D.Double(xl += (double)stride, this.bboxD.y, x2, y));
                    if (doubleLine) {
                        g2.draw(new Line2D.Double(xl - (double)step, this.bboxD.y, x2, y + (double)step));
                    }
                    g2.draw(new Line2D.Double(this.bboxD.x, y, xr -= (double)stride, this.bboxD.y));
                    if (!doubleLine) continue;
                    g2.draw(new Line2D.Double(this.bboxD.x, y + (double)step, xr + (double)step, this.bboxD.y));
                }
                break;
            }
            case 3: {
                this.drawSubpixelRect(g2, this.bboxD, true);
                break;
            }
        }
        g2.setClip(clip);
        g2.setStroke(save);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
    }

    private boolean isDecalTexture() {
        return this.texImage != null && this.texEnvMode == 2;
    }

    private boolean isModulatedTexture() {
        return this.texImage != null && this.texEnvMode == 3;
    }

    public static int getBlurringMargin(int category, int type, float dpiFactor) {
        if (category == 1 || category == 2) {
            return J3Rectangle.getBlurringMargin(3.0f * dpiFactor, 4.0f * dpiFactor, 3);
        }
        return 4;
    }

    public static DropShadowFilter createDropShadowFilter(int category, int type, float dpiFactor) {
        DropShadowFilter shadow = null;
        if (category == 1 || category == 2) {
            shadow = new DropShadowFilter();
            shadow.setHideObject(false);
            shadow.setInner(false);
            shadow.setAngle(45.0f);
            shadow.setColor(Color.black);
            switch (type) {
                case 5: {
                    shadow.setBlurX(4.0f * dpiFactor);
                    shadow.setBlurY(4.0f * dpiFactor);
                    shadow.setDistance(3.0f * dpiFactor);
                    shadow.setAlpha(0.25f);
                    shadow.setQuality(0);
                    shadow.setStrength(1.0f);
                    break;
                }
                case 6: {
                    return null;
                }
                case 7: {
                    shadow.setBlurX(3.0f * dpiFactor);
                    shadow.setBlurY(3.0f * dpiFactor);
                    shadow.setDistance(2.0f * dpiFactor);
                    shadow.setAlpha(0.4f);
                    shadow.setQuality(3);
                    shadow.setStrength(1.0f);
                    break;
                }
                case 3: {
                    return null;
                }
                case 4: {
                    shadow.setBlurX(3.0f * dpiFactor);
                    shadow.setBlurY(3.0f * dpiFactor);
                    shadow.setDistance(3.0f * dpiFactor);
                    shadow.setAlpha(0.25f);
                    shadow.setQuality(3);
                    shadow.setStrength(1.0f);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return shadow;
    }

    public static BevelFilter createBevelFilter(int category, int type, Rectangle bbox, float dpiFactor) {
        BevelFilter bevel = null;
        if (category == 1 || category == 2) {
            bevel = new BevelFilter();
            bevel.setKnockout(true);
            bevel.setHighlightColor(Color.white);
            bevel.setShadowColor(Color.black);
            float angle = category == 1 ? 0.0f : 90.0f;
            switch (type) {
                case 5: {
                    bevel.setAngle(45.0f);
                    bevel.setDistance(4.0f * dpiFactor);
                    bevel.setBlurX(0.0f);
                    bevel.setBlurY(0.0f);
                    bevel.setHighlightAlpha(0.3f);
                    bevel.setShadowAlpha(0.2f);
                    bevel.setQuality(0);
                    bevel.setStrength(1.0f);
                    break;
                }
                case 6: {
                    return null;
                }
                case 7: {
                    float dist;
                    float facX = (float)bbox.width / 50.0f;
                    float facY = (float)bbox.height / 50.0f;
                    float blurX = 25.0f;
                    float blurY = 25.0f;
                    float distOrg = dist = 20.0f;
                    if (angle == 0.0f) {
                        blurX *= facX;
                        dist *= facX;
                        if ((float)bbox.height < blurY * 2.0f) {
                            blurY *= facY;
                            if (distOrg * facY < dist) {
                                dist = distOrg * facY;
                            }
                        }
                    } else if (angle == 90.0f) {
                        blurY *= facY;
                        dist *= facY;
                        if ((float)bbox.width < blurX * 2.0f) {
                            blurX *= facX;
                            if (distOrg * facX < dist) {
                                dist = distOrg * facX;
                            }
                        }
                    } else if ((float)bbox.width < blurX * 2.0f || (float)bbox.height < blurY * 2.0f) {
                        float deltaHeight;
                        float deltaWidth = Math.abs((float)bbox.width - blurX * 2.0f);
                        if (deltaWidth >= (deltaHeight = Math.abs((float)bbox.height - blurY * 2.0f))) {
                            blurX *= facX;
                            blurY *= facX;
                            dist *= facX;
                        } else {
                            blurX *= facY;
                            blurY *= facY;
                            dist *= facY;
                        }
                    }
                    bevel.setAngle(angle);
                    bevel.setDistance(dist * dpiFactor);
                    bevel.setBlurX(blurX * dpiFactor);
                    bevel.setBlurY(blurY * dpiFactor);
                    bevel.setHighlightAlpha(0.5f);
                    bevel.setShadowAlpha(0.3f);
                    bevel.setQuality(3);
                    bevel.setStrength(1.0f);
                    bevel.setPostProcessRequired(true);
                    break;
                }
                case 3: {
                    return null;
                }
                case 4: {
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return bevel;
    }

    public static GlowFilter createGlowFilter(int category, int type, float dpiFactor) {
        GlowFilter glow = null;
        if (category == 1 || category == 2) {
            glow = new GlowFilter();
            glow.setKnockout(true);
            glow.setInner(true);
            glow.setColor(Color.black);
            switch (type) {
                case 5: {
                    glow.setBlurX(1.1f * dpiFactor);
                    glow.setBlurY(1.1f * dpiFactor);
                    glow.setAlpha(0.8f);
                    glow.setQuality(3);
                    glow.setStrength(15.0f);
                    break;
                }
                case 6: {
                    glow.setBlurX(1.1f * dpiFactor);
                    glow.setBlurY(1.1f * dpiFactor);
                    glow.setAlpha(0.6f);
                    glow.setQuality(3);
                    glow.setStrength(8.0f);
                    break;
                }
                case 7: {
                    glow.setBlurX(1.5f * dpiFactor);
                    glow.setBlurY(1.5f * dpiFactor);
                    glow.setAlpha(0.6f);
                    glow.setQuality(3);
                    glow.setStrength(3.0f);
                    break;
                }
                case 3: {
                    glow.setBlurX(1.2f * dpiFactor);
                    glow.setBlurY(1.2f * dpiFactor);
                    glow.setAlpha(0.5f);
                    glow.setQuality(4);
                    glow.setStrength(3.0f);
                    break;
                }
                case 4: {
                    glow.setBlurX(1.5f * dpiFactor);
                    glow.setBlurY(1.5f * dpiFactor);
                    glow.setAlpha(0.5f);
                    glow.setQuality(3);
                    glow.setStrength(3.0f);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return glow;
    }

    private Filter[] createAdditionalFilters(int category, int type, float dpiFactor) {
        Filter[] filters = null;
        if (category == 3) {
            switch (type) {
                case 5: {
                    BevelFilter bevel = new BevelFilter();
                    bevel.setKnockout(true);
                    bevel.setHighlightColor(Color.white);
                    bevel.setShadowColor(Color.black);
                    bevel.setAngle(45.0f);
                    bevel.setDistance(3.0f * dpiFactor);
                    bevel.setBlurX(0.0f);
                    bevel.setBlurY(0.0f);
                    bevel.setHighlightAlpha(0.3f);
                    bevel.setShadowAlpha(0.2f);
                    bevel.setQuality(0);
                    bevel.setStrength(1.0f);
                    filters = new Filter[]{bevel};
                    break;
                }
                case 6: {
                    GlowFilter glow = new GlowFilter();
                    glow.setKnockout(true);
                    glow.setInner(true);
                    glow.setColor(Color.black);
                    glow.setBlurX(3.5f * dpiFactor);
                    glow.setBlurY(3.5f * dpiFactor);
                    glow.setAlpha(0.45f);
                    glow.setQuality(3);
                    glow.setStrength(2.0f);
                    BevelFilter bevel1 = new BevelFilter();
                    bevel1.setKnockout(true);
                    bevel1.setHighlightColor(Color.white);
                    bevel1.setShadowColor(Color.black);
                    bevel1.setAngle(0.0f);
                    bevel1.setDistance(4.0f * dpiFactor);
                    bevel1.setBlurX(8.0f * dpiFactor);
                    bevel1.setBlurY(0.0f);
                    bevel1.setHighlightAlpha(0.5f);
                    bevel1.setShadowAlpha(0.0f);
                    bevel1.setQuality(2);
                    bevel1.setStrength(2.0f);
                    BevelFilter bevel2 = new BevelFilter();
                    bevel2.setKnockout(true);
                    bevel2.setHighlightColor(Color.white);
                    bevel2.setShadowColor(Color.black);
                    bevel2.setAngle(0.0f);
                    bevel2.setDistance(3.0f * dpiFactor);
                    bevel2.setBlurX(4.0f * dpiFactor);
                    bevel2.setBlurY(0.0f);
                    bevel2.setHighlightAlpha(0.5f);
                    bevel2.setShadowAlpha(0.0f);
                    bevel2.setQuality(2);
                    bevel2.setStrength(2.0f);
                    filters = new Filter[]{glow, bevel1, bevel2};
                    break;
                }
                case 7: {
                    BevelFilter bevel = new BevelFilter();
                    bevel.setKnockout(true);
                    bevel.setHighlightColor(Color.white);
                    bevel.setShadowColor(Color.black);
                    bevel.setAngle(45.0f);
                    bevel.setDistance(3.0f * dpiFactor);
                    float blurX = 6.0f;
                    float blurY = 6.0f;
                    if ((float)this.bbox.width < blurX * 2.0f || (float)this.bbox.height < blurY * 2.0f) {
                        float deltaH;
                        float facX = (float)((double)this.bbox.width / 50.0);
                        float facY = (float)((double)this.bbox.height / 50.0);
                        float deltaW = Math.abs((float)this.bbox.width - blurX * 2.0f);
                        if (deltaW >= (deltaH = Math.abs((float)this.bbox.height - blurY * 2.0f))) {
                            blurX *= facX;
                            blurY *= facX;
                        } else {
                            blurX *= facY;
                            blurY *= facY;
                        }
                    }
                    bevel.setBlurX(blurX * dpiFactor);
                    bevel.setBlurY(blurY * dpiFactor);
                    bevel.setHighlightAlpha(0.5f);
                    bevel.setShadowAlpha(0.3f);
                    bevel.setQuality(3);
                    bevel.setStrength(1.0f);
                    filters = new Filter[]{bevel};
                    break;
                }
                case 3: {
                    GlowFilter glow = new GlowFilter();
                    glow.setKnockout(true);
                    glow.setInner(true);
                    glow.setColor(Color.black);
                    glow.setBlurX(3.5f * dpiFactor);
                    glow.setBlurY(3.5f * dpiFactor);
                    glow.setAlpha(0.4f);
                    glow.setQuality(3);
                    glow.setStrength(3.0f);
                    filters = new Filter[]{glow};
                    break;
                }
                case 4: {
                    BevelFilter bevel = new BevelFilter();
                    bevel.setKnockout(true);
                    bevel.setHighlightColor(Color.white);
                    bevel.setShadowColor(Color.black);
                    bevel.setAngle(45.0f);
                    bevel.setDistance(2.0f * dpiFactor);
                    float blurX = 4.0f;
                    float blurY = 4.0f;
                    if ((float)this.bbox.width < blurX * 2.0f || (float)this.bbox.height < blurY * 2.0f) {
                        float deltaH;
                        float facX = (float)((double)this.bbox.width / 50.0);
                        float facY = (float)((double)this.bbox.height / 50.0);
                        float deltaW = Math.abs((float)this.bbox.width - blurX * 2.0f);
                        if (deltaW >= (deltaH = Math.abs((float)this.bbox.height - blurY * 2.0f))) {
                            blurX *= facX;
                            blurY *= facX;
                        } else {
                            blurX *= facY;
                            blurY *= facY;
                        }
                    }
                    bevel.setBlurX(blurX * dpiFactor);
                    bevel.setBlurY(blurY * dpiFactor);
                    bevel.setHighlightAlpha(0.5f);
                    bevel.setShadowAlpha(0.3f);
                    bevel.setQuality(3);
                    bevel.setStrength(2.0f);
                    filters = new Filter[]{bevel};
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return filters;
    }
}

