/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.image.BevelFilter;
import com.sas.graphics.image.DropShadowFilter;
import com.sas.graphics.image.Filter;
import com.sas.graphics.image.GlowFilter;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.J3Rectangle;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.Primitive;
import com.sas.graphics.util.gl.ScanConvert;
import com.sas.graphics.util.gl.Shape;
import com.sas.graphics.util.gl.Solid;
import com.sas.graphics.util.gl.State;
import com.sas.graphics.util.gl.TransInfo;
import com.sas.graphics.util.gl.VertexSet;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

class J3Polygon
extends VertexSet {
    Point4 wn;
    Point4 nv;
    Point4 wc = new Point4(0.0, 0.0, 0.0, 1.0);
    Point4 center;
    boolean light;
    int edgeWidth;
    boolean fillIncludesEdges;
    Color litColor;
    Color edgeColor;
    Color[] litColorPerVertex;
    private int[] stipplePattern;
    int fillmode;
    protected Image texImage;
    private int texEnvMode;

    J3Polygon() {
        this.wn = new Point4();
        this.nv = new Point4();
        this.center = new Point4();
        this.normal = new Point4();
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.wc.set(0.0, 0.0, 0.0, 1.0);
    }

    @Override
    void copyInit(Shape s) {
        super.copyInit(s);
        J3Polygon p = (J3Polygon)s;
        p.wc = this.wc.copy();
        p.wn = this.wn.copy();
        p.nv = this.nv.copy();
        p.center = this.center.copy();
        p.normal = this.normal.copy();
    }

    @Override
    public Point4 getScreenCenter() {
        return this.center;
    }

    @Override
    void end(Channel ch) {
        super.end(ch);
        State state = ch.getState();
        if (state.capabilities[0]) {
            this.wn.set(this.computeNormal(state, state.winding));
        } else {
            this.wn.set(state.normal);
            this.wn.t = 0.0;
        }
        this.wc.scale(1.0 / (double)this.vertexCount);
        this.wc.t = 1.0;
    }

    Primitive[] extrude(State state) {
        if (this.falseEdgeFlagCount > 0 && this.falseEdgeFlagIndex[this.falseEdgeFlagCount - 1] == this.vertexCount - 1) {
            --this.falseEdgeFlagCount;
        }
        Primitive[] pList = new Primitive[1];
        Point4 extrusionVector = state.extrusionVector;
        J3Polygon from = (J3Polygon)this.copy();
        J3Polygon to = (J3Polygon)this.copy();
        Point4 fromNormal = state.pt5;
        fromNormal.set(this.computeNormal(state, state.winding));
        if (fromNormal.dot(extrusionVector) > 0.0) {
            J3Polygon.reverseWinding(state, from);
            fromNormal.scale(-1.0);
        } else {
            J3Polygon.reverseWinding(state, to);
        }
        state.Normal(fromNormal.x, fromNormal.y, fromNormal.z);
        from.end(state.ch);
        Solid solid = new Solid();
        solid.addPolygon2(from);
        pList[0] = solid;
        to.wc.set(0.0, 0.0, 0.0, 1.0);
        for (int i = 0; i < from.vertexCount; ++i) {
            to.vertex[i].add(extrusionVector);
            to.vertex[i].t = 1.0;
            to.wc.add(to.vertex[i]);
        }
        state.Normal(-fromNormal.x, -fromNormal.y, -fromNormal.z);
        to.end(state.ch);
        solid.addPolygon2(to);
        boolean autoNormal = state.capabilities[0];
        state.capabilities[0] = false;
        boolean edgeFlag = state.edgeFlag;
        state.edgeFlag = true;
        Point4 nv1 = state.pt3;
        Point4 nv2 = state.pt4;
        int efi = 0;
        for (int vi = 0; vi < from.vertexCount - 1; ++vi) {
            if (from.falseEdgeFlagCount > 0 && efi <= from.falseEdgeFlagIndex.length - 1 && from.falseEdgeFlagIndex[efi] == vi) {
                ++efi;
                continue;
            }
            Point4 v1 = from.vertex[vi];
            Point4 v2 = to.vertex[to.vertexCount - vi - 1];
            if (v1.x == v2.x && v1.y == v2.y && v1.z == v2.z) continue;
            Point4 v3 = to.vertex[to.vertexCount - vi - 2];
            Point4 v4 = from.vertex[vi + 1];
            J3Polygon p = new J3Polygon();
            p.vertex(state.ch, v1.x, v1.y, v1.z);
            p.vertex(state.ch, v2.x, v2.y, v2.z);
            p.vertex(state.ch, v3.x, v3.y, v3.z);
            p.vertex(state.ch, v4.x, v4.y, v4.z);
            nv1.set(p.vertex[2]);
            nv1.sub(p.vertex[0]);
            nv2.set(p.vertex[3]);
            nv2.sub(p.vertex[1]);
            nv1.cross(nv2);
            nv1.normalize();
            state.Normal(nv1.x, nv1.y, nv1.z);
            p.end(state.ch);
            solid.addPolygon(p);
        }
        solid.end(state.ch);
        state.capabilities[0] = autoNormal;
        state.edgeFlag = edgeFlag;
        return pList;
    }

    private static void reverseWinding(State state, J3Polygon p) {
        int i;
        Point4 temp = state.pt1;
        for (i = 0; i < p.vertexCount / 2; ++i) {
            temp.set(p.vertex[i]);
            p.vertex[i].set(p.vertex[p.vertexCount - i - 1]);
            p.vertex[p.vertexCount - i - 1].set(temp);
        }
        if (p.falseEdgeFlagCount > 0) {
            state.reallocScratchInt(p.falseEdgeFlagCount);
            System.arraycopy(p.falseEdgeFlagIndex, 0, state.scratchInt, 0, p.falseEdgeFlagCount);
            int n = p.falseEdgeFlagCount;
            int ec = 0;
            for (i = 0; i < n; ++i) {
                int ei = p.vertexCount - 2 - state.scratchInt[n - 1 - i];
                if (ei < 0) {
                    --p.falseEdgeFlagCount;
                    continue;
                }
                p.falseEdgeFlagIndex[ec++] = ei;
            }
        }
    }

    @Override
    public void computeScreen(Channel ch) {
        State state = ch.getState();
        TransInfo tr = ch.trans;
        this.stipplePattern = (int[])(ch.state.capabilities[6] && ch.state.getStipplePattern() != null ? ch.state.getStipplePattern() : null);
        this.clip = false;
        this.fillmode = state.fillmode;
        this.edgeWidth = state.lineWidth;
        this.edgeColor = state.edgecolor;
        this.light = state.capabilities[3];
        this.fillIncludesEdges = state.capabilities[9];
        this.texImage = null;
        if (ch.state.capabilities[10]) {
            this.texImage = ch.state.texImage;
            this.texEnvMode = ch.state.texEnvMode;
        }
        this.nv.set(this.wn);
        tr.Object2EyeNormal(this.nv);
        this.nv.normalize();
        Point4 po = ch.state.pt6;
        po.set(this.wc);
        tr.Object2Eye(po);
        boolean bf = false;
        if (tr.getProjectionMode() != 2 && (state.capabilities[1] || state.face == 2)) {
            bf = this.backFacing(tr.getProjectionMode(), po, this.nv);
            if (state.face == 0 && bf) {
                this.clip = true;
                return;
            }
        }
        super.computeScreen(ch);
        if (this.clip) {
            return;
        }
        this.center.set(this.wc);
        tr.Object2Window(this.center);
        this.normal.set(this.computeScreenNormal(ch.state));
        this.normal.t = 0.0;
        if (tr.getProjectionMode() == 2 && (state.capabilities[1] || state.face == 2)) {
            bf = this.backFacing(tr.getProjectionMode(), this.dscr[0], this.normal);
            if (state.face == 0 && bf) {
                this.clip = true;
                return;
            }
        }
        Point4 eye = state.pt2;
        eye.set(0.0, 0.0, 0.0, 0.0);
        this.litColor = this.color;
        if (this.needLitColor(state)) {
            Point4 tempNormal = state.pt7;
            tempNormal.set(this.nv);
            if (state.face == 2 && bf) {
                tempNormal.scale(-1.0);
            }
            if (state.isSoftwareRender() && state.shadeModel == 0) {
                if (this.litColorPerVertex == null || this.litColorPerVertex.length < this.vertexCount) {
                    this.litColorPerVertex = new Color[this.vertexCount];
                }
                for (int i = 0; i < this.vertexCount; ++i) {
                    this.litColorPerVertex[i] = state.lightMgr.computeColor(po, tempNormal, eye, this.colorPerVertex[i]);
                }
            } else {
                this.litColor = state.lightMgr.computeColor(po, tempNormal, eye, this.color);
            }
        }
    }

    private boolean needLitColor(State state) {
        boolean result = false;
        if (this.light && (this.fillmode == 3 || this.fillmode == 4 || this.fillmode == 6 || this.fillmode == 7) && (state.render_mode != 1 || state.isDisplayListOpen())) {
            result = true;
        }
        return result;
    }

    final Point4 getNormal() {
        return this.normal;
    }

    @Override
    public final void render(State state, Graphics bgc) {
        if (this.clip || this.vertexCount == 0) {
            return;
        }
        Rectangle originalClip = state.applyWorldClip(bgc, this.clipRect);
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        bgc.setColor(this.litColor);
        if (state.isSoftwareRender()) {
            this.softwareRender(state, bgc);
        } else if (state.skinType == 0) {
            this.awtRender(state, bgc);
        } else {
            this.drawSkin(state, bgc);
        }
        state.clearWorldClip(bgc, this.clipRect, originalClip);
    }

    private void awtRender(State state, Graphics bgc) {
        switch (this.fillmode) {
            default: {
                this.drawFill(bgc, state);
                break;
            }
            case 6: {
                this.drawOutline(state, bgc, this.color);
            }
            case 7: {
                Graphics2D g2 = (Graphics2D)bgc;
                Paint save = g2.getPaint();
                g2.setPaint(state.fillPattern.getHatch45(this.color));
                bgc.fillPolygon(this.xpoints, this.ypoints, this.vertexCount);
                g2.setPaint(save);
                break;
            }
            case 2: {
                this.drawOutline(state, bgc, this.litColor);
                break;
            }
            case 1: {
                for (int j = 0; j < this.vertexCount; ++j) {
                    bgc.drawOval(this.xpoints[j], this.ypoints[j], 2, 2);
                }
                break;
            }
            case 4: {
                this.drawFill(bgc, state);
                bgc.setColor(this.edgeColor);
                this.drawOutline(state, bgc, this.edgeColor);
                break;
            }
            case 8: {
                bgc.setColor(state.fillPatternColor);
                if (state.subpixelRendering) {
                    this.drawSubpixelFillPattern(state, bgc);
                    break;
                }
                this.drawFillPattern(state, bgc);
                break;
            }
            case 9: {
                this.drawFill(bgc, state);
                bgc.setColor(state.fillPatternColor);
                if (state.subpixelRendering) {
                    this.drawSubpixelFillPattern(state, bgc);
                    break;
                }
                this.drawFillPattern(state, bgc);
                break;
            }
            case 10: {
                bgc.setColor(state.fillPatternColor);
                if (state.subpixelRendering) {
                    this.drawSubpixelFillPattern(state, bgc);
                } else {
                    this.drawFillPattern(state, bgc);
                }
                bgc.setColor(this.edgeColor);
                this.drawOutline(state, bgc, this.edgeColor);
                break;
            }
            case 11: {
                this.drawFill(bgc, state);
                bgc.setColor(state.fillPatternColor);
                if (state.subpixelRendering) {
                    this.drawSubpixelFillPattern(state, bgc);
                } else {
                    this.drawFillPattern(state, bgc);
                }
                bgc.setColor(this.edgeColor);
                this.drawOutline(state, bgc, this.edgeColor);
            }
            case 5: 
        }
    }

    private void softwareRender(State state, Graphics bgc) {
        boolean clockwise;
        if (state.capabilities[16]) {
            double depth = this.zmax - this.zmin;
            double w = (double)this.bbox.width / state.ch.trans.getViewportWidth();
            double h = (double)this.bbox.height / state.ch.trans.getViewportHeight();
            double maxDepthSlope = Math.max(Math.abs(depth / w), Math.abs(depth / h));
            state.ch.setMaxDepthSlope(maxDepthSlope);
        }
        boolean bl = clockwise = state.winding == 1;
        clockwise = this.normal.z > 0.0 ? clockwise : !clockwise;
        state.appearance.color = this.color;
        state.appearance.edgeColor = this.edgeColor;
        state.appearance.litColor = this.litColor;
        state.appearance.colorPerVertex = this.colorPerVertex;
        state.appearance.litColorPerVertex = this.litColorPerVertex;
        state.appearance.alphaPerVertex = this.alphaPerVertex;
        state.appearance.alpha = this.alpha;
        state.appearance.isLightOn = this.light;
        state.appearance.isLightOn = this.needLitColor(state);
        switch (this.fillmode) {
            default: {
                state.ch.setPixelType(0);
                state.scanConvert.drawConcavePolygon(state, this.vertexCount, this.dscr, state.appearance);
                break;
            }
            case 2: {
                state.ch.setPixelType(1);
                this.drawOutline(state, bgc, this.litColor);
                break;
            }
            case 1: {
                state.ch.setPixelType(2);
                break;
            }
            case 4: {
                state.ch.setPixelType(0);
                state.scanConvert.drawConcavePolygon(state, this.vertexCount, this.dscr, state.appearance);
                state.ch.setPixelType(1);
                this.drawOutline(state, bgc, this.edgeColor);
            }
            case 5: 
        }
        state.ch.setPixelType(3);
    }

    protected void drawFill(Graphics g, State state) {
        Graphics2D g2 = (Graphics2D)g;
        if (this.fillIncludesEdges || state.capabilities[9] && state.capabilities[8]) {
            if (state.subpixelRendering) {
                this.drawSubpixelPolygon(g2, this.xpointsD, this.ypointsD, this.vertexCount, false);
            } else {
                g2.drawPolygon(this.xpoints, this.ypoints, this.vertexCount);
            }
        }
        if (state.subpixelRendering) {
            this.drawSubpixelPolygon(g2, this.xpointsD, this.ypointsD, this.vertexCount, true);
        } else {
            g2.fillPolygon(this.xpoints, this.ypoints, this.vertexCount);
        }
        if (this.texImage != null) {
            Paint savePaint = g2.getPaint();
            Composite saveComposite = g2.getComposite();
            if (!(this.texImage instanceof BufferedImage)) {
                throw new RuntimeException("Texture images must be of type BufferedImage.");
            }
            BufferedImage i = (BufferedImage)this.texImage;
            int w = this.texImage.getWidth(null);
            int h = this.texImage.getHeight(null);
            Rectangle2D.Double tr = new Rectangle2D.Double(0.0, 0.0, w, h);
            TexturePaint tp = new TexturePaint(i, tr);
            if (this.isModulatedTexture()) {
                AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
                g2.setComposite(ac);
            }
            g2.setPaint(tp);
            g2.fillPolygon(this.xpoints, this.ypoints, this.vertexCount);
            g2.setPaint(savePaint);
            g2.setComposite(saveComposite);
        }
    }

    private void drawSubpixelPolygon(Graphics2D g2, double[] xp, double[] yp, int count, boolean fill) {
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        GeneralPath path = new GeneralPath(0);
        path.moveTo(xp[0], yp[0]);
        for (int i = 1; i < count; ++i) {
            path.lineTo(xp[i], yp[i]);
        }
        path.closePath();
        if (fill) {
            g2.fill(path);
        } else {
            g2.draw(path);
        }
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
    }

    private void drawPolyOutline(Graphics2D g2, int[] xp, int[] yp) {
        int to = 1;
        GeneralPath path = new GeneralPath(0);
        path.moveTo(xp[0], yp[0]);
        boolean lastPolygonDrawn = false;
        int i = 1;
        int ei = 0;
        while (i < this.vertexCount) {
            if (ei < this.falseEdgeFlagIndex.length && this.falseEdgeFlagIndex[ei] + 1 == i) {
                path.closePath();
                g2.draw(path);
                ++ei;
                path = new GeneralPath(0);
                path.moveTo(xp[to], yp[to]);
            } else {
                path.lineTo(this.xpoints[to], this.ypoints[to]);
            }
            ++i;
            ++to;
        }
        if (this.falseEdgeFlagCount == 1) {
            path.closePath();
            g2.draw(path);
        }
    }

    protected void drawSkin(State state, Graphics bgc) {
        Filter[] filters;
        boolean borderOn;
        int i;
        Polygon p = new Polygon(this.xpoints, this.ypoints, this.vertexCount);
        Rectangle bbox = p.getBounds();
        Rectangle2D bboxD = null;
        if (state.subpixelRendering) {
            GeneralPath path = new GeneralPath(0);
            path.moveTo(this.xpointsD[0], this.ypointsD[0]);
            for (i = 1; i < this.vertexCount; ++i) {
                path.lineTo(this.xpointsD[i], this.ypointsD[i]);
            }
            path.closePath();
            bboxD = path.getBounds2D();
        }
        if (bbox.width == 0 || bbox.height == 0) {
            this.awtRender(state, bgc);
            return;
        }
        BufferedImage[] actualSizeImages = null;
        if (state.pixelBenderImages != null) {
            actualSizeImages = new BufferedImage[state.pixelBenderImages.length];
            for (i = 0; i < state.pixelBenderImages.length; ++i) {
                actualSizeImages[i] = new BufferedImage(bbox.width, bbox.height, 2);
                Graphics2D g2 = actualSizeImages[i].createGraphics();
                g2.drawImage(state.pixelBenderImages[i], 0, 0, bbox.width, bbox.height, null);
                g2.dispose();
            }
        }
        int margin = state.lineWidth + J3Rectangle.getBlurringMargin(state.skinCategory, state.skinType, state.DPIScaleFactor);
        int img_w = bbox.width + margin * 2;
        int img_h = bbox.height + margin * 2;
        BufferedImage src = new BufferedImage(img_w, img_h, 2);
        Graphics2D g2 = (Graphics2D)src.getGraphics();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2.translate(-bbox.x + margin, -bbox.y + margin);
        Color saveColor = state.color;
        int r = state.color.getRed();
        int g = state.color.getGreen();
        int b = state.color.getBlue();
        int a = state.color.getAlpha();
        this.alpha = (float)a / 255.0f;
        state.color = new Color(r, g, b, 255);
        g2.setColor(state.color);
        this.awtRender(state, g2);
        state.color = saveColor;
        g2.dispose();
        int dx = bbox.x - margin;
        int dy = bbox.y - margin;
        Composite saveComposite = ((Graphics2D)bgc).getComposite();
        Graphics gc = bgc;
        int DX = dx;
        int DY = dy;
        BufferedImage combined = null;
        if (this.alpha < 1.0f) {
            combined = new BufferedImage(img_w, img_h, 2);
            bgc = combined.getGraphics();
            ((Graphics2D)bgc).setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            dx = 0;
            dy = 0;
        }
        if (actualSizeImages != null) {
            src = this.blendImages(src, actualSizeImages, state.skinCategory, state.skinType, margin, margin);
        }
        boolean graphRendered = false;
        if ((state.skinRenderMode & 2) != 0) {
            BufferedImage s_img = src;
            DropShadowFilter shadow = J3Rectangle.createDropShadowFilter(state.skinCategory, state.skinType, state.DPIScaleFactor);
            if (shadow != null) {
                s_img = shadow.filter(s_img, null);
                bgc.drawImage(s_img, dx, dy, null);
                graphRendered = true;
            }
        }
        if ((state.skinRenderMode & 1) != 0 && !graphRendered) {
            bgc.drawImage(src, dx, dy, null);
        }
        if ((state.skinRenderMode & 4) != 0) {
            BufferedImage b_img = src;
            BevelFilter bevel = J3Rectangle.createBevelFilter(state.skinCategory, state.skinType, bbox, state.DPIScaleFactor);
            if (bevel != null) {
                b_img = bevel.filter(b_img, null);
                bgc.drawImage(b_img, dx, dy, null);
            }
            if (state.skinImage != null && bbox.width > 0 && bbox.height > 0) {
                Object[] clipYPts;
                Object[] clipXPts;
                int skinWidth = (int)Math.ceil(bbox.width);
                int skinHeight = (int)Math.ceil(bbox.height);
                BufferedImage scaledImage = new BufferedImage(skinWidth, skinHeight, 2);
                Graphics2D imageGraphics = scaledImage.createGraphics();
                imageGraphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                if (state.subpixelRendering) {
                    clipXPts = new double[this.vertexCount];
                    clipYPts = new double[this.vertexCount];
                    for (int i2 = 0; i2 < this.vertexCount; ++i2) {
                        clipXPts[i2] = this.xpointsD[i2] - bboxD.getX();
                        clipYPts[i2] = this.ypointsD[i2] - bboxD.getY();
                    }
                    GeneralPath path = new GeneralPath(0);
                    path.moveTo(clipXPts[0], clipYPts[0]);
                    for (int i3 = 1; i3 < this.vertexCount; ++i3) {
                        path.lineTo(clipXPts[i3], clipYPts[i3]);
                    }
                    path.closePath();
                    imageGraphics.setClip(path);
                } else {
                    clipXPts = new int[this.vertexCount];
                    clipYPts = new int[this.vertexCount];
                    for (int i4 = 0; i4 < this.vertexCount; ++i4) {
                        clipXPts[i4] = this.xpoints[i4] - bbox.x;
                        clipYPts[i4] = this.ypoints[i4] - bbox.y;
                    }
                    Polygon clip = new Polygon((int[])clipXPts, (int[])clipYPts, this.vertexCount);
                    imageGraphics.setClip(clip);
                }
                imageGraphics.drawImage(state.skinImage, 0, 0, skinWidth, skinHeight, null);
                if (this.alpha < 1.0f) {
                    bgc.drawImage(scaledImage, margin, margin, skinWidth, skinHeight, null);
                } else {
                    bgc.drawImage(scaledImage, bbox.x, bbox.y, skinWidth, skinHeight, null);
                }
                imageGraphics.dispose();
            }
        }
        boolean bl = borderOn = state.skinCategory == 1 && (float)bbox.width >= 5.0f * state.DPIScaleFactor || state.skinCategory == 2 && (float)bbox.height >= 5.0f * state.DPIScaleFactor;
        if ((state.skinRenderMode & 8) != 0 && borderOn) {
            BufferedImage g_img = src;
            GlowFilter glow = J3Rectangle.createGlowFilter(state.skinCategory, state.skinType, state.DPIScaleFactor);
            if (glow != null) {
                g_img = glow.filter(g_img, null);
                bgc.drawImage(g_img, dx, dy, null);
            }
        }
        if ((filters = this.createAdditionalFilters(state.skinCategory, state.skinType, state.DPIScaleFactor)) != null) {
            for (int i5 = 0; i5 < filters.length; ++i5) {
                BufferedImage img = src;
                img = filters[i5].filter(img, null);
                bgc.drawImage(img, dx, dy, null);
            }
        }
        if (this.alpha < 1.0f) {
            bgc.dispose();
            ((Graphics2D)gc).setComposite(AlphaComposite.getInstance(3, this.alpha));
            gc.drawImage(combined, DX, DY, null);
            ((Graphics2D)gc).setComposite(saveComposite);
        }
    }

    private void drawFillPattern(State state, Graphics bgc) {
        boolean doubleLine;
        Graphics2D g2 = (Graphics2D)bgc;
        Stroke strokeSave = g2.getStroke();
        Rectangle clipSave = g2.getClipBounds();
        Polygon clip = new Polygon(this.xpoints, this.ypoints, this.vertexCount);
        int gap = 0;
        int step = 0;
        int thickness = state.fillPatternWidth;
        boolean bl = doubleLine = state.fillPatternWidth == 4 || state.fillPatternWidth == 5;
        if (doubleLine) {
            gap = state.fillPatternWidth == 4 ? 3 : 5;
            thickness = state.fillPatternWidth == 4 ? 1 : 2;
            step = gap + thickness;
        }
        int stride = 5 + state.fillPatternWidth * 3;
        thickness = (int)Math.round((double)thickness * state.fillPatternScaleFactor);
        gap = (int)Math.round((double)gap * state.fillPatternScaleFactor);
        step = (int)Math.round((double)step * state.fillPatternScaleFactor);
        stride = (int)Math.round((double)stride * state.fillPatternScaleFactor);
        g2.setStroke(new BasicStroke(thickness));
        if (clipSave == null) {
            g2.setClip(clip);
        } else {
            Area area1 = new Area(clip);
            Area area2 = new Area(clipSave);
            area1.intersect(area2);
            g2.setClip(area1);
        }
        int w = this.bbox.width - 1;
        int x2 = this.bbox.x + w;
        int y2 = this.bbox.y + this.bbox.height - 1;
        switch (state.fillPatternType) {
            case 0: {
                for (int y = this.bbox.y; y < y2; y += stride) {
                    g2.drawLine(this.bbox.x, y, x2, y + w);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step, x2, y + step + w);
                }
                int x = this.bbox.x;
                for (int y = this.bbox.y + w - stride; y >= this.bbox.y; y -= stride) {
                    g2.drawLine(x += stride, this.bbox.y, x2, y);
                    if (!doubleLine) continue;
                    g2.drawLine(x - step, this.bbox.y, x2, y + step);
                }
                break;
            }
            case 1: {
                int y;
                for (y = this.bbox.y; y < y2; y += stride) {
                    g2.drawLine(this.bbox.x, y + w, x2, y);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step + w, x2, y + step);
                }
                int x = x2;
                for (y = this.bbox.y + w - stride; y >= this.bbox.y; y -= stride) {
                    g2.drawLine(this.bbox.x, y, x -= stride, this.bbox.y);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step, x + step, this.bbox.y);
                }
                break;
            }
            case 2: {
                for (int y = this.bbox.y; y < y2; y += stride) {
                    g2.drawLine(this.bbox.x, y, x2, y + w);
                    if (doubleLine) {
                        g2.drawLine(this.bbox.x, y + step, x2, y + step + w);
                    }
                    g2.drawLine(this.bbox.x, y + w, x2, y);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step + w, x2, y + step);
                }
                int xl = this.bbox.x;
                int xr = x2;
                for (int y = this.bbox.y + w - stride; y >= this.bbox.y; y -= stride) {
                    g2.drawLine(xl += stride, this.bbox.y, x2, y);
                    if (doubleLine) {
                        g2.drawLine(xl - step, this.bbox.y, x2, y + step);
                    }
                    g2.drawLine(this.bbox.x, y, xr -= stride, this.bbox.y);
                    if (!doubleLine) continue;
                    g2.drawLine(this.bbox.x, y + step, xr + step, this.bbox.y);
                }
                break;
            }
            case 3: {
                g2.fillPolygon(this.xpoints, this.ypoints, this.vertexCount);
                break;
            }
        }
        g2.setClip(clipSave);
        g2.setStroke(strokeSave);
    }

    private void drawSubpixelFillPattern(State state, Graphics bgc) {
        boolean doubleLine;
        Graphics2D g2 = (Graphics2D)bgc;
        Stroke strokeSave = g2.getStroke();
        Rectangle clipSave = g2.getClipBounds();
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        GeneralPath clip = new GeneralPath(0);
        clip.moveTo(this.xpointsD[0], this.ypointsD[0]);
        for (int i = 1; i < this.vertexCount; ++i) {
            clip.lineTo(this.xpointsD[i], this.ypointsD[i]);
        }
        clip.closePath();
        Rectangle2D bbox = clip.getBounds2D();
        Rectangle2D.Double bboxD = new Rectangle2D.Double(bbox.getX(), bbox.getY(), bbox.getWidth(), bbox.getHeight());
        int gap = 0;
        int step = 0;
        int thickness = state.fillPatternWidth;
        boolean bl = doubleLine = state.fillPatternWidth == 4 || state.fillPatternWidth == 5;
        if (doubleLine) {
            gap = state.fillPatternWidth == 4 ? 3 : 5;
            thickness = state.fillPatternWidth == 4 ? 1 : 2;
            step = gap + thickness;
        }
        int stride = 5 + state.fillPatternWidth * 3;
        thickness = (int)Math.round((double)thickness * state.fillPatternScaleFactor);
        gap = (int)Math.round((double)gap * state.fillPatternScaleFactor);
        step = (int)Math.round((double)step * state.fillPatternScaleFactor);
        stride = (int)Math.round((double)stride * state.fillPatternScaleFactor);
        g2.setStroke(new BasicStroke(thickness));
        if (clipSave == null) {
            g2.setClip(clip);
        } else {
            Area area1 = new Area(clip);
            Area area2 = new Area(clipSave);
            area1.intersect(area2);
            g2.setClip(area1);
        }
        double w = bboxD.width - 1.0;
        double x2 = bboxD.x + w;
        double y2 = bboxD.y + bboxD.height - 1.0;
        switch (state.fillPatternType) {
            case 0: {
                for (double y = bboxD.y; y < y2; y += (double)stride) {
                    g2.draw(new Line2D.Double(bboxD.x, y, x2, y + w));
                    if (!doubleLine) continue;
                    g2.draw(new Line2D.Double(bboxD.x, y + (double)step, x2, y + (double)step + w));
                }
                double x = bboxD.x;
                for (double y = bboxD.y + w - (double)stride; y >= bboxD.y; y -= (double)stride) {
                    g2.draw(new Line2D.Double(x += (double)stride, bboxD.y, x2, y));
                    if (!doubleLine) continue;
                    g2.draw(new Line2D.Double(x - (double)step, bboxD.y, x2, y + (double)step));
                }
                break;
            }
            case 1: {
                double y;
                for (y = bboxD.y; y < y2; y += (double)stride) {
                    g2.draw(new Line2D.Double(bboxD.x, y + w, x2, y));
                    if (!doubleLine) continue;
                    g2.draw(new Line2D.Double(bboxD.x, y + (double)step + w, x2, y + (double)step));
                }
                double x = x2;
                for (y = bboxD.y + w - (double)stride; y >= bboxD.y; y -= (double)stride) {
                    g2.draw(new Line2D.Double(bboxD.x, y, x -= (double)stride, bboxD.y));
                    if (!doubleLine) continue;
                    g2.draw(new Line2D.Double(bboxD.x, y + (double)step, x + (double)step, bboxD.y));
                }
                break;
            }
            case 2: {
                for (double y = bboxD.y; y < y2; y += (double)stride) {
                    g2.draw(new Line2D.Double(bboxD.x, y, x2, y + w));
                    if (doubleLine) {
                        g2.draw(new Line2D.Double(bboxD.x, y + (double)step, x2, y + (double)step + w));
                    }
                    g2.draw(new Line2D.Double(bboxD.x, y + w, x2, y));
                    if (!doubleLine) continue;
                    g2.draw(new Line2D.Double(bboxD.x, y + (double)step + w, x2, y + (double)step));
                }
                double xl = bboxD.x;
                double xr = x2;
                for (double y = bboxD.y + w - (double)stride; y >= bboxD.y; y -= (double)stride) {
                    g2.draw(new Line2D.Double(xl += (double)stride, bboxD.y, x2, y));
                    if (doubleLine) {
                        g2.draw(new Line2D.Double(xl - (double)step, bboxD.y, x2, y + (double)step));
                    }
                    g2.draw(new Line2D.Double(bboxD.x, y, xr -= (double)stride, bboxD.y));
                    if (!doubleLine) continue;
                    g2.draw(new Line2D.Double(bboxD.x, y + (double)step, xr + (double)step, bboxD.y));
                }
                break;
            }
            case 3: {
                this.drawSubpixelPolygon(g2, this.xpointsD, this.ypointsD, this.vertexCount, true);
                break;
            }
        }
        g2.setClip(clipSave);
        g2.setStroke(strokeSave);
        g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
    }

    private boolean isModulatedTexture() {
        return this.texImage != null && this.texEnvMode == 3;
    }

    protected void drawOutline(State state, Graphics g, Color color) {
        Graphics2D g2 = (Graphics2D)g;
        Stroke save = null;
        if (!state.isSoftwareRender()) {
            BasicStroke bs = state.getStroke(this.edgeWidth, 0, 1, this.stipplePattern);
            save = g2.getStroke();
            g2.setStroke(bs);
        }
        float alpha = (float)color.getAlpha() / 255.0f;
        if (this.falseEdgeFlagCount == 0) {
            if (state.isSoftwareRender()) {
                for (int from = 0; from < this.vertexCount; ++from) {
                    int to = (from + 1) % this.vertexCount;
                    ScanConvert.bresenhamLine(state, this.edgeWidth, this.xpoints[from], this.ypoints[from], this.dscr[from].z, color, alpha, this.xpoints[to], this.ypoints[to], this.dscr[to].z, color, alpha);
                }
            } else if (state.subpixelRendering) {
                this.drawSubpixelPolygon(g2, this.xpointsD, this.ypointsD, this.vertexCount, false);
            } else {
                g.drawPolygon(this.xpoints, this.ypoints, this.vertexCount);
                g.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[this.vertexCount - 1], this.ypoints[this.vertexCount - 1]);
            }
        } else if (state.drawPolyOutline && !state.isSoftwareRender()) {
            this.drawPolyOutline(g2, this.xpoints, this.ypoints);
        } else {
            int from = 0;
            int to = 1;
            int i = 1;
            int ei = 0;
            while (i < this.vertexCount) {
                if (ei < this.falseEdgeFlagIndex.length && this.falseEdgeFlagIndex[ei] + 1 == i) {
                    ++ei;
                } else if (state.isSoftwareRender()) {
                    ScanConvert.bresenhamLine(state, this.edgeWidth, this.xpoints[from], this.ypoints[from], this.dscr[from].z, color, alpha, this.xpoints[to], this.ypoints[to], this.dscr[to].z, color, alpha);
                } else {
                    g.drawLine(this.xpoints[from], this.ypoints[from], this.xpoints[to], this.ypoints[to]);
                }
                ++i;
                ++from;
                ++to;
            }
            if ((this.xpoints[0] != this.xpoints[this.vertexCount - 1] || this.ypoints[0] != this.ypoints[this.vertexCount - 1]) && this.falseEdgeFlagIndex[this.falseEdgeFlagCount - 1] != this.vertexCount - 1) {
                g.drawLine(this.xpoints[0], this.ypoints[0], this.xpoints[this.vertexCount - 1], this.ypoints[this.vertexCount - 1]);
            }
        }
        if (!state.isSoftwareRender()) {
            g2.setStroke(save);
        }
    }

    @Override
    final void vertex(Channel ch, double x, double y, double z) {
        super.vertex(ch, x, y, z);
        this.wc.add(this.vertex[this.vertexCount - 1]);
    }

    protected final boolean backFacing(int projectionMode, Point4 p, Point4 n) {
        return projectionMode == 1 ? p.dot(n) >= 0.0 : (projectionMode == 2 ? n.z >= 0.0 : n.z < 0.0);
    }

    protected final Point4 computeNormal(State state, int winding) {
        Point4 n = this.computeNormal(state, false);
        n.t = 0.0;
        n.normalize();
        if (winding == 1) {
            n.scale(-1.0);
        }
        return n;
    }

    protected final Point4 computeScreenNormal(State state) {
        Point4 n = this.computeNormal(state, true);
        n.t = 1.0;
        n.normalize();
        if (state.winding == 1) {
            n.scale(-1.0);
        }
        return n;
    }

    protected final Point4 computeNormal(State state, boolean screen) {
        Point4 faceNormal = null;
        switch (this.vertexCount) {
            case 0: 
            case 1: 
            case 2: {
                faceNormal = state.pt1;
                faceNormal.set(0.0, 0.0, 0.0, 0.0);
                break;
            }
            case 3: {
                faceNormal = this.computeArea(state, screen);
                break;
            }
            case 4: {
                faceNormal = this.computeArea(state, screen);
                break;
            }
            default: {
                faceNormal = this.computeArea(state, screen);
            }
        }
        return faceNormal;
    }

    protected final Point4 computeArea(State state, boolean screen) {
        Point4 area = state.pt1;
        area.set(0.0, 0.0, 0.0, 0.0);
        for (int i = 0; i < this.vertexCount; ++i) {
            int next = i == this.vertexCount - 1 ? 0 : i + 1;
            Point4 p1 = screen ? this.dscr[i] : this.vertex[i];
            Point4 p2 = screen ? this.dscr[next] : this.vertex[next];
            area.x += (p2.z - p1.z) / 2.0 * (p1.y + p2.y);
            area.y += (p2.x - p1.x) / 2.0 * (p1.z + p2.z);
            area.z += (p2.x - p1.x) / 2.0 * (p1.y + p2.y);
        }
        area.z *= -1.0;
        return area;
    }

    @Override
    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        if (this.clip) {
            return false;
        }
        return this.intersects(state, aperture);
    }

    @Override
    final boolean inside(int x, int y, State state) {
        return VertexSet.inside(x, y, this.xpoints, this.ypoints, this.vertexCount, this.falseEdgeFlagIndex, this.falseEdgeFlagCount, state);
    }

    final boolean intersects(State state, Rectangle aperture) {
        if (!aperture.intersects(this.bbox)) {
            return false;
        }
        return VertexSet.apertureIntersectsPolygon(state, aperture, this.xpoints, this.ypoints, this.vertexCount, this.falseEdgeFlagIndex, this.falseEdgeFlagCount);
    }

    private Filter[] createAdditionalFilters(int category, int type, float dpiFactor) {
        if (category != 3) {
            return null;
        }
        Filter[] filters = null;
        switch (type) {
            case 5: {
                BevelFilter bevel = new BevelFilter();
                bevel.setKnockout(true);
                bevel.setHighlightColor(Color.white);
                bevel.setShadowColor(Color.black);
                bevel.setAngle(45.0f);
                bevel.setDistance(3.0f * dpiFactor);
                bevel.setBlurX(0.0f);
                bevel.setBlurY(0.0f);
                bevel.setHighlightAlpha(0.3f);
                bevel.setShadowAlpha(0.2f);
                bevel.setQuality(0);
                bevel.setStrength(1.0f);
                filters = new Filter[]{bevel};
                break;
            }
            case 6: {
                GlowFilter glow = new GlowFilter();
                glow.setKnockout(true);
                glow.setInner(true);
                glow.setColor(Color.black);
                glow.setBlurX(3.5f * dpiFactor);
                glow.setBlurY(3.5f * dpiFactor);
                glow.setAlpha(0.45f);
                glow.setQuality(3);
                glow.setStrength(2.0f);
                BevelFilter bevel1 = new BevelFilter();
                bevel1.setKnockout(true);
                bevel1.setHighlightColor(Color.white);
                bevel1.setShadowColor(Color.black);
                bevel1.setAngle(0.0f);
                bevel1.setDistance(4.0f * dpiFactor);
                bevel1.setBlurX(8.0f * dpiFactor);
                bevel1.setBlurY(0.0f);
                bevel1.setHighlightAlpha(0.5f);
                bevel1.setShadowAlpha(0.0f);
                bevel1.setQuality(2);
                bevel1.setStrength(2.0f);
                BevelFilter bevel2 = new BevelFilter();
                bevel2.setKnockout(true);
                bevel2.setHighlightColor(Color.white);
                bevel2.setShadowColor(Color.black);
                bevel2.setAngle(0.0f);
                bevel2.setDistance(3.0f * dpiFactor);
                bevel2.setBlurX(4.0f * dpiFactor);
                bevel2.setBlurY(0.0f);
                bevel2.setHighlightAlpha(0.5f);
                bevel2.setShadowAlpha(0.0f);
                bevel2.setQuality(2);
                bevel2.setStrength(2.0f);
                filters = new Filter[]{glow, bevel1, bevel2};
                break;
            }
            case 7: {
                BevelFilter bevel = new BevelFilter();
                bevel.setKnockout(true);
                bevel.setHighlightColor(Color.white);
                bevel.setShadowColor(Color.black);
                bevel.setAngle(45.0f);
                bevel.setDistance(3.0f * dpiFactor);
                float blurX = 6.0f;
                float blurY = 6.0f;
                if ((float)this.bbox.width < blurX * 2.0f || (float)this.bbox.height < blurY * 2.0f) {
                    float deltaH;
                    float facX = (float)((double)this.bbox.width / 50.0);
                    float facY = (float)((double)this.bbox.height / 50.0);
                    float deltaW = Math.abs((float)this.bbox.width - blurX * 2.0f);
                    if (deltaW >= (deltaH = Math.abs((float)this.bbox.height - blurY * 2.0f))) {
                        blurX *= facX;
                        blurY *= facX;
                    } else {
                        blurX *= facY;
                        blurY *= facY;
                    }
                }
                bevel.setBlurX(blurX * dpiFactor);
                bevel.setBlurY(blurY * dpiFactor);
                bevel.setHighlightAlpha(0.5f);
                bevel.setShadowAlpha(0.3f);
                bevel.setQuality(3);
                bevel.setStrength(1.0f);
                filters = new Filter[]{bevel};
                break;
            }
            case 3: {
                GlowFilter glow = new GlowFilter();
                glow.setKnockout(true);
                glow.setInner(true);
                glow.setColor(Color.black);
                glow.setBlurX(3.5f * dpiFactor);
                glow.setBlurY(3.5f * dpiFactor);
                glow.setAlpha(0.4f);
                glow.setQuality(3);
                glow.setStrength(3.0f);
                filters = new Filter[]{glow};
                break;
            }
            case 4: {
                BevelFilter bevel = new BevelFilter();
                bevel.setKnockout(true);
                bevel.setHighlightColor(Color.white);
                bevel.setShadowColor(Color.black);
                bevel.setAngle(45.0f);
                bevel.setDistance(2.0f * dpiFactor);
                float blurX = 4.0f;
                float blurY = 4.0f;
                if ((float)this.bbox.width < blurX * 2.0f || (float)this.bbox.height < blurY * 2.0f) {
                    float deltaH;
                    float facX = (float)((double)this.bbox.width / 50.0);
                    float facY = (float)((double)this.bbox.height / 50.0);
                    float deltaW = Math.abs((float)this.bbox.width - blurX * 2.0f);
                    if (deltaW >= (deltaH = Math.abs((float)this.bbox.height - blurY * 2.0f))) {
                        blurX *= facX;
                        blurY *= facX;
                    } else {
                        blurX *= facY;
                        blurY *= facY;
                    }
                }
                bevel.setBlurX(blurX * dpiFactor);
                bevel.setBlurY(blurY * dpiFactor);
                bevel.setHighlightAlpha(0.5f);
                bevel.setShadowAlpha(0.3f);
                bevel.setQuality(3);
                bevel.setStrength(2.0f);
                filters = new Filter[]{bevel};
                break;
            }
            default: {
                return null;
            }
        }
        return filters;
    }
}

