/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.gl;

import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gl.Point4;
import com.sas.graphics.util.gl.State;
import com.sas.graphics.util.gl.VertexSet;
import java.awt.Graphics;
import java.awt.Rectangle;

class J3Point
extends VertexSet {
    float pointSize = 2.0f;

    J3Point() {
    }

    @Override
    public void render(State state, Graphics bgc) {
        if (this.clip) {
            return;
        }
        Rectangle originalClip = state.applyWorldClip(bgc, this.clipRect);
        if (this.doPick(state, bgc)) {
            return;
        }
        if (this.doFeedback(state, bgc)) {
            return;
        }
        bgc.setColor(this.color);
        if (state.isSoftwareRender()) {
            this.softwareRender(state, bgc);
        } else {
            this.awtRender(state, bgc);
        }
        state.clearWorldClip(bgc, this.clipRect, originalClip);
    }

    private void softwareRender(State state, Graphics graphics) {
        Channel ch = state.ch;
        float a = 0.0f;
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        r = (float)this.color.getRed() / 255.0f;
        g = (float)this.color.getGreen() / 255.0f;
        b = (float)this.color.getBlue() / 255.0f;
        for (int i = 0; i < this.vertexCount; ++i) {
            for (double x = (double)(-this.pointSize / 2.0f); x < (double)this.pointSize; x += 1.0) {
                for (double y = (double)(-this.pointSize / 2.0f); y < (double)this.pointSize; y += 1.0) {
                    ch.plant((int)((double)this.xpoints[i] + x + 0.5), (int)((double)this.ypoints[i] + y + 0.5), this.dscr[i].z, this.alpha, r, g, b);
                }
            }
        }
    }

    private void awtRender(State state, Graphics g) {
        for (int i = 0; i < this.vertexCount; ++i) {
            g.drawOval(this.xpoints[0], this.ypoints[0], (int)this.pointSize, (int)this.pointSize);
        }
    }

    void split(Channel ch) {
        for (int i = 0; i < this.vertexCount; ++i) {
            J3Point point = new J3Point();
            Point4 p = this.vertex[i];
            point.vertex(ch, p.x, p.y, p.z);
            point.end(ch);
            ch.state.openDisplayList.primitives.addElement(point);
        }
    }

    @Override
    public boolean pick(State state, Graphics gc, Rectangle aperture) {
        if (this.clip) {
            return false;
        }
        return aperture.intersects(this.bbox);
    }

    @Override
    public void computeScreen(Channel ch) {
        super.computeScreen(ch);
        this.pointSize = ch.state.pointSize;
        if (this.pointSize > 1.0f) {
            this.bbox.setBounds((int)((float)this.bbox.x - this.pointSize / 2.0f), (int)((float)this.bbox.y - this.pointSize / 2.0f), (int)((float)this.bbox.width + this.pointSize), (int)((float)this.bbox.height + this.pointSize));
        }
    }

    @Override
    public Point4 getScreenCenter() {
        return this.dscr[0];
    }
}

