/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.ssl;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.Utils;
import com.sas.ssn.validate.ValidationResult;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorResult;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXCertPathValidatorResult;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FilenameUtils;

public class ChainValidatorUtil {
    public static final String MSG_KEY_CERT_FILE_NOT_FOUND = "certframe.cert.file.not.found";
    public static final String MSG_KEY_CERT_FILE_LOAD_PASSED = "certframe.cert.file.load.passed";
    public static final String MSG_KEY_CERT_FILE_NO_CERTS_FAILED = "certframe.cert.file.no.certs.failed";
    public static final String MSG_KEY_CERT_FILE_LOAD_FAILED = "certframe.cert.file.load.failed";
    public static final String MSG_KEY_CERT_FILE_NAME_RESERVED = "certframe.keystore.file.name.reserved";
    public static final String MSG_KEY_CERT_FILE_NOT_SUPPORTED = "certframe.cert.file.not.supported";
    public static final String MSG_KEY_CERT_FILE_BASE64_CHECK_FAILED = "certframe.keystore.file.base64.check.failed";
    public static final String MSG_KEY_CERT_FILE_NOT_PEM_FORMAT = "certframe.cert.file.not.pem.format";
    public static final String MSG_KEY_KEYSTORE_FILE_NOT_FOUND = "certframe.keystore.file.not.found";
    public static final String MSG_KEY_KEYSTORE_FILE_LOAD_PASSED = "certframe.keystore.file.load.passed";
    public static final String MSG_KEY_KEYSTORE_FILE_LOAD_FAILED = "certframe.keystore.file.load.failed";
    public static final String MSG_KEY_CERT_SIGNATURE_VERIFICATION_PASSED = "certframe.cert.signature.verification.passed";
    public static final String MSG_KEY_CERT_SIGNATURE_VERIFICATION_FAILED = "certframe.cert.signature.verification.failed";
    public static final String MSG_KEY_CERT_VALIDITY_CHECK_PASSED = "certframe.validity.check.passed";
    public static final String MSG_KEY_CERT_VALIDITY_CHECK_FAILED = "certframe.validity.check.failed";
    public static final String MSG_KEY_KEYSTORE_ALIAS_LOAD_PASSED = "certframe.keystore.alias.load.passed";
    public static final String MSG_KEY_KEYSTORE_ALIAS_LOAD_FAILED = "certframe.keystore.alias.load.failed";
    public static final String MSG_KEY_SIGNING_CERT_IN_KEYSTORE_CHECK_FAILED = "certframe.signing.cert.in.keystore.check.failed";
    public static final String MSG_KEY_GENERATE_CERTPATH_PASSED = "certframe.generate.certpath.passed";
    public static final String MSG_KEY_GENERATE_CERTPATH_FAILED = "certframe.generate.certpath.failed";
    public static final String MSG_KEY_VALIDATE_CERTPATH_PASSED = "certframe.validate.certpath.passed";
    public static final String MSG_KEY_VALIDATE_CERTPATH_FAILED = "certframe.validate.certpath.failed";
    protected String _certFileName;
    protected String _keyStoreFileName;
    protected String _keyStorePassword;
    protected List<X509Certificate> _certList = null;
    protected KeyStore _keyStore = null;
    protected CertPathValidatorResult _cpvResult = null;
    protected CertPath _cp = null;
    protected List<String> _supportedExtensions = new ArrayList<String>(3);
    protected List<String> _reservedFileNames;
    protected boolean _isZos;
    protected boolean _isAix;

    public ChainValidatorUtil() {
        this._supportedExtensions.add("cer");
        this._supportedExtensions.add("crt");
        this._supportedExtensions.add("pem");
        this._reservedFileNames = new ArrayList<String>(2);
        this._reservedFileNames.add("cacerts");
        this._reservedFileNames.add("trustedcerts");
        this._isZos = Utils.getOS() == 8 || Utils.getOS() == 10;
        this._isAix = Utils.getOS() == 5;
    }

    public void setCertFileName(String fileName) {
        Logging.log.fine("ChainValidatorUtil.setCertFileName(): setting cert file to: " + fileName);
        this._certFileName = fileName;
    }

    public String getCertFileName() {
        String retVal = null;
        retVal = this._certFileName;
        Logging.log.fine("ChainValidatorUtil.getCertFileName(): returning cert file: " + retVal);
        return retVal;
    }

    public void setKeyStoreFileName(String fileName) {
        Logging.log.fine("ChainValidatorUtil.setKeyStoreFileName(): setting keystore file to: " + fileName);
        this._keyStoreFileName = fileName;
    }

    public String getKeyStoreFileName() {
        String retVal = null;
        retVal = this._keyStoreFileName;
        Logging.log.fine("ChainValidatorUtil.getKeyStoreFileName(): returning cert file: " + retVal);
        return retVal;
    }

    public void setKeyStorePassword(String pw) {
        this._keyStorePassword = pw;
    }

    public String getKeyStorePassword() {
        return this._keyStorePassword;
    }

    public String getChainStr() {
        List<? extends Certificate> certsLoaded = this._cp.getCertificates();
        Iterator<? extends Certificate> it = certsLoaded.iterator();
        X509Certificate theCert = null;
        String chainStr = "";
        while (it.hasNext()) {
            theCert = (X509Certificate)it.next();
            chainStr = chainStr + "subject=" + theCert.getSubjectDN().getName() + ",issuer=" + theCert.getIssuerDN().getName() + "\r\n";
        }
        return chainStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String computePathToTrustStore() {
        String retVal = null;
        try (RegistryAccess registryAccess = null;){
            String certFrameInstallDirStr = null;
            String trustStorePathStr = null;
            RegistryData.setRegistry(Globals.g_cmtSASHome);
            registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            if (registryAccess != null && registryAccess.open()) {
                ProductData prodData = Globals.g_deploymentData.getProduct(Globals.g_order, "certframe", true);
                certFrameInstallDirStr = registryAccess.getInstallLoc(prodData.getProdCode(), prodData.getProdVersion(), prodData.getPlatform());
                Logging.log.fine("ChainValidatorUtil.computePathToTrustStore(): certframe install location = " + certFrameInstallDirStr);
                if (certFrameInstallDirStr == null) {
                    Logging.log.severe("ChainValidatorUtil.computePathToTrustStore(): certframe install location not found");
                    throw new Exception("certframe install location not found");
                }
            }
            certFrameInstallDirStr = Utils.joinPath(certFrameInstallDirStr, "cacerts");
            trustStorePathStr = Utils.joinPath(certFrameInstallDirStr, "trustedcerts.p12");
            trustStorePathStr = trustStorePathStr.replaceAll(Pattern.compile("^/(\\.\\.?/)+").toString(), "/");
            Logging.log.fine("CertificateValidator.groovy: trustStorePathStr = " + trustStorePathStr);
            retVal = trustStorePathStr;
        }
        return retVal;
    }

    protected ValidationResult loadInputCerts() {
        Logging.log.fine("ChainValidatorUtil.loadInputCerts(): BEGIN");
        ValidationResult result = null;
        String certFileName = this.getCertFileName();
        File certFile = new File(certFileName);
        if (!certFile.exists()) {
            Logging.log.severe("ChainValidatorUtil.loadInputCerts(): cert file not found: " + certFileName);
            result = new ValidationResult();
            result.setResult(2, MSG_KEY_CERT_FILE_NOT_FOUND);
        }
        if (result == null) {
            Logging.log.fine("ChainValidatorUtil.loadInputCerts(): cert file exists: " + certFileName);
            String baseFileName = FilenameUtils.getBaseName(certFileName);
            if (this._reservedFileNames.contains(baseFileName.toLowerCase())) {
                result = new ValidationResult();
                result.setResult(2, MSG_KEY_CERT_FILE_NAME_RESERVED, baseFileName);
            }
        }
        if (result == null) {
            Logging.log.fine("ChainValidatorUtil.loadInputCerts(): cert file name is accepted: " + certFileName);
            String ext = FilenameUtils.getExtension(certFileName);
            if (ext != null && !this._supportedExtensions.contains(ext = ext.toLowerCase())) {
                result = new ValidationResult();
                result.setResult(2, MSG_KEY_CERT_FILE_NOT_SUPPORTED, ext);
            }
        }
        if (result == null) {
            Logging.log.fine("ChainValidatorUtil.loadInputCerts(): cert file extension is accepted: " + certFileName);
            result = this.validateEncoding(certFile, certFileName);
        }
        if (result == null) {
            Logging.log.fine("ChainValidatorUtil.loadInputCerts(): cert file is base64 encoded: " + certFileName);
            result = this.validateFormat(certFileName);
        }
        if (result == null) {
            Logging.log.fine("ChainValidatorUtil.loadInputCerts(): cert file format is PEM: " + certFileName);
            if (!this._isZos && !this._isAix) {
                result = this.validateX509(certFileName);
            }
        }
        if (result == null) {
            Logging.log.fine("ChainValidatorUtil.loadInputCerts(): cert file has valid certificates: " + certFileName);
            result = new ValidationResult();
            result.setResult(0, MSG_KEY_CERT_FILE_LOAD_PASSED, certFileName);
        }
        Logging.log.fine("ChainValidatorUtil.loadInputCerts(): result = " + result.getMessageKey());
        Logging.log.fine("ChainValidatorUtil.loadInputCerts(): END");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ValidationResult loadKeyStore() {
        ValidationResult result = null;
        String keyStoreFileName = this.getKeyStoreFileName();
        String keyStorePassword = this.getKeyStorePassword();
        KeyStore keyStore = null;
        if (!new File(keyStoreFileName).exists()) {
            Logging.log.severe("ChainValidatorUtil.loadKeyStore(): keystore file not found: " + keyStoreFileName);
            result = new ValidationResult();
            result.setResult(2, MSG_KEY_KEYSTORE_FILE_NOT_FOUND, keyStoreFileName);
        } else {
            Logging.log.fine("ChainValidatorUtil.loadKeyStore(): keyStoreFileName exists: " + keyStoreFileName);
            FileInputStream fis = null;
            try {
                keyStore = KeyStore.getInstance("PKCS12");
                fis = new FileInputStream(keyStoreFileName);
                keyStore.load(fis, keyStorePassword.toCharArray());
                result = new ValidationResult();
                result.setResult(0, MSG_KEY_KEYSTORE_FILE_LOAD_PASSED, keyStoreFileName);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
                result = new ValidationResult();
                result.setResult(2, MSG_KEY_KEYSTORE_FILE_LOAD_FAILED, e.getMessage());
            }
            finally {
                try {
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (Exception e) {
                    Logging.log.warning("Error closing input stream for '" + keyStoreFileName + "': " + e);
                    Logging.logStackTrace(e);
                }
            }
        }
        Logging.log.fine("ChainValidatorUtil.loadKeyStore(): loaded keystore");
        this._keyStore = keyStore;
        return result;
    }

    protected ValidationResult validateChain(List<? extends Certificate> certList) {
        ValidationResult result = null;
        CertPathValidator cpv = null;
        PKIXParameters params = null;
        CertificateFactory cf = null;
        CertPath cp = null;
        PKIXCertPathValidatorResult cpvResult = null;
        int indexLast = certList.size() - 1;
        X509Certificate rootCert = (X509Certificate)certList.get(indexLast);
        String subjectdn = rootCert.getSubjectDN().getName();
        String issuerdn = rootCert.getIssuerDN().getName();
        try {
            if (subjectdn.equals(issuerdn)) {
                Logging.log.fine("ChainValidatorUtil.validateChain(): Root cert is a self-signed certificate.");
                TrustAnchor ta = new TrustAnchor(rootCert, null);
                params = new PKIXParameters(Collections.singleton(ta));
            } else {
                Logging.log.fine("ChainValidatorUtil.validateChain(): Root cert is not a self-signed certificate.");
                params = new PKIXParameters(this._keyStore);
            }
            params.setRevocationEnabled(false);
            cf = CertificateFactory.getInstance("X.509");
            this._cp = cp = cf.generateCertPath(certList);
            Logging.log.fine("ChainValidatorUtil.validateChain(): Cert path = " + cp.toString());
            result = new ValidationResult();
            result.setResult(0, MSG_KEY_GENERATE_CERTPATH_PASSED);
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
            Logging.log.fine("ChainValidatorUtil.validateChain(): message = " + e.getMessage());
            result = new ValidationResult();
            result.setResult(2, MSG_KEY_GENERATE_CERTPATH_FAILED, e.getMessage(), this.getChainStr());
        }
        try {
            cpv = CertPathValidator.getInstance("PKIX");
            cpvResult = (PKIXCertPathValidatorResult)cpv.validate(cp, params);
            result = new ValidationResult();
            result.setResult(0, MSG_KEY_VALIDATE_CERTPATH_PASSED);
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
            Logging.log.fine("ChainValidatorUtil.validateChain(): message = " + e.getMessage());
            result = new ValidationResult();
            result.setResult(2, MSG_KEY_VALIDATE_CERTPATH_FAILED, e.getMessage(), this.getChainStr());
        }
        if (result.getResultType() == 0) {
            Logging.log.fine("ChainValidatorUtil.validateChain(): created CertPathValidatorResult");
            this._cpvResult = cpvResult;
        }
        return result;
    }

    protected ValidationResult validateCert(X509Certificate cert) {
        String subjectdn = null;
        String issuerdn = null;
        boolean selfSignedCert = false;
        ValidationResult result = null;
        subjectdn = cert.getSubjectDN().getName();
        issuerdn = cert.getIssuerDN().getName();
        Logging.log.fine("ChainValidatorUtil.validateCert(): SubjectName = " + subjectdn);
        Logging.log.fine("ChainValidatorUtil.validateCert(): IssuerName = " + issuerdn);
        if (subjectdn.equals(issuerdn)) {
            Logging.log.fine("ChainValidatorUtil.validateCert(): This is a self-signed certificate.");
            selfSignedCert = true;
            try {
                cert.verify(cert.getPublicKey());
                Logging.log.fine("ChainValidatorUtil.validateCert(): Signature verification passed");
                result = new ValidationResult();
                result.setResult(0, MSG_KEY_CERT_SIGNATURE_VERIFICATION_PASSED, subjectdn);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
                result = new ValidationResult();
                result.setResult(2, MSG_KEY_CERT_SIGNATURE_VERIFICATION_FAILED, subjectdn);
            }
        }
        if (!selfSignedCert) {
            Logging.log.fine("ChainValidatorUtil.validateCert(): This is not a self-signed certificate");
            Enumeration<String> en = null;
            try {
                en = this._keyStore.aliases();
                result = new ValidationResult();
                result.setResult(0, MSG_KEY_KEYSTORE_ALIAS_LOAD_PASSED);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
                result = new ValidationResult();
                result.setResult(2, MSG_KEY_KEYSTORE_ALIAS_LOAD_FAILED);
            }
            Logging.log.fine("ChainValidatorUtil.validateCert(): Searching in keystore for the issuer's certificate");
            if (result.getResultType() == 0) {
                X509Certificate signingCert = null;
                String alias = null;
                X509Certificate keystoreCert = null;
                boolean aliasFound = false;
                while (en.hasMoreElements() && !aliasFound) {
                    alias = en.nextElement();
                    Logging.log.fine("ChainValidatorUtil.validateCert(): keystore alias = " + alias);
                    try {
                        if (!this._keyStore.isCertificateEntry(alias) || !(keystoreCert = (X509Certificate)this._keyStore.getCertificate(alias)).getIssuerDN().getName().equals(issuerdn)) continue;
                        aliasFound = true;
                        Logging.log.fine("ChainValidatorUtil.validateCert(): Found matching issuer DN cert in keystore: issuerdn");
                        cert.verify(keystoreCert.getPublicKey());
                        Logging.log.fine("ChainValidatorUtil.validateCert(): Signature verified on certificate");
                        signingCert = keystoreCert;
                        result = new ValidationResult();
                        result.setResult(0, MSG_KEY_CERT_SIGNATURE_VERIFICATION_PASSED, issuerdn);
                    }
                    catch (Exception e) {
                        Logging.logStackTrace(e);
                        result = new ValidationResult();
                        result.setResult(2, MSG_KEY_CERT_SIGNATURE_VERIFICATION_FAILED, issuerdn);
                    }
                }
                if (signingCert == null) {
                    Logging.log.fine("ChainValidatorUtil.validateCert(): Issuer certificate not found in keystore: " + issuerdn);
                    result = new ValidationResult();
                    result.setResult(2, MSG_KEY_SIGNING_CERT_IN_KEYSTORE_CHECK_FAILED, issuerdn);
                }
            }
        }
        if (result.getResultType() == 0) {
            try {
                cert.checkValidity();
                Logging.log.fine("ChainValidatorUtil.validateCert(): Certificate valid");
                result = new ValidationResult();
                result.setResult(0, MSG_KEY_CERT_VALIDITY_CHECK_PASSED, subjectdn);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
                result = new ValidationResult();
                result.setResult(2, MSG_KEY_CERT_VALIDITY_CHECK_FAILED, subjectdn);
            }
        }
        return result;
    }

    public ValidationResult validateData() {
        ValidationResult result = null;
        Logging.log.fine("ChainValidatorUtil.validateData(): calling loadInputCerts()");
        result = this.loadInputCerts();
        Logging.log.fine("ChainValidatorUtil.validateData(): result from calling loadInputCerts() = " + result.getMessageKey());
        if (result.getResultType() == 0) {
            Logging.log.fine("ChainValidatorUtil.validateData(): calling loadKeyStore()");
            result = this.loadKeyStore();
            if (result.getResultType() == 0) {
                Logging.log.fine("ChainValidatorUtil.validateData(): calling validateChain()");
                result = this.validateChain(this._certList);
            }
        }
        Logging.log.fine("ChainValidatorUtil.validateData(): result message key:" + result.getMessageKey());
        if (result.getResultType() == 0) {
            result = null;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult validateEncoding(File certFile, String certFilePath) {
        ValidationResult result = null;
        byte[] fileBytes = new byte[(int)certFile.length()];
        boolean isBase64 = true;
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(certFile);
            ((InputStream)inStream).read(fileBytes);
            isBase64 = Base64.isBase64(fileBytes);
            if (!isBase64) {
                String message = "cert file is not base64 encoded";
                Logging.log.severe("ChainValidatorUtil.loadInputCerts(): " + message + ": " + certFilePath);
                throw new Exception(message);
            }
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
            result = new ValidationResult();
            result.setResult(2, MSG_KEY_CERT_FILE_BASE64_CHECK_FAILED, certFilePath);
        }
        finally {
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                    inStream = null;
                }
            }
            catch (Exception e) {
                Logging.log.warning("Error closing input stream for '" + certFilePath + "': " + e);
                Logging.logStackTrace(e);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult validateFormat(String certFilePath) {
        ValidationResult result;
        block20: {
            String pem;
            ArrayList<String> pemBlocks = new ArrayList<String>();
            result = null;
            FileInputStream inStream = null;
            BufferedReader reader = null;
            boolean inBlock = false;
            Pattern beginPattern = Pattern.compile("-+BEGIN.*?CERTIFICATE-+");
            Pattern endPattern = Pattern.compile("-+END.*?CERTIFICATE-+");
            try {
                StringBuffer pemBlock = null;
                inStream = new FileInputStream(certFilePath);
                InputStreamReader isr = new InputStreamReader(inStream);
                reader = new BufferedReader(isr);
                String line = "";
                while (line != null) {
                    line = reader.readLine();
                    if (line == null) {
                        break;
                    }
                    if (!inBlock) {
                        Matcher beginPatternMatcher = beginPattern.matcher(line);
                        if (!beginPatternMatcher.find()) continue;
                        inBlock = true;
                        pemBlock = new StringBuffer();
                        continue;
                    }
                    Matcher endPatternMatcher = endPattern.matcher(line);
                    if (endPatternMatcher.find()) {
                        pemBlocks.add(pemBlock.toString());
                        inBlock = false;
                        continue;
                    }
                    pemBlock.append(line);
                }
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
                result = new ValidationResult();
                result.setResult(2, MSG_KEY_CERT_FILE_LOAD_FAILED, certFilePath);
            }
            finally {
                try {
                    if (inStream != null) {
                        ((InputStream)inStream).close();
                    }
                }
                catch (Exception e) {
                    Logging.log.warning("Error closing input stream for '" + certFilePath + "': " + e);
                    Logging.logStackTrace(e);
                }
            }
            if (pemBlocks.isEmpty()) {
                result = new ValidationResult();
                result.setResult(2, MSG_KEY_CERT_FILE_NOT_PEM_FORMAT, certFilePath);
            }
            if (result != null) break block20;
            if (this._isZos || this._isAix) {
                this._certList = new ArrayList<X509Certificate>(pemBlocks.size());
            }
            Iterator iterator = pemBlocks.iterator();
            while (iterator.hasNext() && null == (result = this.validatePEM(pem = (String)iterator.next(), certFilePath))) {
            }
        }
        return result;
    }

    private ValidationResult validatePEM(String pem, String certFilePath) {
        ValidationResult result = null;
        byte[] der = Base64.decodeBase64(pem);
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(der);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate cert = (X509Certificate)cf.generateCertificate(inputStream);
            if (this._isZos || this._isAix) {
                this._certList.add(cert);
            }
        }
        catch (Exception e) {
            Logging.log.severe("Error loading certificate: " + e);
            result = new ValidationResult();
            result.setResult(2, MSG_KEY_CERT_FILE_NOT_PEM_FORMAT);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ValidationResult validateX509(String certFilePath) {
        ValidationResult result = null;
        FileInputStream inStream = null;
        CertificateFactory cf = null;
        List x509CertList = null;
        try {
            inStream = new FileInputStream(certFilePath);
            cf = CertificateFactory.getInstance("X.509");
            x509CertList = (List)cf.generateCertificates(inStream);
            if (x509CertList == null || x509CertList.size() == 0) {
                result = new ValidationResult();
                result.setResult(2, MSG_KEY_CERT_FILE_NO_CERTS_FAILED);
            }
            this._certList = x509CertList;
        }
        catch (Exception e) {
            Logging.log.severe("Error loading certificate: " + e);
            Logging.logStackTrace(e);
            result = new ValidationResult();
            result.setResult(2, MSG_KEY_CERT_FILE_LOAD_FAILED, e.getMessage());
        }
        finally {
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (Exception e) {
                Logging.log.warning("Error closing input stream for '" + certFilePath + "': " + e);
                Logging.logStackTrace(e);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        Logging.createLog();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.ALL);
        handler.setFormatter(new SimpleFormatter());
        Logging.log.addHandler(handler);
        Logging.log.setLevel(Level.ALL);
        String CERTFILE1 = "C:\\Testing\\S1455059\\certificates\\certchain.cer";
        String CERTFILE2 = "C:\\Testing\\S1455059\\certificates\\sas.crt";
        String CERTFILE3 = "C:\\Testing\\S1455059\\certificates\\certchain.p7b";
        String CERTFILE4 = "C:\\Testing\\S1455059\\certificates\\certchain.p7b.pem";
        String CERTFILE5 = "C:\\Testing\\S1455059\\certificates\\trustedcerts.pem";
        String CERTFILE6 = "C:\\Testing\\S1455059\\certificates\\cacerts.pem";
        String KEYSTORE = "C:\\Program Files\\SASHome\\SASSecurityCertificateFramework\\1.1\\cacerts\\trustedcerts.p12";
        String KEYSTORE_PW = "changeit";
        ChainValidatorUtil chainValidatorUtil = new ChainValidatorUtil();
        chainValidatorUtil.setKeyStoreFileName(KEYSTORE);
        chainValidatorUtil.setKeyStorePassword(KEYSTORE_PW);
        chainValidatorUtil.setCertFileName(CERTFILE1);
        ValidationResult result = chainValidatorUtil.validateData();
        chainValidatorUtil.setCertFileName(CERTFILE2);
        result = chainValidatorUtil.validateData();
        chainValidatorUtil.setCertFileName(CERTFILE3);
        result = chainValidatorUtil.validateData();
        System.out.println("Result key = " + result.getMessageKey() + ", data = " + result.getMessageValues());
        chainValidatorUtil.setCertFileName(CERTFILE4);
        result = chainValidatorUtil.validateData();
        System.out.println("Result key = " + result.getMessageKey() + ", data = " + result.getMessageValues());
        chainValidatorUtil.setCertFileName(CERTFILE5);
        result = chainValidatorUtil.validateData();
        System.out.println("Result key = " + result.getMessageKey() + ", data = " + result.getMessageValues());
        chainValidatorUtil.setCertFileName(CERTFILE6);
        result = chainValidatorUtil.validateData();
        System.out.println("Result key = " + result.getMessageKey() + ", data = " + result.getMessageValues());
    }
}

