/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.ssl;

import com.sas.ssn.Logging;
import com.sas.ssn.validate.ValidationResult;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;

public class CertificateValidatorUtil {
    public static final String MSG_KEY_CERT_FILE_NOT_FOUND = "certframe.cert.file.not.found";
    public static final String MSG_KEY_CERT_FILE_LOAD_PASSED = "certframe.cert.file.load.passed";
    public static final String MSG_KEY_CERT_FILE_LOAD_FAILED = "certframe.cert.file.load.failed";
    public static final String MSG_KEY_CERT_FILE_CLOSE_FAILED = "certframe.cert.file.close.failed";
    public static final String MSG_KEY_KEYSTORE_FILE_NOT_FOUND = "certframe.keystore.file.not.found";
    public static final String MSG_KEY_KEYSTORE_FILE_LOAD_PASSED = "certframe.keystore.file.load.passed";
    public static final String MSG_KEY_KEYSTORE_FILE_LOAD_FAILED = "certframe.keystore.file.load.failed";
    public static final String MSG_KEY_KEYSTORE_FILE_CLOSE_FAILED = "certframe.keystore.file.close.failed";
    public static final String MSG_KEY_CERT_SIGNATURE_VERIFICATION_PASSED = "certframe.cert.signature.verification.passed";
    public static final String MSG_KEY_CERT_SIGNATURE_VERIFICATION_FAILED = "certframe.cert.signature.verification.failed";
    public static final String MSG_KEY_CERT_VALIDITY_CHECK_PASSED = "certframe.validity.check.passed";
    public static final String MSG_KEY_CERT_VALIDITY_CHECK_FAILED = "certframe.validity.check.failed";
    public static final String MSG_KEY_KEYSTORE_ALIAS_LOAD_PASSED = "certframe.keystore.alias.load.passed";
    public static final String MSG_KEY_KEYSTORE_ALIAS_LOAD_FAILED = "certframe.keystore.alias.load.failed";
    public static final String MSG_KEY_SIGNING_CERT_IN_KEYSTORE_CHECK_FAILED = "certframe.signing.cert.in.keystore.check.failed";
    protected String _certFileName;
    protected String _keyStoreFileName;
    protected String _keyStorePassword;

    public void setCertFileName(String fileName) {
        Logging.log.fine("CertificateValidatorUtil.setCertFileName(): setting cert file to: " + fileName);
        this._certFileName = fileName;
    }

    public String getCertFileName() {
        String retVal = null;
        retVal = this._certFileName;
        Logging.log.fine("CertificateValidatorUtil.getCertFileName(): returning cert file: " + retVal);
        return retVal;
    }

    public void setKeyStoreFileName(String fileName) {
        Logging.log.fine("CertificateValidatorUtil.setKeyStoreFileName(): setting keystore file to: " + fileName);
        this._keyStoreFileName = fileName;
    }

    public String getKeyStoreFileName() {
        String retVal = null;
        retVal = this._keyStoreFileName;
        Logging.log.fine("CertificateValidatorUtil.getKeyStoreFileName(): returning cert file: " + retVal);
        return retVal;
    }

    public void setKeyStorePassword(String pw) {
        this._keyStorePassword = pw;
    }

    public String getKeyStorePassword() {
        return this._keyStorePassword;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ValidationResult validateData() {
        ValidationResult result;
        X509Certificate cert;
        String subjectdn;
        block46: {
            KeyStore keyStore;
            String issuerdn;
            block43: {
                String keyStorePassword;
                String keyStoreFileName;
                block47: {
                    block45: {
                        block42: {
                            String certFileName;
                            block44: {
                                subjectdn = null;
                                issuerdn = null;
                                cert = null;
                                result = null;
                                certFileName = this.getCertFileName();
                                if (new File(certFileName).exists()) break block44;
                                Logging.log.severe("CertificateValidatorUtil: cert file not found: " + certFileName);
                                result = new ValidationResult();
                                result.setResult(2, MSG_KEY_CERT_FILE_NOT_FOUND, certFileName);
                                break block45;
                            }
                            Logging.log.fine("CertificateValidatorUtil: certFileName exists: " + certFileName);
                            FileInputStream inStream = null;
                            CertificateFactory cf = null;
                            inStream = new FileInputStream(certFileName);
                            cf = CertificateFactory.getInstance("X.509");
                            cert = (X509Certificate)cf.generateCertificate(inStream);
                            try {
                                if (inStream != null) {
                                    ((InputStream)inStream).close();
                                }
                                break block42;
                            }
                            catch (Exception e) {
                                Logging.logStackTrace(e);
                                result = new ValidationResult();
                                result.setResult(2, MSG_KEY_CERT_FILE_CLOSE_FAILED, certFileName);
                            }
                            break block42;
                            catch (Exception e) {
                                try {
                                    Logging.logStackTrace(e);
                                    result = new ValidationResult();
                                    result.setResult(2, MSG_KEY_CERT_FILE_LOAD_FAILED, certFileName);
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (inStream != null) {
                                            ((InputStream)inStream).close();
                                        }
                                    }
                                    catch (Exception e2) {
                                        Logging.logStackTrace(e2);
                                        result = new ValidationResult();
                                        result.setResult(2, MSG_KEY_CERT_FILE_CLOSE_FAILED, certFileName);
                                    }
                                    throw throwable;
                                }
                                try {
                                    if (inStream != null) {
                                        ((InputStream)inStream).close();
                                    }
                                }
                                catch (Exception e3) {
                                    Logging.logStackTrace(e3);
                                    result = new ValidationResult();
                                    result.setResult(2, MSG_KEY_CERT_FILE_CLOSE_FAILED, certFileName);
                                }
                            }
                        }
                        if (result == null) {
                            subjectdn = cert.getSubjectDN().getName();
                            issuerdn = cert.getIssuerDN().getName();
                            Logging.log.fine("CertificateValidatorUtil: SubjectName = " + subjectdn);
                            Logging.log.fine("CertificateValidatorUtil: IssuerName = " + issuerdn);
                            if (subjectdn.equals(issuerdn)) {
                                Logging.log.fine("CertificateValidatorUtil: This is a self-signed certificate.");
                                try {
                                    cert.verify(cert.getPublicKey());
                                    Logging.log.fine("CertificateValidatorUtil: Signature verification passed");
                                    result = new ValidationResult();
                                    result.setResult(0, MSG_KEY_CERT_SIGNATURE_VERIFICATION_PASSED, subjectdn);
                                }
                                catch (Exception e) {
                                    Logging.logStackTrace(e);
                                    result = new ValidationResult();
                                    result.setResult(2, MSG_KEY_CERT_SIGNATURE_VERIFICATION_FAILED, subjectdn);
                                }
                            }
                        }
                    }
                    if (result != null) break block46;
                    Logging.log.fine("CertificateValidatorUtil: This is not a self-signed certificate");
                    Logging.log.fine("CertificateValidatorUtil: Searching in keystore for the issuer's certificate");
                    keyStoreFileName = this.getKeyStoreFileName();
                    keyStorePassword = this.getKeyStorePassword();
                    if (new File(keyStoreFileName).exists()) break block47;
                    Logging.log.severe("CertificateValidatorUtil: keystore file not found: " + keyStoreFileName);
                    result = new ValidationResult();
                    result.setResult(2, MSG_KEY_KEYSTORE_FILE_NOT_FOUND, keyStoreFileName);
                    break block46;
                }
                Logging.log.fine("CertificateValidatorUtil: keyStoreFileName exists: " + keyStoreFileName);
                keyStore = null;
                FileInputStream fis = null;
                keyStore = KeyStore.getInstance("PKCS12");
                fis = new FileInputStream(keyStoreFileName);
                keyStore.load(fis, keyStorePassword.toCharArray());
                try {
                    if (fis != null) {
                        fis.close();
                    }
                    break block43;
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                    result = new ValidationResult();
                    result.setResult(2, MSG_KEY_KEYSTORE_FILE_CLOSE_FAILED, keyStoreFileName);
                }
                break block43;
                catch (Exception e) {
                    try {
                        Logging.logStackTrace(e);
                        result = new ValidationResult();
                        result.setResult(2, MSG_KEY_KEYSTORE_FILE_LOAD_FAILED, keyStoreFileName);
                    }
                    catch (Throwable throwable) {
                        try {
                            if (fis != null) {
                                fis.close();
                            }
                        }
                        catch (Exception e4) {
                            Logging.logStackTrace(e4);
                            result = new ValidationResult();
                            result.setResult(2, MSG_KEY_KEYSTORE_FILE_CLOSE_FAILED, keyStoreFileName);
                        }
                        throw throwable;
                    }
                    try {
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (Exception e5) {
                        Logging.logStackTrace(e5);
                        result = new ValidationResult();
                        result.setResult(2, MSG_KEY_KEYSTORE_FILE_CLOSE_FAILED, keyStoreFileName);
                    }
                }
            }
            if (result == null) {
                Logging.log.fine("CertificateValidatorUtil: loaded keystore");
                Enumeration<String> en = null;
                try {
                    en = keyStore.aliases();
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                    result = new ValidationResult();
                    result.setResult(2, MSG_KEY_KEYSTORE_FILE_LOAD_FAILED);
                }
                if (result == null) {
                    X509Certificate signingcert = null;
                    while (en.hasMoreElements() && result == null) {
                        X509Certificate storecert = null;
                        String ali = en.nextElement();
                        try {
                            if (!keyStore.isCertificateEntry(ali) || !(storecert = (X509Certificate)keyStore.getCertificate(ali)).getIssuerDN().getName().equals(issuerdn)) continue;
                            Logging.log.fine("CertificateValidatorUtil: Found matching issuer DN cert in keystore: issuerdn");
                            cert.verify(storecert.getPublicKey());
                            Logging.log.fine("CertificateValidatorUtil: Signature verified on certificate");
                            signingcert = storecert;
                            result = new ValidationResult();
                            result.setResult(0, MSG_KEY_CERT_SIGNATURE_VERIFICATION_PASSED, issuerdn);
                        }
                        catch (Exception e) {
                            Logging.logStackTrace(e);
                            result = new ValidationResult();
                            result.setResult(2, MSG_KEY_CERT_SIGNATURE_VERIFICATION_FAILED, issuerdn);
                        }
                    }
                    if (signingcert == null) {
                        Logging.log.fine("CertificateValidatorUtil: Issuer certificate not found in keystore: " + issuerdn);
                        result = new ValidationResult();
                        result.setResult(2, MSG_KEY_SIGNING_CERT_IN_KEYSTORE_CHECK_FAILED, issuerdn);
                    }
                }
            }
        }
        if (result.getResultType() == 0) {
            try {
                cert.checkValidity();
                Logging.log.fine("CertificateValidatorUtil: Certificate valid");
                result = new ValidationResult();
                result.setResult(0, MSG_KEY_CERT_VALIDITY_CHECK_PASSED, subjectdn);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
                result = new ValidationResult();
                result.setResult(2, MSG_KEY_CERT_VALIDITY_CHECK_FAILED, subjectdn);
            }
        }
        Logging.log.fine("CertificateValidatorUtil: result message string:" + result.getMessageKey());
        if (result.getResultType() == 0) {
            result = null;
        }
        return result;
    }

    public static void main(String[] args) {
        Logging.createLog();
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(Level.ALL);
        handler.setFormatter(new SimpleFormatter());
        Logging.log.addHandler(handler);
        Logging.log.setLevel(Level.ALL);
        ArrayList<String> certsAry = new ArrayList<String>();
        certsAry.add("/r/sanyo.unx.sas.com/vol/vol420/u42/viilli/certs/cacerts");
        certsAry.add("/r/sanyo.unx.sas.com/vol/vol420/u42/viilli/certs/cacerts_2_sasrootca.pem");
        certsAry.add("/r/sanyo.unx.sas.com/vol/vol420/u42/viilli/certs/certnew_3_sasrootca.p7b");
        certsAry.add("/r/sanyo.unx.sas.com/vol/vol420/u42/viilli/certs/ettvm46_1_sasca1.cer");
        certsAry.add("/r/sanyo.unx.sas.com/vol/vol420/u42/viilli/certs/ettvm46_1_self.crt");
        certsAry.add("/r/sanyo.unx.sas.com/vol/vol420/u42/viilli/certs/ettvm46_1_self.pem");
        certsAry.add("/r/sanyo.unx.sas.com/vol/vol420/u42/viilli/certs/sasca1_1_sasrootca.cer");
        certsAry.add("/r/sanyo.unx.sas.com/vol/vol420/u42/viilli/certs/SASRootCA_1_self.cer");
        certsAry.add("/r/sanyo.unx.sas.com/vol/vol420/u42/viilli/certs/invalid/cacerts_2_sasrootca_reversed.pem");
        certsAry.add("/r/sanyo.unx.sas.com/vol/vol420/u42/viilli/certs/invalid/cacerts_2_sasrootca_invalid_sig.pem");
        certsAry.add("/r/sanyo.unx.sas.com/vol/vol420/u42/viilli/certs/invalid/cacerts_2_sasrootca_invalid_sig_reversed.pem");
        certsAry.add("/r/sanyo.unx.sas.com/vol/vol420/u42/viilli/certs/invalid/SASRootCA_1_self_invalid_sig.cer");
        certsAry.add("/r/sanyo.unx.sas.com/vol/vol420/u42/viilli/certs/invalid/server_1_self_expired.crt");
        certsAry.add("/r/sanyo.unx.sas.com/vol/vol420/u42/viilli/CertificateVerifier.java");
        ArrayList<String> bundleAry = new ArrayList<String>();
        bundleAry.add("/install/SASHome3/SASPrivateJavaRuntimeEnvironment/9.4/jre/lib/security/cacerts");
        String CERTFILE = (String)certsAry.get(13);
        String KEYSTORE = (String)bundleAry.get(0);
        String KEYSTORE_PW = "changeit";
        CertificateValidatorUtil certificateValidatorUtil = new CertificateValidatorUtil();
        certificateValidatorUtil.setCertFileName(CERTFILE);
        certificateValidatorUtil.setKeyStoreFileName(KEYSTORE);
        certificateValidatorUtil.setKeyStorePassword(KEYSTORE_PW);
        certificateValidatorUtil.validateData();
    }
}

