/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.lsm.impl;

import com.sas.ssn.lsm.ConfigInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

public class JavaIniFile
implements ConfigInterface {
    private static final String VMOPTION_LANGUAGE = "-Duser.language=";
    private static final String VMOPTION_COUNTRY = "-Duser.country=";
    private static final String JAVA_ARGS = "JavaArgs_";
    private static final String EQUAL_STRING = "=";
    private List iniContents = null;
    private List listJavaArgs = null;
    private Locale locale = null;
    private String configFile = null;
    private boolean bInstalled;

    public JavaIniFile(String file) {
        this.configFile = file;
    }

    @Override
    public synchronized void load() throws FileNotFoundException, IOException {
        ArrayList<String> iniContents = new ArrayList<String>();
        ArrayList<JavaArgs> listJavaArgs = new ArrayList<JavaArgs>();
        Locale locale = null;
        File file = new File(this.configFile);
        if (!file.isFile()) {
            this.bInstalled = false;
        } else {
            String line;
            this.bInstalled = true;
            BufferedReader in = new BufferedReader(new FileReader(this.configFile));
            while ((line = in.readLine()) != null) {
                iniContents.add(line);
                if (line.indexOf(JAVA_ARGS) == -1) continue;
                int index = line.indexOf(EQUAL_STRING);
                String key = line.substring(0, index);
                String arg = line.substring(index + 1);
                JavaArgs javaArgs = new JavaArgs(key, arg);
                listJavaArgs.add(javaArgs);
            }
            in.close();
            if (listJavaArgs.size() != 0) {
                String language = null;
                String country = null;
                for (JavaArgs javaArgs : listJavaArgs) {
                    String arg = javaArgs.getArg();
                    if (arg.indexOf(VMOPTION_LANGUAGE) > -1) {
                        language = arg.substring(VMOPTION_LANGUAGE.length());
                        continue;
                    }
                    if (arg.indexOf(VMOPTION_COUNTRY) <= -1) continue;
                    country = arg.substring(VMOPTION_COUNTRY.length());
                }
                if (language != null && country != null) {
                    locale = new Locale(language, country);
                } else if (language != null) {
                    locale = new Locale(language);
                }
            }
            this.iniContents = iniContents;
            this.listJavaArgs = listJavaArgs;
            this.locale = locale;
        }
    }

    @Override
    public void store(String outFile) throws IOException {
        if (this.bInstalled) {
            PrintWriter out = new PrintWriter(new FileWriter(outFile));
            for (int i = 0; i < this.iniContents.size(); ++i) {
                String line = (String)this.iniContents.get(i);
                out.println(line);
            }
            out.flush();
            out.close();
        }
    }

    @Override
    public void update() throws IOException {
        this.store(this.configFile);
    }

    private String updateJavaAgrsList() {
        if (!this.bInstalled) {
            return null;
        }
        if (this.locale == null) {
            Iterator iter = this.listJavaArgs.iterator();
            while (iter.hasNext()) {
                JavaArgs javaArgs = (JavaArgs)iter.next();
                String arg = javaArgs.getArg();
                if (arg.indexOf(VMOPTION_LANGUAGE) > -1) {
                    iter.remove();
                    continue;
                }
                if (arg.indexOf(VMOPTION_COUNTRY) <= -1) continue;
                iter.remove();
            }
        } else {
            String language = this.locale.getLanguage();
            String country = this.locale.getCountry();
            int posLanguage = -1;
            int posCountry = -1;
            for (int i = 0; i < this.listJavaArgs.size(); ++i) {
                JavaArgs javaArgs = (JavaArgs)this.listJavaArgs.get(i);
                String arg = javaArgs.getArg();
                if (arg.indexOf(VMOPTION_LANGUAGE) > -1) {
                    posLanguage = i;
                    continue;
                }
                if (arg.indexOf(VMOPTION_COUNTRY) <= -1) continue;
                posCountry = i;
            }
            if (language != null) {
                if (posLanguage != -1) {
                    JavaArgs javaArgs = (JavaArgs)this.listJavaArgs.get(posLanguage);
                    javaArgs.setArg(VMOPTION_LANGUAGE + language);
                } else {
                    JavaArgs newJavaArg = new JavaArgs(this.listJavaArgs.size() + 1, VMOPTION_LANGUAGE + language);
                    this.listJavaArgs.add(newJavaArg);
                }
            }
            if (country != null && language != null) {
                if (posCountry != -1) {
                    JavaArgs javaArgs = (JavaArgs)this.listJavaArgs.get(posCountry);
                    javaArgs.setArg(VMOPTION_COUNTRY + country);
                } else {
                    JavaArgs newJavaArg = new JavaArgs(this.listJavaArgs.size() + 1, VMOPTION_COUNTRY + country);
                    this.listJavaArgs.add(newJavaArg);
                }
            }
        }
        this.organizeListJavaArgs();
        this.updateIniContentsList();
        return String.valueOf(this.listJavaArgs.size());
    }

    private void updateIniContentsList() {
        int indexJavaArgsLine = -1;
        Iterator iter = this.iniContents.iterator();
        int currentIndex = 0;
        while (iter.hasNext()) {
            String line = (String)iter.next();
            int indexCmdLineArg = line.indexOf(JAVA_ARGS);
            if (indexCmdLineArg != -1) {
                if (indexJavaArgsLine == -1) {
                    indexJavaArgsLine = currentIndex;
                }
                iter.remove();
            }
            ++currentIndex;
        }
        if (indexJavaArgsLine != -1) {
            for (int i = 0; i < this.listJavaArgs.size(); ++i) {
                JavaArgs javaArgs = (JavaArgs)this.listJavaArgs.get(i);
                this.iniContents.add(indexJavaArgsLine + i, javaArgs.keyStr + EQUAL_STRING + javaArgs.argStr);
            }
        }
    }

    private void organizeListJavaArgs() {
        for (int i = 0; i < this.listJavaArgs.size(); ++i) {
            JavaArgs javaArgs = (JavaArgs)this.listJavaArgs.get(i);
            javaArgs.setKey(i + 1);
        }
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
        this.updateJavaAgrsList();
    }

    @Override
    public String getConfigurationFile() {
        return this.configFile;
    }

    @Override
    public List getContents() {
        return this.iniContents;
    }

    @Override
    public int validate() {
        if (this.listJavaArgs.isEmpty()) {
            return 1;
        }
        if (this.listJavaArgs.size() < 1) {
            return 2;
        }
        return 0;
    }

    @Override
    public boolean isInstalled() {
        return this.bInstalled;
    }

    @Override
    public Object clone() {
        JavaIniFile iniFile = null;
        try {
            iniFile = (JavaIniFile)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        return iniFile;
    }

    @Override
    public void printDebug() {
        if (this.locale != null) {
            System.out.println("Locale->" + this.locale.toString());
        }
        for (int i = 0; i < this.iniContents.size(); ++i) {
            System.out.println(i + "-->" + (String)this.iniContents.get(i));
        }
    }

    private class JavaArgs {
        private int index = 0;
        private String keyStr = null;
        private String argStr = null;

        public JavaArgs(String key, String arg) {
            this.index = Integer.parseInt(key.substring(JavaIniFile.JAVA_ARGS.length()));
            this.keyStr = key;
            this.argStr = arg;
        }

        public JavaArgs(int index, String arg) {
            this.index = index;
            this.keyStr = JavaIniFile.JAVA_ARGS + index;
            this.argStr = arg;
        }

        public String getKey() {
            return this.keyStr;
        }

        public String getArg() {
            return this.argStr;
        }

        public int getIndex() {
            return this.index;
        }

        public void setKey(String key) {
            this.keyStr = key;
            this.index = Integer.parseInt(key.substring(JavaIniFile.JAVA_ARGS.length()));
        }

        public void setKey(int index) {
            this.index = index;
            this.keyStr = JavaIniFile.JAVA_ARGS + index;
        }

        public void setArg(String arg) {
            this.argStr = arg;
        }
    }
}

