/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.install;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryImpl;
import com.sas.metadata.remote.MdOMRConnection;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.util.ConfigurablePropertiesUtil;
import com.sas.metadata.util.ConfigurationDirectory;
import com.sas.ssn.Globals;
import com.sas.ssn.install.GroovyInstallTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import org.apache.tools.ant.Project;

public class PushAgentMetadata
extends GroovyInstallTask {
    public static final String DEPLOYAGENT_INSTALL_DIR = "deployagent.install.dir";
    public static final String SOLSTICE_AGENT_JMX_PORT = "solstice.agent.jmx.port";
    public static final String SOLSTICE_SECURITY_ENABLED = "solstice.security.enabled";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int execute(Project project) {
        int ret = 0;
        this.setAntProject(project);
        String metahost = project.getProperty("iomsrv.metadatasrv.host");
        String metaport = project.getProperty("iomsrv.metadatasrv.port");
        String metauser = project.getProperty("oma.person.admin.login.userid");
        String metapassword = project.getProperty("oma.person.admin.login.passwd");
        String myhostname = project.getProperty("os.localhost.fqdn.host.name");
        String installdir = project.getProperty(DEPLOYAGENT_INSTALL_DIR);
        if (installdir == null) {
            this.log(Level.WARNING, "PushAgentMetadata", "execute()", "deployagent.install.dir property is not defined");
        } else {
            String propsFilePath = installdir + "/config/agent.properties";
            MdObjectStore store = null;
            try {
                store = this.getMetadataConnection(metahost, metaport, metauser, metapassword);
                if (store != null) {
                    ret = this.updateLevDirRoots(store, myhostname, propsFilePath);
                    store.updatedMetadataAll();
                }
            }
            catch (IOException ioe) {
                this.logStackTrace(ioe);
                ret = -1;
            }
            catch (MdException me) {
                this.logStackTrace(me);
                ret = -1;
            }
            finally {
                if (store != null) {
                    try {
                        MdFactory factory = store.getFactory();
                        store.dispose();
                        if (factory != null) {
                            factory.dispose();
                        }
                    }
                    catch (IOException ioe) {
                        this.logStackTrace(ioe);
                    }
                }
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(String target) {
        int ret = 0;
        String host = Globals.g_installData.getProperty("metadata.connection.host", null);
        String port = Globals.g_installData.getProperty("metadata.connection.port", null);
        String user = Globals.g_installData.getProperty("metadata.connection.userid", null);
        String password = Globals.g_installData.getProperty("metadata.connection.passwd", null);
        String machine = Globals.g_installData.getProperty("os.localhost.from.metadata", null);
        if (machine == null) {
            machine = Globals.g_installData.getProperty("os.localhost.fqdn.host.name", null);
        }
        String installDir = Globals.g_installData.getProperty(DEPLOYAGENT_INSTALL_DIR, null);
        String propsFilePath = null;
        if (installDir == null) {
            this.log(Level.SEVERE, "PushAgentMetadata", "execute()", "deployagent.install.dir property is not defined");
        } else {
            propsFilePath = installDir + "/config/agent.properties";
            MdObjectStore store = null;
            try {
                store = this.getMetadataConnection(host, port, user, password);
                if (store != null) {
                    ret = this.updateLevDirRoots(store, machine, propsFilePath);
                    store.updatedMetadataAll();
                }
            }
            catch (Exception e) {
                this.log(Level.SEVERE, "PushAgentMetadata", "execute()", "Caught error trying to update LEVDIRROOT", e);
                ret = -1;
            }
            finally {
                if (store != null) {
                    try {
                        MdFactory factory = store.getFactory();
                        store.dispose();
                        if (factory != null) {
                            factory.dispose();
                        }
                    }
                    catch (IOException ioe) {
                        this.logStackTrace(ioe);
                    }
                }
            }
        }
        return ret;
    }

    protected MdObjectStore getMetadataConnection(String host, String port, String user, String password) throws MdException, RemoteException {
        MdObjectStore mdObjectStore = null;
        if (host == null) {
            this.log(Level.SEVERE, "PushAgentMetadata", "getMetadataConnection()", "host is null!");
        }
        if (port == null) {
            this.log(Level.SEVERE, "PushAgentMetadata", "getMetadataConnection()", "port is null!");
        }
        if (user == null) {
            this.log(Level.SEVERE, "PushAgentMetadata", "getMetadataConnection()", "user is null!");
        }
        if (password == null) {
            this.log(Level.SEVERE, "PushAgentMetadata", "getMetadataConnection()", "password is null!");
        }
        if (host != null && port != null && user != null && password != null) {
            MdFactoryImpl mdFactory = new MdFactoryImpl(false);
            mdFactory.setDebug(false);
            mdFactory.getUtil().setOutputStream(System.out);
            mdFactory.setLoggingEnabled(false);
            mdFactory.getUtil().setLogStream(System.out);
            MdOMRConnection connection = mdFactory.getConnection();
            connection.makeOMRConnection(host, port, user, password);
            mdObjectStore = mdFactory.createObjectStore(null, "SDW: ConfigurationStore");
        }
        return mdObjectStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Properties loadProperties(String propsFilePath) throws FileNotFoundException, IOException {
        File file;
        Properties properties = new Properties();
        if (propsFilePath == null) {
            this.log(Level.SEVERE, "PushAgentMetadata", "loadProperties()", "propsFilePath is null!");
        }
        if (!(file = new File(propsFilePath)).exists()) {
            this.log(Level.SEVERE, "PushAgentMetadata", "loadProperties()", "The agent properties file does not exist: " + propsFilePath);
        } else {
            try (FileInputStream fis = new FileInputStream(propsFilePath);){
                properties.load(fis);
            }
        }
        return properties;
    }

    protected int updateLevDirRoots(MdObjectStore store, String machine, String propsFilePath) {
        int ret = 0;
        if (store == null) {
            this.log(Level.SEVERE, "PushAgentMetadata", "updateLevDirRoots()", "store is null!");
        }
        if (machine == null) {
            this.log(Level.SEVERE, "PushAgentMetadata", "updateLevDirRoots()", "machine is null!");
        }
        if (propsFilePath == null) {
            this.log(Level.SEVERE, "PushAgentMetadata", "updateLevDirRoots()", "propsFilePath is null!");
        }
        if (store != null && machine != null && propsFilePath != null) {
            try {
                List<SoftwareComponent> configDirs;
                Properties props = this.loadProperties(propsFilePath);
                String port = props.getProperty(SOLSTICE_AGENT_JMX_PORT);
                String securityEnabled = props.getProperty(SOLSTICE_SECURITY_ENABLED);
                if (port == null) {
                    this.log(Level.SEVERE, "PushAgentMetadata", "updateLevDirRoots()", "solstice.agent.jmx.port is not defined!");
                }
                if (securityEnabled == null) {
                    securityEnabled = "false";
                }
                if ((configDirs = ConfigurationDirectory.getConfigurationDirectories(store, machine)) == null) {
                    this.log(Level.SEVERE, "PushAgentMetadata", "updateLevDirRoots()", "configDirs is null!");
                    ret = -1;
                }
                if (configDirs != null && port != null && securityEnabled != null) {
                    for (SoftwareComponent configDir : configDirs) {
                        HashMap<String, String> publicProperties = new HashMap<String, String>();
                        HashMap<String, String> privateProperties = new HashMap<String, String>();
                        ConfigurablePropertiesUtil.getObjectProperties(configDir, publicProperties, privateProperties);
                        publicProperties.put(SOLSTICE_AGENT_JMX_PORT, port);
                        publicProperties.put(SOLSTICE_SECURITY_ENABLED, securityEnabled);
                        ConfigurablePropertiesUtil.setObjectProperties(configDir, publicProperties, privateProperties);
                        this.log(Level.INFO, "PushAgentMetadata", "updateLevDirRoots()", "Successfully updated LevDirRoot " + configDir.getId() + "(" + configDir.getName() + ")");
                    }
                }
            }
            catch (MdException mde) {
                this.logStackTrace(mde);
                ret = -1;
            }
            catch (IOException ioe) {
                this.logStackTrace(ioe);
                ret = -1;
            }
        }
        return ret;
    }
}

