/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn.install;

import com.sas.ssn.InstallData;
import com.sas.ssn.ProductData;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tools.ant.Project;

public abstract class GroovyInstallTask {
    protected ProductData productData = null;
    protected InstallData installData = null;
    protected Logger logger = null;
    protected Project project = null;

    public void init(InstallData installData, ProductData productData) {
        this.installData = installData;
        this.productData = productData;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setAntProject(Project project) {
        this.project = project;
    }

    protected int getAntLevel(Level level) {
        int ret = 2;
        if (level != null) {
            if (level == Level.FINE || level == Level.FINER || level == Level.FINEST) {
                ret = 3;
            } else if (level == Level.SEVERE) {
                ret = 0;
            } else if (level == Level.WARNING) {
                ret = 1;
            }
        }
        return ret;
    }

    public void log(Level level, String msg) {
        if (this.logger != null) {
            this.logger.log(level, msg);
        }
        if (this.project != null) {
            this.project.log(msg, this.getAntLevel(level));
        }
    }

    public void log(Level level, String sourceClass, String sourceMethod, String msg) {
        if (this.logger != null) {
            this.logger.logp(level, sourceClass, sourceMethod, msg);
        }
        if (this.project != null) {
            StringBuffer sb = new StringBuffer();
            if (sourceClass != null) {
                sb.append(sourceClass + ":");
            }
            if (sourceMethod != null) {
                sb.append(sourceMethod + " ");
            }
            if (msg != null) {
                sb.append(msg);
            }
            this.project.log(sb.toString(), this.getAntLevel(level));
        }
    }

    public void log(Level level, String sourceClass, String sourceMethod, String msg, Throwable thrown) {
        if (this.logger != null) {
            this.logger.logp(level, sourceClass, sourceMethod, msg, thrown);
        }
        if (this.project != null) {
            StringBuffer sb = new StringBuffer();
            if (sourceClass != null) {
                sb.append(sourceClass + ":");
            }
            if (sourceMethod != null) {
                sb.append(sourceMethod + " ");
            }
            if (msg != null) {
                sb.append(msg);
            }
            this.project.log(sb.toString(), thrown, this.getAntLevel(level));
        }
    }

    public void logStackTrace(Throwable e) {
        if (this.logger != null) {
            this.logger.severe(this.getFormattedLogMsg(e));
        }
    }

    public String getFormattedLogMsg(Throwable e) {
        String logMsg = e.toString();
        StackTraceElement[] stackTrace = e.getStackTrace();
        for (int i = 0; i < stackTrace.length; ++i) {
            logMsg = logMsg + "\n" + stackTrace[i].toString();
        }
        Throwable cause = e.getCause();
        if (cause != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            logMsg = logMsg + "\n\nCaused by:\n";
            logMsg = logMsg + sw.toString();
        }
        return logMsg;
    }

    public abstract int execute(String var1);
}

