/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Logging;
import com.sas.ssn.Utils;
import com.sas.tools.installs.it.InstallException;
import com.sas.tools.installs.it.schema.validation.ObjectFactory;
import com.sas.tools.installs.it.schema.validation.ValidationListType;
import com.sas.tools.installs.it.schema.validation.ValidationType;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.transform.stream.StreamSource;

public class ValidationFileList {
    private File validationFile;
    private Map<String, ValidationType> validationData;
    private ObjectFactory objectFactory;

    public ValidationFileList(String sasHome) {
        String fs = File.separator;
        String path = "InstallMisc".concat(fs).concat("InstallLogs").concat(fs).concat("ValidationFileList.xml");
        this.validationFile = new File(sasHome, path);
        this.validationData = Utils.getOS() == 1 ? new TreeMap<String, ValidationType>(String.CASE_INSENSITIVE_ORDER) : new TreeMap<String, ValidationType>();
        this.objectFactory = new ObjectFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unmarshalData() {
        ValidationListType fileData = null;
        Map<String, ValidationType> map = this.validationData;
        synchronized (map) {
            if (this.validationData.isEmpty() && this.validationFile.exists()) {
                try {
                    JAXBContext jc = JAXBContext.newInstance(ValidationListType.class);
                    Unmarshaller u = jc.createUnmarshaller();
                    StreamSource stream = new StreamSource(this.validationFile);
                    JAXBElement<ValidationListType> installJax = u.unmarshal(stream, ValidationListType.class);
                    fileData = installJax.getValue();
                }
                catch (JAXBException e) {
                    Logging.log.severe("Unable to read validation file '" + this.validationFile + "'. Previous validation data will not be preserved. Consider restoring from backup file.");
                    Logging.logStackTrace(e);
                    return false;
                }
            }
        }
        if (fileData == null) {
            return false;
        }
        List<ValidationType> files = fileData.getSasfile();
        for (ValidationType vt : files) {
            this.validationData.put(vt.getName(), vt);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshalData() throws InstallException {
        ValidationListType vList = this.objectFactory.createValidationListType();
        if (this.validationData.size() > 0) {
            for (String file : this.validationData.keySet()) {
                vList.getSasfile().add(this.validationData.get(file));
            }
            this.backup();
            FileOutputStream fos = null;
            try {
                Logging.log.info("Marshalling validation file: " + this.validationFile);
                JAXBElement<ValidationListType> vl = this.objectFactory.createInstalledFiles(vList);
                JAXBContext context = JAXBContext.newInstance(vList.getClass().getPackage().getName());
                Marshaller m = context.createMarshaller();
                m.setProperty("jaxb.formatted.output", Boolean.TRUE);
                fos = new FileOutputStream(this.validationFile);
                m.marshal(vl, fos);
                ValidationFileList.closeQuietly(fos, this.validationFile);
            }
            catch (Exception jbe) {
                Logging.log.severe("Error marshalling the validation data to file.");
                Logging.logStackTrace(jbe);
            }
            finally {
                ValidationFileList.closeQuietly(fos, this.validationFile);
            }
        } else {
            Logging.log.info("No files processed during installation. Validation xml file not created.");
        }
    }

    private static void closeQuietly(Closeable closeable, File file) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException ioEx) {
                Logging.log.warning("An error has occurred while closing file '" + file + "'");
                Logging.logStackTrace(ioEx);
            }
        }
    }

    public void backup() {
        File backupFilePath = new File(this.validationFile.getParent(), "ValidationFileList_backup.xml");
        boolean backedUp = true;
        if (this.validationFile.exists()) {
            Logging.log.info("Backing up previous validation file: " + this.validationFile.toString());
            backedUp = Utils.moveFile(this.validationFile, backupFilePath);
        }
        if (!backedUp) {
            Logging.log.warning("Error backing up the previous validation file.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(String fileName) {
        Map<String, ValidationType> map = this.validationData;
        synchronized (map) {
            ValidationType vt = this.validationData.remove(fileName);
            if (vt != null) {
                Logging.log.fine("Removed '" + vt.getName() + "' from validationData");
            } else {
                Logging.log.info("validationData does not contain '" + fileName + "'. Skipping.");
            }
        }
    }
}

