/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ArchiveWorker;
import com.sas.ssn.CopyFile;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.DeploymentData;
import com.sas.ssn.DlgBusyMsg;
import com.sas.ssn.FileMode;
import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.InstallToolConnector;
import com.sas.ssn.KitAction;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.OrderData;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.VolserData;
import com.sas.swing.visuals.util.Util;
import com.sas.tools.deployjni.disk.DiskInfoAPI;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.tasks.TaskHelper;
import jakarta.xml.bind.DatatypeConverter;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Utils {
    protected static SSNResource bundle = new SSNResource(Utils.class);
    public static final boolean DEBUG = false;
    public static final int RETRY_YES = 0;
    public static final int RETRY_SKIP = 1;
    public static final int RETRY_NO = 2;
    public static final int OS_UNDEFINED = 0;
    public static final int OS_WINDOWS = 1;
    public static final int OS_LINUX = 2;
    public static final int OS_SOLARIS = 3;
    public static final int OS_HPUX = 4;
    public static final int OS_AIX = 5;
    public static final int OS_OPENVMS = 6;
    public static final int OS_ALX = 7;
    public static final int OS_MVS = 8;
    public static final int OS_MAC = 9;
    public static final int OS_Z64 = 10;
    public static final int BITNESS_UNKNOWN = -1;
    public static final int BITNESS_32 = 32;
    public static final int BITNESS_64 = 64;
    public static final String OS_SUFFIX_SAX = "sax";
    public static final String OS_SUFFIX_S64 = "s64";
    public static final String OS_SUFFIX_LIX = "lix";
    public static final String OS_SUFFIX_LAX = "lax";
    public static final String OS_SUFFIX_LNX = "lnx";
    public static final String OS_SUFFIX_H6I = "h6i";
    public static final String OS_SUFFIX_H64 = "h64";
    public static final String OS_SUFFIX_R64 = "r64";
    public static final String OS_SUFFIX_ALX = "alx";
    public static final String OS_SUFFIX_W64 = "w64";
    public static final String OS_SUFFIX_WX6 = "wx6";
    public static final String OS_SUFFIX_WIN = "win";
    public static final String OS_SUFFIX_WN7 = "wn7";
    public static final String OS_SUFFIX_MVS = "mvs";
    public static final String OS_SUFFIX_MAC = "mac";
    public static final String OS_SUFFIX_M64 = "m64";
    public static final String OS_SUFFIX_VMI = "vmi";
    public static final String OS_SUFFIX_Z64 = "z64";
    public static final int PORT_INVALID = -1;
    public static final int PORT_OPEN = 0;
    public static final int PORT_NOT_OPEN = 1;
    public static final int HOSTNAME_NOT_FOUND = 2;
    public static final int SASUMGMT_DOMAIN_MISSING = 219;
    private static final String SASUMGMT_EXE = "sasumgmt.exe";
    static int gc_count = 0;
    static int m_os = 0;
    static String m_osSuffix = null;
    static char quote = (char)34;
    private static final int bufferSize = 65536;
    private static final byte[] buf = new byte[65536];

    public static int getOS(boolean realValue) {
        int rc = 0;
        String osName = System.getProperty("os.name");
        if (!realValue) {
            rc = Utils.getOS();
        } else if (osName.startsWith("Windows")) {
            rc = 1;
        } else if (osName.equalsIgnoreCase("Linux")) {
            rc = 2;
        } else if (osName.equalsIgnoreCase("Solaris") || osName.equalsIgnoreCase("SunOS")) {
            rc = 3;
        } else if (osName.equalsIgnoreCase("HP-UX")) {
            rc = 4;
        } else if (osName.equalsIgnoreCase("AIX")) {
            rc = 5;
        } else if (osName.equalsIgnoreCase("OpenVMS")) {
            rc = 6;
        } else if (osName.equalsIgnoreCase("Compaq's Digital UNIX") || osName.equalsIgnoreCase("OSF1")) {
            rc = 7;
        } else if (osName.equalsIgnoreCase("z/OS")) {
            rc = 8;
        } else if (osName.startsWith("Mac")) {
            rc = 9;
        } else if (osName.startsWith("OpenVMS")) {
            rc = 6;
        }
        return rc;
    }

    public static int getOS() {
        int rc = 0;
        if (m_os != 0) {
            rc = m_os;
        } else {
            if (Globals.g_debugPlatform != null) {
                if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_SAX) || Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_S64)) {
                    rc = 3;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_LIX) || Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_LAX) || Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_LNX)) {
                    rc = 2;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_H6I) || Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_H64)) {
                    rc = 4;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_R64)) {
                    rc = 5;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_VMI)) {
                    rc = 6;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_ALX)) {
                    rc = 7;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_W64) || Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_WX6) || Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_WIN)) {
                    rc = 1;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_MVS) || Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_Z64)) {
                    rc = 8;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_MAC)) {
                    rc = 9;
                } else if (Globals.g_debugPlatform.equalsIgnoreCase(OS_SUFFIX_VMI)) {
                    rc = 6;
                }
            } else {
                rc = Utils.getOS(true);
            }
            m_os = rc;
        }
        return rc;
    }

    public static boolean isWin7() {
        String osVersion;
        boolean win7 = false;
        if (Utils.getOS() == 1 && (osVersion = System.getProperty("os.version")).equals("6.1")) {
            win7 = true;
        }
        return win7;
    }

    public static int copyFile(String sourceFile, String destFile) {
        return Utils.copyFile(new File(sourceFile), new File(destFile));
    }

    public static boolean createDir(String directory) {
        File dir = new File(directory);
        boolean result = false;
        if (!dir.isDirectory()) {
            result = dir.mkdirs();
        }
        return result;
    }

    public static int copyFile(File sourceFile, File destFile) {
        int rc = -1;
        try {
            CopyFile copyFile = new CopyFile(sourceFile);
            if (copyFile.copyTo(destFile, true)) {
                rc = 0;
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Logging.log.severe(sw.getBuffer().toString());
        }
        return rc;
    }

    public static void streamData(InputStream is, OutputStream os) throws IOException {
        int n;
        while ((n = is.read(buf)) > -1) {
            os.write(buf, 0, n);
        }
    }

    public static boolean deleteFolder(File folder, boolean onExit) {
        boolean bValid = true;
        try {
            File[] files = folder.listFiles();
            if (files != null) {
                for (int i = 0; i < files.length; ++i) {
                    if (files[i].isDirectory()) {
                        Utils.deleteFolder(files[i]);
                        continue;
                    }
                    files[i].delete();
                }
            }
            if (onExit) {
                folder.deleteOnExit();
                return true;
            }
            bValid = folder.delete();
        }
        catch (Exception e) {
            bValid = false;
            Logging.log.info("Error deleting folder (" + folder + ") - " + e.getMessage());
            System.err.println("Error deleting folder (" + folder + ") - " + e.getLocalizedMessage());
        }
        return bValid;
    }

    public static boolean deleteFolder(File folder) {
        boolean onExit = false;
        return Utils.deleteFolder(folder, onExit);
    }

    public static String formatPath(String path) {
        String sPath = "";
        sPath = path.replace("\\".toCharArray()[0], File.separatorChar);
        sPath = sPath.replace("/".toCharArray()[0], File.separatorChar);
        return sPath;
    }

    public static String joinPath(String path1, String path2) {
        String sPath = "";
        String sTemp1 = path1;
        String sTemp2 = path2;
        if (sTemp1 == null) {
            sTemp1 = "";
        }
        if (sTemp2 == null) {
            sTemp2 = "";
        }
        while (sTemp1.endsWith(File.separator)) {
            sTemp1 = sTemp1.substring(0, sTemp1.length() - 1);
        }
        while (sTemp2.startsWith(File.separator)) {
            sTemp2 = sTemp2.substring(1, sTemp2.length());
        }
        sPath = sTemp1 + File.separator + sTemp2;
        return sPath;
    }

    public static String joinPath(String path1, String path2, String path3) {
        return Utils.joinPath(Utils.joinPath(path1, path2), path3);
    }

    public static String joinPaths(String ... pathElements) {
        if (pathElements.length == 0) {
            return "";
        }
        File joinedFile = new File(pathElements[0]);
        for (int i = 1; i < pathElements.length; ++i) {
            joinedFile = new File(joinedFile, pathElements[i]);
        }
        return joinedFile.getPath();
    }

    public static String createUniqueTempDir() {
        boolean bFound = false;
        int iCount = 0;
        String sUniqueTempDir = "";
        String sTempDir = System.getProperty("java.io.tmpdir");
        File tempDir = new File(sTempDir);
        if (tempDir.exists()) {
            while (!bFound & iCount < 9999) {
                sUniqueTempDir = Utils.joinPath(sTempDir, "temp" + ++iCount);
                File uniqueTempDir = new File(sUniqueTempDir);
                if (uniqueTempDir.exists()) continue;
                try {
                    bFound = uniqueTempDir.mkdir();
                }
                catch (Exception e) {
                    Logging.log.info("Error creating temp folder (" + sUniqueTempDir + ") - " + e.getMessage());
                    System.err.println("Error creating temp folder (" + sUniqueTempDir + ") - " + e.getLocalizedMessage());
                }
            }
        }
        return sUniqueTempDir;
    }

    public static String pathToURL(String path) {
        String prefix = "";
        prefix = Utils.getOS() == 1 ? (path.startsWith("\\\\") ? "file://///" : "file:///") : "file://";
        return prefix + path;
    }

    public static String localeTwoLangCode(Locale locale) {
        String language = locale.getLanguage();
        String reigion = locale.getCountry();
        String twoLangCode = null;
        twoLangCode = language.equalsIgnoreCase("zh") ? (reigion.equalsIgnoreCase("CN") ? "zh" : (reigion.equalsIgnoreCase("TW") ? "zt" : (reigion.equalsIgnoreCase("HK") ? "zt" : "en"))) : language.toLowerCase(Locale.ENGLISH);
        return twoLangCode;
    }

    public static String unixToVMSPath(String unixPath) {
        String vmsPath = "";
        String path = "";
        if (unixPath.startsWith("/")) {
            int diskend = unixPath.indexOf(47, 1);
            String disk = unixPath.substring(1, diskend) + ":[";
            int pathend = unixPath.lastIndexOf(47);
            if (diskend == pathend) {
                path = "000000]";
            } else {
                path = unixPath.substring(diskend + 1, pathend) + "]";
                path = Utils.stringReplaceAll(path, ".", "^.");
                path = path.replace('/', '.');
            }
            String filename = unixPath.substring(pathend + 1, unixPath.length());
            vmsPath = disk + path + filename;
            vmsPath = vmsPath.replaceAll("\\.\\.\\.", ".");
            vmsPath = vmsPath.replaceAll("\\.\\.", "");
        } else {
            vmsPath = unixPath;
        }
        return vmsPath;
    }

    public static String unixToVMSPathDir(String unixPath) {
        if (!unixPath.startsWith("/")) {
            return unixPath;
        }
        String path = "";
        String fullPath = null;
        int diskend = unixPath.indexOf(47, 1);
        String disk = unixPath.substring(1, diskend) + ":[";
        int pathend = unixPath.length();
        if (diskend == pathend) {
            path = "000000]";
        } else {
            path = unixPath.substring(diskend + 1, pathend) + "]";
            path = Utils.stringReplaceAll(path, ".", "^.");
            path = path.replace('/', '.');
        }
        fullPath = disk + path;
        return fullPath;
    }

    public static boolean isWindows64OS() {
        return System.getenv("ProgramFiles(x86)") != null;
    }

    private static boolean is32bJavaOn64bWin() {
        boolean is32bJavaProcess;
        boolean is64OS = Utils.isWindows64OS();
        String osArch = System.getProperty("os.arch");
        boolean bl = is32bJavaProcess = osArch.length() >= 3 && osArch.substring(0, 3).equalsIgnoreCase("x86");
        return is64OS && is32bJavaProcess;
    }

    private static boolean is64bJavaOn64bWin() {
        boolean is32bJavaProcess;
        boolean is64OS = Utils.isWindows64OS();
        String osArch = System.getProperty("os.arch");
        boolean bl = is32bJavaProcess = osArch.length() >= 3 && osArch.substring(0, 3).equalsIgnoreCase("x86");
        return is64OS && !is32bJavaProcess;
    }

    public static String getOS_Suffix() {
        String suffix = "";
        if (m_osSuffix != null) {
            suffix = m_osSuffix;
        } else {
            if (Globals.g_debugPlatform != null) {
                suffix = Globals.g_debugPlatform;
            } else {
                String osArch = System.getProperty("os.arch");
                boolean itanium = osArch.length() >= 4 && osArch.substring(0, 4).equalsIgnoreCase("ia64");
                boolean x86 = osArch.length() >= 3 && osArch.substring(0, 3).equalsIgnoreCase("x86");
                boolean x86_64 = osArch.length() >= 5 && osArch.substring(0, 5).equalsIgnoreCase("amd64");
                switch (Utils.getOS()) {
                    case 3: {
                        if (x86) {
                            suffix = OS_SUFFIX_SAX;
                            break;
                        }
                        if (x86_64) {
                            suffix = OS_SUFFIX_SAX;
                            break;
                        }
                        suffix = OS_SUFFIX_S64;
                        break;
                    }
                    case 2: {
                        if (!x86_64) {
                            try {
                                x86_64 = KitAction.executeProcess("sh -c 'if [ `uname -m` = \"x86_64\" ] ; then exit 1 ; else exit 0 ; fi'", Globals.g_tempLocation + File.separator + "x86_64", Globals.g_tempLocation + File.separator + ".x86_64log") == 1;
                            }
                            catch (Exception e) {
                                StringWriter sw = new StringWriter();
                                PrintWriter pw = new PrintWriter(sw);
                                e.printStackTrace(pw);
                                Logging.log.severe(sw.getBuffer().toString());
                            }
                        }
                        if (itanium) {
                            suffix = OS_SUFFIX_LIX;
                            break;
                        }
                        if (x86_64) {
                            suffix = OS_SUFFIX_LAX;
                            break;
                        }
                        suffix = OS_SUFFIX_LNX;
                        break;
                    }
                    case 4: {
                        if (itanium) {
                            suffix = OS_SUFFIX_H6I;
                            break;
                        }
                        suffix = OS_SUFFIX_H64;
                        break;
                    }
                    case 5: {
                        suffix = OS_SUFFIX_R64;
                        break;
                    }
                    case 6: {
                        suffix = OS_SUFFIX_VMI;
                        break;
                    }
                    case 7: {
                        suffix = OS_SUFFIX_ALX;
                        break;
                    }
                    case 1: {
                        if (itanium) {
                            suffix = OS_SUFFIX_W64;
                            break;
                        }
                        if (Utils.is32bJavaOn64bWin()) {
                            suffix = OS_SUFFIX_WX6;
                            break;
                        }
                        if (Utils.is64bJavaOn64bWin()) {
                            suffix = OS_SUFFIX_WX6;
                            break;
                        }
                        suffix = OS_SUFFIX_WIN;
                        break;
                    }
                    case 8: {
                        suffix = OS_SUFFIX_MVS;
                        break;
                    }
                    case 9: {
                        try {
                            x86_64 = KitAction.executeProcess("sh -c 'if [ \"`sysctl -n hw.optional.x86_64 2> /dev/null`\" = 1 ] ; then exit 1 ; else exit 0 ; fi'", Globals.g_tempLocation + File.separator + "x86_64", Globals.g_tempLocation + File.separator + ".x86_64log") == 1;
                        }
                        catch (Exception e) {
                            StringWriter sw = new StringWriter();
                            PrintWriter pw = new PrintWriter(sw);
                            e.printStackTrace(pw);
                            Logging.log.severe(sw.getBuffer().toString());
                        }
                        if (x86_64) {
                            suffix = OS_SUFFIX_M64;
                            break;
                        }
                        suffix = OS_SUFFIX_MAC;
                        break;
                    }
                }
            }
            m_osSuffix = suffix;
        }
        return suffix;
    }

    public static String getOSCode4Byte(String osSuffix) {
        String code4Byte = null;
        code4Byte = osSuffix.equalsIgnoreCase(OS_SUFFIX_SAX) ? "slx6" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_S64) ? "sl64" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_LIX) ? "lini" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_LAX) ? "lina" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_LNX) ? "linx" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_H6I) ? "hp6i" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_H64) ? "hp64" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_R64) ? "ar64" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_ALX) ? "aosf" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_W64) ? OS_SUFFIX_W64 : (osSuffix.equalsIgnoreCase(OS_SUFFIX_WX6) ? OS_SUFFIX_WX6 : (osSuffix.equalsIgnoreCase(OS_SUFFIX_WIN) ? "wndw" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_MVS) ? "os" : (osSuffix.equalsIgnoreCase(OS_SUFFIX_MAC) ? OS_SUFFIX_MAC : (osSuffix.equalsIgnoreCase(OS_SUFFIX_VMI) ? "ivms" : ""))))))))))))));
        return code4Byte;
    }

    public static String stringReplaceAll(String search, String find, String replace) {
        int searchIndex;
        if (replace == null) {
            throw new NullPointerException();
        }
        if (find.length() > 0 && (searchIndex = search.indexOf(find)) >= 0) {
            search = search.substring(0, searchIndex) + replace + Utils.stringReplaceAll(search.substring(searchIndex + find.length()), find, replace);
        }
        return search;
    }

    public static String trimTrailingChar(String string, String character) {
        String newString = string;
        while (newString.endsWith(character)) {
            newString = newString.substring(0, newString.length() - 1);
        }
        return newString;
    }

    public static String trimLeadingZeros(String string) {
        String newString = string;
        while (newString.startsWith("0") && newString.length() > 1) {
            newString = newString.substring(1, newString.length());
        }
        return newString;
    }

    public static String trimTrailingSlashes(String path) {
        String newPath = path.trim();
        while (newPath.endsWith(File.separator)) {
            newPath = newPath.substring(0, newPath.length() - 1);
        }
        return newPath;
    }

    public static boolean pathContainsValidChars(String path) {
        boolean valid = true;
        valid = Utils.getOS() == 1 ? Utils.validWinPath(path) : (Utils.getOS() == 9 ? Utils.validMacPath(path) : Utils.validUnxPath(path));
        return valid;
    }

    public static boolean validWinPath(String path) {
        boolean valid = true;
        if (path.indexOf("/") > -1 || path.indexOf("?") > -1 || path.startsWith(":") || path.indexOf(":", 2) > 1 || path.indexOf("<") > -1 || path.indexOf(">") > -1 || path.indexOf("|") > -1 || path.indexOf("\"") > -1 || path.indexOf("*") > -1) {
            valid = false;
        }
        return valid;
    }

    public static boolean validUnxPath(String path) {
        boolean valid = true;
        if (path.indexOf(" ") > -1 || path.indexOf("%") > -1 || path.indexOf("*") > -1 || path.indexOf("\"") > -1 || path.indexOf("&") > -1 || path.indexOf("?") > -1 || path.indexOf(":") > -1 || path.indexOf("<") > -1 || path.indexOf(">") > -1 || path.indexOf("\\") > -1 || path.indexOf("|") > -1 || path.indexOf("(") > -1 || path.indexOf(")") > -1) {
            valid = false;
        }
        return valid;
    }

    public static boolean validMacPath(String path) {
        boolean valid = true;
        if (path.indexOf("\\") > -1 || path.indexOf(":") > -1) {
            valid = false;
        }
        return valid;
    }

    public static boolean validatePath(String path) {
        boolean valid = true;
        File filePath = new File(path);
        if (!filePath.isAbsolute()) {
            valid = false;
        } else if (!filePath.exists()) {
            try {
                filePath.getCanonicalPath();
            }
            catch (Exception e) {
                valid = false;
            }
        }
        return valid;
    }

    public static boolean pathContainsFiles(File file) {
        File[] fileList = file.listFiles();
        return fileList != null && fileList.length > 0;
    }

    public static long getFreeSpace(String path) {
        long space = 0L;
        File pathFile = new File(path);
        if (!pathFile.exists()) {
            File parent;
            for (parent = pathFile.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
            }
            if (parent != null) {
                pathFile = parent;
            }
        }
        if (pathFile.isDirectory()) {
            space = DiskInfoAPI.getFreeDiskSpace(pathFile.getAbsolutePath());
        }
        return space;
    }

    public static String getAdjustedSize(long size) {
        DecimalFormat numberFormat = new DecimalFormat("#,##0.0");
        double adjustedSize = (double)size / 1048576.0;
        String displaySize = null;
        if (adjustedSize >= 1000.0) {
            adjustedSize = (double)size / 1.073741824E9;
            displaySize = bundle.messageString("Common.GBSize.txt", numberFormat.format(adjustedSize));
        } else {
            displaySize = bundle.messageString("Common.MBSize.txt", numberFormat.format(adjustedSize));
        }
        return displaySize;
    }

    public static boolean canWriteToPath(File path) {
        boolean valid = false;
        File newPath = null;
        if (!path.exists()) {
            newPath = path;
            for (File parent = path.getParentFile(); parent != null && !parent.exists(); parent = parent.getParentFile()) {
                newPath = parent;
            }
        }
        if (path.isDirectory() || path.mkdirs()) {
            try {
                int count = 0;
                String newName = "temp" + Integer.toString(count);
                File newFile = new File(path, newName + ".tmp");
                for (int i = 0; i < 999 && newFile.exists(); ++i) {
                    newName = "temp" + Integer.toString(++count);
                    newFile = new File(path, newName + ".tmp");
                }
                File tempFile = File.createTempFile(newName, null, path);
                valid = tempFile.delete();
                if (!valid) {
                    Logging.log.severe("Could not delete temporary file " + tempFile.getCanonicalPath() + "\nCheck alert note 34181.");
                }
            }
            catch (IOException e) {
                Logging.log.fine("Could not create a temporary file in: " + path);
                Logging.log.fine(e.getMessage());
            }
        }
        if (newPath != null) {
            Utils.deleteFolder(newPath);
        }
        return valid;
    }

    public static boolean canWriteToPath(String path) {
        return Utils.canWriteToPath(new File(path));
    }

    public static String getSDWDataPath(boolean create) {
        File pathFile;
        String path = Globals.g_sdwDataLocation;
        if (path == null) {
            if (Utils.getOS() == 1) {
                String localappdata = System.getenv("LOCALAPPDATA");
                String userprofile = System.getenv("USERPROFILE");
                String userhome = System.getProperty("user.home");
                String home = null;
                home = userprofile != null ? userprofile : userhome;
                path = localappdata != null ? Utils.joinPath(localappdata, "SAS", "SASDeploymentWizard") : (Long.parseLong(System.getProperty("os.version").split("\\.", 2)[0]) >= 6L ? Utils.joinPath(home, Utils.joinPath("AppData", "Local"), Utils.joinPath("SAS", "SASDeploymentWizard")) : Utils.joinPath(home, Utils.joinPath("Local Settings", "Application Data"), Utils.joinPath("SAS", "SASDeploymentWizard")));
            } else {
                path = Utils.getOS() == 6 ? Utils.joinPath(System.getProperty("user.home"), "SASAppData/SASDeploymentWizard") : (Utils.getOS() == 8 || Utils.getOS() == 10 ? Utils.joinPath(System.getenv("HOME"), ".SASAppData/SASDeploymentWizard") : Utils.joinPath(System.getProperty("user.home"), ".SASAppData/SASDeploymentWizard"));
            }
            Globals.g_sdwDataLocation = path;
            com.sas.tools.installs.it.tasks.Globals.g_sdwDataLocation = path;
        }
        if (create && !(pathFile = new File(path)).isDirectory() && !pathFile.mkdirs()) {
            Logging.log.info("Could not create directory: " + path);
            System.err.println("Could not create directory: " + path);
            path = System.getProperty("user.home");
        }
        return path;
    }

    public static String getBatchFilePath(boolean create) {
        File pathFile;
        String path = Globals.g_sdwDataLocation;
        if (path == null) {
            String localappdata = System.getenv("LOCALAPPDATA");
            String userprofile = System.getenv("USERPROFILE");
            String userhome = System.getProperty("user.home");
            String home = null;
            home = userprofile != null ? userprofile : userhome;
            path = localappdata != null ? Utils.joinPath(localappdata, "SAS", Utils.joinPath("SASDeploymentWizard", "Batch")) : (Long.parseLong(System.getProperty("os.version").split("\\.", 2)[0]) >= 6L ? Utils.joinPath(home, Utils.joinPath("AppData", "Local"), Utils.joinPath("SAS", "SASDeploymentWizard", "Batch")) : Utils.joinPath(home, Utils.joinPath("Local Settings", "Application Data"), Utils.joinPath("SAS", "SASDeploymentWizard", "Batch")));
        }
        if (create && !(pathFile = new File(path)).isDirectory() && !pathFile.mkdirs()) {
            Logging.log.info("Could not create directory: " + path);
            System.err.println("Could not create directory: " + path);
            path = System.getProperty("user.home");
        }
        return path;
    }

    public static String getSharedDataPath(boolean create) {
        String appdata;
        String path = null;
        if (Utils.getOS() == 1 && (appdata = System.getenv("ALLUSERSPROFILE")) != null) {
            File pathFile = new File(appdata, "Application Data/SAS/SASDeploymentWizard");
            path = pathFile.getAbsolutePath();
            if (!pathFile.isDirectory()) {
                if (create) {
                    if (!pathFile.mkdirs()) {
                        Logging.log.info("Could not create directory: " + path);
                        System.err.println("Could not create directory: " + path);
                        pathFile = null;
                        path = null;
                    }
                } else {
                    pathFile = null;
                    path = null;
                }
            }
        }
        return path;
    }

    public static String getSASHomeDefault() {
        String pathSASHome = null;
        int os = Utils.getOS();
        if (os == 1) {
            File prev_userPropsFile = new File(Utils.getSDWDataPath(true), "sdwprefs.txt");
            File prev_sharedPropsFile = new File(Utils.getSharedDataPath(true), "sdwprefs.txt");
            File existingSASHomePath = new File(Utils.joinPath(Utils.getProgramFilesDir(), "SASHome"));
            pathSASHome = (prev_userPropsFile.exists() || prev_sharedPropsFile.exists()) && existingSASHomePath.exists() ? Utils.joinPath(Utils.getProgramFilesDir(), Utils.nextSASHome()) : Utils.joinPath(Utils.getProgramFilesDir(), "SASHome");
        } else {
            pathSASHome = os == 6 ? "/SYS$COMMON/SASHome" : (os == 8 ? "/usr/lpp/SASHome" : "/usr/local/SASHome");
        }
        return pathSASHome;
    }

    public static String getSharedSASHomeDir() {
        String pathSharedSASHome = null;
        Properties prop = new Properties();
        try {
            File m_userPropsFile = new File(Utils.getSDWDataPath(true), "sdwpreferences.txt");
            FileInputStream fis = new FileInputStream(m_userPropsFile);
            prop.load(fis);
            fis.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        pathSharedSASHome = prop.getProperty("SharedSASHome");
        return pathSharedSASHome;
    }

    private static String nextSASHome() {
        int sasHomeNumber = 1;
        String sasHomeName = "SASHome";
        String sasHomePath = null;
        File newfile = new File(Utils.getProgramFilesDir() + File.separator + sasHomeName);
        if (newfile.exists()) {
            while ((newfile = new File(sasHomePath = Utils.getProgramFilesDir() + File.separator + sasHomeName + Integer.toString(++sasHomeNumber))).exists()) {
            }
            return sasHomeName + Integer.toString(sasHomeNumber);
        }
        return sasHomeName;
    }

    public static String getVJRHome(String sasHome) {
        String vjrHome = null;
        if (sasHome != null) {
            File vjrDir = new File(sasHome, "SASVersionedJarRepository/9.2");
            if (!vjrDir.exists()) {
                vjrDir = new File(sasHome, "SASVersionedJarRepository");
            }
            vjrHome = vjrDir.getAbsolutePath();
        }
        return vjrHome;
    }

    public static String getSDMHome(String sasHome) {
        String sdmHome = null;
        if (sasHome != null) {
            File sdmDir = new File(sasHome, Globals.CMT_INSTALL_DIR);
            sdmHome = sdmDir.getAbsolutePath();
        }
        return sdmHome;
    }

    public static String getProgramFilesDir() {
        String dir = null;
        dir = Utils.getOS() == 1 ? WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\Microsoft\\Windows\\CurrentVersion", "ProgramFilesDir") : "";
        return dir;
    }

    public static String ExecuteCommand(String[] RunCmd, String[] envp) {
        String buffer = "";
        try {
            String data;
            Process p = Runtime.getRuntime().exec(RunCmd, envp);
            p.waitFor();
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((data = in.readLine()) != null) {
                buffer = buffer + data + System.getProperty("line.separator");
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Logging.log.severe(sw.getBuffer().toString());
        }
        return buffer;
    }

    public static int askToRetry(String sourceFilename, String targetFilename) {
        return Utils.askToRetry(sourceFilename, targetFilename, false, true);
    }

    public static int askToRetry(String sourceFilename, String targetFilename, boolean copy, boolean displayCorruptMsg) {
        int result = 0;
        if (Globals.g_wizard.getFrame() == null) {
            return 2;
        }
        Object[] options = new Object[]{Util.getLabelWithoutMnemonic(bundle.getString("Common.RetryButton.txt")), Util.getLabelWithoutMnemonic(bundle.getString("Common.SkipButton.txt")), Util.getLabelWithoutMnemonic(bundle.getString("Common.Cancel.txt"))};
        String title = null;
        String msg = null;
        if (copy) {
            title = bundle.getString("Common.RetryCopyTitle.txt");
            msg = bundle.messageString("Common.RetryCopyMsg.txt", sourceFilename, targetFilename, displayCorruptMsg ? bundle.getString("Common.DepotLeftCorrupted.txt") : "");
        } else {
            title = bundle.getString("Common.RetryMoveTitle.txt");
            msg = bundle.messageString("Common.RetryMoveMsg.txt", sourceFilename, targetFilename, displayCorruptMsg ? bundle.getString("Common.DepotLeftCorrupted.txt") : "");
        }
        JEditorPane msgArea = new JEditorPane();
        msgArea.setOpaque(false);
        msgArea.setEditable(false);
        msgArea.setContentType("text/html");
        String msgPrefix = "<html><body><font face=\"" + Globals.g_wizard.getCancelButton().getFont().getFontName() + "\">";
        String msgPostfix = "</font></body></html>";
        msgArea.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        msgArea.revalidate();
        msgArea.setText(msgPrefix + msg + msgPostfix);
        msgArea.setCaretPosition(0);
        int choice = JOptionPane.showOptionDialog(Globals.g_wizard.getFrame(), msgArea, title, 0, 0, null, options, options[0]);
        result = choice == 0 ? 0 : (choice == 1 ? 1 : (choice == 2 ? 2 : 0));
        return result;
    }

    public static boolean movefilesWithRetry(File source, File target) {
        boolean done = false;
        boolean success = false;
        while (!done) {
            success = Utils.movefiles(source, target);
            if (success) {
                done = true;
                continue;
            }
            try {
                int result = Utils.askToRetry(source.getCanonicalPath(), target.getCanonicalPath());
                if (result == 1) {
                    success = true;
                    done = true;
                    continue;
                }
                if (result != 2) continue;
                done = true;
            }
            catch (IOException e) {
                Logging.logStackTrace(e);
                done = true;
            }
        }
        return success;
    }

    public static boolean movefiles(File source, File target) {
        boolean returnCode = true;
        String sourceName = source.toString();
        String targetName = target.toString();
        try {
            if (source.isDirectory()) {
                if (target.exists()) {
                    if (target.isDirectory()) {
                        for (String file2bMoved : Arrays.asList(source.list())) {
                            returnCode &= Utils.movefiles(source, target, file2bMoved);
                        }
                    } else if (target.isFile()) {
                        if (!target.delete()) {
                            Logging.log.warning("Delete (1) failed for " + targetName);
                        }
                        if (!Utils.rename(source, target)) {
                            Logging.log.warning("RenameTo (1) failed for " + targetName);
                            returnCode = false;
                        }
                    }
                } else {
                    File targetParent = target.getParentFile();
                    if (!targetParent.exists() && !targetParent.mkdirs()) {
                        Logging.log.warning("Mkdirs (1) failed for " + targetName);
                    }
                    if (!Utils.rename(source, target)) {
                        Logging.log.warning("RenameTo (2) failed for " + targetName);
                        returnCode = false;
                    }
                }
            } else if (source.isFile()) {
                if (target.exists()) {
                    if (target.isDirectory()) {
                        if (!target.delete()) {
                            Logging.log.warning("Delete (2) failed for " + targetName);
                        }
                        if (!Utils.rename(source, target)) {
                            Logging.log.warning("RenameTo (3) failed for " + targetName);
                            returnCode = false;
                        }
                    } else if (target.isFile()) {
                        if (!target.delete()) {
                            Logging.log.warning("Delete (3) failed for " + targetName);
                        }
                        if (!Utils.rename(source, target)) {
                            Logging.log.warning("RenameTo (4) failed for " + targetName);
                            returnCode = false;
                        }
                    }
                } else {
                    File targetParent = target.getParentFile();
                    if (!targetParent.exists() && !targetParent.mkdirs()) {
                        Logging.log.warning("Mkdirs (2) failed for " + targetName);
                    }
                    if (!Utils.rename(source, target)) {
                        Logging.log.warning("RenameTo (5) failed for " + targetName);
                        returnCode = false;
                    }
                }
            } else {
                returnCode = false;
                if (source.exists()) {
                    Logging.log.warning(sourceName + " is neither a Directory or a File. Very odd!");
                } else {
                    Logging.log.warning(sourceName + " does not exist.");
                }
            }
        }
        catch (SecurityException e) {
            Logging.log.warning("Security error moving file: " + sourceName + " => " + targetName);
            Logging.log.warning(e.getMessage());
            returnCode = false;
        }
        catch (Exception e) {
            Logging.log.warning("File move failed with Exception: " + sourceName + " => " + targetName);
            Logging.logStackTrace(e);
            returnCode = false;
        }
        return returnCode;
    }

    public static boolean rename(File sourceFile, File targetFile) {
        boolean success = false;
        File srcParentFile = sourceFile.getParentFile();
        File tgtParentFile = targetFile.getParentFile();
        if (tgtParentFile != null && !tgtParentFile.exists()) {
            Logging.log.finer("Trying to create directory: " + tgtParentFile);
            if (tgtParentFile.mkdirs()) {
                Logging.log.warning("Could not create parent directory: " + tgtParentFile);
            }
        }
        for (int retries = 3; !success && retries > 0; --retries) {
            if (targetFile.exists() && !targetFile.delete()) {
                Logging.log.warning("Could not delete file: " + targetFile.getPath());
            }
            if (!(success = sourceFile.renameTo(targetFile)) && srcParentFile != null && tgtParentFile != null && !srcParentFile.equals(tgtParentFile)) {
                Logging.log.finer("The source and target files do not share the same parent directory for a file rename.  Fallback to copy and delete.");
                break;
            }
            if (success || retries <= 1) continue;
            try {
                Logging.log.warning("Rename retry (" + (4 - retries) + "): " + sourceFile.getPath() + " -> " + targetFile.getPath());
                Thread.sleep(3000L);
                continue;
            }
            catch (Exception e) {
                retries = 0;
                Logging.logStackTrace(e);
            }
        }
        if (!success && sourceFile.isFile()) {
            boolean bl = success = Utils.copyFile(sourceFile, targetFile) == 0;
            if (success && !sourceFile.delete()) {
                Logging.log.warning("After successful copy, delete failed for file: " + sourceFile.getPath());
            }
            Logging.log.warning((success ? "Successfully" : "Unsuccessfully") + " used copyFile instead of renameTo to copy " + sourceFile.getPath() + " -> " + targetFile.getPath());
        }
        return success;
    }

    protected static boolean movefiles(File sourceDir, File targetDir, String file2bMoved) {
        boolean result = true;
        String sourceName = sourceDir.toString();
        String targetName = targetDir.toString();
        try {
            sourceName = sourceDir.getCanonicalPath();
            targetName = targetDir.getCanonicalPath();
            if (sourceDir.isDirectory() && targetDir.isDirectory()) {
                if (new File(targetDir, file2bMoved).isDirectory()) {
                    for (String aFile : Arrays.asList(new File(sourceDir, file2bMoved).list())) {
                        result &= Utils.movefiles(new File(new File(sourceDir, file2bMoved), aFile), new File(new File(targetDir, file2bMoved), aFile));
                    }
                } else {
                    result &= Utils.rename(new File(sourceDir, file2bMoved), new File(targetDir, file2bMoved));
                }
            }
        }
        catch (IOException e) {
            Logging.log.warning("IO error moving file: " + sourceName + " => " + targetName);
            Logging.log.warning(e.getMessage());
        }
        catch (SecurityException e) {
            Logging.log.warning("Security error moving file: " + sourceName + " => " + targetName);
            Logging.log.warning(e.getMessage());
        }
        return result;
    }

    public static String escapeHTMLString(String inString) {
        StringBuffer stringBuffer = new StringBuffer();
        int i = inString.length();
        char[] inChar = new char[i];
        inString.getChars(0, i, inChar, 0);
        for (i = 0; i < inChar.length; ++i) {
            String outChar;
            switch (inChar[i]) {
                case '<': {
                    outChar = "&lt;";
                    break;
                }
                case '>': {
                    outChar = "&gt;";
                    break;
                }
                case '&': {
                    outChar = "&amp;";
                    break;
                }
                case '\"': {
                    outChar = "&quot;";
                    break;
                }
                case '\u00a0': {
                    outChar = "*&nbsp;";
                    break;
                }
                case '\u00a1': {
                    outChar = "&iexcl;";
                    break;
                }
                case '\u00a2': {
                    outChar = "&cent;";
                    break;
                }
                case '\u00a3': {
                    outChar = "&pound;";
                    break;
                }
                case '\u00a4': {
                    outChar = "&curren;";
                    break;
                }
                case '\u00a5': {
                    outChar = "&yen;";
                    break;
                }
                case '\u00a6': {
                    outChar = "&brvbar;";
                    break;
                }
                case '\u00a7': {
                    outChar = "&sect;";
                    break;
                }
                case '\u00a8': {
                    outChar = "&uml;";
                    break;
                }
                case '\u00a9': {
                    outChar = "*&copy;";
                    break;
                }
                case '\u00aa': {
                    outChar = "&ordf;";
                    break;
                }
                case '\u00ab': {
                    outChar = "&laquo;";
                    break;
                }
                case '\u00ac': {
                    outChar = "&not;";
                    break;
                }
                case '\u00ad': {
                    outChar = "&shy;";
                    break;
                }
                case '\u00ae': {
                    outChar = "&reg;";
                    break;
                }
                case '\u00af': {
                    outChar = "&macr;";
                    break;
                }
                case '\u00b0': {
                    outChar = "&deg;";
                    break;
                }
                case '\u00b1': {
                    outChar = "&plusmn;";
                    break;
                }
                case '\u00b2': {
                    outChar = "&sup2;";
                    break;
                }
                case '\u00b3': {
                    outChar = "&sup3;";
                    break;
                }
                case '\u00b4': {
                    outChar = "&acute;";
                    break;
                }
                case '\u00b5': {
                    outChar = "&micro;";
                    break;
                }
                case '\u00b6': {
                    outChar = "&para;";
                    break;
                }
                case '\u00b7': {
                    outChar = "&middot;";
                    break;
                }
                case '\u00b8': {
                    outChar = "&cedil;";
                    break;
                }
                case '\u00b9': {
                    outChar = "&sup1;";
                    break;
                }
                case '\u00ba': {
                    outChar = "&ordm;";
                    break;
                }
                case '\u00bb': {
                    outChar = "*&raquo;";
                    break;
                }
                case '\u00bc': {
                    outChar = "&frac14;";
                    break;
                }
                case '\u00bd': {
                    outChar = "&frac12;";
                    break;
                }
                case '\u00be': {
                    outChar = "&frac34;";
                    break;
                }
                case '\u00bf': {
                    outChar = "&iquest;";
                    break;
                }
                case '\u00c0': {
                    outChar = "&Agrave;";
                    break;
                }
                case '\u00c1': {
                    outChar = "&Aacute;";
                    break;
                }
                case '\u00c2': {
                    outChar = "&Acirc;";
                    break;
                }
                case '\u00c3': {
                    outChar = "&Atilde;";
                    break;
                }
                case '\u00c4': {
                    outChar = "&Auml;";
                    break;
                }
                case '\u00c5': {
                    outChar = "&Aring;";
                    break;
                }
                case '\u00c6': {
                    outChar = "&AElig;";
                    break;
                }
                case '\u00c7': {
                    outChar = "&Ccedil;";
                    break;
                }
                case '\u00c8': {
                    outChar = "&Egrave;";
                    break;
                }
                case '\u00c9': {
                    outChar = "&Eacute;";
                    break;
                }
                case '\u00ca': {
                    outChar = "&Ecirc;";
                    break;
                }
                case '\u00cb': {
                    outChar = "&Euml;";
                    break;
                }
                case '\u00cc': {
                    outChar = "&Igrave;";
                    break;
                }
                case '\u00cd': {
                    outChar = "&Iacute;";
                    break;
                }
                case '\u00ce': {
                    outChar = "&Icirc;";
                    break;
                }
                case '\u00cf': {
                    outChar = "&Iuml;";
                    break;
                }
                case '\u00d0': {
                    outChar = "&ETH;";
                    break;
                }
                case '\u00d1': {
                    outChar = "&Ntilde;";
                    break;
                }
                case '\u00d2': {
                    outChar = "&Ograve;";
                    break;
                }
                case '\u00d3': {
                    outChar = "&Oacute;";
                    break;
                }
                case '\u00d4': {
                    outChar = "&Ocirc;";
                    break;
                }
                case '\u00d5': {
                    outChar = "&Otilde;";
                    break;
                }
                case '\u00d6': {
                    outChar = "&Ouml;";
                    break;
                }
                case '\u00d7': {
                    outChar = "&times;";
                    break;
                }
                case '\u00d8': {
                    outChar = "&Oslash;";
                    break;
                }
                case '\u00d9': {
                    outChar = "&Ugrave;";
                    break;
                }
                case '\u00da': {
                    outChar = "&Uacute;";
                    break;
                }
                case '\u00db': {
                    outChar = "&Ucirc;";
                    break;
                }
                case '\u00dc': {
                    outChar = "&Uuml;";
                    break;
                }
                case '\u00dd': {
                    outChar = "&Yacute;";
                    break;
                }
                case '\u00de': {
                    outChar = "&THORN;";
                    break;
                }
                case '\u00df': {
                    outChar = "&szlig;";
                    break;
                }
                case '\u00e0': {
                    outChar = "&agrave;";
                    break;
                }
                case '\u00e1': {
                    outChar = "&aacute;";
                    break;
                }
                case '\u00e2': {
                    outChar = "&acirc;";
                    break;
                }
                case '\u00e3': {
                    outChar = "&atilde;";
                    break;
                }
                case '\u00e4': {
                    outChar = "&auml;";
                    break;
                }
                case '\u00e5': {
                    outChar = "&aring;";
                    break;
                }
                case '\u00e6': {
                    outChar = "&aelig;";
                    break;
                }
                case '\u00e7': {
                    outChar = "&ccedil;";
                    break;
                }
                case '\u00e8': {
                    outChar = "&egrave;";
                    break;
                }
                case '\u00e9': {
                    outChar = "&eacute;";
                    break;
                }
                case '\u00ea': {
                    outChar = "&ecirc;";
                    break;
                }
                case '\u00eb': {
                    outChar = "&euml;";
                    break;
                }
                case '\u00ec': {
                    outChar = "&igrave;";
                    break;
                }
                case '\u00ed': {
                    outChar = "&iacute;";
                    break;
                }
                case '\u00ee': {
                    outChar = "&icirc;";
                    break;
                }
                case '\u00ef': {
                    outChar = "&iuml;";
                    break;
                }
                case '\u00f0': {
                    outChar = "&eth;";
                    break;
                }
                case '\u00f1': {
                    outChar = "&ntilde;";
                    break;
                }
                case '\u00f2': {
                    outChar = "&ograve;";
                    break;
                }
                case '\u00f3': {
                    outChar = "&oacute;";
                    break;
                }
                case '\u00f4': {
                    outChar = "&ocirc;";
                    break;
                }
                case '\u00f5': {
                    outChar = "&otilde;";
                    break;
                }
                case '\u00f6': {
                    outChar = "&ouml;";
                    break;
                }
                case '\u00f7': {
                    outChar = "&divide;";
                    break;
                }
                case '\u00f8': {
                    outChar = "&oslash;";
                    break;
                }
                case '\u00f9': {
                    outChar = "&ugrave;";
                    break;
                }
                case '\u00fa': {
                    outChar = "&uacute;";
                    break;
                }
                case '\u00fb': {
                    outChar = "&ucirc;";
                    break;
                }
                case '\u00fc': {
                    outChar = "&uuml;";
                    break;
                }
                case '\u00fd': {
                    outChar = "&yacute;";
                    break;
                }
                case '\u00fe': {
                    outChar = "&thorn;";
                    break;
                }
                case '\u00ff': {
                    outChar = "&yuml;";
                    break;
                }
                default: {
                    outChar = String.valueOf(inChar[i]);
                }
            }
            stringBuffer.append(outChar);
        }
        return stringBuffer.toString();
    }

    public static boolean isValidNumber(String number) {
        boolean valid = true;
        if (number.indexOf(new DecimalFormatSymbols().getDecimalSeparator()) > -1) {
            valid = false;
        } else {
            try {
                if (!Integer.valueOf(number).toString().equals(number)) {
                    valid = false;
                }
            }
            catch (Exception e) {
                valid = false;
            }
        }
        return valid;
    }

    public static boolean isValidPortNumber(String port) {
        boolean valid = true;
        if (port.indexOf(new DecimalFormatSymbols().getDecimalSeparator()) > -1) {
            valid = false;
        } else {
            try {
                int portNum;
                valid = !Integer.valueOf(port).toString().equals(port) ? false : (portNum = Integer.parseInt(port)) >= 0 && portNum <= 65535;
            }
            catch (Exception e) {
                valid = false;
            }
        }
        return valid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkPortAvailability(String hostname, String port) {
        if (Utils.isValidPortNumber(port)) {
            int retVal = 0;
            int intPort = Integer.parseInt(port);
            Socket testSocket = null;
            try {
                InetAddress address = InetAddress.getByName(hostname);
                testSocket = new Socket(address, intPort);
                retVal = 1;
            }
            catch (UnknownHostException ignore) {
                retVal = 2;
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (testSocket != null && !testSocket.isClosed()) {
                        testSocket.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return retVal;
        }
        return -1;
    }

    public static boolean isNumberWithinRange(String value, String minRequired, String maxRequired) {
        boolean valid = true;
        try {
            if (Integer.parseInt(minRequired) > Integer.parseInt(maxRequired)) {
                valid = false;
            } else {
                int rangeNum = Integer.parseInt(value);
                int floor = Math.min(Integer.parseInt(minRequired), Integer.parseInt(maxRequired));
                int ceiling = Math.max(Integer.parseInt(minRequired), Integer.parseInt(maxRequired));
                valid = rangeNum >= floor && rangeNum <= ceiling;
            }
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    public static boolean isValidJobcard(String jobcard) {
        boolean valid = false;
        if (jobcard.length() <= 73 && jobcard.endsWith("\"\"") && (jobcard.startsWith("\"\"//") || jobcard.startsWith("\"\"/*"))) {
            valid = true;
        }
        return valid;
    }

    public static boolean isValidHighLevelQualifier(String hlq) {
        String highLevelQualifier = hlq.toUpperCase();
        if (highLevelQualifier.startsWith(".") || highLevelQualifier.endsWith(".") || highLevelQualifier.contains("..")) {
            return false;
        }
        String patternString = "[A-Z\\$\\#\\@][A-Z0-9\\-\\$\\#\\@]*";
        Pattern p = Pattern.compile(patternString);
        String token = null;
        StringTokenizer tokens = new StringTokenizer(highLevelQualifier, ".");
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            if (token.length() > 8) {
                return false;
            }
            Matcher m = p.matcher(token);
            if (m.matches()) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidWorkspc(String workspc) {
        String patternString = "[0-9]+";
        Pattern p = Pattern.compile(patternString);
        StringTokenizer tokens = new StringTokenizer(workspc, ",");
        String token = null;
        if (tokens.countTokens() != 2) {
            return false;
        }
        while (tokens.hasMoreTokens()) {
            token = tokens.nextToken();
            if (token.length() > 8) {
                return false;
            }
            Matcher m = p.matcher(token);
            if (m.matches()) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidIntrdr(String intrdr) {
        String value;
        String patternString = "\"'DD +SYSOUT=\\([A-Z0-9\\*],INTRDR(,[^,]+)*\\)'\"";
        Pattern p = Pattern.compile(patternString);
        Matcher m = p.matcher(value = intrdr.toUpperCase());
        return m.matches();
    }

    public static boolean isValidSvcNumber(String svc) {
        boolean valid = true;
        try {
            int svcNum;
            valid = !Integer.valueOf(svc).toString().equals(svc) ? false : (svcNum = Integer.parseInt(svc)) >= 0 && svcNum <= 255;
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    public static boolean isValidMulticast(String addr) {
        boolean valid = false;
        if (Globals.g_skipAddrCheck) {
            return true;
        }
        try {
            InetAddress address = InetAddress.getByName(addr);
            valid = address.isMulticastAddress();
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    public static String makeSHA256Hash(String input) {
        SecureRandom rand = new SecureRandom();
        int seed = rand.nextInt();
        return Utils.makeSHA256Hash(input, seed);
    }

    public static String makeSHA256Hash(String input, int seed) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.reset();
            ByteBuffer buffer = ByteBuffer.allocate(input.length() + 4);
            buffer.put(input.getBytes());
            buffer.putInt(seed);
            md.update(buffer.array());
            byte[] digest = md.digest();
            return DatatypeConverter.printHexBinary(digest) + "|" + seed;
        }
        catch (Exception e) {
            Logging.log.severe("Failed to make SHA-256 hash of password string. Error: " + e.toString());
            return null;
        }
    }

    public static boolean isMSPasswordValid(String host, String port, String user, String password) {
        boolean valid = MetadataAccess.testConnection(host, port, user, password);
        return valid;
    }

    public static int isOSPasswordValid(String user, String password, boolean logonAsBatch) {
        int rc = 0;
        if (Utils.getOS(true) == 1 && user != null && password != null) {
            File sasumgmt = new File(Utils.joinPath(Globals.g_setupLocation, Utils.getOS_Suffix()), SASUMGMT_EXE);
            if (sasumgmt.isFile()) {
                try {
                    String option = null;
                    option = logonAsBatch ? "-cupw" : "-cunpw";
                    String usr = Utils.stringReplaceAll(user, "\"", "\\\"");
                    String pwd = Utils.stringReplaceAll(password, "\"", "\\\"");
                    String[] cmd = new String[]{sasumgmt.getAbsolutePath(), option, "-u" + usr, "-p" + pwd};
                    Process p = Runtime.getRuntime().exec(cmd);
                    BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String sysOut = "";
                    String data = in.readLine();
                    while (data != null) {
                        sysOut = sysOut + data + System.getProperty("line.separator");
                        data = in.readLine();
                    }
                    p.waitFor();
                    rc = p.exitValue();
                }
                catch (Exception e) {
                    Logging.log.warning("Unable to validate the password for user: " + user);
                }
            } else {
                Logging.log.warning("Could not find the following file to validate passwords: " + sasumgmt.getAbsolutePath());
            }
        }
        return rc;
    }

    public static boolean isAdmin(String user) {
        boolean admin = true;
        if (user == null) {
            admin = false;
        }
        if (Utils.getOS(true) == 1 && user != null) {
            File sasumgmt = new File(Utils.joinPath(Globals.g_setupLocation, Utils.getOS_Suffix()), SASUMGMT_EXE);
            if (sasumgmt.isFile()) {
                try {
                    String[] cmd = new String[]{sasumgmt.getAbsolutePath(), "-cuadmin"};
                    Process p = Runtime.getRuntime().exec(cmd);
                    BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    String sysOut = "";
                    String data = in.readLine();
                    while (data != null) {
                        sysOut = sysOut + data + System.getProperty("line.separator");
                        data = in.readLine();
                    }
                    p.waitFor();
                    admin = p.exitValue() == 0;
                }
                catch (Exception e) {
                    Logging.log.warning("Unable to determine if the user is an administrator: " + user);
                }
            } else {
                Logging.log.warning("Could not find the following file to check administrator status: " + sasumgmt.getAbsolutePath());
            }
        }
        return admin;
    }

    public static String getUserDomain() {
        String domain = "";
        if (Utils.getOS(true) == 1) {
            try {
                Class<?> c = Class.forName("com.sun.security.auth.module.NTSystem");
                Method m = c.getMethod("getDomain", null);
                domain = (String)m.invoke(c.newInstance(), null);
            }
            catch (Exception e) {
                Logging.log.severe("Error retrieving domain name: " + e.getMessage());
            }
        }
        return domain;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isRunning(String code, String version, String platform, String filename) {
        boolean flag = false;
        File deployRegJar = new File(RegistryData.getDeployRegJar());
        if (deployRegJar.isFile()) {
            RegistryAccess m_registryAccess = null;
            FileLock lock = null;
            AbstractInterruptibleChannel channel = null;
            RandomAccessFile randomAcs = null;
            try {
                m_registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                if (m_registryAccess.open()) {
                    File file;
                    String location = null;
                    if (platform == null) {
                        location = m_registryAccess.getInstallLoc(code, version);
                        if (location == null) {
                            location = m_registryAccess.getInstallLoc(code, "default");
                        }
                    } else {
                        location = m_registryAccess.getInstallLoc(code, version, platform);
                        if (location == null) {
                            location = m_registryAccess.getInstallLoc(code, "default", platform);
                        }
                    }
                    if (location != null && (file = new File(location + "\\" + filename)).isFile()) {
                        randomAcs = new RandomAccessFile(file, "rw");
                        channel = randomAcs.getChannel();
                        lock = ((FileChannel)channel).lock();
                    }
                }
            }
            catch (OverlappingFileLockException e) {
                Logging.log.info("OverlappingFileLockException" + e.getMessage());
                flag = true;
            }
            catch (FileNotFoundException e) {
                Logging.log.info("RandomAccessFile-FileNotFoundException" + e.getMessage());
                flag = true;
            }
            catch (Exception e) {
                Logging.log.info(e.getMessage());
                m_registryAccess = null;
                flag = true;
            }
            finally {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    if (channel != null) {
                        channel.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                try {
                    if (randomAcs != null) {
                        randomAcs.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (m_registryAccess != null) {
                    m_registryAccess.close();
                }
            }
        }
        return flag;
    }

    public static boolean allowD3D() {
        String ati2dvagdll = "ati2dvag.dll";
        String regMachine = "\\registry\\machine";
        if (Utils.getOS() == 1) {
            String temp = WinRegAPI.getWindowsRegistryValue(8, "hardware\\DeviceMap\\Video", "\\Device\\Video0");
            if (temp == null) {
                return true;
            }
            String temp2 = temp.toLowerCase();
            if (!temp2.startsWith(regMachine, 0)) {
                return true;
            }
            temp = temp2.substring(regMachine.length() + 1);
            if ((temp2 = WinRegAPI.getWindowsRegistryValue(8, temp, "drv")) == null) {
                return true;
            }
            temp = temp2.toLowerCase();
            return temp.compareToIgnoreCase(ati2dvagdll) != 0;
        }
        return true;
    }

    public static int extractTar(String tarFile, String destDir, DlgBusyMsg progressIndicator) {
        int rc = -1;
        try {
            File rcFile;
            File destDirFile = new File(destDir);
            if (!destDirFile.exists()) {
                destDirFile.mkdirs();
            }
            String logFile = Utils.joinPath(Globals.g_tempLocation, ".tarlog");
            String script = Utils.joinPath(Globals.g_tempLocation, "tarscript");
            File scriptFile = new File(script);
            PrintStream out = new PrintStream(new FileOutputStream(scriptFile));
            out.println("#!/bin/sh");
            out.println("if [ -x /usr/bin/echo ]; then ");
            out.println("  echo=/usr/bin/echo");
            out.println("elif [ -x /bin/echo ] ; then ");
            out.println("  echo=/bin/echo");
            out.println("else ");
            out.println("  echo=echo");
            out.println("fi");
            out.println("if [ -f " + logFile + " ]; then ");
            out.println("  rm -f " + logFile);
            out.println("fi");
            out.println("cd " + destDir);
            out.println("tar xvf " + tarFile + " 1>" + Globals.g_tempLocation + "/tarlog 2>&1");
            out.println("$echo $? >" + logFile);
            out.close();
            String[] cmd = new String[]{"chmod", "755", script};
            Process scriptProc = Runtime.getRuntime().exec(cmd);
            scriptProc.waitFor();
            scriptProc = null;
            String[] command = new String[]{"/bin/sh", "-c", script};
            ArchiveWorker worker = new ArchiveWorker(0, command);
            if (progressIndicator != null) {
                progressIndicator.execute(worker);
            } else {
                worker.run();
            }
            if (scriptFile.isFile() && !Globals.g_debug) {
                scriptFile.delete();
            }
            if ((rcFile = new File(logFile)).isFile()) {
                BufferedReader in = new BufferedReader(new FileReader(rcFile));
                rc = Integer.parseInt(in.readLine());
                in.close();
                in = null;
                if (!Globals.g_debug) {
                    rcFile.delete();
                }
            }
        }
        catch (Exception e) {
            Logging.log.severe("Error extracting: " + tarFile);
        }
        return rc;
    }

    public static int extractTaz(String tazFile, String destDir, DlgBusyMsg progressIndicator) {
        int rc = -1;
        try {
            File rcFile;
            File destDirFile = new File(destDir);
            if (!destDirFile.exists()) {
                destDirFile.mkdirs();
            }
            String logFile = Utils.joinPath(Globals.g_tempLocation, ".tazlog");
            String script = Utils.joinPath(Globals.g_tempLocation, "tazscript");
            File scriptFile = new File(script);
            PrintStream out = new PrintStream(new FileOutputStream(scriptFile));
            out.println("#!/bin/sh");
            out.println("if [ -x /usr/bin/echo ]; then ");
            out.println("  echo=/usr/bin/echo");
            out.println("elif [ -x /bin/echo ] ; then ");
            out.println("  echo=/bin/echo");
            out.println("else ");
            out.println("  echo=echo");
            out.println("fi");
            out.println("if [ -f " + logFile + " ]; then ");
            out.println("  rm -f " + logFile);
            out.println("fi");
            out.println("cd " + destDir);
            out.println("zcat <" + tazFile + " | tar xvf - 1>" + Globals.g_tempLocation + "/tazlog 2>&1");
            out.println("$echo $? >" + logFile);
            out.close();
            String[] cmd = new String[]{"chmod", "755", script};
            Process scriptProc = Runtime.getRuntime().exec(cmd);
            scriptProc.waitFor();
            scriptProc = null;
            String[] command = new String[]{"/bin/sh", "-c", script};
            ArchiveWorker worker = new ArchiveWorker(0, command);
            if (progressIndicator != null) {
                progressIndicator.execute(worker);
            } else {
                worker.run();
            }
            if (scriptFile.isFile() && !Globals.g_debug) {
                scriptFile.delete();
            }
            if ((rcFile = new File(logFile)).isFile()) {
                BufferedReader in = new BufferedReader(new FileReader(rcFile));
                rc = Integer.parseInt(in.readLine());
                in.close();
                in = null;
                if (!Globals.g_debug) {
                    rcFile.delete();
                }
            }
        }
        catch (Exception e) {
            Logging.log.severe("Error extracting: " + tazFile);
        }
        return rc;
    }

    public static int uncompressGZIP(String gzipFile, String destFile) {
        int rc = -1;
        Logging.log.finer("UnGZIPing " + gzipFile + " to file " + destFile);
        try {
            int len;
            GZIPInputStream in = new GZIPInputStream(new FileInputStream(gzipFile));
            FileOutputStream out = new FileOutputStream(destFile);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            in.close();
            ((OutputStream)out).close();
            rc = 0;
            Logging.log.finer("Finished UnGZIPing " + gzipFile + " to file " + destFile);
        }
        catch (IOException e) {
            Logging.log.severe("Could not uncompress gzip file:" + gzipFile + " into dest file:" + destFile);
            Logging.logStackTrace(e);
        }
        return rc;
    }

    public static String VMSToUnixPath(String inpath) {
        int rbracket;
        String retpath = null;
        if (inpath.indexOf(":") == -1 && inpath.indexOf("[") == -1) {
            return inpath;
        }
        int idx = inpath.indexOf(58);
        if (idx == inpath.length() - 1) {
            retpath = "/" + inpath.substring(0, inpath.length() - 1);
            return retpath;
        }
        if (idx == -1) {
            idx = inpath.indexOf(91);
            if (idx == -1) {
                return inpath;
            }
        } else {
            retpath = "/" + inpath.substring(0, idx);
            ++idx;
        }
        if ((rbracket = inpath.indexOf(93)) == -1) {
            return null;
        }
        String dirspec = inpath.substring(idx + 1, rbracket);
        if (dirspec.contains("^")) {
            dirspec = dirspec.replace("^.", "^");
        }
        String sepstr = "\\.";
        if ((retpath = retpath == null ? dirspec.replaceAll(sepstr, "/") : retpath + "/" + dirspec.replaceAll(sepstr, "/")).contains("^")) {
            retpath = retpath.replace('^', '.');
        }
        if (rbracket < inpath.length() - 1) {
            retpath = retpath + "/" + inpath.substring(rbracket + 1, inpath.length());
        }
        return retpath;
    }

    public static String GetJarVersion(String file) {
        String version = null;
        File setupFile = new File(file);
        if (setupFile.isFile()) {
            try {
                JarFile jf = new JarFile(setupFile);
                version = jf.getManifest().getMainAttributes().getValue("Implementation-Version").trim();
            }
            catch (Exception e) {
                Logging.log.info("Error checking manifest for jar: " + setupFile.toString());
            }
        }
        return version;
    }

    public static String GetSDWVersion() {
        String path = Utils.joinPath(Globals.g_setupLocation, "setup.jar");
        String version = Utils.GetJarVersion(path);
        return version;
    }

    public static void ShowJarVersions() {
        String[] jars = new String[]{"setup.jar", "sas.tools.installs.it.jar", "sas.tools.deployjni.jar", "sas.tools.deploymntreg.jar"};
        StringBuffer displayOutput = new StringBuffer("<HTML><table><th>" + bundle.messageString("Utils.JarFileColumnHeader.txt") + "</th><th>" + bundle.messageString("Utils.VersionColumnHeader.txt") + "</th><th></th>");
        StringBuffer logOutput = new StringBuffer("Jar versions from location " + Globals.g_setupLocation + ":\n");
        for (String jar : jars) {
            String path = Utils.joinPath(Globals.g_setupLocation, jar);
            String version = Utils.GetJarVersion(path);
            logOutput.append(String.format("%-30s -- %s\n", jar, version));
            displayOutput.append("<tr><td>" + jar + "</td><td>" + version + "</td></tr>");
        }
        String deployRegJar = null;
        File deployRegJarFile = null;
        boolean foundRegJarFile = false;
        Logging.log.info("Mode is: 2");
        if (Globals.g_mode == 2) {
            File pSASHome = new File(Globals.g_startupLocation).getParentFile();
            deployRegJarFile = new File(pSASHome, Utils.joinPath("deploymntreg", "sas.tools.deploymntreg.jar"));
            if (deployRegJarFile.exists()) {
                foundRegJarFile = true;
                deployRegJar = deployRegJarFile.getPath();
            } else {
                deployRegJarFile = new File(pSASHome = pSASHome.getParentFile(), Utils.joinPath("deploymntreg", "sas.tools.deploymntreg.jar"));
                if (deployRegJarFile.exists()) {
                    foundRegJarFile = true;
                    deployRegJar = deployRegJarFile.getPath();
                }
            }
        } else {
            deployRegJar = Utils.joinPath(Globals.g_setupLocation, "deploymntreg", "sas.tools.deploymntreg.jar");
            deployRegJarFile = new File(deployRegJar);
            if (deployRegJarFile.exists()) {
                foundRegJarFile = true;
            }
        }
        if (foundRegJarFile) {
            String version = Utils.GetJarVersion(deployRegJar);
            logOutput.append("Deployment Registry Jar version from location " + deployRegJar + ":\n");
            logOutput.append(String.format("%-30s -- %s\n", "sas.tools.deploymntreg.jar", version));
            displayOutput.append("<tr><td>sas.tools.deploymntreg.jar</td><td>" + version + "</td></tr>");
        }
        Logging.log.info(logOutput.toString());
        displayOutput.append("</table>");
        if (!Globals.g_quietMode) {
            CustMsgBox.showMessageDialog(null, displayOutput.toString(), bundle.getString("Utils.JarVersionsHeader.txt"));
        }
    }

    public static void ListDepot(String outputFile) {
        OrderData[] orders;
        DeploymentData depotData = new DeploymentData(Globals.g_startupLocation);
        if (Globals.g_forceOrder == null) {
            depotData.loadOrders();
        } else {
            depotData.loadOrder(Globals.g_forceOrder);
        }
        if (depotData.getOrderCount() < 1) {
            Logging.log.severe("No orders found on media");
            return;
        }
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        }
        catch (IOException e) {
            Logging.logStackTrace(e);
            if (!Globals.g_quietMode) {
                CustMsgBox.showMessageDialog(null, bundle.messageString("Utils.ListDepotCanNotOpenFile.txt", outputFile), bundle.getString("Common.Warning.txt"), 2);
            }
            return;
        }
        out.println("Date: " + new SimpleDateFormat("yyyy MMM dd HH:mm:ss").format(new Date()));
        out.println("Depot: " + Globals.g_startupLocation);
        out.println();
        for (OrderData order : orders = depotData.getOrders()) {
            out.println("Order: " + order.getOrder());
            OrderData orderData = depotData.getOrder(order.getOrder());
            for (String volser : orderData.getVolsers(orderData.getMediaType())) {
                VolserData volserData = depotData.getVolser(volser);
                for (String spsSku : volserData.getSpsSkus()) {
                    SpsSkuData spsSkuData = depotData.getSpsSku(spsSku);
                    out.println((volserData.isPayloadIncluded(spsSku) ? "+ " : "- ") + spsSkuData.getDisplayName("en") + " [" + spsSku + "]");
                }
                out.println();
            }
        }
        out.close();
    }

    public static void setFileModeOnDirectoryTree(File folder) {
        File[] files = folder.listFiles();
        FileMode fm = null;
        if (files == null) {
            return;
        }
        try {
            fm = new FileMode(folder);
            fm.setPerm(493);
            fm.commit();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                Utils.setFileModeOnDirectoryTree(files[i]);
                continue;
            }
            try {
                fm = new FileMode(files[i]);
                fm.setPerm(493);
                fm.commit();
                continue;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public static String getJavaCommand() {
        String javaRoot = Globals.g_jreHome;
        if (javaRoot == null && Utils.getOS() == 8) {
            javaRoot = System.getProperty("java.home");
        }
        return Utils.buildJavaCommand(javaRoot);
    }

    public static String buildJavaCommand(String javaRoot) {
        String javaCommand = null;
        javaCommand = Utils.getOS() == 1 ? Utils.joinPath(javaRoot, "bin\\java.exe") : Utils.joinPath(javaRoot, "bin/java");
        return javaCommand;
    }

    protected static int getPreferredRowHeight(JTable table) {
        int maxHeight = 0;
        if (Globals.g_rowheight == 0) {
            TableCellRenderer renderer = null;
            Component comp = null;
            int height = 0;
            for (int row = 0; row < table.getRowCount(); ++row) {
                for (int col = 0; col < table.getColumnCount(); ++col) {
                    renderer = table.getCellRenderer(row, col);
                    comp = table.prepareRenderer(renderer, row, col);
                    height = comp.getPreferredSize().height;
                    maxHeight = Math.max(maxHeight, height);
                }
            }
            Globals.g_rowheight = maxHeight;
        } else {
            maxHeight = Globals.g_rowheight;
        }
        return maxHeight;
    }

    protected static int getMinColumnWidth(JTable table, int columnIndex) {
        int margin = table.getRowMargin();
        TableCellRenderer renderer = table.getTableHeader().getDefaultRenderer();
        TableColumn column = table.getColumnModel().getColumn(columnIndex);
        Component comp = renderer.getTableCellRendererComponent(null, column.getHeaderValue(), false, false, 0, 0);
        int headerWidth = comp.getPreferredSize().width + margin * 2;
        return headerWidth;
    }

    protected static int getPreferredColumnWidth(JTable table, int columnIndex) {
        int maxWidth = Utils.getMinColumnWidth(table, columnIndex);
        int margin = table.getRowMargin();
        for (int rowIndex = 0; rowIndex < table.getRowCount(); ++rowIndex) {
            TableCellRenderer renderer = table.getCellRenderer(rowIndex, columnIndex);
            Component comp = table.prepareRenderer(renderer, rowIndex, columnIndex);
            int w = comp.getPreferredSize().width;
            maxWidth = Math.max(maxWidth, w);
        }
        return maxWidth += margin * 2;
    }

    public static void loggingToFiner() {
        Logging.log.setLevel(java.util.logging.Level.FINER);
        Globals.g_debug = true;
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig http = config.getLoggerConfig("org.apache.http");
        http.setLevel(Level.DEBUG);
        LoggerConfig wire = config.getLoggerConfig("org.apache.http.wire");
        wire.setLevel(Level.ERROR);
        Logging.log.info("Logging set for FINER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLinuxVersion(String vendor, File file) {
        String version = "";
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
            String line = in.readLine();
            while (line != null) {
                line = line.trim();
                int size = line.length();
                int maxIndex = size - 1;
                int index = -1;
                if (size > 0) {
                    int versionIndex;
                    if (vendor.equals("redhat")) {
                        index = line.toLowerCase(Locale.ENGLISH).indexOf("release ");
                        versionIndex = index + 8;
                        if (index > -1 && versionIndex <= maxIndex && (version = line.substring(versionIndex)).indexOf(".") > 0) {
                            version = version.substring(0, version.indexOf("."));
                            break;
                        }
                    } else if (vendor.equals("SuSE")) {
                        index = line.toLowerCase(Locale.ENGLISH).indexOf("version = ");
                        versionIndex = index + 10;
                        if (index > -1 && versionIndex <= maxIndex) {
                            version = line.substring(versionIndex);
                            break;
                        }
                    }
                }
                line = in.readLine();
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            Logging.log.warning("File not found");
            Logging.logStackTrace(e);
        }
        catch (IOException e) {
            Logging.log.warning("Error reading file");
            Logging.logStackTrace(e);
        }
        catch (Exception e) {
            Logging.log.warning("Error finding operating system data.");
            Logging.logStackTrace(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Logging.logStackTrace(e);
                }
            }
        }
        if (version.length() < 1) {
            version = "unknown";
        }
        return version;
    }

    public static ProcessData runProcess(String fullCmd) {
        return Utils.runProcess(fullCmd, true);
    }

    public static ProcessData runProcess(String fullCmd, boolean wait) {
        String temp = null;
        String[] args = fullCmd.split(" ");
        ArrayList<String> cmd = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("\"") && !args[i].endsWith("\"")) {
                temp = args[i];
                continue;
            }
            if (temp != null) {
                temp = temp + " " + args[i];
                if (!args[i].endsWith("\"")) continue;
                cmd.add(temp.replaceAll("\"", ""));
                temp = null;
                continue;
            }
            cmd.add(args[i].replaceAll("\"", ""));
        }
        return Utils.runProcess(cmd.toArray(new String[0]), wait);
    }

    public static ProcessData runProcess(String[] cmd) {
        return Utils.runProcess(cmd, true);
    }

    public static ProcessData runProcess(String[] cmd, boolean wait) {
        return Utils.runProcess(cmd, wait, null);
    }

    public static ProcessData runProcess(String[] cmd, boolean wait, String sudoPassword) {
        int exitValue = -1;
        final ArrayList stdoutput = new ArrayList();
        final ArrayList stderror = new ArrayList();
        try {
            BufferedWriter writer;
            Process p = Runtime.getRuntime().exec(cmd);
            if (sudoPassword != null && cmd.length > 1 && cmd[0].equals("sudo") && cmd[1].equals("-S") && (writer = new BufferedWriter(new OutputStreamWriter(p.getOutputStream()))) != null) {
                writer.write(sudoPassword + "\n");
                writer.flush();
                writer.close();
            }
            if (wait) {
                final BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
                new Thread(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                String line = in.readLine();
                                while (line != null) {
                                    stdoutput.add(line);
                                    line = in.readLine();
                                }
                            }
                            catch (IOException e) {
                                if ("Stream closed".equalsIgnoreCase(e.getMessage())) break block3;
                                Logging.log.info("Read standard output");
                                Logging.logStackTrace(e);
                            }
                        }
                    }
                }.start();
                final BufferedReader errIn = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                new Thread(){

                    @Override
                    public void run() {
                        block3: {
                            try {
                                String line = errIn.readLine();
                                while (line != null) {
                                    stderror.add(line);
                                    line = errIn.readLine();
                                }
                            }
                            catch (IOException e) {
                                if ("Stream closed".equalsIgnoreCase(e.getMessage())) break block3;
                                Logging.log.info("Read standard error");
                                Logging.logStackTrace(e);
                            }
                        }
                    }
                }.start();
                exitValue = p.waitFor();
                in.close();
                errIn.close();
            } else {
                exitValue = 0;
            }
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        String[] myoutput = stdoutput.toArray(new String[0]);
        String[] myerror = stderror.toArray(new String[0]);
        ProcessData mydata = new ProcessData(cmd, exitValue, myoutput, myerror);
        return mydata;
    }

    public static String concatArray(String[] array, String delimiter) {
        StringBuffer sb = new StringBuffer();
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                if (delimiter != null && sb.length() > 0) {
                    sb.append(delimiter);
                }
                sb.append(array[i]);
            }
        }
        return sb.toString();
    }

    public static boolean isEqualPaths(String path1, String path2) {
        boolean equal = false;
        File file1 = new File(path1);
        File file2 = new File(path2);
        try {
            String canonicalPath1 = file1.getCanonicalPath();
            String canonicalPath2 = file2.getCanonicalPath();
            equal = canonicalPath1.equals(canonicalPath2);
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        return equal;
    }

    public static boolean isPortListening(String host, int port) {
        boolean listening = false;
        try {
            Socket socket = new Socket(host, port);
            socket.close();
            listening = true;
        }
        catch (Exception e) {
            listening = false;
        }
        return listening;
    }

    public static boolean isServerPortAvailable(int checkPort, String protocol, InetAddress addr) {
        boolean isAvailable = false;
        if (protocol != null && Utils.isValidPortNumber(Integer.toString(checkPort))) {
            try {
                protocol = protocol.toLowerCase(Locale.ENGLISH);
                if ("tcp".equals(protocol)) {
                    ServerSocket serverSocket = addr == null ? new ServerSocket(checkPort) : new ServerSocket(checkPort, 1, addr);
                    serverSocket.close();
                    isAvailable = true;
                } else if ("udp".equals(protocol)) {
                    DatagramSocket datagramSocket = addr == null ? new DatagramSocket(checkPort) : new DatagramSocket(checkPort, addr);
                    datagramSocket.close();
                    isAvailable = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return isAvailable;
    }

    public static int locInArrayList(ArrayList<String> arrayList, String string) {
        int loc = -1;
        for (int i = 0; i < arrayList.size() && loc == -1; ++i) {
            if (!arrayList.get(i).equalsIgnoreCase(string)) continue;
            loc = i;
        }
        return loc;
    }

    public static int getOfficeBitness() {
        int bitness = -1;
        bitness = Utils.getOfficeProductBitness("12.0", "Excel");
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("14.0", "Excel");
        }
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("15.0", "Excel");
        }
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("16.0", "Excel");
        }
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("12.0", "Word");
        }
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("14.0", "Word");
        }
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("15.0", "Word");
        }
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("16.0", "Word");
        }
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("12.0", "PowerPoint");
        }
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("14.0", "PowerPoint");
        }
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("15.0", "PowerPoint");
        }
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("16.0", "PowerPoint");
        }
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("12.0", "Outlook");
        }
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("14.0", "Outlook");
        }
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("15.0", "Outlook");
        }
        if (bitness == -1) {
            bitness = Utils.getOfficeProductBitness("16.0", "Outlook");
        }
        return bitness;
    }

    private static int getOfficeProductBitness(String version, String product) {
        File pathFile;
        String path;
        int bitness = -1;
        if (Utils.getOS_Suffix().equalsIgnoreCase(OS_SUFFIX_WX6)) {
            String path2 = WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\Microsoft\\Office\\" + version + "\\" + product + "\\InstallRoot", "Path");
            if (path2 != null && !path2.isEmpty()) {
                File pathFile2 = new File(path2);
                if (pathFile2.isDirectory()) {
                    bitness = 64;
                }
            } else {
                File pathFile3;
                path2 = WinRegAPI.getWinRegValue32(8, "SOFTWARE\\Microsoft\\Office\\" + version + "\\" + product + "\\InstallRoot", "Path");
                if (path2 != null && !path2.isEmpty() && (pathFile3 = new File(path2)).isDirectory()) {
                    bitness = 32;
                }
            }
        } else if (Utils.getOS_Suffix().equalsIgnoreCase(OS_SUFFIX_WIN) && (path = WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\Microsoft\\Office\\" + version + "\\" + product + "\\InstallRoot", "Path")) != null && !path.isEmpty() && (pathFile = new File(path)).isDirectory()) {
            bitness = 32;
        }
        return bitness;
    }

    public static String removeHTMLTags(String inText) {
        int openTagPos = inText.indexOf("<");
        String outText = "";
        if (openTagPos > -1) {
            boolean moreTags = true;
            int openTagCount = 0;
            int closeTagPos = inText.indexOf(">");
            int closeTagCount = 0;
            int startTextPos = 0;
            String replaceText = null;
            while (moreTags) {
                if (openTagPos < closeTagPos && openTagPos > -1) {
                    if (++openTagCount == 1 && openTagPos > 0) {
                        outText = outText + inText.substring(startTextPos, openTagPos);
                        replaceText = inText.substring(openTagPos + 1, closeTagPos);
                        if (replaceText.equalsIgnoreCase("br") || replaceText.equalsIgnoreCase("/h2") || replaceText.equalsIgnoreCase("ol") || replaceText.equalsIgnoreCase("ul") || replaceText.equalsIgnoreCase("/li") || replaceText.equalsIgnoreCase("/tr")) {
                            outText = outText + "\n";
                        }
                    }
                    openTagPos = inText.indexOf("<", openTagPos + 1);
                    continue;
                }
                if (closeTagPos > -1) {
                    if (++closeTagCount == openTagCount) {
                        openTagCount = 0;
                        closeTagCount = 0;
                        startTextPos = closeTagPos + 1;
                    }
                    closeTagPos = inText.indexOf(">", closeTagPos + 1);
                    continue;
                }
                if (openTagPos != -1) continue;
                moreTags = false;
                if (startTextPos >= inText.length()) continue;
                outText = outText + inText.substring(startTextPos);
            }
        } else {
            outText = inText;
        }
        outText = Utils.stringReplaceAll(outText, "&nbsp;", " ");
        return outText;
    }

    public static void setSASHome() {
        Globals.g_cmtSASHome = null;
        if (Globals.g_startupLocation != null) {
            File startupLoc = new File(Globals.g_startupLocation);
            File sasHome = startupLoc.getParentFile();
            File deploymntreg = new File(sasHome, "deploymntreg/sas.tools.deploymntreg.jar");
            if (deploymntreg.isFile()) {
                Globals.g_cmtSASHome = sasHome.getPath();
            } else {
                deploymntreg = new File(sasHome = sasHome.getParentFile(), "deploymntreg/sas.tools.deploymntreg.jar");
                if (deploymntreg.isFile()) {
                    Globals.g_cmtSASHome = sasHome.getPath();
                }
            }
        }
        if (Globals.g_cmtSASHome != null) {
            if (Globals.g_wizardData != null) {
                Globals.g_wizardData.setPreference("SASHome", Globals.g_cmtSASHome);
            }
            Globals.g_wizardData.setPreference("SASVersion", Globals.g_majorReleaseVersion);
        } else {
            Logging.log.severe("Unable to determine SAS Home from the location where the SAS Deployment Manager is running: " + Globals.g_startupLocation);
        }
    }

    public static boolean validateSMUTierExecution(String tier) {
        String TRUE = "true";
        File smuPropertiesFile = new File(tier, "smu.properties");
        Properties smuProperties = new Properties();
        try {
            if (smuPropertiesFile.isFile()) {
                FileInputStream fis = new FileInputStream(smuPropertiesFile);
                smuProperties.load(fis);
                fis.close();
            }
        }
        catch (Exception e) {
            Logging.log.warning("Migration package: Error loading smu.properties file: " + smuPropertiesFile.toString());
        }
        return TRUE.equalsIgnoreCase(smuProperties.getProperty("SMU.Execute"));
    }

    public static float getJREVersion() {
        float javaVerNum = 0.0f;
        String javaVersion = System.getProperty("java.version");
        if (javaVersion != null && javaVersion.length() > 2) {
            try {
                javaVerNum = Float.parseFloat(javaVersion.substring(0, 3));
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        return javaVerNum;
    }

    public static String join(Collection<?> parts, String delimiter) {
        if (parts == null) {
            parts = Collections.EMPTY_LIST;
        }
        if (delimiter == null) {
            delimiter = "";
        }
        StringBuilder sb = new StringBuilder();
        for (Object part : parts) {
            sb.append(part != null ? part.toString() : "");
            sb.append(delimiter);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - delimiter.length());
        }
        return sb.toString();
    }

    public static int compareDates(String date1, String date2) {
        if (date1.equals(null) && date2.equals(null)) {
            return 0;
        }
        if (date1.length() != 9 || date2.length() != 9) {
            throw new NumberFormatException("Supplied last port date is not in ddMMMyyyy format");
        }
        if (date1 == null || date1.length() != 9) {
            return 1;
        }
        long time1 = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(date1, new ParsePosition(0)).getTime();
        if (date2 == null || date2.length() != 9) {
            return -1;
        }
        long time2 = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(date2, new ParsePosition(0)).getTime();
        if (time1 == time2) {
            return 0;
        }
        if (time1 > time2) {
            return -1;
        }
        if (time2 > time1) {
            return 1;
        }
        return 0;
    }

    public static boolean areAnyMVSMVAHotFixes() {
        for (ProductData hotFix : Globals.g_selectedHotFixesToInstall) {
            if (hotFix.getType() != 4 || !((HotFix)hotFix).getSpsSkuData().getPlatform().equalsIgnoreCase(OS_SUFFIX_MVS) && !((HotFix)hotFix).getSpsSkuData().getPlatform().equalsIgnoreCase(OS_SUFFIX_Z64)) continue;
            return true;
        }
        return false;
    }

    public static boolean isWebAppServerCode(String code) {
        boolean webAppServer = false;
        if (code != null && (code.equalsIgnoreCase("jboss") || code.equalsIgnoreCase("vfabrictcsvr") || code.equalsIgnoreCase("tcsclusterc") || code.equalsIgnoreCase("weblogic") || code.equalsIgnoreCase("websphereba") || code.equalsIgnoreCase("webspherend"))) {
            webAppServer = true;
        }
        return webAppServer;
    }

    public static String getPropertyValue(String file, String section, String key) {
        String value = null;
        boolean sectionFlag = false;
        String token = null;
        try {
            FileInputStream stream = new FileInputStream(file);
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)stream, "UTF-8"));
            String line = in.readLine();
            token = "[" + section + "]";
            while (line != null) {
                if (line.startsWith(token)) {
                    sectionFlag = true;
                    break;
                }
                line = in.readLine();
            }
            token = key + "=";
            if (sectionFlag) {
                line = in.readLine();
                while (line != null) {
                    if (line.startsWith(token)) {
                        value = line.substring(token.length());
                        break;
                    }
                    if (line.startsWith("[")) break;
                    line = in.readLine();
                }
            }
            in.close();
        }
        catch (FileNotFoundException e) {
            Logging.log.warning("File not found: " + file);
            Logging.logStackTrace(e);
        }
        catch (IOException e) {
            Logging.log.warning("Error reading file: " + file);
            Logging.logStackTrace(e);
        }
        return value;
    }

    public static String getWebAppServerDisplayName(String code) {
        if (code.equalsIgnoreCase("jboss")) {
            return Globals.WEB_SERVER_DISPLAY_NAME_JBOSS;
        }
        if (code.equalsIgnoreCase("weblogic")) {
            return Globals.WEB_SERVER_DISPLAY_NAME_WEBLOGIC;
        }
        if (code.equalsIgnoreCase("websphereba") || code.equalsIgnoreCase("webspherend")) {
            return Globals.WEB_SERVER_DISPLAY_NAME_WEBSPHERE;
        }
        if (code.equalsIgnoreCase("tcsclusterc") || code.equalsIgnoreCase("vfabrictcsvr")) {
            return Globals.WEB_SERVER_DISPLAY_NAME_TCSERVER;
        }
        return null;
    }

    public static boolean doesDirectoryHaveParent(String dir, String parent) {
        boolean ret = false;
        if (dir != null && parent != null) {
            try {
                File resolvedDir = new File(dir).getCanonicalFile();
                File resolvedParentDir = new File(parent).getCanonicalFile();
                for (File aParentDir = resolvedDir; aParentDir != null; aParentDir = aParentDir.getParentFile()) {
                    if (!aParentDir.equals(resolvedParentDir)) continue;
                    ret = true;
                    break;
                }
            }
            catch (IOException ioe) {
                Logging.logStackTrace(ioe);
            }
        }
        return ret;
    }

    public static boolean removeFile(File destination) {
        boolean isSuccess = true;
        if (destination != null && destination.exists()) {
            isSuccess = destination.delete();
            for (int retries = 1; !isSuccess && retries < 4; ++retries) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd G hh:mm:ss");
                Date now = new Date();
                String dateString = formatter.format(now);
                Logging.log.warning(dateString + "removing " + destination + " failed, so retrying after garbage collection and waiting three seconds.  " + retries + " retries");
                isSuccess = destination.delete();
            }
        }
        return isSuccess;
    }

    public static boolean moveFile(File source, File destination) {
        boolean isSuccess = Utils.removeFile(destination);
        int retries = 1;
        if (!isSuccess) {
            return isSuccess;
        }
        isSuccess = source.renameTo(destination);
        for (retries = 1; !isSuccess && retries < 4; ++retries) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd G hh:mm:ss");
            Date now = new Date();
            String dateString = formatter.format(now);
            Logging.log.warning(dateString + "moving " + source + " to " + destination + " failed, so retrying after garbage collection and waiting three seconds.  " + retries + " retries");
            isSuccess = source.renameTo(destination);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isExistingSASPlannedDeployment() {
        boolean rc = false;
        String[] configDirs = null;
        RegistryAccess registryAccess = null;
        try {
            registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
            if (registryAccess != null && registryAccess.open()) {
                configDirs = registryAccess.getConfigLocs();
            }
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        finally {
            if (registryAccess != null) {
                registryAccess.close();
                registryAccess = null;
            }
        }
        if (configDirs != null && configDirs.length > 0) {
            rc = true;
            Globals.g_checkDeploymentAgentUp = true;
        }
        return rc;
    }

    public static String readFile(File file) throws IOException {
        return Utils.readFile(file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File file, String encoding) throws IOException {
        InputStreamReader streamReader = null;
        streamReader = encoding == null ? new InputStreamReader(new FileInputStream(file)) : new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        BufferedReader reader = new BufferedReader(streamReader);
        String line = null;
        StringBuffer sb = new StringBuffer();
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            reader.close();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return sb.toString();
    }

    public static void writeFile(File file, String content) throws IOException {
        Utils.writeFile(file, content, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File file, String content, String encoding) throws IOException {
        OutputStreamWriter streamWriter = null;
        streamWriter = encoding == null ? new OutputStreamWriter(new FileOutputStream(file)) : new OutputStreamWriter((OutputStream)new FileOutputStream(file), encoding);
        try (PrintWriter out = new PrintWriter(streamWriter);){
            out.write(content);
        }
    }

    private Properties loadPropertiesForLocale(String parentDirectory, String locale, String fileName) throws IOException {
        String localeFilePath;
        File localeFile;
        Properties properties = new Properties();
        String enFilePath = Utils.joinPath(parentDirectory, "en", fileName);
        properties.load(new FileInputStream(enFilePath));
        if (!locale.equalsIgnoreCase("en") && (localeFile = new File(localeFilePath = Utils.joinPath(parentDirectory, locale, fileName))).exists()) {
            Properties localeProperties = new Properties();
            localeProperties.load(new FileInputStream(localeFile));
            properties.putAll((Map<?, ?>)localeProperties);
        }
        return properties;
    }

    public static void removeSasWindowRegistryKey() {
        int hKey = 8;
        String subKey = "SOFTWARE\\SAS Institute Inc.\\Common Data";
        boolean bRemoved = WinRegAPI.DelRegTree(hKey, subKey, true);
        if (bRemoved) {
            Logging.log.info("SAS Windows Registry Key " + subKey + " is successfully removed.");
        } else {
            Logging.log.info("SAS Windows Registry Key " + subKey + " is not removed.");
        }
        bRemoved = WinRegAPI.DelRegTree(hKey, subKey, false);
        if (bRemoved) {
            Logging.log.info("SAS Windows Registry Key " + subKey + " is successfully removed.");
        } else {
            Logging.log.info("SAS Windows Registry Key " + subKey + " is not removed.");
        }
        subKey = "SOFTWARE\\SAS Institute Inc.\\The SAS System";
        bRemoved = WinRegAPI.DelRegTree(hKey, subKey, true);
        if (bRemoved) {
            Logging.log.info("SAS Windows Registry Key " + subKey + " is successfully removed.");
        } else {
            Logging.log.info("SAS Windows Registry Key " + subKey + " is not removed.");
        }
        bRemoved = WinRegAPI.DelRegTree(hKey, subKey, false);
        if (bRemoved) {
            Logging.log.info("SAS Windows Registry Key " + subKey + " is successfully removed.");
        } else {
            Logging.log.info("SAS Windows Registry Key " + subKey + " is not removed.");
        }
    }

    public static boolean has93SasInstalled(boolean check64) {
        String subKey = "SOFTWARE\\SAS Institute Inc.\\The SAS System\\9.3";
        int key = 8;
        return check64 ? WinRegAPI.isWindowsRegistryKey64(key, subKey) : WinRegAPI.isWindowsRegistryKey32(key, subKey);
    }

    public static void removeWinConsumersRegKeys(String sConsumers) {
        StringTokenizer tokens = new StringTokenizer(sConsumers, ",");
        int hKey = 8;
        while (tokens.hasMoreTokens()) {
            String nextConsumerKey = tokens.nextToken();
            WinRegAPI.DelRegKey(hKey, nextConsumerKey, true);
        }
    }

    public static void removeWinConsumersRegKeys32bit(String sConsumers) {
        StringTokenizer tokens = new StringTokenizer(sConsumers, ",");
        int hKey = 8;
        while (tokens.hasMoreTokens()) {
            String nextConsumerKey = tokens.nextToken();
            WinRegAPI.DelRegKey(hKey, nextConsumerKey, false);
        }
    }

    public static boolean extractFilesFromZip(ZipFile zipFile, List<File> filesToExtract, String extractLocation) {
        for (File fileToExtract : filesToExtract) {
            if (Utils.extractFileFromZip(zipFile, fileToExtract, extractLocation) != null) continue;
            return false;
        }
        return true;
    }

    public static File extractFileFromZip(ZipFile zipFile, File fileToExtract, String extractLocation) {
        String key = Utils.join(Arrays.asList(fileToExtract.getPath().split("\\\\")), "/");
        ZipEntry zipEntry = zipFile.getEntry(key);
        InputStream zipEntryStream = null;
        try {
            zipEntryStream = zipFile.getInputStream(zipEntry);
        }
        catch (IOException e) {
            Logging.log.severe("Error reading file " + fileToExtract.getPath() + " from " + zipFile.getName());
            e.printStackTrace();
            return null;
        }
        FileOutputStream fileOutputStream = null;
        File outputFile = new File(extractLocation, fileToExtract.getPath());
        File outputFileDir = new File(outputFile.getParent());
        if (!outputFileDir.exists() && !outputFileDir.mkdirs()) {
            Logging.log.severe("Error creating a directory for file extraction: " + outputFileDir.getAbsolutePath());
            return null;
        }
        try {
            fileOutputStream = new FileOutputStream(outputFile);
        }
        catch (Exception e) {
            Logging.log.severe("Error opening target file during extraction: " + outputFile.getAbsolutePath());
            Logging.logStackTrace(e);
            return null;
        }
        try {
            Utils.streamData(zipEntryStream, fileOutputStream);
        }
        catch (Exception e) {
            Logging.log.severe("Error writing target file during extraction: " + outputFile.getAbsolutePath());
            Logging.logStackTrace(e);
            return null;
        }
        try {
            zipEntryStream.close();
        }
        catch (IOException e) {
            Logging.log.warning("Error closing package file: " + zipFile.getName());
            Logging.logStackTrace(e);
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException e) {
            Logging.log.warning("Error closing target file: " + outputFile.getAbsolutePath());
            Logging.logStackTrace(e);
        }
        return outputFile;
    }

    public static String getFullLocalHostName() throws UnknownHostException {
        return Utils.getFullHostName(InetAddress.getLocalHost());
    }

    public static String getShortLocalHostName() throws UnknownHostException {
        return Utils.getShortHostName(InetAddress.getLocalHost());
    }

    public static String getFullHostName(InetAddress address) {
        return address.getCanonicalHostName().toLowerCase();
    }

    public static String getShortHostName(InetAddress address) {
        return address.getHostName().toLowerCase();
    }

    public static String toLowerCaseHostNameForUrl(String url) {
        String ret = url;
        if (url != null) {
            try {
                String lowercaseHost;
                URL aURL = new URL(url);
                String origHost = aURL.getHost();
                if (origHost != null && !origHost.equals(lowercaseHost = origHost.toLowerCase())) {
                    ret = url.replaceFirst(origHost, lowercaseHost);
                    Logging.log.finer("Utils::toLowerCaseHostNameForUrl() Changed hostname '" + origHost + "' to lower case for URL " + ret);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return ret;
    }

    public static boolean isValidHostNameChars(String hostname) {
        boolean ret = true;
        if (hostname != null && (hostname.contains("_") || hostname.contains(" "))) {
            ret = false;
        }
        return ret;
    }

    public static boolean isWindowServiceRunning(String serviceName) {
        boolean result = false;
        serviceName = quote + serviceName + quote;
        String[] script = new String[]{"cmd.exe", "/c", "sc", "query", serviceName, "|", "find", "/C", "\"RUNNING\""};
        try {
            Process checkProcess = Runtime.getRuntime().exec(script);
            int checkResult = checkProcess.waitFor();
            if (checkResult == 0) {
                result = true;
            }
        }
        catch (IOException ioe) {
            Logging.logStackTrace(ioe);
        }
        catch (InterruptedException ie) {
            Logging.logStackTrace(ie);
        }
        return result;
    }

    public static boolean stopWindowActiveService(String serviceName) {
        boolean result = false;
        serviceName = quote + serviceName + quote;
        String[] script = new String[]{"cmd.exe", "/c", "sc", "stop", serviceName};
        try {
            Process stopProcess = Runtime.getRuntime().exec(script);
            int checkResult = stopProcess.waitFor();
            if (checkResult == 0) {
                Logging.log.info("Active Windows service " + serviceName + " is stopped.");
                result = true;
            }
        }
        catch (IOException ioe) {
            Logging.logStackTrace(ioe);
        }
        catch (InterruptedException ie) {
            Logging.logStackTrace(ie);
        }
        return result;
    }

    public static boolean startWindowActiveService(String serviceName) {
        boolean result = false;
        serviceName = quote + serviceName + quote;
        String[] script = new String[]{"cmd.exe", "/c", "sc", "start", serviceName};
        try {
            Process startProcess = Runtime.getRuntime().exec(script);
            int checkResult = startProcess.waitFor();
            if (checkResult == 0) {
                Logging.log.info("Active Windows service " + serviceName + " is started.");
                result = true;
            }
        }
        catch (IOException ioe) {
            Logging.logStackTrace(ioe);
        }
        catch (InterruptedException ie) {
            Logging.logStackTrace(ie);
        }
        return result;
    }

    public static void restartWindowsServices() {
        String sServiceName = "";
        if (Globals.g_deploymentAgentStopped && !Utils.isWindowServiceRunning(sServiceName = "SAS Deployment Agent") && Utils.startWindowActiveService(sServiceName)) {
            Globals.g_deploymentAgentStopped = false;
            Logging.log.info("Active Windows Service " + sServiceName + " is re-started.");
        }
        if (Globals.g_documentConversionStopped && !Utils.isWindowServiceRunning(sServiceName = "SAS Document Conversion Server") && Utils.startWindowActiveService(sServiceName)) {
            Globals.g_documentConversionStopped = false;
            Logging.log.info("Active Windows Service " + sServiceName + " is re-started.");
        }
        if (Globals.g_pcFilesServerStopped && !Utils.isWindowServiceRunning(sServiceName = "SAS PC Files Server") && Utils.startWindowActiveService(sServiceName)) {
            Globals.g_pcFilesServerStopped = false;
            Logging.log.info("Active Windows Service " + sServiceName + " is re-started.");
        }
    }

    public static boolean startDeploymentAgentIfNotStarted() {
        boolean bResult = true;
        bResult = Utils.getOS() == 1 ? Utils.startDeploymentAgentIfNotStartedOnWindows() : Utils.startDeploymentAgentIfNotStartedOnUnix();
        return bResult;
    }

    public static boolean startDeploymentAgentIfNotStartedOnWindows() {
        boolean bResult = true;
        String agentInstallDir = Utils.getInstallDirForDeploymentAgent();
        if (agentInstallDir == null) {
            Logging.log.info("SAS Deployment Agent is not installed");
            return bResult;
        }
        String sServiceName = "SAS Deployment Agent";
        if (!Utils.isWindowServiceRunning(sServiceName) && !Utils.startWindowActiveService(sServiceName)) {
            Logging.log.info("Windows service " + sServiceName + " was not started.");
            bResult = false;
        }
        return bResult;
    }

    public static boolean startDeploymentAgentIfNotStartedOnUnix() {
        boolean bResult = true;
        String extension = ".sh";
        String osName = System.getProperty("os.name");
        if (osName.equalsIgnoreCase("z/OS")) {
            extension = "_zos.sh";
        }
        try {
            String agentInstallDir = Utils.getInstallDirForDeploymentAgent();
            if (agentInstallDir == null) {
                Logging.log.info("Deployment Agent install location not found");
                return bResult;
            }
            File agentFile = new File(agentInstallDir + "/agent" + extension);
            String script = agentFile.getCanonicalPath();
            Logging.log.info("Deployment Agent Script file, " + script);
            if (!agentFile.exists() || !agentFile.canExecute()) {
                Logging.log.info("Deployment Agent Script file, " + script + " does not exist or executable.");
                return bResult;
            }
            String[] commandStop = new String[]{script, "stop"};
            ProcessData p = Utils.runProcess(commandStop);
            String[] commandStart = new String[]{script, "start"};
            p = Utils.runProcess(commandStart);
            int rc = p.exitValue;
            if (p.getStdErr() != null) {
                Logging.log.info("script=" + script);
                String err = System.getProperty("line.separator");
                for (int i = 0; i < p.getStdErr().length; ++i) {
                    err = err + p.getStdErr()[i] + System.getProperty("line.separator");
                }
                Logging.log.info("standarderroroutput=" + err);
            }
            if (rc == 0) {
                Logging.log.info("Deployment Agent is started.");
            } else {
                Logging.log.severe("Deployment Agent could not be started!");
                bResult = false;
            }
        }
        catch (IOException ioe) {
            Logging.logStackTrace(ioe);
        }
        return bResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getInstallDirForDeploymentAgent() {
        String agentInstallDir = null;
        ProductData agentProdData = null;
        agentProdData = Globals.g_deploymentData.getProduct(Globals.g_order, "deployagent", false);
        String agentVersion = agentProdData.getProdVersion();
        File deployRegJar = new File(RegistryData.getDeployRegJar());
        if (deployRegJar.isFile()) {
            RegistryAccess m_registryAccess = null;
            try {
                m_registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                if (m_registryAccess.open()) {
                    agentInstallDir = m_registryAccess.getInstallLoc("deployagent", agentVersion);
                }
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            finally {
                if (m_registryAccess != null) {
                    m_registryAccess.close();
                    m_registryAccess = null;
                }
            }
        }
        return agentInstallDir;
    }

    public static String getHTMLLinkText(String file) {
        String linkText = "<a href=\"" + Utils.pathToURL(file) + "\">" + file + "</a>";
        return linkText;
    }

    public static int isSASLicenseValidated(String sasRootDir) {
        File sasProcNameFile;
        int result = 0;
        String sasProcName = null;
        String sasExeName = null;
        String sasExeFullPath = null;
        String tempLogDir = null;
        String sasProcDataDir = null;
        String sasLicHome = Globals.g_wizardData.getPreference("SASHome", "");
        sasProcDataDir = Globals.g_cmtTask == 40 ? Utils.joinPath(new File(Globals.g_deploymentData.getProductDir(Globals.g_order, "deploywiz", true, false)).getAbsolutePath(), "deploywiz", "data") : Utils.joinPath(new File(Globals.g_deploymentData.getProductDir(Globals.g_order, "deploywiz", false, false)).getAbsolutePath(), "deploywiz", "data");
        if (TaskHelper.getOS() == 8) {
            return 0;
        }
        if (TaskHelper.isWindows()) {
            sasExeName = "sas.exe";
        } else if (TaskHelper.isUnix()) {
            sasExeName = "bin/sas_en";
        }
        if (null != sasLicHome) {
            sasRootDir = InstallToolConnector.getHome_Base();
            sasExeFullPath = Utils.joinPath(sasRootDir, sasExeName);
            sasProcName = Utils.joinPath(sasProcDataDir, "checklic.sas");
            tempLogDir = Utils.joinPath(sasLicHome, "InstallMisc", "InstallLogs");
        }
        if (!(sasProcNameFile = new File(sasProcName)).exists()) {
            Logging.log.warning("The file " + sasProcName + " does not exist. Returning 528.");
            return 528;
        }
        String logFilename = "checksaslicense.log";
        File _logFile = new File(tempLogDir, logFilename);
        ArrayList<String> args = new ArrayList<String>();
        File sasUserDir = new File(Utils.joinPath(sasLicHome, "InstallMisc", "sasuser"));
        if (!sasUserDir.exists()) {
            sasUserDir.mkdir();
        }
        if (TaskHelper.isWindows()) {
            args.add("\"" + sasExeFullPath + "\"");
            args.add("\"" + sasProcName + "\"");
            args.add("-setinit");
            args.add("-config");
            args.add(Utils.joinPath(sasRootDir, "nls\\en\\sasv9.cfg"));
            args.add("-log");
            args.add("\"" + _logFile.getAbsolutePath() + "\"");
            args.add("-sasuser");
            args.add("\"" + sasUserDir.getAbsolutePath() + "\"");
            args.add("-icon");
            args.add("-nosplash");
            args.add("-nonotes");
            args.add("-noprngetlist");
            args.add("-unbuflog");
            args.add("-noautoexec");
            args.add("-noterminal");
            args.add("-NOQUERYPORTS");
            args.add("-filesync");
            args.add("HOST");
        } else if (TaskHelper.isUnix()) {
            args.add(sasExeFullPath);
            args.add("-config");
            args.add(Utils.joinPath(sasRootDir, "sasv9.cfg"));
            args.add("-nodms");
            args.add("-noterminal");
            args.add("-set");
            args.add("sasroot");
            args.add(sasRootDir);
            args.add("-sasuser");
            args.add(sasUserDir.getAbsolutePath());
            args.add("-msg");
            args.add(sasRootDir + "/sasmsg");
            args.add("-log");
            args.add(_logFile.getAbsolutePath());
            args.add("-filelocks");
            args.add("none");
            args.add("-nonews");
            args.add("-nonotes");
            args.add("-nodate");
            args.add("-nostimer");
            args.add("-ls");
            args.add("78");
            args.add("-filesync");
            args.add("host");
            args.add("-ps");
            args.add("60");
            args.add("-setinit");
            args.add("-noautoexec");
            args.add(sasProcName);
        }
        Logging.log.info("Arguments: " + ((Object)args).toString());
        ProcessBuilder pb = new ProcessBuilder(args);
        try {
            Process process = pb.start();
            result = process.waitFor();
        }
        catch (Exception e) {
            Controller.stackTraceForError(e);
            if (sasUserDir.exists()) {
                Utils.deleteFolder(sasUserDir);
            }
            return 528;
        }
        if (result == 1) {
            Logging.log.info("There were warning(s) in the SAS log while validating the SAS license, please see the SAS log content above for more details");
        } else if (result >= 2) {
            if (!_logFile.exists()) {
                Logging.log.info("The SAS file " + sasExeName + " failed with a return code " + result + " when it tried to validate the Base SAS license.");
                if (sasUserDir.exists()) {
                    Utils.deleteFolder(sasUserDir);
                }
                return 528;
            }
            if (Utils.findWordsFromTheLog(_logFile.getAbsolutePath())) {
                Logging.log.info("The Base SAS Software product is either not licensed for your system or the product license has expired. Please contact your SAS installation representative.");
                if (sasUserDir.exists()) {
                    Utils.deleteFolder(sasUserDir);
                }
                return 528;
            }
        }
        if (sasUserDir.exists()) {
            Utils.deleteFolder(sasUserDir);
        }
        return result;
    }

    private static boolean findWordsFromTheLog(String sLogFileName) {
        boolean bFound = false;
        File sLogFile = new File(sLogFileName);
        String textToFind = ".*license\\s+has\\s+expired.*";
        try {
            StringBuffer buf = new StringBuffer();
            Scanner scanner = new Scanner(sLogFile);
            while (scanner.hasNextLine()) {
                buf.append(scanner.nextLine());
            }
            scanner.close();
            String bufString = buf.toString();
            if (bufString.matches(textToFind)) {
                bFound = true;
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return bFound;
    }

    public static String appendToList(String list, String update) {
        TreeSet<String> prodCodeSet = Utils.listToTreeSet(list);
        prodCodeSet.add(update.toUpperCase(Locale.ENGLISH));
        return Utils.join(prodCodeSet, " ").trim();
    }

    public static String deleteFromList(String list, String update) {
        TreeSet<String> prodCodeSet = Utils.listToTreeSet(list);
        prodCodeSet.remove(update);
        return Utils.join(prodCodeSet, " ").trim();
    }

    private static TreeSet<String> listToTreeSet(String list) {
        ArrayList entries = list.isEmpty() ? new ArrayList() : new ArrayList<String>(Arrays.asList(list));
        TreeSet<String> prodCodeSet = new TreeSet<String>();
        for (String entry : entries) {
            prodCodeSet.add(entry.toUpperCase(Locale.ENGLISH));
        }
        return prodCodeSet;
    }

    public static LinkedHashSet<String> loadFileWithComments(File filename, String delim) {
        LinkedHashSet<Object> content = new LinkedHashSet();
        content = Utils.loadFile(filename);
        Iterator it = content.iterator();
        while (it.hasNext()) {
            String line = (String)it.next();
            if (!line.isEmpty() && !line.startsWith(delim)) continue;
            it.remove();
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LinkedHashSet<String> loadFile(File filename) {
        LinkedHashSet<String> fileSet = new LinkedHashSet<String>();
        BufferedReader br = null;
        String line = null;
        try {
            br = new BufferedReader(new FileReader(filename));
            while ((line = br.readLine()) != null) {
                fileSet.add(line);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return fileSet;
    }

    public static boolean isDeploywizWebOrder() {
        String order = Globals.g_deploymentData.getOrder(Globals.g_order).getOrder();
        return order != null && order.contains("deploywiz");
    }

    public static boolean isNewerVersion(String version1, String portDate1, String version2, String portDate2) {
        boolean newer = false;
        if (!(version1.equals(version2) || portDate1 == null && portDate2 == null)) {
            long time1 = 0L;
            long time2 = 0L;
            if (portDate1 != null && portDate1.length() == 9) {
                time1 = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(portDate1, new ParsePosition(0)).getTime();
            }
            if (portDate2 != null && portDate2.length() == 9) {
                time2 = new SimpleDateFormat("ddMMMyyyy", Locale.US).parse(portDate2, new ParsePosition(0)).getTime();
            }
            if (time1 > time2) {
                newer = true;
            }
        }
        return newer;
    }

    public static String getCanonicalPath(String path) {
        File file = new File(path);
        String canonicalPath = path;
        try {
            canonicalPath = file.getCanonicalPath();
        }
        catch (Exception e) {
            String msg = String.format("Unable to get the canonical path for '%s'.", canonicalPath);
            Logging.log.warning(msg);
            msg = Logging.getFormattedLogMsg(e);
            Logging.log.warning(msg);
        }
        return canonicalPath;
    }

    private static byte[] readFileBytes(File ifile) {
        byte[] fileBytes = new byte[(int)ifile.length() < 1024 ? (int)ifile.length() : 1024];
        try {
            FileInputStream fileStream = new FileInputStream(ifile);
            int bytesRead = fileStream.read(fileBytes);
            if (bytesRead < 1) {
                Logging.log.severe("Error: reading file " + ifile.getAbsolutePath());
            }
            fileStream.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fileBytes;
    }

    private static Encoding checkFile(byte[] fileBytes) {
        int asciiCount = 0;
        int ebcdicCount = 0;
        for (byte i : fileBytes) {
            if (i == 10) {
                ++asciiCount;
                continue;
            }
            if (i != 21) continue;
            ++ebcdicCount;
        }
        int total = ebcdicCount + asciiCount;
        if (ebcdicCount * 100 / total > 10 && asciiCount * 100 / total > 10) {
            return Encoding.UNKNOWN;
        }
        if (ebcdicCount > asciiCount) {
            return Encoding.EBCDIC;
        }
        return Encoding.ASCII;
    }

    public static boolean isAscii(File fileToCheck) {
        byte[] fileBytes = Utils.readFileBytes(fileToCheck);
        if (fileBytes.length == 0) {
            Logging.log.severe("Error: File contains 0 bytes");
            return false;
        }
        Encoding encoding = Utils.checkFile(fileBytes);
        return encoding == Encoding.ASCII;
    }

    public static boolean convertToEbcdic(File fileToConvert) {
        Path ipath = Paths.get(fileToConvert.getAbsolutePath(), new String[0]);
        Path opath = Paths.get(fileToConvert.getAbsolutePath() + "ebcdic", new String[0]);
        long fileSize = fileToConvert.length();
        long transferred = 0L;
        Logging.log.finer("Converting file " + fileToConvert.getAbsolutePath() + " from ASCII to EBCDIC");
        try {
            int nRead;
            CharsetDecoder decoder = Charset.forName("UTF-8").newDecoder();
            decoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("?");
            InputStreamReader _reader = new InputStreamReader(Files.newInputStream(ipath, StandardOpenOption.READ), decoder);
            BufferedReader reader = new BufferedReader(_reader);
            CharsetEncoder encoder = Charset.forName("CP1047").newEncoder();
            encoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith("o".getBytes());
            OutputStreamWriter _writer = new OutputStreamWriter(Files.newOutputStream(opath, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), encoder);
            BufferedWriter writer = new BufferedWriter(_writer);
            char[] buffer = new char[1024];
            while ((nRead = reader.read(buffer, 0, 1024)) >= 0) {
                writer.write(buffer, 0, nRead);
                transferred += (long)nRead;
            }
            reader.close();
            writer.close();
        }
        catch (Exception e) {
            Logging.log.severe("Error: Failed to convert ASCII file to EBCDIC");
            Logging.logStackTrace(e);
            return false;
        }
        if (transferred != fileSize) {
            Logging.log.severe("Error: Tranfered number of bytes does not match size of input file.");
            return false;
        }
        try {
            Files.move(opath, ipath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            Logging.log.severe("Error: Failed to replace original ASCII file with EBCDIC version");
            Logging.logStackTrace(e);
            return false;
        }
        return true;
    }

    public static void removeBlankLines(File file) {
        FileReader inFile = null;
        BufferedReader in = null;
        String crlf = System.getProperty("line.separator");
        try {
            inFile = new FileReader(file);
            in = new BufferedReader(inFile);
            String line = "";
            Vector<String> buffer = new Vector<String>();
            while (in.ready()) {
                line = in.readLine();
                if (line == null || line.isEmpty() || Utils.isLineAllWhiteSpace(line)) continue;
                buffer.add(line);
            }
            in.close();
            inFile.close();
            BufferedWriter output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            for (String bufferLine : buffer) {
                if (bufferLine.endsWith(crlf)) {
                    output.write(bufferLine);
                    continue;
                }
                output.write(bufferLine + crlf);
            }
            output.close();
        }
        catch (Exception e) {
            Logging.log.info(e.getMessage());
            Logging.logStackTrace(e);
        }
    }

    private static boolean isLineAllWhiteSpace(String line) {
        String test = new String(line);
        return test.trim().isEmpty();
    }

    public static class ProcessData {
        int exitValue;
        String[] cmd;
        String[] stdOutput;
        String[] stdError;

        ProcessData(String[] cmd, int value, String[] output, String[] error) {
            this.cmd = cmd;
            this.exitValue = value;
            this.stdOutput = output;
            this.stdError = error;
        }

        public int getExitValue() {
            return this.exitValue;
        }

        public String[] getStdOutput() {
            return this.stdOutput;
        }

        public String[] getStdErr() {
            return this.stdError;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("Executed: " + Utils.concatArray(this.cmd, " ") + "\n");
            sb.append("Return code(" + this.exitValue + "):\n");
            if (this.stdOutput != null) {
                sb.append(Utils.concatArray(this.stdOutput, "\n"));
            }
            if (this.stdError != null) {
                sb.append(Utils.concatArray(this.stdError, "\n"));
            }
            return sb.toString();
        }
    }

    static enum Encoding {
        ASCII,
        EBCDIC,
        UNKNOWN;

    }
}

