/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Unzip {
    private static byte[] buf = new byte[262144];

    public static void getAll(String sourceFile, String targetDir) throws FileNotFoundException, ZipException, IOException {
        Unzip.getAll(new File(sourceFile), targetDir);
    }

    public static void getAll(File sourceFile, String targetDir) throws FileNotFoundException, ZipException, IOException {
        try (ZipFile zipFile = new ZipFile(sourceFile);){
            Enumeration<? extends ZipEntry> files = zipFile.entries();
            while (files.hasMoreElements()) {
                Unzip.extract(zipFile, files.nextElement(), targetDir);
            }
        }
    }

    public static void getEntry(String sourceFile, String entry, String targetDir) throws FileNotFoundException, ZipException, IOException {
        Unzip.getEntry(new File(sourceFile), entry, targetDir);
    }

    public static void getEntry(File sourceFile, String entry, String targetDir) throws FileNotFoundException, ZipException, IOException {
        try (ZipFile zipFile = new ZipFile(sourceFile);){
            Unzip.extract(zipFile, new ZipEntry(entry), targetDir);
        }
    }

    public static String getEntryPath(File sourceFile, String entry, String targetDir) throws FileNotFoundException, ZipException, IOException {
        ZipFile zipFile = new ZipFile(sourceFile);
        Enumeration<? extends ZipEntry> files = zipFile.entries();
        ZipEntry zipEntry = null;
        String path = null;
        while (files.hasMoreElements()) {
            zipEntry = files.nextElement();
            File file = new File(zipEntry.getName());
            String basename = file.getName();
            if (!basename.equals(entry)) continue;
            path = file.getParent();
            break;
        }
        zipFile.close();
        return path;
    }

    private static void extract(ZipFile zipFile, ZipEntry entry, String targetDir) throws ZipException, IOException {
        File file = new File(targetDir + System.getProperty("file.separator") + entry.getName());
        if (entry.isDirectory()) {
            file.mkdirs();
        } else {
            InputStream is = zipFile.getInputStream(entry);
            String parent = file.getParent();
            if (parent != null) {
                new File(parent).mkdirs();
            }
            FileOutputStream os = new FileOutputStream(file);
            try {
                int n;
                while ((n = is.read(buf)) > -1) {
                    os.write(buf, 0, n);
                    if (Globals.g_mode != 1) continue;
                    Globals.g_esdStats.addToTask("EXTRACT", n);
                }
            }
            catch (ZipException e) {
                Logging.log.info(zipFile.getName() + " has format error.");
                throw e;
            }
            catch (IOException e) {
                Logging.log.info(zipFile.getName() + " has I/O error.");
                throw e;
            }
            finally {
                os.close();
                is.close();
            }
        }
        if (!file.setLastModified(entry.getTime())) {
            Logging.log.severe("setLastModified failed for file " + file.getCanonicalPath());
            throw new IOException("setLastModified failed for file " + file.getCanonicalPath());
        }
    }

    private static boolean isPrivateJre(String path) {
        path = path.replace("\\", "/");
        String zipName = path.substring(path.lastIndexOf("/") + 1);
        return zipName.startsWith("jre_");
    }
}

