/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.PropsParser;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.UnicodeInputStream;
import com.sas.ssn.Utils;
import com.sas.tools.deployjni.winregistry.WinRegAPI;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ThirdParty {
    public static final int LEVEL_RECOMMENDED = 0;
    public static final int LEVEL_ACCEPTED = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_INVALID = -1;
    private static String m_jvmType;

    public static String getRecommendedVersion(String prodCode) {
        String version = "";
        SpsSkuData spsSkuData = Globals.g_deploymentData.getSpsSkuByProdCode(Globals.g_order, prodCode, Utils.getOS_Suffix(), false);
        String recommended = spsSkuData.getRecommendedVersion(Utils.getOS_Suffix());
        String[] recVers = spsSkuData.getQueries(Utils.getOS_Suffix());
        if (recommended.length() > 0) {
            version = recommended;
        } else if (prodCode.equalsIgnoreCase("javaruntime") && Utils.getOS() == 5) {
            version = "1.5_SR5";
        } else if (recVers.length > 0) {
            version = recVers[0];
        }
        return version;
    }

    public static String getInstalledPath(String prodCode) {
        return ThirdParty.getInstalledPath(null, prodCode, null);
    }

    public static String getInstalledPath(String order, String prodCode, String levCheckFileName) {
        Logging.log.info("getInstalledPath for order=" + order + " prodCode=" + prodCode + " levCheckFileName=" + levCheckFileName);
        String path = null;
        String[] recVers = null;
        if (levCheckFileName != null) {
            ArrayList<String> recVersions = new ArrayList<String>();
            String prodDataDir = Globals.g_deploymentData.getProductDataDir(order, prodCode, true, false);
            File levCheckFile = new File(prodDataDir, levCheckFileName);
            if (levCheckFile.isFile()) {
                try {
                    Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(levCheckFile)).getDocumentElement();
                    NodeList nodes = root.getElementsByTagName("platform");
                    Element node = null;
                    String plat = null;
                    boolean found = false;
                    for (int i = 0; !found && i < nodes.getLength(); ++i) {
                        node = (Element)nodes.item(i);
                        plat = node.getAttribute("id");
                        if (!plat.equalsIgnoreCase(Utils.getOS_Suffix())) continue;
                        found = true;
                        NodeList queries = node.getElementsByTagName("queries");
                        for (int j = 0; j < queries.getLength(); ++j) {
                            node = (Element)queries.item(j);
                            NodeList query = node.getElementsByTagName("query");
                            for (int k = 0; k < query.getLength(); ++k) {
                                node = (Element)query.item(k);
                                String ver = node.getAttribute("ver");
                                if (ver == null) continue;
                                recVersions.add(ver);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
            }
            recVers = recVersions.toArray(new String[0]);
        } else {
            recVers = Globals.g_deploymentData.getSpsSkuByProdCode(Globals.g_order, prodCode, Utils.getOS_Suffix(), false).getQueries(Utils.getOS_Suffix());
        }
        for (int i = 0; i < recVers.length && path == null; ++i) {
            String keyFile;
            String osSuffix;
            if (prodCode.equalsIgnoreCase("javaruntime")) {
                osSuffix = Utils.getOS_Suffix();
                if (osSuffix.equals("win")) {
                    keyFile = WinRegAPI.getWinRegValue32(8, "SOFTWARE\\JavaSoft\\Java Runtime Environment\\" + recVers[i], "RuntimeLib");
                    if (keyFile == null || keyFile.length() <= 0 || !new File(keyFile).isFile()) continue;
                    path = WinRegAPI.getWinRegValue32(8, "SOFTWARE\\JavaSoft\\Java Runtime Environment\\" + recVers[i], "JavaHome");
                    continue;
                }
                if (osSuffix.equals("wx6")) {
                    File tempfile;
                    keyFile = WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\JavaSoft\\Java Runtime Environment\\" + recVers[i], "RuntimeLib");
                    if (keyFile == null || keyFile.length() <= 0 || (tempfile = new File(keyFile)).exists()) continue;
                    path = WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\JavaSoft\\Java Runtime Environment\\" + recVers[i], "JavaHome");
                    continue;
                }
                if (osSuffix.equals("w64")) {
                    keyFile = WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\JRockit\\Java Runtime Environment\\" + recVers[i], "RuntimeLib");
                    if (keyFile == null || keyFile.length() <= 0 || !new File(keyFile).isFile()) continue;
                    path = WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\JRockit\\Java Runtime Environment\\" + recVers[i], "JavaHome");
                    continue;
                }
                path = ThirdParty.checkPath(prodCode, Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "jre" + ThirdParty.getRecommendedVersion("javaruntime")), recVers[i]);
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "jre" + recVers[i]), recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "jre1.5"), recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "SAS_9.2/sasjre", recVers[i]), recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/local/SAS/SAS_9.2/sasjre/5.0.03", recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/local/SAS/SAS_9.2/sasjre/5.0.0.50/jre", recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/local/SAS/SAS_9.2/sasjre/5.0.0.80/jre", recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/opt/sasjre", recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/sasjre", recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/jre" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/jdk" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/jdk/jdk" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/opt/java1.5", recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/java5", recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/java5_64", recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/java", recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/local/jre" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/local/jdk" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/local/jdk/jdk" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/opt/jre" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/opt/jdk" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/opt/jdk/jdk" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(System.getProperty("user.home"), "jre" + recVers[i]), recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(System.getProperty("user.home"), "jdk" + recVers[i]), recVers[i]);
                }
                if (path != null) continue;
                path = ThirdParty.checkPath(prodCode, Utils.joinPath(System.getProperty("user.home"), "jdk/jdk" + recVers[i]), recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("jdk")) {
                osSuffix = Utils.getOS_Suffix();
                if (osSuffix.equals("win") || osSuffix.equals("wx6")) {
                    String javaHome = null;
                    javaHome = osSuffix.equals("wx6") ? WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\JavaSoft\\Java Development Kit\\" + recVers[i], "JavaHome") : WinRegAPI.getWinRegValue32(8, "SOFTWARE\\JavaSoft\\Java Development Kit\\" + recVers[i], "JavaHome");
                    String keyFile2 = Utils.joinPath(javaHome, "bin", "java.exe");
                    if (keyFile2 == null || keyFile2.length() <= 0 || !new File(keyFile2).isFile()) continue;
                    path = javaHome;
                    continue;
                }
                if (osSuffix.equals("w64")) {
                    String javaHome;
                    keyFile = WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\JRockit\\Java Development Kit\\" + recVers[i], "RuntimeLib");
                    if (keyFile != null && keyFile.length() > 0 && new File(keyFile).isFile()) {
                        path = WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\JRockit\\Java Development Kit\\" + recVers[i], "JavaHome");
                    }
                    if (path != null || (keyFile = Utils.joinPath(javaHome = WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\JavaSoft\\Java Development Kit\\" + recVers[i], "JavaHome"), "bin", "java.exe")) == null || keyFile.length() <= 0 || !new File(keyFile).isFile()) continue;
                    path = javaHome;
                    continue;
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/jdk" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/jdk/jdk" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/opt/java1.5", recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/java5", recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/java5_64", recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/java", recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/local/jdk" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/local/jdk/jdk" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/opt/jdk" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/opt/jdk/jdk" + recVers[i], recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(System.getProperty("user.home"), "jdk" + recVers[i]), recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(System.getProperty("user.home"), "jdk/jdk" + recVers[i]), recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/opt/java1.6", recVers[i]);
                }
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, "/usr/java6", recVers[i]);
                }
                if (path != null) continue;
                path = ThirdParty.checkPath(prodCode, "/usr/java6_64", recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("jboss")) {
                int os = Utils.getOS();
                if (os == 1) {
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(Utils.getProgramFilesDir(), "jboss-4.0.4.GA"), recVers[i]);
                    continue;
                }
                path = ThirdParty.checkPath(prodCode, Utils.joinPath(System.getProperty("user.home"), "jboss-4.0.4.GA"), recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("weblogic")) {
                int os = Utils.getOS();
                if (os == 1) {
                    if (path != null && path.length() > 0) {
                        path = Utils.joinPath(path, "wlserver");
                        continue;
                    }
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(Globals.g_windowsSystemDrive, "bea"), recVers[i]);
                    continue;
                }
                path = ThirdParty.checkPath(prodCode, Utils.joinPath(System.getProperty("user.home"), "bea"), recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("websphereba")) {
                int os = Utils.getOS();
                if (os == 1) {
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(Utils.getProgramFilesDir(), "IBM\\WebSphere\\AppServer"), recVers[i]);
                    continue;
                }
                if (os == 5) {
                    path = ThirdParty.checkPath(prodCode, "/usr/IBM/WebSphere/AppServer", recVers[i]);
                    if (path != null) continue;
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(System.getProperty("user.home"), "IBM/WebSphere/AppServer"), recVers[i]);
                    continue;
                }
                path = ThirdParty.checkPath(prodCode, "/opt/IBM/WebSphere/AppServer", recVers[i]);
                if (path != null) continue;
                path = ThirdParty.checkPath(prodCode, Utils.joinPath(System.getProperty("user.home"), "IBM/WebSphere/AppServer"), recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("webspherend")) {
                int os = Utils.getOS();
                if (os == 1) {
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(Utils.getProgramFilesDir(), "IBM\\WebSphere\\AppServer"), recVers[i]);
                    continue;
                }
                if (os == 5) {
                    path = ThirdParty.checkPath(prodCode, "/usr/IBM/WebSphere/AppServer", recVers[i]);
                    if (path != null) continue;
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(System.getProperty("user.home"), "IBM/WebSphere/AppServer"), recVers[i]);
                    continue;
                }
                path = ThirdParty.checkPath(prodCode, "/opt/IBM/WebSphere/AppServer", recVers[i]);
                if (path != null) continue;
                path = ThirdParty.checkPath(prodCode, Utils.joinPath(System.getProperty("user.home"), "IBM/WebSphere/AppServer"), recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("mysqldbs")) {
                osSuffix = Utils.getOS_Suffix();
                if (osSuffix.equals("win") || osSuffix.equals("wx6")) {
                    path = WinRegAPI.getWinRegValue32(8, "SOFTWARE\\MySQL AB\\MySQL Server " + recVers[i], "Location");
                    if (path == null) {
                        path = ThirdParty.checkPath(prodCode, Utils.joinPath(Utils.getProgramFilesDir(), "MySQL\\MySQL Server "), recVers[i]);
                        continue;
                    }
                    if (path != null) continue;
                    path = ThirdParty.checkPath(prodCode, "c:\\mysql", recVers[i]);
                    continue;
                }
                if (osSuffix.equals("w64")) {
                    path = WinRegAPI.getWindowsRegistryValue(8, "SOFTWARE\\MySQL AB\\MySQL Server" + recVers[i] + "\\", "Location");
                    if (path != null) continue;
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(Utils.getProgramFilesDir(), "MySQL\\MySQL Server"), recVers[i]);
                    continue;
                }
                path = ThirdParty.checkPath(prodCode, "/usr/mysql", recVers[i]);
                if (path != null) continue;
                path = ThirdParty.checkPath(prodCode, Utils.joinPath(System.getProperty("user.home"), "mysql-pro-"), recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("mysqljdbc")) {
                if (Utils.getOS() == 1) {
                    path = Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), "MySQLConnectorJ");
                }
                path = ThirdParty.checkPath(prodCode, path, recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("mysqllib")) {
                if (Utils.getOS() == 1) {
                    path = Utils.joinPath(Utils.getProgramFilesDir(), "MySQL\\MySQL Server 5.0\\bin");
                }
                path = ThirdParty.checkPath(prodCode, path, recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("platformpm")) {
                if (Utils.getOS() == 1) {
                    Logging.log.fine("ProgramFilesDir=" + Utils.getProgramFilesDir());
                    path = Utils.joinPath(Utils.getProgramFilesDir(), "Platform Computing\\Platform Process Manager", recVers[i]);
                    if (path != null) {
                        Logging.log.fine("pm_path=" + path);
                        path = ThirdParty.checkPath(prodCode, path, recVers[i]);
                    }
                    if (path != null) continue;
                    String pmHome = System.getenv("JS_HOME");
                    String pmVersion = System.getenv("JS_VERSION");
                    if (pmVersion != null && pmHome != null) {
                        Logging.log.fine("pmHome=" + pmHome);
                    }
                    Logging.log.fine("pmVersion=" + pmVersion);
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(pmHome, pmVersion), recVers[i]);
                    continue;
                }
                path = ThirdParty.checkPath(prodCode, Utils.joinPath("/usr/local/platformpm", recVers[i]), recVers[i]);
                if (path == null) {
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath("/usr/share/platformpm", recVers[i]), recVers[i]);
                }
                if (path != null) continue;
                path = ThirdParty.checkPath(prodCode, Utils.joinPath("/usr/share/Platform_Computing/Platform_Process_Manager", recVers[i]), recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("platformlsf")) {
                String lsfEnvDir = System.getenv("LSF_ENVDIR");
                Logging.log.fine("lsfEnvDir= " + lsfEnvDir);
                File tmppath = null;
                if (lsfEnvDir != null && lsfEnvDir != "") {
                    tmppath = new File(lsfEnvDir);
                    if (tmppath.isDirectory()) {
                        path = tmppath.getAbsolutePath();
                    } else {
                        Logging.log.info("LSF directory " + tmppath + " does not exist or is not readable.");
                    }
                }
                if (path == null) {
                    path = Utils.getOS() == 1 ? "c:\\LSF\\conf" : "/usr/share/lsf";
                }
                path = ThirdParty.checkPath(prodCode, path, recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("platformgms")) {
                if (Utils.getOS() == 1) {
                    path = Utils.joinPath("c:\\LSF_" + recVers[i], "gms");
                    path = ThirdParty.checkPath(prodCode, path, recVers[i]);
                    continue;
                }
                path = Utils.joinPath("/usr/share/lsf", recVers[i], "gms");
                path = ThirdParty.checkPath(prodCode, path, recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("platformmpi")) {
                if (Utils.getOS() == 1) {
                    Logging.log.fine("ProgramFilesDir=" + Utils.getProgramFilesDir());
                    path = Utils.joinPath(Utils.getProgramFilesDir(), "Platform Computing\\Platform-MPI");
                    continue;
                }
                path = ThirdParty.checkPath(prodCode, "/opt/platform_mpi", recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("wasmq")) {
                int os = Utils.getOS();
                if (os == 1) {
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(Utils.getProgramFilesDir(), "IBM\\WebSphere MQ"), recVers[i]);
                    continue;
                }
                path = ThirdParty.checkPath(prodCode, "/opt/mqm", recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("wasmqclnt")) {
                int os = Utils.getOS();
                if (os == 1) {
                    path = ThirdParty.checkPath(prodCode, Utils.joinPath(Utils.getProgramFilesDir(), "IBM\\WebSphere MQ"), recVers[i]);
                    continue;
                }
                path = ThirdParty.checkPath(prodCode, "/opt/mqm", recVers[i]);
                continue;
            }
            if (prodCode.equalsIgnoreCase("autocad")) {
                path = Utils.joinPath(Utils.getProgramFilesDir(), "AutoCAD " + recVers[i]);
                if (new File(path).isDirectory()) {
                    String version = ThirdParty.getVersion(prodCode, path);
                    if (version != null && ThirdParty.getLevel(prodCode, version) >= 0) continue;
                    path = null;
                    continue;
                }
                path = null;
                continue;
            }
            if (prodCode.equalsIgnoreCase("pythoncfg")) {
                path = ThirdParty.getPythonPath(path);
                continue;
            }
            if (!prodCode.equalsIgnoreCase("powershell2")) continue;
            path = ThirdParty.getPowerShellPath();
        }
        Logging.log.info("getInstalledPath returned path=" + path);
        return path;
    }

    private static String getPythonPath(String path) {
        String pythonpath = null;
        pythonpath = ThirdParty.PythonScript(path, "PATH");
        if (pythonpath != null) {
            File temp = new File(pythonpath);
            if (temp.exists()) {
                if (temp.isFile()) {
                    pythonpath = temp.getParent();
                    Logging.log.fine("python path=" + pythonpath);
                } else {
                    Logging.log.warning("pythonpath is not a file.  pythonpath='" + pythonpath + "'");
                }
            } else {
                Logging.log.warning("pythonpath doesn't exist.  pythonpath='" + pythonpath + "'");
            }
        } else {
            Logging.log.warning("pythonpath is null.  Input was path='" + path + "'");
        }
        return pythonpath;
    }

    private static String getPowerShellPath() {
        String pspath = null;
        String regPathOld = "SOFTWARE\\Microsoft\\PowerShell\\1\\PowerShellEngine";
        String regPathNewer = "SOFTWARE\\Microsoft\\PowerShell\\3\\PowerShellEngine";
        String regKey = "ApplicationBase";
        String osSuffix = Utils.getOS_Suffix();
        if (osSuffix.equals("wx6")) {
            pspath = WinRegAPI.getWindowsRegistryValue(8, regPathNewer, regKey);
        } else if (osSuffix.equals("win")) {
            pspath = WinRegAPI.getWinRegValue32(8, regPathNewer, regKey);
        }
        if (pspath != null && pspath.length() > 0) {
            return pspath;
        }
        if (osSuffix.equals("wx6")) {
            pspath = WinRegAPI.getWindowsRegistryValue(8, regPathOld, regKey);
        } else if (osSuffix.equals("win")) {
            pspath = WinRegAPI.getWinRegValue32(8, regPathOld, regKey);
        }
        if (pspath == null || pspath.length() == 0) {
            pspath = null;
        }
        return pspath;
    }

    private static String getPowerShellVersion() {
        String psversion = null;
        String regPathOld = "SOFTWARE\\Microsoft\\PowerShell\\1\\PowerShellEngine";
        String regPathNewer = "SOFTWARE\\Microsoft\\PowerShell\\3\\PowerShellEngine";
        String regKey = "PowerShellVersion";
        String osSuffix = Utils.getOS_Suffix();
        if (osSuffix.equals("wx6")) {
            psversion = WinRegAPI.getWindowsRegistryValue(8, regPathNewer, regKey);
        } else if (osSuffix.equals("win")) {
            psversion = WinRegAPI.getWinRegValue32(8, regPathNewer, regKey);
        }
        if (psversion != null && psversion.length() > 0) {
            return psversion;
        }
        if (osSuffix.equals("wx6")) {
            psversion = WinRegAPI.getWindowsRegistryValue(8, regPathOld, regKey);
        } else if (osSuffix.equals("win")) {
            psversion = WinRegAPI.getWinRegValue32(8, regPathOld, regKey);
        }
        if (psversion == null || psversion.length() == 0) {
            psversion = null;
        }
        return psversion;
    }

    private static String checkPath(String prodCode, String path, String recVer) {
        String validPath = null;
        if (path == null) {
            Logging.log.fine("path in checkPath is null");
            return null;
        }
        if (new File(path).isDirectory()) {
            String version = ThirdParty.getVersion(prodCode, path);
            if (version != null && version.equals(recVer)) {
                validPath = path;
                if (prodCode.equalsIgnoreCase("javaruntime") && !ThirdParty.verifyJreFunction(path)) {
                    validPath = null;
                }
            }
        } else {
            Logging.log.info("LSF directory " + path + " does not exist or is not readable.");
        }
        return validPath;
    }

    public static String getVersion(String prodCode, String path) {
        return ThirdParty.getVersion(prodCode, path, false);
    }

    /*
     * Unable to fully structure code
     */
    public static String getVersion(String prodCode, String path, boolean majorVersion) {
        block124: {
            Logging.log.info("get version for prodCode=" + prodCode + " path=" + path + " majorVersion=" + majorVersion);
            version = null;
            if (prodCode.equalsIgnoreCase("javaruntime")) {
                if (Utils.getOS() == 5) {
                    java = new File(path, "bin/java");
                    if (java.isFile()) {
                        try {
                            output = Utils.joinPath(Globals.g_tempLocation, ".jrever");
                            script = Utils.joinPath(Globals.g_tempLocation, "jrescript");
                            scriptFile = new File(script);
                            out = new PrintStream(new FileOutputStream(scriptFile));
                            out.println("#!/bin/sh");
                            out.println("if [ -f " + output + " ]; then ");
                            out.println("  rm -f " + output);
                            out.println("fi");
                            out.println("export LANG=en_US");
                            out.println(java.getPath() + " -fullversion 1>" + output + " 2>&1");
                            out.close();
                            cmd = new String[]{"chmod", "755", script};
                            scriptProc = Runtime.getRuntime().exec(cmd);
                            scriptProc.waitFor();
                            scriptProc = null;
                            cmd = new String[]{"/bin/sh", "-c", script};
                            javaVer = Runtime.getRuntime().exec(cmd);
                            javaVer.waitFor();
                            if (scriptFile.isFile() && !Globals.g_debug) {
                                scriptFile.delete();
                            }
                            if ((outputFile = new File(output)).isFile()) {
                                in = new BufferedReader(new FileReader(outputFile));
                                line = in.readLine();
                                if (line != null) {
                                    firstQuote = line.indexOf("\"");
                                    lastQuote = line.indexOf("\"", firstQuote + 1);
                                    if (firstQuote > -1 && lastQuote > -1) {
                                        version = line.substring(firstQuote + 1, lastQuote);
                                    } else {
                                        substring = "java full version jre";
                                        if (line.toLowerCase().startsWith(substring)) {
                                            beginning_version = substring.length() + 1;
                                            end_version = line.indexOf(" ", beginning_version + 1);
                                            version = line.substring(beginning_version, end_version);
                                        }
                                    }
                                }
                                in.close();
                                if (!Globals.g_debug) {
                                    outputFile.delete();
                                }
                            }
                        }
                        catch (Exception e) {
                            Logging.log.warning("Error checking JRE version: " + java.getPath());
                            Logging.logStackTrace(e);
                        }
                    }
                } else {
                    keyFile = new File(Utils.joinPath(path, "lib", "rt.jar"));
                    if (keyFile.isFile()) {
                        try {
                            jf = new JarFile(keyFile);
                            if (majorVersion) {
                                version = jf.getManifest().getMainAttributes().getValue("Specification-Version").trim();
                                break block124;
                            }
                            version = jf.getManifest().getMainAttributes().getValue("Implementation-Version").trim();
                        }
                        catch (Exception e) {
                            Logging.log.warning("Error checking manifest for jar: " + keyFile.toString());
                            Logging.logStackTrace(e);
                        }
                    }
                }
            } else if (prodCode.equalsIgnoreCase("jdk")) {
                if (Utils.getOS() == 1) {
                    if (new File(path, "bin/javac.exe").isFile()) {
                        version = ThirdParty.getVersion("javaruntime", path + "/jre", majorVersion);
                    }
                } else if (Utils.getOS() == 5) {
                    if (new File(path, "bin/javac").isFile()) {
                        version = ThirdParty.getVersion("javaruntime", path, majorVersion);
                    }
                } else if (new File(path, "bin/javac").isFile()) {
                    version = ThirdParty.getVersion("javaruntime", path + "/jre", majorVersion);
                }
            } else if (prodCode.equalsIgnoreCase("jboss")) {
                version = ThirdParty.getJarVersion(Utils.joinPath(path, "bin/run.jar"), "Implementation-Version");
                if (version != null) {
                    if (majorVersion && version.length() > 3) {
                        version = version.substring(0, 3);
                    }
                } else {
                    version = ThirdParty.getJarVersion(Utils.joinPath(path, "bin/client/jboss-client.jar"), "Implementation-Version");
                    if (version != null && majorVersion && version.length() > 3) {
                        version = version.substring(0, 3);
                    }
                }
                j = 0;
                jarfile = null;
                for (i = 0; version == null && i < 9; ++i) {
                    for (j = 0; version == null && j <= 9; ++j) {
                        jarfile = "jboss-as-server-7." + i + "." + j + ".Final.jar";
                        version = ThirdParty.getJarVersion(Utils.joinPath(path, "modules/org/jboss/as/server/main", jarfile), "Implementation-Version");
                        if (version == null || !majorVersion || version.length() <= 3) continue;
                        version = version.substring(0, 3);
                    }
                }
            } else if (prodCode.equalsIgnoreCase("weblogic")) {
                validPath = true;
                specificPath = true;
                beaHome = ThirdParty.getBEAHomePath(path);
                if (beaHome == null) {
                    specificPath = false;
                    beaHome = path;
                }
                if ((registryFile = new File(beaHome, "registry.xml")).isFile()) {
                    try {
                        root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(registryFile)).getDocumentElement();
                        data = root.getElementsByTagName("release");
                        if (data == null) ** GOTO lbl363
                        level = null;
                        sp = null;
                        patch = null;
                        installDir = null;
                        compInstallDir = null;
                        element = null;
                        parent = null;
                        components = null;
                        for (i = 0; validPath && i < data.getLength(); ++i) {
                            element = (Element)data.item(i);
                            parent = (Element)element.getParentNode();
                            if (!"product".equals(parent.getTagName()) || !"WebLogic Platform".equals(parent.getAttribute("name"))) continue;
                            level = element.getAttribute("level");
                            sp = element.getAttribute("ServicePackLevel");
                            patch = element.getAttribute("PatchLevel");
                            installDir = element.getAttribute("InstallDir");
                            if (level.equals("10.2")) {
                                level = "10.0";
                            }
                            components = element.getElementsByTagName("component");
                            for (j = 0; validPath && j < components.getLength(); ++j) {
                                element = (Element)components.item(j);
                                parent = (Element)element.getParentNode();
                                if (!"component".equals(parent.getTagName()) || !"WebLogic Server".equals(parent.getAttribute("name")) || !"Server".equals(element.getAttribute("name")) && !"Core Application Server".equals(element.getAttribute("name"))) continue;
                                compInstallDir = parent.getAttribute("InstallDir");
                                if (compInstallDir != null && compInstallDir.length() > 0) {
                                    installDir = compInstallDir;
                                }
                                if (!specificPath && version != null) {
                                    validPath = false;
                                    version = null;
                                    continue;
                                }
                                if ((Utils.getOS() != 1 || !path.equalsIgnoreCase(installDir)) && !path.equals(installDir) && specificPath) continue;
                                version = majorVersion != false ? level : level + "_" + sp + "_" + patch;
                            }
                        }
                    }
                    catch (Exception e) {
                        Logging.log.warning("Error parsing XML file: " + registryFile.getAbsolutePath());
                        Logging.logStackTrace(e);
                    }
                } else {
                    libFile = new File(Utils.joinPath(path, "modules", "clients"));
                    fileList = libFile.listFiles();
                    if (fileList != null && fileList.length != 0) {
                        for (fileCount = 0; version == null && fileCount < fileList.length; ++fileCount) {
                            keyFile = fileList[fileCount];
                            Logging.log.info("weblogic fileList = " + fileList.toString());
                            if (!keyFile.isFile() || !keyFile.getName().contains("com.oracle.webservices.wls.jaxws-wlswss-client")) continue;
                            try {
                                jf = new JarFile(keyFile);
                                Logging.log.info("weblogic keyFile = " + keyFile.getCanonicalPath());
                                version = jf.getManifest().getMainAttributes().getValue("Implementation-Version").trim();
                                Logging.log.info("weblogic version = " + version);
                                if (majorVersion && version.length() > 3) {
                                    version = version.substring(0, 3);
                                }
                                Logging.log.info("weblogic majorVersion = " + version);
                                continue;
                            }
                            catch (Exception e) {
                                Logging.log.info("Error checking manifest for jar: " + keyFile.getAbsolutePath());
                                Logging.logStackTrace(e);
                            }
                        }
                    }
                }
            } else if (prodCode.equalsIgnoreCase("websphereba")) {
                keyFile = new File(path, "properties/version/WAS.product");
                if (keyFile.isFile()) {
                    try {
                        dbf = DocumentBuilderFactory.newInstance();
                        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
                        root = dbf.newDocumentBuilder().parse(new UnicodeInputStream(keyFile)).getDocumentElement();
                        data = root.getElementsByTagName("id");
                        if (data.getLength() == 1 && "BASE".equals(data.item(0).getFirstChild().getNodeValue()) && (data = root.getElementsByTagName("version")).getLength() == 1) {
                            version = data.item(0).getFirstChild().getNodeValue();
                        }
                    }
                    catch (Exception e) {
                        Logging.log.warning("Error parsing XML file: " + keyFile.getAbsolutePath());
                        Logging.logStackTrace(e);
                    }
                }
            } else if (prodCode.equalsIgnoreCase("webspherend")) {
                keyFile = new File(path, "properties/version/WAS.product");
                if (keyFile.isFile()) {
                    try {
                        dbf = DocumentBuilderFactory.newInstance();
                        dbf.setAttribute("http://apache.org/xml/features/nonvalidating/load-external-dtd", Boolean.FALSE);
                        root = dbf.newDocumentBuilder().parse(new UnicodeInputStream(keyFile)).getDocumentElement();
                        data = root.getElementsByTagName("id");
                        if (data.getLength() == 1 && "ND".equals(data.item(0).getFirstChild().getNodeValue()) && (data = root.getElementsByTagName("version")).getLength() == 1) {
                            version = data.item(0).getFirstChild().getNodeValue();
                        }
                    }
                    catch (Exception e) {
                        Logging.log.warning("Error parsing XML file: " + keyFile.getAbsolutePath());
                        Logging.logStackTrace(e);
                    }
                }
            } else if (prodCode.equalsIgnoreCase("mysqldbs")) {
                command = new String[2];
                if (Utils.getOS() == 1) {
                    command[0] = Utils.joinPath(path, "bin", "mysql.exe");
                }
                if (Utils.getOS() != 1) {
                    command[0] = Utils.joinPath(path, "bin", "mysql");
                }
                command[1] = "--version";
                try {
                    p = Runtime.getRuntime().exec(command);
                    pin = p.getInputStream();
                    cin = new InputStreamReader(pin);
                    in = new BufferedReader(cin);
                    line = in.readLine();
                    if (line != null) {
                        begin = line.indexOf("Distrib") + 8;
                        end = line.indexOf(",", begin);
                        if (begin > -1 && end > -1) {
                            version = line.substring(begin, end);
                        }
                    }
                    in.close();
                }
                catch (IOException e) {
                    Logging.log.info("Get mysql version failed: " + command);
                    Logging.logStackTrace(e);
                    e.printStackTrace();
                }
            } else if (prodCode.equalsIgnoreCase("mysqljdbc")) {
                lstFiles = new File(path).listFiles();
                keyFile = null;
                if (lstFiles != null) {
                    for (i = 0; i < lstFiles.length && keyFile == null; ++i) {
                        if (!lstFiles[i].isFile() || !(filename = lstFiles[i].getName()).startsWith("mysql-connector") || !filename.endsWith(".jar")) continue;
                        keyFile = lstFiles[i];
                    }
                }
                if (keyFile != null) {
                    try {
                        my_manifest = new JarFile(keyFile).getManifest();
                        version = my_manifest.getMainAttributes().getValue("Implementation-Version");
                        if (version == null) {
                            version = my_manifest.getEntries().get("common").getValue("Implementation-Version");
                        }
                        if (version != null) {
                            version.trim();
                        }
                    }
                    catch (Exception e) {
                        Logging.log.warning("Error checking manifest for jar: " + keyFile.toString());
                        Logging.logStackTrace(e);
                    }
                }
            } else if (prodCode.equalsIgnoreCase("mysqllib")) {
                keyFile = new File(Utils.joinPath(path, "libmySQL.dll"));
                if (keyFile.isFile()) {
                    version = "";
                }
            } else if (prodCode.equalsIgnoreCase("platformpm")) {
                version = new File(path).getName();
                if (version != null && !Pattern.compile("^\\d+(\\.\\d+)*$").matcher(version).matches()) {
                    version = null;
                }
                if (version != null) {
                    keyfile = new File(path, "app/admin.jar");
                    if (!keyfile.isFile()) {
                        version = null;
                    } else {
                        Logging.log.info("platform PM version is " + version);
                    }
                }
                if (version == null) {
                    Logging.log.warning("Failed to find valid version info for platform PM.");
                }
            } else if (prodCode.equalsIgnoreCase("platformlsf")) {
                version = ThirdParty.getLSFVersion(path);
            } else if (prodCode.equalsIgnoreCase("platformgms")) {
                dir = new File(path).listFiles();
                for (i = 0; version == null && dir != null && i < dir.length; ++i) {
                    if (!dir[i].isDirectory()) continue;
                    version = dir[i].getName();
                    if (Pattern.compile("^\\d+(\\.\\d+)*$").matcher(version).matches()) continue;
                    version = null;
                }
                filename = Utils.getOS() == 1 ? "etc/gabd.exe" : "etc/gabd";
                keyfile = new File(path, filename);
                if (!keyfile.isFile()) {
                    version = null;
                }
            } else if (prodCode.equalsIgnoreCase("platformmpi")) {
                command = new String[]{Utils.getOS() == 1 ? Utils.joinPath(path, "bin", "mpirun.exe") : Utils.joinPath(path, "bin", "mpirun"), " -version"};
                try {
                    p = Runtime.getRuntime().exec(command);
                    pin = p.getInputStream();
                    cin = new InputStreamReader(pin);
                    in = new BufferedReader(cin);
                    line = in.readLine();
                    pattern = Pattern.compile(" (\\d{2}\\.\\d{2}\\.\\d{2}\\.\\d{2})W? ");
                    matcher = pattern.matcher(line);
                    if (matcher.find()) {
                        version = matcher.group(1);
                    }
                    in.close();
                }
                catch (IOException e) {
                    Logging.log.info("Get platformmpi version failed: " + command);
                    Logging.logStackTrace(e);
                    e.printStackTrace();
                }
            } else if (prodCode.equalsIgnoreCase("wasmq")) {
                version = ThirdParty.getWasVersion(prodCode, path);
            } else if (prodCode.equalsIgnoreCase("wasmqclnt")) {
                version = ThirdParty.getWasVersion(prodCode, path);
            } else if (prodCode.equalsIgnoreCase("autocad")) {
                identityFile = new File(path, "identity.ini");
                subKey = null;
                if (identityFile.isFile()) {
                    try {
                        props = new PropsParser(true);
                        props.load(identityFile, null);
                        subKey = props.getINIValue("ProductIdentity", "ProductRegistryRootKey", null);
                        if (subKey != null && subKey.length() != 0) {
                            version = WinRegAPI.getWindowsRegistryValue(8, subKey, "Release");
                        }
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                        Logging.log.warning(e.getLocalizedMessage());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        Logging.log.warning(e.getLocalizedMessage());
                    }
                }
            } else if (prodCode.equalsIgnoreCase("pythoncfg")) {
                version = ThirdParty.PythonScript(path, "VERSION");
                pythonPath = ThirdParty.getPythonPath(path);
                Logging.log.info("pythonPath= '" + pythonPath + "' path= '" + path + "'");
                if (pythonPath == null || path == null) {
                    Logging.log.warning("pythonPath or path is null");
                    version = null;
                } else if (pythonPath.compareToIgnoreCase(path) != 0) {
                    Logging.log.warning("pythonPath '" + pythonPath + "' is not equal to path '" + path + "'");
                    version = null;
                }
                if (version != null && Utils.getOS() == 1) {
                    winapi = ThirdParty.PythonScript(path, "WIN32API");
                    if (winapi == null) {
                        version = null;
                        Logging.log.warning("Python is missing win32api");
                    } else {
                        Logging.log.fine("python win32api found.");
                    }
                }
            } else if (prodCode.equalsIgnoreCase("powershell2")) {
                version = ThirdParty.getPowerShellVersion();
                filename = "";
                if (Utils.getOS() == 1) {
                    filename = "powershell.exe";
                }
                if (!(keyfile = new File(path, filename)).isFile()) {
                    version = null;
                }
            }
        }
        Logging.log.info("version='" + version + "'");
        return version;
    }

    private static String PythonScript(String path, String stringtype) {
        String value = null;
        String pythonscript = ThirdParty.getPythonScript(stringtype);
        String script = Utils.joinPath(Globals.g_tempLocation, "check-python.py");
        File scriptFile = new File(script);
        try {
            FileWriter fout = new FileWriter(scriptFile);
            fout.write(pythonscript);
            fout.close();
        }
        catch (IOException e) {
            Logging.log.severe("Error writing file: " + scriptFile);
            return null;
        }
        String command = "";
        command = Utils.getOS() == 1 ? (path == null || path.length() == 0 ? "cmd.exe /C python.exe " + script : "cmd.exe /C \"" + path + "\\python.exe\" " + script) : (path == null || path.length() == 0 ? "python " + script : path + "/python " + script);
        Logging.log.info("Python running command=" + command);
        Utils.ProcessData processdata = Utils.runProcess(command);
        if (processdata != null) {
            if (processdata.exitValue != -1) {
                if (processdata.getStdOutput() != null && processdata.getStdOutput().length != 0) {
                    value = processdata.getStdOutput()[0];
                    Logging.log.info("standard output=" + value);
                } else {
                    Logging.log.info("no standard output returned");
                }
                if (processdata.getStdErr() != null && processdata.getStdErr().length != 0) {
                    String valueStdErr = processdata.getStdErr()[0];
                    Logging.log.info("standard error=" + valueStdErr);
                }
            } else {
                Logging.log.warning("exitValue=" + processdata.exitValue);
                value = null;
            }
        } else {
            Logging.log.warning("Returned 'processdata' is null");
            value = null;
        }
        return value;
    }

    private static String getPythonScript(String scripttype) {
        String pythonscript = null;
        if (scripttype.equalsIgnoreCase("PATH")) {
            pythonscript = "import sys" + System.getProperty("line.separator");
            pythonscript = pythonscript + "print (sys.executable)" + System.getProperty("line.separator");
            pythonscript = pythonscript + "sys.exit(0)";
        } else if (scripttype.equalsIgnoreCase("VERSION")) {
            pythonscript = "import platform" + System.getProperty("line.separator");
            pythonscript = pythonscript + "import sys" + System.getProperty("line.separator");
            pythonscript = pythonscript + "(major, minor, patchlevel) = platform.python_version_tuple()" + System.getProperty("line.separator");
            pythonscript = pythonscript + "print (str(major) + \".\" + str(minor))" + System.getProperty("line.separator");
            pythonscript = pythonscript + "sys.exit(0)";
        } else if (scripttype.equalsIgnoreCase("WIN32API")) {
            pythonscript = "import sys" + System.getProperty("line.separator");
            pythonscript = pythonscript + "try:" + System.getProperty("line.separator");
            pythonscript = pythonscript + "  import win32api" + System.getProperty("line.separator");
            pythonscript = pythonscript + "except:" + System.getProperty("line.separator");
            pythonscript = pythonscript + "   sys.exit(-1)" + System.getProperty("line.separator");
            pythonscript = pythonscript + "print (1)" + System.getProperty("line.separator");
            pythonscript = pythonscript + "sys.exit(1)" + System.getProperty("line.separator");
        }
        Logging.log.fine("Python " + scripttype + " script=\n" + pythonscript);
        return pythonscript;
    }

    public static int getLevel(String prodCode, String version) {
        int level = Globals.g_deploymentData.getSpsSkuByProdCode(Globals.g_order, prodCode, Utils.getOS_Suffix(), false).getLevelAsInt(version, Utils.getOS_Suffix());
        return level;
    }

    public static int getLevel(String order, String prodCode, String version, String levCheckFileName) {
        int level = -1;
        String prodDataDir = Globals.g_deploymentData.getProductDataDir(order, prodCode, true, false);
        File levCheckFile = new File(prodDataDir, levCheckFileName);
        if (levCheckFile.isFile()) {
            try {
                Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(levCheckFile)).getDocumentElement();
                NodeList nodes = root.getElementsByTagName("platform");
                Element node = null;
                String plat = null;
                boolean found = false;
                for (int i = 0; !found && i < nodes.getLength(); ++i) {
                    node = (Element)nodes.item(i);
                    plat = node.getAttribute("id");
                    if (!plat.equalsIgnoreCase(Utils.getOS_Suffix())) continue;
                    found = true;
                    NodeList levChecks = node.getElementsByTagName("level");
                    for (int j = 0; j < levChecks.getLength(); ++j) {
                        node = (Element)levChecks.item(j);
                        int levelVal = Integer.parseInt(node.getAttribute("id"));
                        NodeList checks = node.getElementsByTagName("check");
                        for (int k = 0; k < checks.getLength(); ++k) {
                            node = (Element)checks.item(k);
                            String pattern = node.getAttribute("pattern");
                            if (!Pattern.compile(pattern).matcher(version).find()) continue;
                            level = levelVal;
                        }
                    }
                }
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        return level;
    }

    public static String getBEAHomePath(String webLogicPath) {
        File uninstallFile;
        String beaHome = null;
        File homeFile = new File(webLogicPath, ".home");
        if (homeFile.isFile()) {
            try {
                Properties homeProps = new Properties();
                FileInputStream fis = new FileInputStream(homeFile);
                homeProps.load(fis);
                fis.close();
                beaHome = homeProps.getProperty("HOME", null);
                if (beaHome != null && Utils.isEqualPaths(beaHome, webLogicPath)) {
                    beaHome = null;
                }
            }
            catch (Exception e) {
                Logging.log.warning("Error loading properties file: " + homeFile.getPath());
                Logging.logStackTrace(e);
            }
        }
        if (beaHome == null && (uninstallFile = new File(Utils.joinPath(webLogicPath, "uninstall"), "uninstall.xml")).isFile()) {
            try {
                Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(uninstallFile)).getDocumentElement();
                beaHome = root.getAttribute("beahome");
            }
            catch (Exception e) {
                Logging.log.warning("Error parsing XML file: " + uninstallFile.getAbsolutePath());
                Logging.logStackTrace(e);
            }
        }
        return beaHome;
    }

    public static String getWebLogicPath(String beaHomePath) {
        boolean found = false;
        String webLogicPath = null;
        File registryFile = new File(beaHomePath, "registry.xml");
        if (registryFile.isFile()) {
            try {
                Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(registryFile)).getDocumentElement();
                NodeList data = root.getElementsByTagName("release");
                if (data != null) {
                    String installDir = null;
                    String compInstallDir = null;
                    Element element = null;
                    Element parent = null;
                    NodeList components = null;
                    for (int i = 0; !found && i < data.getLength(); ++i) {
                        element = (Element)data.item(i);
                        parent = (Element)element.getParentNode();
                        if (!"product".equals(parent.getTagName()) || !"WebLogic Platform".equals(parent.getAttribute("name"))) continue;
                        installDir = element.getAttribute("InstallDir");
                        components = element.getElementsByTagName("component");
                        for (int j = 0; !found && j < components.getLength(); ++j) {
                            element = (Element)components.item(j);
                            parent = (Element)element.getParentNode();
                            if (!"component".equals(parent.getTagName()) || !"WebLogic Server".equals(parent.getAttribute("name")) || !"Server".equals(element.getAttribute("name")) && !"Core Application Server".equals(element.getAttribute("name"))) continue;
                            compInstallDir = parent.getAttribute("InstallDir");
                            if (compInstallDir != null && compInstallDir.length() > 0) {
                                installDir = compInstallDir;
                            }
                            if (found) continue;
                            found = true;
                            webLogicPath = installDir;
                        }
                    }
                }
            }
            catch (Exception e) {
                Logging.log.warning("Error parsing XML file: " + registryFile.getAbsolutePath());
                Logging.logStackTrace(e);
            }
        }
        return webLogicPath;
    }

    public static HashMap<String, String> extractWebsphereVersionIdentifiers(String version) {
        HashMap<String, String> extractedVersionIdentifiers = new HashMap<String, String>();
        String[] propertyNames = new String[]{"websphere.selected.version.major", "websphere.selected.version.release", "websphere.selected.version.refresh", "websphere.selected.version.fixpack"};
        StringTokenizer st = new StringTokenizer(version, ".");
        for (int i = 0; i < propertyNames.length; ++i) {
            try {
                extractedVersionIdentifiers.put(propertyNames[i], st.nextToken());
                continue;
            }
            catch (NoSuchElementException nse) {
                Logging.log.warning("Unable to set " + propertyNames[i] + ". Property will be set to UNKNOWN.");
                extractedVersionIdentifiers.put(propertyNames[i], "UNKNOWN");
            }
        }
        return extractedVersionIdentifiers;
    }

    private static String getJarVersion(String pathname, String token) {
        String jarversion = null;
        File keyFile = new File(pathname);
        if (keyFile.isFile()) {
            try {
                JarFile jf = new JarFile(keyFile);
                jarversion = jf.getManifest().getMainAttributes().getValue(token).trim();
            }
            catch (Exception e) {
                Logging.log.warning("Error checking manifest for jar: " + keyFile.getAbsolutePath());
                Logging.logStackTrace(e);
            }
        }
        return jarversion;
    }

    private static File findJRESetupInDirectoryTree(File folder) {
        File[] files = folder.listFiles();
        File thisFile = null;
        if (files == null) {
            return null;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                thisFile = ThirdParty.findJRESetupInDirectoryTree(files[i]);
                if (thisFile == null) continue;
                return thisFile;
            }
            String fname = files[i].getName().toLowerCase();
            if (!fname.endsWith("_setup.com") || fname.indexOf("_cancel_") != -1) continue;
            return files[i];
        }
        return null;
    }

    private static String getWasVersion(String prodCode, String path) {
        String componentFlag;
        File keyFile;
        String verInfo = null;
        String command = null;
        command = Utils.getOS() != 1 ? Utils.joinPath(path, "bin", "dspmqver") + " -b -f 2" : "\"" + Utils.joinPath(path, "bin", "dspmqver") + "\" -b -f 2";
        verInfo = Utils.runProcess(command).getStdOutput()[0];
        if (verInfo == null && (keyFile = new File(path, "java/lib/com.ibm.mq.jar")) != null) {
            try {
                Manifest my_manifest = new JarFile(keyFile).getManifest();
                verInfo = my_manifest.getMainAttributes().getValue("Specification-Version");
            }
            catch (Exception e) {
                Logging.log.warning("Error checking manifest for jar: " + keyFile.toString());
                Logging.logStackTrace(e);
            }
        }
        if (!(verInfo == null || (componentFlag = ThirdParty.isWasMQ_Client(prodCode, path)) != null && componentFlag.equalsIgnoreCase(prodCode))) {
            verInfo = null;
        }
        if (verInfo != null) {
            verInfo.trim();
        }
        Logging.log.info(prodCode + " version is " + verInfo);
        return verInfo;
    }

    private static String isWasMQ_Client(String prodCode, String path) {
        String osSuffix = Utils.getOS_Suffix();
        String regValue = null;
        String flag = null;
        if (osSuffix.equals("win") || osSuffix.equals("wx6") || osSuffix.equals("w64")) {
            String regPath = "SOFTWARE\\IBM\\MQSeries\\CurrentVersion\\Components";
            String regKey = "Server";
            if (prodCode.equalsIgnoreCase("wasmqclnt")) {
                regPath = "SOFTWARE\\IBM\\MQSeries\\CurrentVersion\\Components";
                regKey = "Local Clients\\Windows NT Client";
            }
            if ((regValue = osSuffix.equals("w64") ? WinRegAPI.getWindowsRegistryValue(8, regPath, regKey) : WinRegAPI.getWinRegValue32(8, regPath, regKey)) != null && regValue.compareToIgnoreCase("Installed") == 0) {
                flag = prodCode;
            }
        } else if (osSuffix.equals("s64") || osSuffix.equals("sax")) {
            String command = "pkgparam mqm CLASSES";
            String buffer = Utils.runProcess(command).getStdOutput()[0];
            Logging.log.info("pkgparam mqm CLASSES=" + buffer);
            if (buffer != null) {
                buffer.toLowerCase();
                if (buffer.indexOf("server") < buffer.length() && prodCode.equalsIgnoreCase("wasmq")) {
                    flag = prodCode;
                } else if (buffer.indexOf("sol_client") < buffer.length() && prodCode.equalsIgnoreCase("wasmqclnt")) {
                    flag = prodCode;
                }
            }
        } else if (osSuffix.equals("r64")) {
            String command = "lslpp -al mqm*";
            String buffer = Utils.runProcess(command).getStdOutput()[0];
            if (buffer != null) {
                buffer.toLowerCase();
                if (buffer.indexOf("server") < buffer.length() && prodCode.equalsIgnoreCase("wasmq")) {
                    flag = prodCode;
                } else if (buffer.indexOf("mqm.client.rte") < buffer.length() && prodCode.equalsIgnoreCase("wasmqclnt")) {
                    flag = prodCode;
                }
            }
            Logging.log.info("flag=" + flag);
        } else if (osSuffix.equals("lax")) {
            String command = "rpm -qa ";
            command = prodCode.equalsIgnoreCase("wasmq") ? command + "MQSeriesServer" : (prodCode.equalsIgnoreCase("wasmqclnt") ? command + "MQSeriesClient" : "rpm -qa | grep -i mq | sort");
            Logging.log.info(command + " returns:\n" + command);
            String[] buffer = Utils.runProcess(command).getStdOutput();
            for (int i = 0; i < buffer.length; ++i) {
                Logging.log.info(buffer[i]);
                if (buffer[i] == null) continue;
                if (buffer[i].indexOf("MQSeriesServer") < buffer[i].length() && prodCode.equalsIgnoreCase("wasmq")) {
                    flag = prodCode;
                    break;
                }
                if (buffer[i].indexOf("MQSeriesClient") >= buffer[i].length() || !prodCode.equalsIgnoreCase("wasmqclnt")) continue;
                flag = prodCode;
                break;
            }
            flag = prodCode;
        }
        return flag;
    }

    private static String getLSFVersion(String path) {
        SpsSkuData spsSkuData = Globals.g_deploymentData.getSpsSkuByProdCode(Globals.g_order, "platformlsf", Utils.getOS_Suffix(), false);
        String[] recVers = spsSkuData.getQueries(Utils.getOS_Suffix());
        String lsfVersion = null;
        String lsfConfDir = path;
        Logging.log.info("The LSF conf directory value is " + lsfConfDir);
        if (lsfConfDir == null || lsfConfDir == "") {
            Logging.log.info("The lsfConf directory doesn't exist.");
            return null;
        }
        String tmpPath = Utils.joinPath(path, "lsf.conf");
        File tmpFile = new File(tmpPath);
        if (!tmpFile.exists()) {
            Logging.log.info("The lsf.conf file does not exist in " + tmpFile);
            return null;
        }
        try {
            BufferedReader in = new BufferedReader(new FileReader(tmpFile));
            String line = null;
            String includeDirProp = "LSF_INCLUDEDIR";
            String str = null;
            while ((line = in.readLine()) != null) {
                if (!line.startsWith(includeDirProp)) continue;
                str = line.substring(includeDirProp.length(), line.length());
                str.trim();
                if (str.startsWith("=")) {
                    str = str.substring(1);
                }
                if (str.startsWith("\"")) {
                    str = str.substring(1);
                }
                if (!str.endsWith("\"")) break;
                str = str.substring(0, str.length() - 1);
                break;
            }
            in.close();
            if (str == null || str == "") {
                Logging.log.info("The LSF_INCLUDEDIR property does not exist");
                return null;
            }
            File includeLoc = new File(str);
            if (!includeLoc.exists()) {
                Logging.log.info("The LSF_INCLUDEDIR location does not exist " + includeLoc);
                return null;
            }
            File parentDir = new File(includeLoc.getParent());
            lsfVersion = parentDir.getName();
            Logging.log.info("Version = " + lsfVersion);
        }
        catch (Exception e) {
            Logging.log.warning("Problems accessing files to determine PLATFORM LSF properties");
            return null;
        }
        if (lsfVersion == null || lsfVersion == "") {
            Logging.log.info("Unable to determine the PLATFORM LSF version.");
            return null;
        }
        Pattern pattern1 = Pattern.compile("^[7-9](\\.\\d+)*$");
        Pattern pattern2 = Pattern.compile("^[1-9][0-9](\\.\\d+)*$");
        Matcher matcher = pattern1.matcher(lsfVersion);
        if (matcher.find()) {
            return matcher.group();
        }
        matcher = pattern2.matcher(lsfVersion);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("java.vm.name"));
    }

    public static String getVMName(String path) {
        File java = null;
        m_jvmType = "";
        java = Utils.getOS() == 1 ? new File(path, "jre/bin/java.exe") : new File(path, "jre/bin/java");
        if (java.isFile()) {
            try {
                String[] command = new String[]{java.getPath(), "-Duser.language=en -classpath", System.getProperty("java.class.path"), "com.sas.ssn.ThirdParty"};
                Process javaVer = Runtime.getRuntime().exec(command);
                final BufferedReader err = new BufferedReader(new InputStreamReader(javaVer.getErrorStream()));
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            String line;
                            while ((line = err.readLine()) != null) {
                                System.out.println(line);
                            }
                        }
                        catch (IOException e) {
                            Logging.logStackTrace(e);
                        }
                    }
                }.start();
                final BufferedReader in = new BufferedReader(new InputStreamReader(javaVer.getInputStream()));
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            String line;
                            while ((line = in.readLine()) != null) {
                                m_jvmType = m_jvmType + line;
                            }
                        }
                        catch (IOException e) {
                            Logging.logStackTrace(e);
                        }
                    }
                }.start();
                javaVer.waitFor();
            }
            catch (Exception e) {
                Logging.log.warning("Error capturing JVM Name: " + java.getPath());
                Logging.logStackTrace(e);
            }
        }
        return m_jvmType;
    }

    static boolean verifyJreFunction(String path) {
        boolean value = false;
        String command = null;
        command = Utils.getOS() != 1 ? Utils.buildJavaCommand(path) + " -fullversion" : "\"" + Utils.buildJavaCommand(path) + "\" -fullversion";
        Utils.ProcessData processdata = Utils.runProcess(command);
        if (processdata != null) {
            value = processdata.getExitValue() == 0;
        }
        return value;
    }
}

