/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.DepotManager;
import com.sas.ssn.DepotSubsetListData;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.PanelDepotSubsetFullOrSubset;
import com.sas.ssn.PanelDepotSubsetPlatform;
import com.sas.ssn.ParseRequirementsXML;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SkuData;
import com.sas.ssn.SkuRequirementsForOrder;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.ssn.VolserData;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;

public class SubsetData
implements Serializable {
    private static final long serialVersionUID = -4343096318399904979L;
    protected static SSNResource bundle = new SSNResource(PanelDepotSubsetFullOrSubset.class);
    private boolean subsetActive = false;
    private boolean subsetByPlatform = true;
    private boolean subsetByProducts = true;
    private boolean subsetByLanguage = true;
    private HashMap<String, String> platformNames = new HashMap();
    private HashMap<String, String> productNames = new HashMap();
    private HashMap<String, String> languageNames = new HashMap();
    private HashMap<String, HashSet<String>> listAltSkusByPlatform = new HashMap();
    private HashMap<String, HashSet<String>> listAltSkusByProduct = new HashMap();
    private HashMap<String, HashSet<String>> listAltSkusByProductCode = new HashMap();
    private HashMap<String, HashSet<String>> listAltSkusByLanguage = new HashMap();
    private ArrayList<DepotSubsetListData> platformSelectList = new ArrayList();
    private ArrayList<DepotSubsetListData> productSelectList = new ArrayList();
    private ArrayList<DepotSubsetListData> languageSelectList = new ArrayList();
    private HashMap<String, HashSet<String>> platformDependencies = new HashMap();
    private HashMap<String, HashSet<String>> productDependencies = new HashMap();
    private HashMap<String, HashSet<String>> languageDependencies = new HashMap();
    private HashMap<String, HashSet<String>> platformRevDependencies = new HashMap();
    private HashMap<String, HashSet<String>> productRevDependencies = new HashMap();
    private HashMap<String, HashSet<String>> languageRevDependencies = new HashMap();
    private HashSet<String> allAltSkus = new HashSet();
    private HashSet<String> isFoundation = new HashSet();
    private HashSet<String> isConfig = new HashSet();
    private HashSet<String> isInstallable = new HashSet();
    private HashSet<String> isSelectable = new HashSet();
    private HashMap<String, String> oldVolsers = new HashMap();
    private HashSet<String> platformsWithJRE = new HashSet();
    private HashMap<String, String> productCodes = new HashMap();
    private String origOrder = null;
    private String origDepotLocation = null;
    private String subsetOrderNumber = null;
    private HashMap<String, HashSet<String>> listOfMaintAltSkus = new HashMap();
    private HashMap<String, String> listOfNonMaintAltSkus = new HashMap();
    Set<String> skuDependencies = null;
    HashSet<String> uniqueUnselectableSkus = new HashSet();

    public void loadOrderData() {
        OrderData orderData = Globals.g_deploymentData.getOrder(Globals.g_order);
        this.loadAltSkuData(orderData);
        this.loadDependencies(orderData);
        this.loadPlatformNames();
        this.loadLanguageNames();
    }

    public void loadAltSkuData(OrderData orderData) {
        String[] volsers = orderData.getVolsers(orderData.getMediaType());
        for (int i = 0; i < volsers.length; ++i) {
            VolserData volserData = Globals.g_deploymentData.getVolser(volsers[i]);
            String[] spsSkus = volserData.getSpsSkus();
            for (int j = 0; j < spsSkus.length; ++j) {
                if (!volserData.isPayloadIncluded(spsSkus[j])) continue;
                this.allAltSkus.add(spsSkus[j]);
                if (Globals.g_subsetWithRecipe && !Globals.g_subsetRecipes.isAltSkuInRecipe(spsSkus[j])) continue;
                SpsSkuData spsSkuData = Globals.g_deploymentData.getSpsSku(spsSkus[j]);
                boolean isJRE = "javaruntime".compareToIgnoreCase(spsSkuData.getProdCode()) == 0;
                boolean isClientConfig = "clientconfig".compareToIgnoreCase(spsSkuData.getProdCode()) == 0;
                this.productCodes.put(spsSkuData.getDisplayName("en"), spsSkuData.getProdCode());
                SkuData[] skuData = spsSkuData.getSkus();
                for (int k = 0; k < skuData.length; ++k) {
                    if (isJRE || "z64".equalsIgnoreCase(spsSkuData.getPlatform())) {
                        this.platformsWithJRE.add(skuData[k].getPlatform());
                    }
                    this.addItem(this.listAltSkusByPlatform, skuData[k].getPlatform(), spsSkus[j]);
                    this.productNames.put(spsSkus[j], spsSkuData.getDisplayName("en"));
                    this.addItem(this.listAltSkusByLanguage, this.localefix(spsSkuData.getLanguage()), spsSkus[j]);
                    this.addItem(this.listAltSkusByProduct, spsSkuData.getDisplayName("en"), spsSkus[j]);
                    this.addItem(this.listAltSkusByProductCode, spsSkuData.getProdCode(), spsSkus[j]);
                    if (spsSkuData.isMaintLevelGreaterThanZero()) {
                        this.addItem(this.listOfMaintAltSkus, spsSkuData.getProdCode() + ":" + spsSkuData.getDisplayVer("en") + ":" + spsSkuData.getPlatform() + ":" + spsSkuData.getLanguage(), spsSkus[j]);
                    } else {
                        this.listOfNonMaintAltSkus.put(spsSkus[j], spsSkuData.getProdCode() + ":" + spsSkuData.getDisplayVer("en") + ":" + spsSkuData.getPlatform() + ":" + spsSkuData.getLanguage());
                    }
                    if ("true".equalsIgnoreCase(skuData[k].getMiscValue("is_foundation"))) {
                        this.isFoundation.add(spsSkuData.getDisplayName("en"));
                    }
                    if (!isClientConfig && "true".equalsIgnoreCase(skuData[k].getMiscValue("is_config"))) {
                        this.isConfig.add(spsSkuData.getDisplayName("en"));
                    }
                    if (skuData[k].isInstallable()) {
                        this.isInstallable.add(spsSkuData.getDisplayName("en"));
                    }
                    if (!skuData[k].isSelectable()) continue;
                    this.isSelectable.add(spsSkuData.getDisplayName("en"));
                }
            }
        }
    }

    private String localefix(String language) {
        if ("zx".equals(language)) {
            return "zt";
        }
        return language;
    }

    private void loadDependencies(OrderData orderData) {
        this.platformDependencies = ParseRequirementsXML.loadRequirementsData(new File(orderData.getOrderInfoDir(), "platreq.xml"), "platform");
        this.productDependencies = this.loadProductDependencies(orderData);
        this.languageDependencies = ParseRequirementsXML.loadRequirementsData(new File(orderData.getOrderInfoDir(), "langreq.xml"), "language");
        this.platformRevDependencies = this.reverseDependency(this.platformDependencies);
        this.productRevDependencies = this.reverseDependency(this.productDependencies);
        this.languageRevDependencies = this.reverseDependency(this.languageDependencies);
    }

    private void RemoveCircularSkusRefs(String sku, HashSet<String> skuDeps) {
        String skuProdCode = Globals.g_deploymentData.getSpsSku(sku).getProdCode();
        Iterator<String> i = skuDeps.iterator();
        while (i.hasNext()) {
            String element = i.next();
            SpsSkuData spsSku = Globals.g_deploymentData.getSpsSku(element);
            if (spsSku == null || !spsSku.getProdCode().equals(skuProdCode)) continue;
            i.remove();
        }
    }

    private HashMap<String, HashSet<String>> loadProductDependencies(OrderData orderData) {
        HashMap<String, HashSet<String>> requirementsData = new HashMap<String, HashSet<String>>();
        SkuRequirementsForOrder skuReqsForOrder = orderData.getSkuRequirements();
        if (skuReqsForOrder != null) {
            for (String sku : this.allAltSkus) {
                SpsSkuData spsSkuData = Globals.g_deploymentData.getSpsSku(sku);
                if (requirementsData.containsKey(spsSkuData.getProdCode())) continue;
                HashSet<String> skuReqsInOrder = skuReqsForOrder.getImmediateSkuRequirements("default", sku, null);
                requirementsData.put(sku, skuReqsInOrder);
                this.chaseRequirementsXml(requirementsData, sku, spsSkuData);
            }
        }
        return requirementsData;
    }

    private void chaseRequirementsXml(HashMap<String, HashSet<String>> requirementsData, String sku, SpsSkuData spsSkuData) {
        SkuData[] skuData;
        HashSet<String> allPlatforms = new HashSet<String>();
        for (SkuData skudata : skuData = spsSkuData.getSkus()) {
            String platform = skudata.getPlatform();
            allPlatforms.add(platform);
        }
        String type = "triggers_install";
        for (String platform : allPlatforms) {
            HashSet<String> reqSkus;
            for (String product : spsSkuData.getRequiredBy(type, platform)) {
                if (product == null || (reqSkus = this.listAltSkusByProductCode.get(product)) == null) continue;
                for (String reqSku : reqSkus) {
                    if (reqSku == null) continue;
                    this.addItem(requirementsData, reqSku, sku);
                }
            }
            for (String product : spsSkuData.getRequires(type, platform)) {
                if (product == null || (reqSkus = this.listAltSkusByProductCode.get(product)) == null) continue;
                for (String reqSku : reqSkus) {
                    if (reqSku == null) continue;
                    this.addItem(requirementsData, sku, reqSku);
                }
            }
        }
    }

    private HashMap<String, HashSet<String>> reverseDependency(HashMap<String, HashSet<String>> depList) {
        HashMap<String, HashSet<String>> revDepList = new HashMap<String, HashSet<String>>();
        for (String i : depList.keySet()) {
            for (String j : depList.get(i)) {
                if (!revDepList.containsKey(j)) {
                    revDepList.put(j, new HashSet());
                }
                revDepList.get(j).add(i);
            }
        }
        return revDepList;
    }

    public ArrayList<String> getOmitList() {
        HashSet<String> omitList = new HashSet<String>(this.allAltSkus);
        for (DepotSubsetListData lang : this.languageSelectList) {
            if (!lang.isSelectedByUser()) continue;
            for (String sku : lang.getAltSkus()) {
                omitList.remove(sku);
            }
        }
        ArrayList<String> spsSkusToOmit = new ArrayList<String>();
        for (String sku : omitList) {
            if (!sku.contains("__sps__")) continue;
            spsSkusToOmit.add(sku);
        }
        for (String sku : spsSkusToOmit) {
            omitList.remove(sku);
        }
        return new ArrayList<String>(omitList);
    }

    public void addProductDependencies() {
        HashSet<String> allSelectedPlatformSkus = this.getSkusDependencies();
        HashSet<String> selectedProductSkusToChase = this.selected(this.productSelectList, this.allAltSkus);
        HashSet<String> newAltSkusToAddToFinalList = new HashSet<String>();
        HashSet<String> seen = new HashSet<String>();
        for (String sku : selectedProductSkusToChase) {
            LinkedList<String> altskusToBeChased = new LinkedList<String>((Collection)this.productDependencies.get(sku));
            while (!altskusToBeChased.isEmpty()) {
                HashSet<String> maintAltSkus;
                String altskuBeingChased = (String)altskusToBeChased.remove();
                if (seen.contains(altskuBeingChased)) continue;
                seen.add(altskuBeingChased);
                if (!allSelectedPlatformSkus.contains(altskuBeingChased)) continue;
                newAltSkusToAddToFinalList.add(altskuBeingChased);
                HashSet<String> depAltSkus = this.productDependencies.get(altskuBeingChased);
                if (depAltSkus != null) {
                    altskusToBeChased.addAll(depAltSkus);
                    altskusToBeChased.addAll(this.getNlsSkuDependenciesForLikeProductCodes(altskuBeingChased, depAltSkus));
                }
                if ((maintAltSkus = this.listOfMaintAltSkus.get(this.listOfNonMaintAltSkus.get(altskuBeingChased))) == null) continue;
                altskusToBeChased.addAll(maintAltSkus);
            }
        }
        this.addToProductSelectList(newAltSkusToAddToFinalList);
    }

    private Set<String> getNlsSkuDependenciesForLikeProductCodes(String skuBeingChased, Set<String> skus) {
        HashSet<String> nlsSkuDependencies = new HashSet<String>();
        SpsSkuData skuData = Globals.g_deploymentData.getSpsSku(skuBeingChased);
        if (skuData == null) {
            String msg = String.format("Sku data is null for %s while chasing NLS dependencies for depot subsetting.", skuBeingChased);
            Logging.log.warning(msg);
        }
        String productCodeBeingChased = skuData.getProdCode();
        String language = skuData.getLanguage();
        if ("en".equals(language)) {
            for (String sku : skus) {
                ProductData[] productArray;
                String productCode;
                skuData = Globals.g_deploymentData.getSpsSku(sku);
                if (skuData == null || !productCodeBeingChased.equals(productCode = skuData.getProdCode())) continue;
                String platform = skuData.getPlatform();
                for (ProductData prodData : productArray = Globals.g_deploymentData.getProductArray(Globals.g_order, productCode, platform, false)) {
                    String skuToAdd = prodData.getSpsSku();
                    nlsSkuDependencies.add(skuToAdd);
                }
            }
        }
        return nlsSkuDependencies;
    }

    public void addUniqueUnselectableSkus() {
        HashSet<String> allSelectedPlatformSkus = this.getSkusDependencies();
        HashSet<String> newAltSkusToAddToFinalList = new HashSet<String>();
        for (String sku : this.uniqueUnselectableSkus) {
            if (!allSelectedPlatformSkus.contains(sku)) continue;
            newAltSkusToAddToFinalList.add(sku);
        }
        this.addToProductSelectList(newAltSkusToAddToFinalList);
    }

    private void addToProductSelectList(HashSet<String> newAltSkusToAddToFinalList) {
        this.skuDependencies = newAltSkusToAddToFinalList;
        if (newAltSkusToAddToFinalList.size() > 0) {
            DepotSubsetListData newEntry = new DepotSubsetListData(newAltSkusToAddToFinalList, "Dependancies", "Dependancies", false, true);
            this.productSelectList.add(newEntry);
        }
    }

    private HashSet<String> getSkusDependencies() {
        HashSet<String> allSelectedPlatformSkus = new HashSet<String>();
        for (String productStr : this.listAltSkusByProduct.keySet()) {
            HashSet<String> skus = this.listAltSkusByProduct.get(productStr);
            HashSet<String> selectedSkus = this.selected(this.platformSelectList, skus);
            allSelectedPlatformSkus.addAll(selectedSkus);
        }
        return allSelectedPlatformSkus;
    }

    public ArrayList<DepotSubsetListData> loadPlatforms() {
        HashSet<String> uniquePlatforms = new HashSet<String>();
        this.platformSelectList.clear();
        for (String platformStr : this.listAltSkusByPlatform.keySet()) {
            if (!this.platformsWithJRE.contains(platformStr) && !Globals.g_subsetWithRecipe) continue;
            DepotSubsetListData platformData = new DepotSubsetListData(this.listAltSkusByPlatform.get(platformStr), this.platformNames.get(platformStr), platformStr, true);
            uniquePlatforms.add(platformStr);
            this.platformSelectList.add(platformData);
        }
        HashMap<String, DepotSubsetListData> platformByCode = new HashMap<String, DepotSubsetListData>();
        for (DepotSubsetListData platform : this.platformSelectList) {
            platformByCode.put(platform.getCode(), platform);
        }
        for (DepotSubsetListData platform : this.platformSelectList) {
            String platformCode = platform.getCode();
            if (this.platformDependencies.containsKey(platformCode)) {
                for (String i : this.platformDependencies.get(platformCode)) {
                    if (!uniquePlatforms.contains(i) || i.equals(platformCode)) continue;
                    platform.addDependency((DepotSubsetListData)platformByCode.get(i));
                }
            }
            if (!this.platformDependencies.containsKey(platformCode)) continue;
            for (String i : this.platformRevDependencies.get(platformCode)) {
                if (!uniquePlatforms.contains(i) || i.equals(platformCode)) continue;
                platform.addRevDependency((DepotSubsetListData)platformByCode.get(i));
            }
        }
        return this.platformSelectList;
    }

    public ArrayList<DepotSubsetListData> loadProducts() {
        DepotSubsetListData product;
        HashSet<String> uniqueSelectedSkus = new HashSet<String>();
        this.productSelectList.clear();
        for (String string : this.listAltSkusByProduct.keySet()) {
            HashSet<String> skus = this.listAltSkusByProduct.get(string);
            HashSet<String> selectedSkus = this.selected(this.platformSelectList, skus);
            if (selectedSkus.size() <= 0) continue;
            DepotSubsetListData productData = new DepotSubsetListData(selectedSkus, string, this.productCodes.get(string), !this.isAnyProdRequired(skus), this.isAnyProdRequired(skus));
            this.productSelectList.add(productData);
        }
        ArrayList<DepotSubsetListData> selectableProducts = new ArrayList<DepotSubsetListData>();
        if (Globals.g_subsetClients) {
            for (DepotSubsetListData product2 : this.productSelectList) {
                if (this.overrideSelectionRules(product2) || !product2.isSelectable() || !this.isConfig.contains(product2.getName()) && !this.isFoundation.contains(product2.getName())) {
                    if (!this.isInstallable.contains(product2.getName()) || !this.isSelectable.contains(product2.getName())) continue;
                    selectableProducts.add(product2);
                    uniqueSelectedSkus.addAll(product2.getAltSkus());
                    continue;
                }
                product2.setOmittedByPolicy(true);
            }
        } else if (Globals.g_subsetNonConfig) {
            for (DepotSubsetListData product2 : this.productSelectList) {
                if (this.overrideSelectionRules(product2) || !product2.isSelectable() || !this.isConfig.contains(product2.getName()) || this.isFoundation.contains(product2.getName())) {
                    if (!this.isInstallable.contains(product2.getName()) || !this.isSelectable.contains(product2.getName())) continue;
                    selectableProducts.add(product2);
                    uniqueSelectedSkus.addAll(product2.getAltSkus());
                    continue;
                }
                product2.setOmittedByPolicy(true);
            }
        } else if (Globals.g_subsetAll) {
            for (DepotSubsetListData product2 : this.productSelectList) {
                if (!product2.isSelectable() || this.isInstallable.contains(product2.getName()) && this.isSelectable.contains(product2.getName())) {
                    selectableProducts.add(product2);
                    uniqueSelectedSkus.addAll(product2.getAltSkus());
                    continue;
                }
                this.uniqueUnselectableSkus.addAll(product2.getAltSkus());
            }
        } else if (Globals.g_subsetAllForPlatAndLang) {
            for (DepotSubsetListData product2 : this.productSelectList) {
                selectableProducts.add(product2);
                uniqueSelectedSkus.addAll(product2.getAltSkus());
            }
        } else {
            for (DepotSubsetListData product2 : this.productSelectList) {
                if (!this.isFoundation.contains(product2.getName()) || !this.isSelectable.contains(product2.getName()) || !this.isInstallable.contains(product2.getName())) continue;
                selectableProducts.add(product2);
                uniqueSelectedSkus.addAll(product2.getAltSkus());
            }
        }
        if (!Globals.g_subset32bitonly) {
            ArrayList<DepotSubsetListData> arrayList = ((PanelDepotSubsetPlatform)Globals.g_wizard.getPanel("selectsubsetPlatform")).getJREs();
            this.productSelectList.addAll(arrayList);
        }
        HashMap<String, DepotSubsetListData> hashMap = new HashMap<String, DepotSubsetListData>();
        HashMap<String, DepotSubsetListData> productByProductName = new HashMap<String, DepotSubsetListData>();
        for (DepotSubsetListData product3 : this.productSelectList) {
            for (String productAltSku : product3.getAltSkus()) {
                hashMap.put(productAltSku, product3);
                productByProductName.put(product3.getName(), product3);
            }
        }
        boolean onlyWINSelected = ((PanelDepotSubsetPlatform)Globals.g_wizard.getPanel("selectsubsetPlatform")).isOnlyWINSelected();
        boolean onlyLNXSelected = ((PanelDepotSubsetPlatform)Globals.g_wizard.getPanel("selectsubsetPlatform")).isOnlyLNXSelected();
        ArrayList<DepotSubsetListData> newProductSelectList = new ArrayList<DepotSubsetListData>();
        HashSet<String> newlyAddedAltSkus = new HashSet<String>();
        if (!Globals.g_subset32bitonly && (onlyWINSelected || onlyLNXSelected)) {
            for (DepotSubsetListData product4 : this.productSelectList) {
                if (product4.isOmittedByPolicy()) continue;
                ArrayList<String> allProductAltSkus = new ArrayList<String>(product4.getAltSkus());
                for (int i = 0; i < allProductAltSkus.size(); ++i) {
                    String productAltSku = allProductAltSkus.get(i);
                    for (String productDepAltSku : this.productDependencies.get(productAltSku)) {
                        SpsSkuData spsAltSku = Globals.g_deploymentData.getSpsSku(productDepAltSku);
                        if (spsAltSku == null || (spsAltSku.getSku("wx6") == null || !onlyWINSelected) && (spsAltSku.getSku("lax") == null || !onlyLNXSelected)) continue;
                        DepotSubsetListData productToUpdate = (DepotSubsetListData)productByProductName.get(spsAltSku.getDisplayName("en"));
                        if (productToUpdate != null) {
                            HashSet<String> altskus = productToUpdate.getAltSkus();
                            if (altskus.contains(productDepAltSku)) continue;
                            altskus.add(productDepAltSku);
                            newlyAddedAltSkus.add(productDepAltSku);
                            hashMap.put(productDepAltSku, productToUpdate);
                            Logging.log.info("Adding 64-bit product(1): " + productDepAltSku + " for " + productAltSku);
                            continue;
                        }
                        HashSet<String> newAltSku = new HashSet<String>();
                        newAltSku.add(productDepAltSku);
                        newlyAddedAltSkus.add(productDepAltSku);
                        DepotSubsetListData productData = new DepotSubsetListData(newAltSku, spsAltSku.getDisplayName("en"), null, false);
                        newProductSelectList.add(productData);
                        hashMap.put(productDepAltSku, productData);
                        productByProductName.put(productData.getName(), productData);
                        Logging.log.info("Adding 64-bit product(2): " + productDepAltSku + " for " + productAltSku);
                    }
                }
            }
            this.productSelectList.addAll(newProductSelectList);
            HashSet<String> seen = new HashSet<String>();
            LinkedList altskusToBeChased = new LinkedList(newlyAddedAltSkus);
            while (!altskusToBeChased.isEmpty()) {
                String altskuBeingChased = (String)altskusToBeChased.remove();
                if (seen.contains(altskuBeingChased)) continue;
                seen.add(altskuBeingChased);
                for (String productDepAltSku : this.productDependencies.get(altskuBeingChased)) {
                    SpsSkuData spsAltSku = Globals.g_deploymentData.getSpsSku(productDepAltSku);
                    if (spsAltSku == null) continue;
                    DepotSubsetListData productToUpdate = (DepotSubsetListData)productByProductName.get(spsAltSku.getDisplayName("en"));
                    if (productToUpdate != null) {
                        HashSet<String> altskus = productToUpdate.getAltSkus();
                        if (altskus.contains(productDepAltSku)) continue;
                        altskus.add(productDepAltSku);
                        altskusToBeChased.add(productDepAltSku);
                        Logging.log.info("Adding needed dependency (3): " + productDepAltSku + " for " + altskuBeingChased);
                        continue;
                    }
                    HashSet<String> newAltSku = new HashSet<String>();
                    newAltSku.add(productDepAltSku);
                    altskusToBeChased.add(productDepAltSku);
                    DepotSubsetListData productData = new DepotSubsetListData(newAltSku, spsAltSku.getDisplayName("en"), null, false);
                    this.productSelectList.add(productData);
                    Logging.log.info("Adding needed dependency (4): " + productDepAltSku + " for " + altskuBeingChased);
                }
            }
        }
        LinkedList<DepotSubsetListData> productsToBeRemoved = new LinkedList<DepotSubsetListData>();
        for (DepotSubsetListData selectableProduct : selectableProducts) {
            for (String selectableProductAltSku : selectableProduct.getAltSkus()) {
                if (!this.productDependencies.containsKey(selectableProductAltSku)) continue;
                for (String productDepAltSku : this.productDependencies.get(selectableProductAltSku)) {
                    product = (DepotSubsetListData)hashMap.get(productDepAltSku);
                    if (product == null) continue;
                    if (uniqueSelectedSkus.contains(productDepAltSku)) {
                        if (selectableProduct.getName().equals(product.getName())) continue;
                        selectableProduct.addDependency(product);
                        continue;
                    }
                    if (!product.isOmittedByPolicy()) continue;
                    Logging.log.info("Removing " + selectableProduct.getName() + " (" + selectableProductAltSku + ") because " + product.getName() + " (" + productDepAltSku + ") was omitted.");
                    selectableProduct.setOmittedByPolicy(true);
                    productsToBeRemoved.add(selectableProduct);
                }
            }
        }
        for (DepotSubsetListData selectableProduct : selectableProducts) {
            for (String selectableProductAltSku : selectableProduct.getAltSkus()) {
                if (!this.productRevDependencies.containsKey(selectableProductAltSku)) continue;
                for (String productDepByAltSku : this.productRevDependencies.get(selectableProductAltSku)) {
                    product = (DepotSubsetListData)hashMap.get(productDepByAltSku);
                    if (!uniqueSelectedSkus.contains(productDepByAltSku) || product == null || product.isOmittedByPolicy() || selectableProduct.getName().equals(((DepotSubsetListData)hashMap.get(productDepByAltSku)).getName())) continue;
                    selectableProduct.addRevDependency((DepotSubsetListData)hashMap.get(productDepByAltSku));
                }
            }
        }
        HashSet<DepotSubsetListData> seen = new HashSet<DepotSubsetListData>();
        while (!productsToBeRemoved.isEmpty()) {
            DepotSubsetListData product5 = (DepotSubsetListData)productsToBeRemoved.remove();
            if (seen.contains(product5)) continue;
            seen.add(product5);
            product5.setOmittedByPolicy(true);
            Logging.log.finer("Removing " + product5.getName() + " ( " + product5.getAltSkus().toString() + " )");
            HashSet<DepotSubsetListData> revDeps = product5.getRevDependencies();
            if (revDeps == null) continue;
            productsToBeRemoved.addAll(product5.getRevDependencies());
            Logging.log.info("Adding the following to the list to be removed: " + product5.getRevDependencies().toString());
        }
        Iterator iter = selectableProducts.iterator();
        while (iter.hasNext()) {
            DepotSubsetListData product6 = (DepotSubsetListData)iter.next();
            if (!product6.isOmittedByPolicy()) continue;
            iter.remove();
        }
        return selectableProducts;
    }

    public ArrayList<DepotSubsetListData> loadLanguages() {
        HashSet<String> uniqueSelectedDisplayableLanguages = new HashSet<String>();
        this.languageSelectList.clear();
        for (String string : this.listAltSkusByLanguage.keySet()) {
            if ("".equalsIgnoreCase(string)) continue;
            HashSet<String> skus = this.listAltSkusByLanguage.get(string);
            HashSet<String> selectedSkus = this.selected(this.productSelectList, skus);
            DepotSubsetListData languageData = null;
            if (selectedSkus.size() <= 0) continue;
            languageData = new DepotSubsetListData(selectedSkus, this.languageNames.get(string), string, !this.isLangRequired(string), this.isLangRequired(string));
            this.languageSelectList.add(languageData);
        }
        ArrayList<DepotSubsetListData> displayableLanguages = new ArrayList<DepotSubsetListData>();
        for (DepotSubsetListData i : this.languageSelectList) {
            if (!i.getName().startsWith("donotshow")) {
                displayableLanguages.add(i);
                uniqueSelectedDisplayableLanguages.addAll(i.getAltSkus());
                continue;
            }
            i.setSelectedByUser(true);
        }
        HashMap<String, DepotSubsetListData> hashMap = new HashMap<String, DepotSubsetListData>();
        for (DepotSubsetListData language : displayableLanguages) {
            hashMap.put(language.getCode(), language);
        }
        for (DepotSubsetListData language : displayableLanguages) {
            String languageCode = language.getCode();
            if (this.languageDependencies.containsKey(languageCode)) {
                for (String i : this.languageDependencies.get(languageCode)) {
                    if (!uniqueSelectedDisplayableLanguages.contains(i) || i.equals(languageCode)) continue;
                    language.addDependency((DepotSubsetListData)hashMap.get(i));
                }
            }
            if (!this.languageDependencies.containsKey(languageCode)) continue;
            for (String i : this.languageRevDependencies.get(languageCode)) {
                if (!uniqueSelectedDisplayableLanguages.contains(i) || i.equals(languageCode)) continue;
                language.addRevDependency((DepotSubsetListData)hashMap.get(i));
            }
        }
        return displayableLanguages;
    }

    private HashSet<String> selected(ArrayList<DepotSubsetListData> selectList, HashSet<String> skuList) {
        HashSet<String> selectedSkus = new HashSet<String>();
        for (DepotSubsetListData i : selectList) {
            if (i.isOmittedByPolicy()) continue;
            for (String j : skuList) {
                for (String k : i.getAltSkus()) {
                    if (!j.equalsIgnoreCase(k) || !i.isSelected()) continue;
                    selectedSkus.add(k);
                }
            }
        }
        return selectedSkus;
    }

    private void addItem(HashMap<String, HashSet<String>> list, String item, String sku) {
        HashSet<Object> al = null;
        if (list.containsKey(item)) {
            al = list.get(item);
            al.add(sku);
        } else {
            al = new HashSet();
            al.add(sku);
            list.put(item, al);
        }
    }

    private boolean overrideSelectionRules(DepotSubsetListData product) {
        return "mgmtconsole".equalsIgnoreCase(product.getCode());
    }

    protected boolean isProdRequired(String sku) {
        boolean required = false;
        if (!Globals.g_processRequirements) {
            return false;
        }
        String prodCode = Globals.g_deploymentData.getSpsSku(sku).getProdCode();
        if (!Globals.g_subsetClients && !Globals.g_subsetAll && prodCode.equalsIgnoreCase("base")) {
            required = true;
        } else if (prodCode.equalsIgnoreCase("cfgwizard") || prodCode.equalsIgnoreCase("deploywiz") || prodCode.equalsIgnoreCase("installutils") || prodCode.equalsIgnoreCase("javaruntime") || prodCode.equalsIgnoreCase("ordersummary") || prodCode.equalsIgnoreCase("privatejre") || prodCode.equalsIgnoreCase("quickstart") || prodCode.equalsIgnoreCase("sampleplans") || prodCode.equalsIgnoreCase("sdwstartup") || prodCode.equalsIgnoreCase("sid_files") || prodCode.equalsIgnoreCase("soi")) {
            required = true;
        }
        return required;
    }

    protected boolean isAnyProdRequired(HashSet<String> skus) {
        boolean result = false;
        for (String sku : skus) {
            if (!this.isProdRequired(sku)) continue;
            result = true;
        }
        return result;
    }

    protected boolean isLangRequired(String lang) {
        boolean required = false;
        if ("en".equalsIgnoreCase(lang) || "07".equalsIgnoreCase(lang) || "u8".equalsIgnoreCase(lang)) {
            required = true;
        }
        return required;
    }

    private void loadPlatformNames() {
        for (String platformCode : this.listAltSkusByPlatform.keySet()) {
            String platformName = null;
            platformName = bundle.getString("Common.Platform" + platformCode.toUpperCase(Locale.ENGLISH) + ".txt");
            this.platformNames.put(platformCode, platformName);
        }
    }

    private void loadLanguageNames() {
        for (String languageCode : this.listAltSkusByLanguage.keySet()) {
            String languageName = null;
            if ("xx".equalsIgnoreCase(languageCode) || "ne".equalsIgnoreCase(languageCode) || "".equalsIgnoreCase(languageCode)) {
                languageName = "donotshow" + languageCode;
            } else if (languageCode.compareToIgnoreCase("zt") == 0) {
                languageName = bundle.getString("Common.SDWLangCode" + languageCode.toUpperCase(Locale.ENGLISH) + ".txt");
            } else {
                languageName = bundle.getRawString("Common.LangCode" + languageCode.toUpperCase(Locale.ENGLISH) + ".txt");
                if (languageName == null) {
                    languageName = "donotshow" + languageCode;
                }
            }
            this.languageNames.put(languageCode, languageName);
        }
    }

    public void omitSkus() {
        ArrayList<String> omitlist = Globals.g_subsetData.getOmitList();
        for (String i : omitlist) {
            if (((DepotManager.AddJob)Globals.g_job).omitSpsSkuPayload(i)) continue;
            Logging.log.finer(i + ": failed to omit sku");
        }
    }

    public void resetData() {
        this.subsetActive = false;
        this.subsetByPlatform = true;
        this.subsetByProducts = true;
        this.subsetByLanguage = true;
        this.platformNames.clear();
        this.productNames.clear();
        this.languageNames.clear();
        this.listAltSkusByPlatform.clear();
        this.listAltSkusByProduct.clear();
        this.listAltSkusByLanguage.clear();
        this.platformSelectList.clear();
        this.productSelectList.clear();
        this.languageSelectList.clear();
        this.platformDependencies.clear();
        this.productDependencies.clear();
        this.languageDependencies.clear();
        this.platformRevDependencies.clear();
        this.productRevDependencies.clear();
        this.languageRevDependencies.clear();
        this.allAltSkus.clear();
        this.isFoundation.clear();
        this.isConfig.clear();
        this.isInstallable.clear();
        this.isSelectable.clear();
        this.oldVolsers.clear();
        this.platformsWithJRE.clear();
    }

    public void setSubsetActive(boolean goSubset) {
        this.subsetActive = goSubset;
    }

    public boolean isSubsetActive() {
        return this.subsetActive;
    }

    public void setSubsetByPlatform(boolean subsetByPlatform) {
        this.subsetByPlatform = subsetByPlatform;
    }

    public boolean isSubsetByPlatform() {
        return this.subsetByPlatform;
    }

    public void setSubsetByProducts(boolean subsetByProducts) {
        this.subsetByProducts = subsetByProducts;
    }

    public boolean isSubsetByProducts() {
        return this.subsetByProducts;
    }

    public void setSubsetByLanguage(boolean subsetByLanguage) {
        this.subsetByLanguage = subsetByLanguage;
    }

    public boolean isSubsetByLanguage() {
        return this.subsetByLanguage;
    }

    public void clearPlatformSelections() {
        this.platformSelectList.clear();
    }

    public void clearProductSelections() {
        this.productSelectList.clear();
    }

    public void clearLanguageSelections() {
        this.languageSelectList.clear();
    }

    public void setOldVolser(String oldVolser, String newVolser) {
        this.oldVolsers.put(newVolser, oldVolser);
    }

    public String getOldVolser(String newVolser) {
        return this.oldVolsers.get(newVolser);
    }

    public void setOrigOrder(String order) {
        this.origOrder = order;
    }

    public void setOrigDepot(String tempLocation) {
        this.origDepotLocation = tempLocation;
    }

    public String getOrigOrder() {
        return this.origOrder;
    }

    public String getOrigDepot() {
        return this.origDepotLocation;
    }

    public String getSubsetOrderNumber() {
        return this.subsetOrderNumber;
    }

    public void setSubsetOrderNumber(String subsetOrderNumber) {
        this.subsetOrderNumber = subsetOrderNumber;
    }

    public static void loadSubsetData() {
        SubsetData subsetData = null;
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(Utils.joinPath(Globals.g_downloadDir, "resume3")));
            subsetData = (SubsetData)ois.readObject();
            Logging.log.finer("Loaded subsetData from resume3 from thread " + Thread.currentThread().getName());
        }
        catch (IOException e) {
            Logging.logStackTrace(e);
        }
        catch (ClassNotFoundException e) {
            Logging.logStackTrace(e);
        }
        finally {
            try {
                ois.close();
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
        if (subsetData != null) {
            Globals.g_subsetData = subsetData;
        }
    }

    public static void saveSubsetData(SubsetData subsetData) {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(Utils.joinPath(Globals.g_downloadDir, "resume3")));
            oos.writeObject(subsetData);
            Logging.log.finer("Saved subsetData to resume3 from thread " + Thread.currentThread().getName());
        }
        catch (IOException e) {
            Logging.logStackTrace(e);
        }
        finally {
            try {
                oos.close();
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
        }
    }
}

