/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Logging;
import com.sas.ssn.SASManifest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public class SearchFile {
    public static String FindAFile(String filename, String searchLoc, boolean search) {
        Vector theFile = SearchFile.FindFile(new Vector(), filename, searchLoc, search, true);
        if (!theFile.isEmpty()) {
            return (String)theFile.firstElement();
        }
        return null;
    }

    public static String[] FindFiles(String filename, String searchLoc, boolean search) {
        Vector theFile = SearchFile.FindFile(new Vector(), filename, searchLoc, search, false);
        String[] paths = theFile.toArray(new String[0]);
        return paths;
    }

    public static File FindVersionedJar(String filename, String version, String searchLoc, boolean search) {
        File ret = null;
        String[] files = SearchFile.FindFiles(filename, searchLoc, search);
        if (files.length == 0) {
            return null;
        }
        ZipFile currentJarFile = null;
        SASManifest currentSASManifest = null;
        for (String file : files) {
            try {
                JarFile nextJarFile = new JarFile(file);
                SASManifest nextSASManifest = SearchFile.getSASManifest(nextJarFile);
                if (nextJarFile == null || !nextSASManifest.containsVersion(version)) continue;
                if (currentJarFile == null) {
                    currentJarFile = nextJarFile;
                    currentSASManifest = nextSASManifest;
                    continue;
                }
                if (currentSASManifest.compareTo(nextSASManifest) >= 0) continue;
                currentJarFile = nextJarFile;
                currentSASManifest = nextSASManifest;
                Logging.log.fine("newer dst=" + file);
            }
            catch (IOException e) {
                Logging.logStackTrace(e);
            }
        }
        if (currentJarFile != null) {
            ret = new File(currentJarFile.getName());
        }
        return ret;
    }

    private static SASManifest getSASManifest(JarFile jarFile) throws IOException {
        SASManifest ret = null;
        String pathName = jarFile.getName();
        Logging.log.fine("pathName=" + pathName);
        File file = new File(pathName);
        String parentDir = file.getParent();
        String externalManifest = parentDir + File.separator + "META-INF" + File.separator + "MANIFEST.MF";
        File externalManifestFile = new File(externalManifest);
        if (externalManifestFile.exists()) {
            ret = new SASManifest(new FileInputStream(externalManifestFile));
        } else {
            Manifest man = jarFile.getManifest();
            if (man != null) {
                ret = new SASManifest(man);
            }
        }
        return ret;
    }

    public static File FindNewestJar(String filename, String searchLoc, boolean search) {
        return SearchFile.FindVersionedJar(filename, null, searchLoc, search);
    }

    private static Vector FindFile(Vector dst, String filename, String searchLoc, boolean search, boolean isFindOne) {
        File[] files = new File(searchLoc).listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                String name = files[i].getName();
                if (files[i].isDirectory()) {
                    if (!search) continue;
                    SearchFile.FindFile(dst, filename, files[i].getAbsolutePath(), search, isFindOne);
                    if (!isFindOne || dst.size() <= 0) continue;
                    break;
                }
                if (!name.equals(filename)) continue;
                dst.add(files[i].getAbsolutePath());
                Logging.log.fine("dst=" + dst);
                if (isFindOne) break;
            }
        }
        return dst;
    }
}

