/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public class SSLCert {
    private static SSNResource bundle = new SSNResource(SSLCert.class);
    private static final String CACERTS_PATH = "/lib/security/cacerts";
    private static final String CACERTS_PASSWORD = "changeit";

    private static File setupTemporaryKeyStoreFile() throws IOException {
        File javaCacertsFile = new File(System.getProperty("java.home") + CACERTS_PATH);
        File tempCacertsFile = File.createTempFile("cacerts", ".tmp");
        if (!Globals.g_debug) {
            tempCacertsFile.deleteOnExit();
        }
        Logging.log.info("Temporary cacerts file: " + tempCacertsFile.getCanonicalPath());
        Utils.copyFile(javaCacertsFile, tempCacertsFile);
        if (!tempCacertsFile.exists()) {
            throw new FileNotFoundException(tempCacertsFile.getAbsolutePath());
        }
        return tempCacertsFile;
    }

    private static KeyStore loadTempKeystore(File tempCacertsFile) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FileInputStream tempCacertsIs = new FileInputStream(tempCacertsFile);
        KeyStore tempCacerts = KeyStore.getInstance(KeyStore.getDefaultType());
        tempCacerts.load(tempCacertsIs, CACERTS_PASSWORD.toCharArray());
        tempCacertsIs.close();
        return tempCacerts;
    }

    private static Certificate loadProxyCert(InputStream certInputStream) throws CertificateException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Certificate cert = cf.generateCertificate(certInputStream);
        certInputStream.close();
        return cert;
    }

    private static void saveProxyCertToTempKeystoreFile(Certificate proxyCert, KeyStore tempCacerts, File tempCacertsFile) throws KeyStoreException, FileNotFoundException, NoSuchAlgorithmException, CertificateException, IOException {
        if (tempCacerts.getCertificateAlias(proxyCert) == null) {
            tempCacerts.setCertificateEntry("proxycert", proxyCert);
            FileOutputStream cacertsOs = new FileOutputStream(tempCacertsFile);
            tempCacerts.store(cacertsOs, CACERTS_PASSWORD.toCharArray());
            cacertsOs.close();
        }
    }

    public static boolean initSSLCert(String certPath) {
        File certPathFile = new File(certPath);
        if (!certPathFile.exists()) {
            Logging.log.severe("missing cert file:" + certPath);
            if (!Globals.g_quietMode) {
                CustMsgBox.showMessageDialog(null, bundle.messageString("SSLCert.MissingCertFileMsg.txt", certPath), bundle.getString("Common.Error.txt"), 0);
            }
            return false;
        }
        try {
            File tempCacertsFile = SSLCert.setupTemporaryKeyStoreFile();
            KeyStore tempCacerts = SSLCert.loadTempKeystore(tempCacertsFile);
            Certificate proxyCert = SSLCert.loadProxyCert(new FileInputStream(certPathFile));
            SSLCert.saveProxyCertToTempKeystoreFile(proxyCert, tempCacerts, tempCacertsFile);
            System.setProperty("javax.net.ssl.trustStore", tempCacertsFile.getCanonicalPath());
            System.setProperty("javax.net.ssl.keyStorePassword", CACERTS_PASSWORD);
        }
        catch (CertificateException e) {
            Logging.logStackTrace(e);
            if (!Globals.g_quietMode) {
                CustMsgBox.showMessageDialog(null, bundle.messageString("SSLCert.InvalidCertFileMsg.txt", certPath), bundle.getString("Common.Error.txt"), 0);
            }
            return false;
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
            if (!Globals.g_quietMode) {
                CustMsgBox.showMessageDialog(null, bundle.messageString("SSLCert.GenericError.txt", certPath), bundle.getString("Common.Error.txt"), 0);
            }
            return false;
        }
        return true;
    }
}

