/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Logging;
import com.sas.ssn.UnicodeInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SDMTaskData {
    public static final String DYNAMIC_TYPE_INSTALL = "install";
    public static final String DYNAMIC_TYPE_CONFIG = "config";
    private final String ROOT_TAG = "sdmtasks";
    private final String TASKS_TAG = "tasks";
    private final String TASK_TAG = "task";
    private final String GROUPS_TAG = "groups";
    private final String GROUP_TAG = "group";
    private final String ATTRIBUTE_VERSION = "version";
    private final String ATTRIBUTE_NAME = "name";
    private final String ATTRIBUTE_ID = "id";
    private final String ATTRIBUTE_ENTRYPANEL = "entrypanel";
    private final String ATTRIBUTE_METASERVER = "metaserver";
    private final String ATTRIBUTE_REQINSTALL = "reqinstall";
    private final String ATTRIBUTE_CHECKBOX = "checkbox";
    private final String ATTRIBUTE_CBDEFAULT = "cbdefault";
    private final String ATTRIBUTE_CBRESPONSENAME = "cbresponsename";
    private final String ATTRIBUTE_OSARCH = "osarch";
    private final String ATTRIBUTE_OSTYPE = "ostype";
    private final String ATTRIBUTE_DYNAMICTYPE = "dynamictype";
    private final String ATTRIBUTE_ITTARGET = "ittarget";
    private final String ATTRIBUTE_TARGETS = "targets";
    private final String ATTRIBUTE_ENABLED = "enabled";
    private Element m_root = null;
    private float m_version = 0.0f;

    public SDMTaskData(String file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this(new File(file));
    }

    public SDMTaskData(File file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        String version = "";
        try {
            if (file.exists()) {
                this.m_root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(file)).getDocumentElement();
                if (this.m_root != null && "sdmtasks".equals(this.m_root.getTagName())) {
                    version = this.m_root.getAttribute("version");
                    this.m_version = Float.parseFloat(version);
                }
            }
        }
        catch (FileNotFoundException e) {
            Logging.log.severe("SDMTasks.xml file not found: " + file.toString());
        }
        catch (NumberFormatException e) {
            Logging.log.warning("Invalid version attribute: " + version);
        }
    }

    public HashMap<String, SDMTask> getSDMTasks() {
        NodeList tasksNodeList;
        HashMap<String, SDMTask> taskList = new HashMap<String, SDMTask>();
        if (this.m_root != null && "sdmtasks".equals(this.m_root.getTagName()) && (tasksNodeList = this.m_root.getElementsByTagName("tasks")) != null) {
            Element taskElement = null;
            SDMTask sdmTask = null;
            for (int i = 0; i < tasksNodeList.getLength(); ++i) {
                taskElement = (Element)tasksNodeList.item(i);
                if (taskElement == null) continue;
                NodeList taskNodeList = taskElement.getElementsByTagName("task");
                for (int j = 0; j < taskNodeList.getLength(); ++j) {
                    sdmTask = new SDMTask((Element)taskNodeList.item(j));
                    taskList.put(sdmTask.getName(), sdmTask);
                }
            }
        }
        return taskList;
    }

    public SDMGroup getSDMRootGroup() {
        NodeList groupsNodeList;
        SDMGroup rootGroup = new SDMGroup("rootgroup");
        if (this.m_root != null && "sdmtasks".equals(this.m_root.getTagName()) && (groupsNodeList = this.m_root.getElementsByTagName("groups")) != null && groupsNodeList.getLength() >= 0) {
            NodeList groupNodeList;
            Element groupsNode = (Element)groupsNodeList.item(0);
            Element element = null;
            String name = null;
            NodeList tasksNodeList = groupsNode.getElementsByTagName("task");
            if (tasksNodeList != null) {
                for (int i = 0; i < tasksNodeList.getLength(); ++i) {
                    element = (Element)tasksNodeList.item(i);
                    if (!element.getParentNode().getNodeName().equalsIgnoreCase("groups")) continue;
                    name = element.getAttribute("name").trim();
                    rootGroup.addTask(name);
                }
            }
            if ((groupNodeList = groupsNode.getElementsByTagName("group")) != null) {
                SDMGroup group = null;
                for (int i = 0; i < groupNodeList.getLength(); ++i) {
                    element = (Element)groupNodeList.item(i);
                    name = element.getAttribute("name").trim();
                    group = new SDMGroup(name);
                    tasksNodeList = element.getElementsByTagName("task");
                    if (tasksNodeList != null) {
                        for (int j = 0; j < tasksNodeList.getLength(); ++j) {
                            element = (Element)tasksNodeList.item(j);
                            name = element.getAttribute("name").trim();
                            group.addTask(name);
                        }
                    }
                    if (group.getTasks() == null || group.getTasks().size() <= 0) continue;
                    rootGroup.addSubGroup(group);
                }
            }
        }
        return rootGroup;
    }

    public class SDMTask {
        private String m_name = null;
        private int m_id = 0;
        private String m_entryPanel = null;
        private boolean m_metaserver = false;
        private String m_reqinstall = null;
        private String m_checkbox = null;
        private boolean m_cbDefault = false;
        private String m_cbResponseName = null;
        private String[] m_osType = null;
        private String[] m_osArch = null;
        private String m_dynamictype = null;
        private String[] m_targets = null;
        private boolean m_itTarget = false;
        private boolean m_enabled = true;

        public SDMTask(Element element) {
            int i;
            StringTokenizer tokens;
            String temp = null;
            this.m_name = element.getAttribute("name").trim();
            temp = element.getAttribute("id").trim();
            if (temp.length() > 0) {
                try {
                    this.m_id = Integer.parseInt(temp);
                }
                catch (Exception e) {
                    this.m_id = 0;
                }
            } else {
                this.m_id = 0;
            }
            this.m_entryPanel = element.getAttribute("entrypanel").trim();
            temp = element.getAttribute("metaserver").trim();
            this.m_metaserver = "yes".equalsIgnoreCase(temp);
            temp = element.getAttribute("reqinstall").trim();
            if (temp.length() > 0) {
                this.m_reqinstall = temp;
            }
            this.m_checkbox = element.getAttribute("checkbox").trim();
            if (this.m_checkbox.length() > 0) {
                temp = element.getAttribute("cbdefault").trim();
                this.m_cbDefault = "true".equalsIgnoreCase(temp);
                this.m_cbResponseName = element.getAttribute("cbresponsename").trim();
            }
            if ((temp = element.getAttribute("ostype").trim()).length() > 0) {
                tokens = new StringTokenizer(temp.toLowerCase(Locale.ENGLISH));
                this.m_osType = new String[tokens.countTokens()];
                i = 0;
                while (tokens.hasMoreTokens()) {
                    this.m_osType[i] = tokens.nextToken();
                    ++i;
                }
            } else {
                this.m_osType = new String[0];
            }
            if ((temp = element.getAttribute("osarch").trim()).length() > 0) {
                tokens = new StringTokenizer(temp.toLowerCase(Locale.ENGLISH));
                this.m_osArch = new String[tokens.countTokens()];
                i = 0;
                while (tokens.hasMoreTokens()) {
                    this.m_osArch[i] = tokens.nextToken();
                    ++i;
                }
            } else {
                this.m_osArch = new String[0];
            }
            if ((temp = element.getAttribute("dynamictype").trim()).length() > 0) {
                this.m_dynamictype = temp;
            }
            this.m_itTarget = "yes".equalsIgnoreCase(temp = element.getAttribute("ittarget").trim());
            temp = element.getAttribute("targets").trim();
            if (temp.length() > 0) {
                tokens = new StringTokenizer(temp);
                this.m_targets = new String[tokens.countTokens()];
                i = 0;
                while (tokens.hasMoreTokens()) {
                    this.m_targets[i] = tokens.nextToken();
                    ++i;
                }
            } else {
                this.m_targets = null;
            }
            this.m_enabled = !"no".equalsIgnoreCase(temp = element.getAttribute("enabled").trim());
        }

        public String getName() {
            return this.m_name;
        }

        public int getID() {
            return this.m_id;
        }

        public String getEntryPanel() {
            return this.m_entryPanel;
        }

        public boolean getMetaserver() {
            return this.m_metaserver;
        }

        public String getReqInstall() {
            return this.m_reqinstall;
        }

        public String getCheckbox() {
            return this.m_checkbox;
        }

        public boolean getCheckboxDefault() {
            return this.m_cbDefault;
        }

        public String getCheckboxResponseName() {
            return this.m_cbResponseName;
        }

        public String[] getOSType() {
            return this.m_osType;
        }

        public String[] getOSArch() {
            return this.m_osArch;
        }

        public String getDynamicType() {
            return this.m_dynamictype;
        }

        public boolean isITTarget() {
            return this.m_itTarget;
        }

        public String[] getTargets() {
            return this.m_targets;
        }

        public boolean isEnabled() {
            return this.m_enabled;
        }
    }

    public class SDMGroup {
        private String m_name = null;
        private Vector<String> m_tasks = new Vector();
        private Vector<SDMGroup> m_subGroups = new Vector();

        public SDMGroup(String name) {
            this.m_name = name;
        }

        public void addTask(String task) {
            this.m_tasks.add(task);
        }

        public Vector<String> getTasks() {
            return this.m_tasks;
        }

        public void addSubGroup(SDMGroup group) {
            this.m_subGroups.add(group);
        }

        public Vector<SDMGroup> getSubGroups() {
            return this.m_subGroups;
        }

        public String getName() {
            return this.m_name;
        }
    }
}

