/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SASManifest
extends Manifest {
    private boolean sasVersion = false;
    private int major = 0;
    private int minor = 0;
    private int micro = 0;
    private int sequence = 0;
    private int hotfix = 0;
    private int date = 0;
    private int time = 0;
    private String track = null;

    public SASManifest() {
    }

    public SASManifest(InputStream is) throws IOException {
        super(is);
        this.parseVersionString(this.getMainAttributes().getValue("Implementation-Version"));
        if (!this.sasVersion) {
            this.parseVersionString(this.getMainAttributes().getValue("Specification-Version"));
            if (!this.sasVersion) {
                this.parseVersionString(this.getMainAttributes().getValue("Bundle-Version"));
            }
        }
    }

    public SASManifest(Manifest man) throws IOException {
        super(man);
        this.parseVersionString(this.getMainAttributes().getValue("Implementation-Version"));
        if (!this.sasVersion) {
            this.parseVersionString(this.getMainAttributes().getValue("Specification-Version"));
            if (!this.sasVersion) {
                this.parseVersionString(this.getMainAttributes().getValue("Bundle-Version"));
            }
        }
    }

    public boolean hasSASVersion() {
        return this.sasVersion;
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public int getMicroVersion() {
        return this.micro;
    }

    public int getSequenceNum() {
        return this.sequence;
    }

    public int getHotFixNum() {
        return this.hotfix;
    }

    public String getTrackSpecifier() {
        return this.track;
    }

    public int getDate() {
        return this.date;
    }

    public int getTime() {
        return this.time;
    }

    public boolean containsVersion(String version) {
        boolean ret = true;
        if (this.sasVersion && version != null) {
            try {
                StringTokenizer st = new StringTokenizer(version, ".");
                if (st.hasMoreTokens()) {
                    int major = Integer.parseInt(st.nextToken());
                    if (major != this.getMajorVersion()) {
                        ret = false;
                    } else if (st.hasMoreTokens()) {
                        int minor = Integer.parseInt(st.nextToken());
                        if (minor != this.getMinorVersion()) {
                            ret = false;
                        } else if (st.hasMoreTokens()) {
                            int seq;
                            int micro = Integer.parseInt(st.nextToken());
                            if (micro != this.getMicroVersion()) {
                                ret = false;
                            } else if (st.hasMoreTokens() && (seq = Integer.parseInt(st.nextToken())) != this.getSequenceNum()) {
                                ret = false;
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException nfe) {
                ret = false;
            }
        }
        return ret;
    }

    public int compareTo(SASManifest anotherManifest) {
        int[] a = new int[]{this.getMajorVersion(), this.getMinorVersion(), this.getMicroVersion(), this.getDate(), this.getTime()};
        int[] b = new int[]{anotherManifest.getMajorVersion(), anotherManifest.getMinorVersion(), anotherManifest.getMicroVersion(), anotherManifest.getDate(), anotherManifest.getTime()};
        for (int i = 0; i < a.length; ++i) {
            if (a[i] < b[i]) {
                return -1;
            }
            if (a[i] <= b[i]) continue;
            return 1;
        }
        return 0;
    }

    private void parseVersionString(String version) {
        try {
            Pattern pattern;
            Matcher matcher;
            if (!this.hasSASVersion() && (matcher = (pattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d{3})(\\d{3})_([-_a-zA-Z0-9]+)_(\\d{8})_(\\d+)$")).matcher(version)).find()) {
                this.sasVersion = true;
                this.major = new Integer(matcher.group(1));
                this.minor = new Integer(matcher.group(2));
                this.micro = new Integer(matcher.group(3));
                this.sequence = new Integer(matcher.group(4));
                this.hotfix = new Integer(matcher.group(5));
                this.track = matcher.group(6);
                this.date = new Integer(matcher.group(7));
                this.time = new Integer(matcher.group(8));
            }
            if (!this.hasSASVersion() && (matcher = (pattern = Pattern.compile("^(\\d+)(\\d{2})(\\d{3})\\.\\d+\\.\\d+\\.(\\d{8})(\\d+)_([-_a-zA-Z0-9]+)$")).matcher(version)).find()) {
                this.sasVersion = true;
                this.major = new Integer(matcher.group(1));
                this.minor = new Integer(matcher.group(2));
                this.micro = new Integer(matcher.group(3));
                this.date = new Integer(matcher.group(4));
                this.time = new Integer(matcher.group(5));
                this.track = matcher.group(6);
            }
            if (!this.hasSASVersion() && (matcher = (pattern = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)_SAS_(\\d{8})(\\d+)$")).matcher(version)).find()) {
                this.sasVersion = true;
                this.major = new Integer(matcher.group(1));
                this.minor = new Integer(matcher.group(2));
                this.micro = new Integer(matcher.group(3));
                this.sequence = new Integer(matcher.group(4));
                this.date = new Integer(matcher.group(5));
                this.time = new Integer(matcher.group(6));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

