/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.tools.installs.schema.ittasks.LocaleType;
import java.io.File;
import java.util.Locale;

public class SASLocale
implements Comparable<SASLocale>,
Cloneable {
    private String m_MVAPosixName = null;
    private String m_SASEncoding = null;
    private String m_SASEncodingForSelectedLocale = null;
    private String m_javaEncoding = null;
    private String m_displayText = null;
    private String m_ibmEncoding = null;
    private String m_encodingType = null;
    private String m_encodingTwoByte = null;
    private boolean m_defaultSelection = false;
    private static SSNResource bundle = new SSNResource(SASLocale.class);
    private static SASLocale deployRegLocale = null;
    private static String deployRegJar = null;

    public SASLocale(String mvaPosixName, String sasEncoding, String javaEncoding, String ibmEncoding, String encodingType, String encodingTwoByte) {
        this.m_MVAPosixName = mvaPosixName;
        this.m_SASEncoding = sasEncoding;
        this.m_SASEncodingForSelectedLocale = sasEncoding;
        this.m_javaEncoding = javaEncoding;
        this.m_ibmEncoding = ibmEncoding;
        this.m_encodingType = encodingType;
        this.m_encodingTwoByte = encodingTwoByte;
        if (this.m_MVAPosixName != null) {
            this.m_displayText = bundle.getString("Common.LocaleDisplayName." + this.m_MVAPosixName + ".txt");
            if (this.m_displayText.equals("") || this.m_displayText.startsWith("Missing resource")) {
                this.m_displayText = this.m_MVAPosixName;
            }
        }
    }

    public SASLocale(String mvaPosixName, String sasEncoding, String javaEncoding) {
        this(mvaPosixName, sasEncoding, javaEncoding, null, null, null);
    }

    public SASLocale(LocaleType localeType, String encodingTwoByte) {
        this(localeType.getName(), localeType.getSasEncoding(), localeType.getJavaEncoding(), localeType.getIbmEncoding(), localeType.getEncodingType(), encodingTwoByte);
        Boolean isDefault = localeType.isDefault();
        if (isDefault != null) {
            this.setDefaultSelection(isDefault);
        }
    }

    public String getMVAPosixName() {
        return this.m_MVAPosixName;
    }

    public String getSASEncoding() {
        return this.m_SASEncoding;
    }

    public String getSASEncodingForSelectedLocale() {
        return this.m_SASEncodingForSelectedLocale;
    }

    public String getJavaEncoding() {
        return this.m_javaEncoding;
    }

    public void setDefaultSelection(boolean isDefault) {
        this.m_defaultSelection = isDefault;
    }

    public boolean isDefaultSelection() {
        return this.m_defaultSelection;
    }

    public String getIbmEncoding() {
        return this.m_ibmEncoding;
    }

    public String getEncodingType() {
        return this.m_encodingType;
    }

    public String getEncodingTwoByte() {
        return this.m_encodingTwoByte;
    }

    public void setAsUnicode() {
        this.m_SASEncoding = "UTF-8";
        this.m_javaEncoding = "UTF-8";
    }

    private Locale getJavaLocale() {
        String[] localeDefn = this.m_MVAPosixName.split("_");
        Locale javaLocale = localeDefn.length == 1 ? new Locale(localeDefn[0]) : (localeDefn.length == 2 ? new Locale(localeDefn[0], localeDefn[1]) : new Locale(localeDefn[0], localeDefn[1], localeDefn[2]));
        return javaLocale;
    }

    public boolean isMatchForJavaLocale(Locale checkLocale) {
        Locale javaLocale;
        boolean result = false;
        if (checkLocale != null && (javaLocale = this.getJavaLocale()).getLanguage().equals(checkLocale.getLanguage())) {
            String myCountry = javaLocale.getCountry();
            String myVariant = javaLocale.getVariant();
            result = !(!myCountry.equals(checkLocale.getCountry()) && !"".equals(myCountry) || !myVariant.equals(checkLocale.getVariant()) && !"".equals(myVariant));
        }
        return result;
    }

    private static RegistryAccess getRegistryAccess() {
        RegistryAccess registryAccess = null;
        try {
            File deployRegJar = null;
            if (Globals.g_cmtSASHome != null) {
                deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
            } else {
                String deploymentRegJarFile = RegistryData.getDeployRegJar();
                if (deploymentRegJarFile != null) {
                    deployRegJar = new File(deploymentRegJarFile);
                }
            }
            if (deployRegJar != null && deployRegJar.exists()) {
                registryAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
            }
        }
        catch (Exception e) {
            registryAccess = null;
            Logging.logStackTrace(e);
        }
        return registryAccess;
    }

    public static synchronized SASLocale getSASLocaleFromDeploymentReg(boolean forceRead) {
        if (!forceRead) {
            if (deployRegLocale == null) {
                forceRead = true;
            } else if (Globals.g_cmtSASHome == null) {
                String currentDeployRegJar = RegistryData.getDeployRegJar();
                if (currentDeployRegJar == null) {
                    if (deployRegJar != null) {
                        forceRead = true;
                    }
                } else if (!currentDeployRegJar.equals(deployRegJar)) {
                    forceRead = true;
                }
            }
        }
        if (forceRead) {
            SASLocale foundLocale = null;
            RegistryAccess registryAccess = SASLocale.getRegistryAccess();
            if (registryAccess != null && registryAccess.open()) {
                if (registryAccess.getSashomeLocaleName() != null) {
                    foundLocale = new SASLocale(registryAccess.getSashomeLocaleName(), registryAccess.getSashomeEncodingName(), registryAccess.getSashomeEncodingJavaName(), registryAccess.getSashomeEncodingIbmName(), registryAccess.getSashomeEncodingType(), registryAccess.getSashomeEncodingTwoByte());
                }
                registryAccess.close();
            }
            deployRegLocale = foundLocale == null ? new SASLocale(null, null, null) : foundLocale;
            if (Globals.g_cmtSASHome == null) {
                deployRegJar = RegistryData.getDeployRegJar();
            }
        }
        SASLocale returnLocale = deployRegLocale == null || deployRegLocale.getMVAPosixName() == null ? null : deployRegLocale.clone();
        return returnLocale;
    }

    public static SASLocale getSASLocaleFromDeploymentReg() {
        return SASLocale.getSASLocaleFromDeploymentReg(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean saveSASLocaleInDeploymentReg() {
        boolean success = false;
        if (this.getMVAPosixName() != null) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
                RegistryAccess registryAccess = SASLocale.getRegistryAccess();
                if (registryAccess != null && registryAccess.open()) {
                    registryAccess.setSashomeLocaleName(this.getMVAPosixName());
                    if (this.getSASEncoding() != null) {
                        registryAccess.setSashomeEncodingName(this.getSASEncoding());
                    }
                    if (this.getJavaEncoding() != null) {
                        registryAccess.setSashomeEncodingJavaName(this.getJavaEncoding());
                    }
                    if (this.getIbmEncoding() != null) {
                        registryAccess.setSashomeEncodingIbmName(this.getIbmEncoding());
                    }
                    if (this.getEncodingType() != null) {
                        registryAccess.setSashomeEncodingType(this.getEncodingType());
                    }
                    if (this.getEncodingTwoByte() != null) {
                        registryAccess.setSashomeEncodingTwoByte(this.getEncodingTwoByte());
                    }
                    registryAccess.close();
                    deployRegLocale = this.clone();
                    if (Globals.g_cmtSASHome == null) {
                        deployRegJar = RegistryData.getDeployRegJar();
                    }
                    success = true;
                }
            }
        }
        return success;
    }

    @Override
    public int compareTo(SASLocale otherLocale) {
        return this.toString().compareTo(otherLocale.toString());
    }

    public String toString() {
        return this.m_displayText;
    }

    public SASLocale clone() {
        SASLocale slClone = null;
        try {
            slClone = (SASLocale)super.clone();
        }
        catch (CloneNotSupportedException e) {
            Logging.logStackTrace(e);
        }
        return slClone;
    }
}

