/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.JREData;
import com.sas.ssn.Logging;
import com.sas.ssn.MsiInstallData;
import com.sas.ssn.OrderData;
import com.sas.ssn.ProductData;
import com.sas.ssn.PropsParser;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SASHomeStatus {
    private RegistryAccess registryAccess = null;
    private boolean upgradeSAS = false;
    private boolean sidForSASRequired = false;
    private boolean sidForSPDSRequired = false;
    private boolean sidForJMPRequired = false;
    private boolean sidForSimStudioRequired = false;
    private boolean sidForMomInstallRequired = false;
    private boolean sidForVAERequired = false;
    private boolean isWebinfdsvrRemovedFromUpdateChain = false;
    private Vector<UpdateEntity> newerInstalledProducts = new Vector();
    private Vector<UpdateEntity> requiredInstalls = new Vector();
    private Vector<UpdateEntity> promptedInstalls = new Vector();
    private Vector<UpdateEntity> requiredMaintenance = new Vector();
    private Vector<UpdateEntity> requisiteInstalls = new Vector();
    private Vector<UpdateEntity> processedUpdateEntities = new Vector();
    private Vector<String> mvaAltSkuList = new Vector();
    private HashSet<String> mvaLangList = new HashSet();
    private boolean mvaProductUpdate = false;
    private SSNResource bundle = new SSNResource(SASHomeStatus.class);
    private HashSet<String> installedLanguages = new HashSet();

    SASHomeStatus(String sasHome) {
        Logging.log.fine("Loading SASHomeStatus(\"" + sasHome + "\")...");
        if (Globals.g_order != null) {
            try {
                RegistryData.setRegistry(sasHome);
                this.registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                if (this.registryAccess.open()) {
                    this.loadHosts(this.registryAccess);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            finally {
                if (this.registryAccess != null) {
                    this.registryAccess.close();
                }
            }
        }
        Logging.log.fine("...finished loading SASHomeStatus(\"" + sasHome + "\")");
    }

    private void loadHosts(RegistryAccess registryAccess) {
        String[] hosts = registryAccess.getInstallHosts();
        for (int i = 0; i < hosts.length; ++i) {
            this.loadProducts(hosts[i], registryAccess);
        }
    }

    private void loadProducts(String host, RegistryAccess registryAccess) {
        UpdateEntity updateEntity;
        String[] codes = registryAccess.getInstallCodes(host);
        ArrayList<String> codesList = new ArrayList<String>(Arrays.asList(codes));
        if (host.equals("win") || host.equals("wx6")) {
            Object prodData = this.isProductInDepotForHost(host, "msofficeint");
            if (!Arrays.asList(codes).contains("msofficeint") && prodData != null) {
                codesList.add("msofficeint");
            }
            prodData = this.isProductInDepotForHost(host, "eguide");
            if (!Arrays.asList(codes).contains("eguide") && prodData != null) {
                codesList.add("eguide");
            }
        }
        for (String code : codesList) {
            this.loadVersions(host, code, registryAccess);
        }
        this.addRequiredProducts(this.processedUpdateEntities, host);
        if (this.requiredInstalls.size() == 1 && this.requiredMaintenance.isEmpty() && "zostools".equals((updateEntity = this.requiredInstalls.firstElement()).getBaseProductData().getProdCode())) {
            this.requiredInstalls.remove(updateEntity);
            this.mvaProductUpdate = false;
            this.upgradeSAS = false;
        }
        if (this.mvaProductUpdate) {
            for (String spsSku : this.mvaAltSkuList) {
                SpsSkuData mvaData;
                int i;
                String prodCode = Globals.g_deploymentData.getSpsSku(spsSku).getProdCode();
                updateEntity = null;
                ProductData[] productDataArray = Globals.g_deploymentData.getProductArray(Globals.g_order, prodCode, host, false);
                ProductData productData = productDataArray[0];
                for (i = 0; i < productDataArray.length; ++i) {
                    if (!Globals.g_deploymentData.getSpsSku(productDataArray[i].getSpsSku()).isStandardLanguage()) continue;
                    productData = productDataArray[i];
                    for (UpdateEntity existingEntity : this.requiredMaintenance) {
                        if (!productData.getSpsSku().equals(existingEntity.getBaseProductData().getSpsSku())) continue;
                        existingEntity.removeInstallSteps();
                    }
                    for (UpdateEntity existingEntity : this.requiredInstalls) {
                        if (!productData.getSpsSku().equals(existingEntity.getBaseProductData().getSpsSku())) continue;
                        existingEntity.removeInstallSteps();
                        updateEntity = existingEntity;
                    }
                    i = productDataArray.length;
                }
                if (updateEntity == null) {
                    updateEntity = new UpdateEntity(productData);
                    updateEntity.setUpdateHidden(true);
                    updateEntity.setExistingProductName(productData.getProdName());
                    updateEntity.setExistingProductVersion(productData.getProdVersion());
                    updateEntity.setExistingCustomerVersion(productData.getProdCustVersion());
                    updateEntity.setExistingLastPortDate(productData.getLastPortDate());
                    updateEntity.setExistingLanguages(this.mvaLangList.toArray(new String[0]));
                    this.requiredInstalls.add(updateEntity);
                }
                for (i = 0; i < productDataArray.length; ++i) {
                    productData = productDataArray[i];
                    mvaData = Globals.g_deploymentData.getSpsSku(productData.getSpsSku());
                    if (!mvaData.isStandardLanguage() && !this.mvaLangList.contains(mvaData.getLanguage())) continue;
                    updateEntity.addInstallStep(productData);
                }
                productData = Globals.g_deploymentData.getMaintenance(Globals.g_order, prodCode, host, "xx", false);
                if (productData != null && (mvaData = Globals.g_deploymentData.getSpsSku(productData.getSpsSku())).isMaintLevelGreaterThanZero() && mvaData.isDeltaRelease()) {
                    updateEntity.addInstallStep(productData);
                }
                for (String language : this.mvaLangList) {
                    productData = Globals.g_deploymentData.getMaintenance(Globals.g_order, prodCode, host, language, false);
                    if (productData == null || !(mvaData = Globals.g_deploymentData.getSpsSku(productData.getSpsSku())).isMaintLevelGreaterThanZero() || !mvaData.isDeltaRelease()) continue;
                    updateEntity.addInstallStep(productData);
                }
            }
        }
        this.mvaAltSkuList.clear();
        this.mvaLangList.clear();
        this.mvaProductUpdate = false;
        if (this.requiredInstalls.size() == 1 && this.requiredMaintenance.isEmpty() && (updateEntity = this.requiredInstalls.firstElement()).isUpdateHidden() && "instqualtool".equals(updateEntity.getBaseProductData().getProdCode())) {
            this.requiredInstalls.remove(updateEntity);
        }
    }

    private ProductData isProductInDepotForHost(String host, String productCode) {
        ProductData productData = null;
        ProductData[] productArray = Globals.g_deploymentData.getProductArrayByRegPlat(Globals.g_order, productCode, host, false);
        for (int j = 0; j < productArray.length && productData == null; ++j) {
            if (!Globals.g_deploymentData.getSpsSku(productArray[j].getSpsSku()).isStandardLanguage()) continue;
            productData = productArray[j];
        }
        return productData;
    }

    private void loadVersions(String host, String code, RegistryAccess registryAccess) {
        int j;
        boolean newerInstalledProduct = false;
        String[] versions = registryAccess.getInstallVersions(code, host);
        if ("privatejre".equalsIgnoreCase(code) && versions.length > 1) {
            String bitness;
            String newestVersion = versions[0];
            String newestLastPortDate = registryAccess.getInstallLastPortDate(code, versions[0], host);
            for (j = 1; j < versions.length; ++j) {
                String currentVersion = versions[j];
                String currentLastPortDate = registryAccess.getInstallLastPortDate(code, versions[j], host);
                if (registryAccess.getInstallStatus(code, currentVersion, host) != "0") {
                    registryAccess.removeInstall(code, currentVersion, host);
                    continue;
                }
                if (Utils.isNewerVersion(currentVersion, currentLastPortDate, newestVersion, newestLastPortDate)) {
                    registryAccess.removeInstall(code, newestVersion, host);
                    newestVersion = currentVersion;
                    newestLastPortDate = currentLastPortDate;
                    continue;
                }
                registryAccess.removeInstall(code, currentVersion, host);
            }
            versions = new String[]{newestVersion};
            if (Utils.getOS_Suffix() == "wx6" && Globals.g_sasinstallPlat == null && (bitness = registryAccess.getInstallLoc("privatejre", versions[0], "wx6")) == null && (bitness = registryAccess.getInstallLoc("privatejre", versions[0], "win")) != null) {
                Globals.g_sasinstallPlat = "win";
            }
        }
        if (code.equalsIgnoreCase("eguide") || code.equalsIgnoreCase("msofficeint")) {
            MsiInstallData msiData;
            ProductData prodData = null;
            ProductData[] productArray = Globals.g_deploymentData.getProductArrayByRegPlat(Globals.g_order, code, host, false);
            for (j = 0; j < productArray.length && prodData == null; ++j) {
                if (!Globals.g_deploymentData.getSpsSku(productArray[j].getSpsSku()).isStandardLanguage()) continue;
                prodData = productArray[j];
            }
            if (prodData != null && (msiData = new MsiInstallData(prodData, versions)).isAutoUpdate()) {
                prodData.setAutoUpdate(true);
            }
        }
        for (int i = 0; i < versions.length; ++i) {
            String version = versions[i];
            newerInstalledProduct = false;
            if (!this.isValidInstallation(code, version, host)) {
                registryAccess.removeInstall(code, version, host);
                continue;
            }
            if (Globals.g_skipSASUpdate || Globals.g_order == null) continue;
            ProductData productData = null;
            ProductData[] productArray = Globals.g_deploymentData.getProductArrayByRegPlat(Globals.g_order, code, host, false);
            for (int j2 = 0; j2 < productArray.length && productData == null; ++j2) {
                if (!Globals.g_deploymentData.getSpsSku(productArray[j2].getSpsSku()).isStandardLanguage()) continue;
                productData = productArray[j2];
            }
            if ("sasinstall".equalsIgnoreCase(code)) {
                productData = null;
            }
            if ("webinfdsvr".equalsIgnoreCase(code)) {
                productData = null;
                this.setWebinfdsvrRemovedFromUpdateChain(true);
            }
            if ((code.equalsIgnoreCase("eguide") || code.equalsIgnoreCase("msofficeint")) && productData != null && productData.isAutoUpdate()) {
                productData = null;
            }
            if (productData == null) continue;
            boolean indbProduct = Globals.g_deploymentData.getSpsSku(productData.getSpsSku()).getIndb();
            Vector<UpdateEntity> maintenanceQueue = this.requiredMaintenance;
            UpdateEntity updateEntity = new UpdateEntity(productData);
            String currentProductName = registryAccess.getInstallDisplayName(code, version, host);
            if (currentProductName == null || currentProductName.length() == 0) {
                currentProductName = productData.getProdName();
            }
            String currentLastPortDate = registryAccess.getInstallLastPortDate(code, version, host);
            String currentCustomerVersion = null;
            if (registryAccess.getMaintLevel(code, version, host) != null) {
                currentCustomerVersion = registryAccess.getMaintDisplayName(code, version, host, registryAccess.getMaintLevel(code, version, host));
            }
            if (currentCustomerVersion == null || currentCustomerVersion.length() == 0) {
                currentCustomerVersion = version;
            }
            HashSet<String> langSet = new HashSet<String>(Arrays.asList(registryAccess.getInstallLanguages(code, version, host)));
            if (code.equals("base")) {
                this.installedLanguages.addAll(langSet);
            }
            updateEntity.setExistingProductName(currentProductName);
            updateEntity.setExistingProductVersion(version);
            updateEntity.setExistingCustomerVersion(currentCustomerVersion);
            updateEntity.setExistingLastPortDate(currentLastPortDate);
            updateEntity.setExistingLanguages(langSet.toArray(new String[0]));
            if (productData.isFoundation()) {
                this.mvaAltSkuList.add(productData.getSpsSku());
                this.mvaLangList.addAll(langSet);
            }
            if ("base".equalsIgnoreCase(productData.getProdCode())) {
                Globals.g_installingBasePlatform = productData.getPlatform();
                this.sidForSASRequired = true;
            }
            if ("javaruntime".equalsIgnoreCase(productData.getProdCode())) {
                productData = null;
            } else if ("privatejre".equalsIgnoreCase(productData.getProdCode())) {
                if (!Utils.isNewerVersion(productData.getProdVersion(), productData.getLastPortDate(), version, currentLastPortDate)) {
                    String currentinstalledloc = registryAccess.getInstallLoc(code, version, host);
                    JREData.setJREData(host, false, registryAccess);
                    JREData.setPrivateJREDest(currentinstalledloc);
                } else {
                    JREData.setJREData(host, true, registryAccess);
                }
                productData = null;
            } else if (productData.getPrompt() || Utils.isNewerVersion(productData.getProdVersion(), productData.getLastPortDate(), version, currentLastPortDate)) {
                if (productData.getPrompt()) {
                    maintenanceQueue = this.promptedInstalls;
                    if (!Globals.g_forceThirdPartyPrompt) {
                        productData = null;
                    }
                } else if (Globals.g_maintOnly) {
                    productData = null;
                } else if (!this.isValidInstallation(productData.getProdCode(), productData.getProdVersion(), host)) {
                    maintenanceQueue = this.requiredInstalls;
                } else {
                    productData = null;
                }
                if (productData != null) {
                    for (UpdateEntity existingEntity : maintenanceQueue) {
                        if (!existingEntity.getBaseProductData().getSpsSku().equals(productData.getSpsSku())) continue;
                        if (Utils.isNewerVersion(version, currentLastPortDate, existingEntity.getExistingProductVersion(), existingEntity.getExistingLastPortDate())) {
                            existingEntity.setExistingProductName(updateEntity.getExistingProductName());
                            existingEntity.setExistingProductVersion(updateEntity.getExistingProductVersion());
                            existingEntity.setExistingCustomerVersion(updateEntity.getExistingCustomerVersion());
                            existingEntity.setExistingLastPortDate(updateEntity.getExistingLastPortDate());
                            existingEntity.setExistingLanguages(updateEntity.getExistingLanguages());
                        }
                        productData = null;
                        break;
                    }
                    if (productData != null) {
                        String sidType;
                        String[] setnumids;
                        if ("base".equalsIgnoreCase(code)) {
                            this.sidForSASRequired = true;
                        }
                        if (code.equalsIgnoreCase("tklasr")) {
                            this.sidForSASRequired = true;
                        } else if (this.isSASSidRequiredForVAE(code, versions)) {
                            this.sidForSASRequired = true;
                            this.sidForVAERequired = true;
                        } else if ("spds".equalsIgnoreCase(code)) {
                            this.sidForSPDSRequired = true;
                        } else if ("jmp".equalsIgnoreCase(code) || "jmp64".equalsIgnoreCase(code) || "jmpgenom".equalsIgnoreCase(code) || "jmp64genom".equalsIgnoreCase(code) || "jmpclin".equalsIgnoreCase(code) || "jmp64clin".equalsIgnoreCase(code) || "jmppro".equalsIgnoreCase(code) || "jmplifesci".equalsIgnoreCase(code) || "jmpwithsas".equalsIgnoreCase(code)) {
                            this.sidForJMPRequired = true;
                        } else if ("simstudio".equalsIgnoreCase(code)) {
                            setnumids = Globals.g_deploymentData.getOrder(Globals.g_order).getSetnumids();
                            for (int j3 = 0; j3 < setnumids.length; ++j3) {
                                sidType = Globals.g_deploymentData.getOrder(Globals.g_order).getSidType(setnumids[j3]);
                                if (!"NAP".equals(sidType) || !Globals.g_deploymentData.getOrder(Globals.g_order).getSidProducts(setnumids[i]).contains("simstudio")) continue;
                                this.sidForSimStudioRequired = true;
                                break;
                            }
                            if (!this.sidForSimStudioRequired) {
                                this.sidForSASRequired = true;
                            }
                        } else if ("mominstall".equalsIgnoreCase(code)) {
                            setnumids = Globals.g_deploymentData.getOrder(Globals.g_order).getSetnumids();
                            for (int j4 = 0; j4 < setnumids.length; ++j4) {
                                sidType = Globals.g_deploymentData.getOrder(Globals.g_order).getSidType(setnumids[j4]);
                                if (!"NAP".equals(sidType) || !this.isAMomProduct(setnumids[i])) continue;
                                this.sidForMomInstallRequired = true;
                                break;
                            }
                            if (!this.sidForMomInstallRequired) {
                                this.sidForSASRequired = true;
                            }
                        }
                        if (productData != null) {
                            for (int j5 = 0; j5 < productArray.length; ++j5) {
                                SpsSkuData spsSkuData = Globals.g_deploymentData.getSpsSku(productArray[j5].getSpsSku());
                                if (spsSkuData.isMaintLevelGreaterThanZero()) continue;
                                if (productArray[j5].getPrompt() || productArray[j5].getChainingRef(false).length() > 0) {
                                    if (productArray[j5].isFoundation()) {
                                        this.mvaProductUpdate = true;
                                    }
                                    if (!spsSkuData.isStandardLanguage() && !langSet.contains(spsSkuData.getLanguage())) continue;
                                    updateEntity.addInstallStep(productArray[j5]);
                                    continue;
                                }
                                productData = null;
                            }
                        }
                    }
                }
            } else if (!version.equals(productData.getProdVersion())) {
                productData = null;
                newerInstalledProduct = true;
            }
            if (productData != null) {
                this.processedUpdateEntities.add(updateEntity);
            }
            if (productData != null) {
                boolean maintenanceProcessed = false;
                int currentMaintLevel = 0;
                String currentMaintString = registryAccess.getMaintLevel(productData.getProdCode(), productData.getProdVersion(), host);
                if (currentMaintString != null && currentMaintString.length() > 0) {
                    currentMaintLevel = Integer.parseInt(currentMaintString);
                }
                ProductData[] maintData = indbProduct ? Globals.g_deploymentData.getIndbMaintenance(Globals.g_order, code, Utils.getOS_Suffix(), host, false) : Globals.g_deploymentData.getMaintenance(Globals.g_order, code, host, false);
                for (int j6 = 0; j6 < maintData.length; ++j6) {
                    maintenanceProcessed = true;
                    SpsSkuData spsSkuData = Globals.g_deploymentData.getSpsSku(maintData[j6].getSpsSku());
                    if (!spsSkuData.isStandardLanguage() && !langSet.contains(spsSkuData.getLanguage())) continue;
                    if (Integer.parseInt(maintData[j6].getProdMaint()) < currentMaintLevel) {
                        newerInstalledProduct = true;
                        continue;
                    }
                    if (!Globals.g_forceMaint && Integer.parseInt(maintData[j6].getProdMaint()) <= currentMaintLevel) continue;
                    updateEntity.addInstallStep(maintData[j6]);
                }
                if (!maintenanceProcessed) {
                    if (productData.getProdMaint().length() > 0) {
                        if (Integer.parseInt(productData.getProdMaint()) < currentMaintLevel) {
                            newerInstalledProduct = true;
                        }
                    } else if (currentMaintLevel > 0) {
                        newerInstalledProduct = true;
                    }
                }
                if (Globals.g_z64 && "mvs".equals(updateEntity.getBaseProductData().getPlatform()) || !Globals.g_z64 && "z64".equals(updateEntity.getBaseProductData().getPlatform())) {
                    if (updateEntity.getBaseProductData().isFoundation()) {
                        this.mvaProductUpdate = false;
                    }
                    updateEntity.removeInstallSteps();
                }
                if (updateEntity.getInstallSteps().size() > 0) {
                    if (productData.isFoundation() || Utils.getOS() == 8 && (!Globals.g_z64 && productData.getSpsSku().contains("__mvs__") || Globals.g_z64 && productData.getSpsSku().contains("__z64__"))) {
                        this.upgradeSAS = true;
                    }
                    maintenanceQueue.add(updateEntity);
                }
            }
            if (!newerInstalledProduct || this.isAnIgnoreNewerProduct(code)) continue;
            for (int j7 = this.newerInstalledProducts.size() - 1; j7 >= -1; --j7) {
                if (j7 == -1) {
                    this.newerInstalledProducts.add(j7 + 1, updateEntity);
                    continue;
                }
                UpdateEntity entity = this.newerInstalledProducts.get(j7);
                if ((entity.getExistingProductName() + entity.getExistingCustomerVersion()).compareTo(updateEntity.getExistingProductName() + updateEntity.getExistingCustomerVersion()) > 0) continue;
                this.newerInstalledProducts.add(j7 + 1, updateEntity);
                j7 = -1;
            }
        }
    }

    private boolean isAnIgnoreNewerProduct(String code) {
        OrderData order;
        return "certframe".equalsIgnoreCase(code) && (order = Globals.g_deploymentData.getOrder(Globals.g_order)).isWeb();
    }

    private boolean isAMomProduct(String setnumids) {
        Vector<String> sidProducts = Globals.g_deploymentData.getOrder(Globals.g_order).getSidProducts(setnumids);
        if (sidProducts.contains("mominstall")) {
            return true;
        }
        if (sidProducts.contains("momfdnbndl")) {
            return true;
        }
        return sidProducts.contains("momsdmbndl");
    }

    private boolean isSASSidRequiredForVAE(String code, String[] versions) {
        boolean isRequired = true;
        if (!code.equalsIgnoreCase("sagemid")) {
            return false;
        }
        String lowerCaseCode = code.toLowerCase(Locale.ENGLISH);
        String[] vaProductCodes = new String[]{"sagemid"};
        ArrayList<String> productCodes = new ArrayList<String>();
        for (String each : vaProductCodes) {
            productCodes.add(each);
        }
        if (productCodes.contains(lowerCaseCode) && this.containsVersionWithCorrectLicense(versions)) {
            isRequired = false;
        }
        return isRequired;
    }

    private boolean containsVersionWithCorrectLicense(String[] versions) {
        boolean hasVersionWithVAESidSlot = false;
        ArrayList<String> existingVersions = new ArrayList<String>(Arrays.asList(versions));
        for (String version : existingVersions) {
            hasVersionWithVAESidSlot = this.isVersionOK(version);
            if (!hasVersionWithVAESidSlot) continue;
            return true;
        }
        return hasVersionWithVAESidSlot;
    }

    private boolean isVersionOK(String compare) {
        String[] regexs;
        String regex7Dot3 = "^([7])\\.([3-9][0-9]?)(_[mM][0-9]+)?$";
        String regex8or9 = "^([8-9]+)\\.([0-9]+)(_[mM][0-9]+)?$";
        String regex10orHigher = "^([1-9]+[0-9]+)\\.([0-9]+)(_[mM][0-9]+)?$";
        for (String each : regexs = new String[]{regex7Dot3, regex8or9, regex10orHigher}) {
            boolean found = this.findMatch(each, compare);
            if (!found) continue;
            return true;
        }
        return false;
    }

    private boolean findMatch(String regex, String str) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(str);
        return matcher.find();
    }

    private void addRequiredProducts(Vector<UpdateEntity> updateEntities, String host) {
        ArrayList<String> dependencyInstalls = new ArrayList<String>();
        for (UpdateEntity processedUpdateEntity : updateEntities) {
            if (processedUpdateEntity.getBaseProductData().getPrompt()) continue;
            String[] spsSkus = Globals.g_deploymentData.getOrder(Globals.g_order).chaseRequirements("triggers_install", processedUpdateEntity.getBaseProductData().getSpsSku(), host);
            for (int i = 0; i < spsSkus.length; ++i) {
                HashSet<String> langSet;
                UpdateEntity updateEntity = null;
                ProductData[] productArray = null;
                ProductData productData = null;
                String requirementHost = null;
                SpsSkuData spsSkuData = Globals.g_deploymentData.getSpsSku(spsSkus[i]);
                Vector<UpdateEntity> maintenanceQueue = spsSkuData.isSysReq() ? this.requisiteInstalls : this.requiredInstalls;
                boolean indbProduct = spsSkuData.getIndb();
                if ("privatejre".equalsIgnoreCase(spsSkuData.getProdCode())) {
                    Logging.log.fine("Found privatejre");
                } else if (!"javaruntime".equalsIgnoreCase(spsSkuData.getProdCode())) {
                    if (indbProduct) {
                        requirementHost = spsSkuData.getPlatform();
                        productData = Globals.g_deploymentData.getIndbProduct(Globals.g_order, spsSkuData.getProdCode(), Utils.getOS_Suffix(), requirementHost, false);
                        if (productData != null) {
                            productArray = new ProductData[]{productData};
                        }
                    } else {
                        requirementHost = spsSkuData.platformToDeploy(Utils.getOS_Suffix());
                        if (spsSkuData.isTargetByBaseHost()) {
                            requirementHost = this.registryAccess.getInstallLoc("base", Globals.g_majorReleaseVersion, Utils.getOS_Suffix()) != null && this.registryAccess.getInstallVersions(spsSkuData.getProdCode(), Utils.getOS_Suffix()).length == 0 ? Utils.getOS_Suffix() : (Utils.getOS_Suffix() == "wx6" && this.registryAccess.getInstallLoc("base", Globals.g_majorReleaseVersion, "win") != null && this.registryAccess.getInstallVersions(spsSkuData.getProdCode(), "win").length == 0 ? "win" : (Utils.getOS_Suffix() == "lax" && this.registryAccess.getInstallLoc("base", Globals.g_majorReleaseVersion, "lnx") != null && this.registryAccess.getInstallVersions(spsSkuData.getProdCode(), "lnx").length == 0 ? "lnx" : null));
                        }
                        if (Globals.g_z64 && "mvs".equals(requirementHost) || !Globals.g_z64 && "z64".equals(requirementHost)) {
                            requirementHost = null;
                        }
                        if (requirementHost != null) {
                            productArray = Globals.g_deploymentData.getProductArray(Globals.g_order, Globals.g_deploymentData.getSpsSku(spsSkus[i]).getProdCode(), requirementHost, false);
                            for (int j = 0; productData == null && j < productArray.length; ++j) {
                                if (!spsSkus[i].equals(productArray[j].getSpsSku())) continue;
                                productData = productArray[j];
                            }
                        }
                    }
                    if (productData != null && productData.isFoundation() && this.registryAccess.getInstallVersions("base", requirementHost).length == 0) {
                        productData = null;
                    }
                    if (productData != null) {
                        if (productData.getProdCode().equalsIgnoreCase("msofficeint") && Utils.getOS_Suffix() == "wx6") {
                            if (this.registryAccess.getInstallVersions("msofficeint", "wx6").length != 0 || this.registryAccess.getInstallVersions("msofficeint", "win").length != 0) {
                                productData = null;
                            }
                        } else if (productData.getProdCode().equalsIgnoreCase("eguide") && Utils.getOS_Suffix() == "wx6" && (this.registryAccess.getInstallVersions("eguide", "wx6").length != 0 || this.registryAccess.getInstallVersions("eguide", "win").length != 0)) {
                            productData = null;
                        }
                    }
                }
                if (productData == null || this.registryAccess.getInstallVersions(productData.getProdCode(), requirementHost).length != 0) continue;
                for (UpdateEntity existingEntity : maintenanceQueue) {
                    if (!existingEntity.getBaseProductData().getSpsSku().equals(productData.getSpsSku())) continue;
                    updateEntity = existingEntity;
                    break;
                }
                if (updateEntity == null) {
                    if (productData.getChainingRef(false).length() > 0) {
                        updateEntity = new UpdateEntity(productData);
                        updateEntity.setUpdateHidden(true);
                        updateEntity.setExistingProductName(productData.getProdName());
                        updateEntity.setExistingProductVersion(null);
                        updateEntity.setExistingCustomerVersion(null);
                        updateEntity.setExistingLastPortDate(null);
                        if (productData.isFoundation()) {
                            this.upgradeSAS = true;
                            this.mvaProductUpdate = true;
                            if (!this.mvaAltSkuList.contains(productData.getSpsSku())) {
                                this.mvaAltSkuList.add(productData.getSpsSku());
                            }
                            updateEntity.setExistingLanguages(this.mvaLangList.toArray(new String[0]));
                        } else {
                            updateEntity.setExistingLanguages(processedUpdateEntity.getExistingLanguages());
                        }
                        if (!Globals.g_DocUpdate || Globals.g_deploymentData.getSpsSku(productData.getSpsSku()).getDoc()) {
                            maintenanceQueue.add(updateEntity);
                        } else {
                            Logging.log.fine("For doc update, " + productData.getProdCode() + " is not a document product.");
                        }
                        if (!Globals.g_DocUpdate && !spsSkuData.isSysReq()) {
                            dependencyInstalls.add(productData.getProdCode());
                        }
                    }
                } else {
                    langSet = new HashSet<String>(Arrays.asList(updateEntity.getExistingLanguages()));
                    langSet.addAll(Arrays.asList(processedUpdateEntity.getExistingLanguages()));
                    if (langSet.equals(new HashSet<String>(Arrays.asList(updateEntity.getExistingLanguages())))) {
                        updateEntity = null;
                    } else {
                        updateEntity.removeInstallSteps();
                        updateEntity.setExistingLanguages(langSet.toArray(new String[0]));
                    }
                }
                if (updateEntity == null) continue;
                langSet = new HashSet<String>(Arrays.asList(updateEntity.getExistingLanguages()));
                for (int k = 0; k < productArray.length; ++k) {
                    if (productArray[k].getChainingRef(false).length() <= 0 || (spsSkuData = Globals.g_deploymentData.getSpsSku(productArray[k].getSpsSku())).isMaintLevelGreaterThanZero() || !spsSkuData.isStandardLanguage() && !langSet.contains(spsSkuData.getLanguage())) continue;
                    updateEntity.addInstallStep(productArray[k]);
                }
                ProductData[] maintData = indbProduct ? Globals.g_deploymentData.getIndbMaintenance(Globals.g_order, productData.getProdCode(), Utils.getOS_Suffix(), requirementHost, false) : Globals.g_deploymentData.getMaintenance(Globals.g_order, productData.getProdCode(), requirementHost, false);
                for (int k = 0; k < maintData.length; ++k) {
                    if (maintData[k].getChainingRef(false).length() <= 0 || !(spsSkuData = Globals.g_deploymentData.getSpsSku(maintData[k].getSpsSku())).isStandardLanguage() && !langSet.contains(spsSkuData.getLanguage())) continue;
                    updateEntity.addInstallStep(maintData[k]);
                }
            }
        }
        if (Globals.g_dependencyInstalls == null || Globals.g_dependencyInstalls.length == 0) {
            Globals.g_dependencyInstalls = dependencyInstalls.toArray(new String[0]);
        } else if (dependencyInstalls.size() > 0) {
            int i;
            ArrayList<String> tmpArrList = new ArrayList<String>();
            for (i = 0; i < Globals.g_dependencyInstalls.length; ++i) {
                tmpArrList.add(Globals.g_dependencyInstalls[i]);
            }
            for (i = 0; i < dependencyInstalls.size(); ++i) {
                String dep = (String)dependencyInstalls.get(i);
                if (tmpArrList.contains(dep)) continue;
                tmpArrList.add(dep);
            }
            Globals.g_dependencyInstalls = tmpArrList.toArray(new String[0]);
        }
    }

    private boolean containsFiles(File directory) {
        boolean found = false;
        File[] files = directory.listFiles();
        if (files != null) {
            for (int i = 0; !found && i < files.length; ++i) {
                found = files[i].isDirectory() ? this.containsFiles(files[i]) : true;
            }
        }
        return found;
    }

    private boolean isValidInstallation(String code, String version, String host) {
        boolean valid = false;
        String installLoc = this.registryAccess.getInstallLoc(code, version, host);
        String installKeyFile = this.registryAccess.getInstallKeyFile(code, version, host);
        if (("mvs".equals(host) || "z64".equals(host)) && installLoc != null && !installLoc.startsWith("/")) {
            valid = true;
        }
        if (!valid) {
            if (installKeyFile != null) {
                valid = new File(installKeyFile).isFile();
            } else if (installLoc != null) {
                valid = this.containsFiles(new File(installLoc));
            }
        }
        return valid;
    }

    public HashSet<String> getInstalledLanguages() {
        return this.installedLanguages;
    }

    public UpdateEntity[] getNewerInstalledProducts() {
        return this.newerInstalledProducts.toArray(new UpdateEntity[0]);
    }

    public boolean visibleRequiredInstalls() {
        boolean visible = false;
        for (UpdateEntity entity : this.requiredInstalls) {
            if (entity.isUpdateHidden() || "zostools".equalsIgnoreCase(entity.getBaseProductData().getProdCode())) continue;
            visible = true;
            break;
        }
        return visible;
    }

    public UpdateEntity[] getRequiredInstalls() {
        return this.requiredInstalls.toArray(new UpdateEntity[0]);
    }

    public ProductData[] getRequiredInstallSteps() {
        Vector<ProductData> queue = new Vector<ProductData>();
        for (UpdateEntity entity : this.requiredInstalls) {
            queue.addAll(entity.getInstallSteps());
        }
        return queue.toArray(new ProductData[0]);
    }

    public UpdateEntity[] getPromptedInstalls() {
        return this.promptedInstalls.toArray(new UpdateEntity[0]);
    }

    public ProductData[] getPromptedInstallSteps() {
        Vector<ProductData> queue = new Vector<ProductData>();
        for (UpdateEntity entity : this.promptedInstalls) {
            queue.addAll(entity.getInstallSteps());
        }
        return queue.toArray(new ProductData[0]);
    }

    public boolean visibleRequiredMaintenance() {
        boolean visible = false;
        for (UpdateEntity entity : this.requiredMaintenance) {
            if (entity.isUpdateHidden()) continue;
            visible = true;
            break;
        }
        return visible;
    }

    public UpdateEntity[] getRequiredMaintenance() {
        return this.requiredMaintenance.toArray(new UpdateEntity[0]);
    }

    public ProductData[] getRequiredMaintenanceInstallSteps() {
        Vector<ProductData> queue = new Vector<ProductData>();
        for (UpdateEntity entity : this.requiredMaintenance) {
            queue.addAll(entity.getInstallSteps());
        }
        return queue.toArray(new ProductData[0]);
    }

    public UpdateEntity[] getRequisites() {
        return this.requisiteInstalls.toArray(new UpdateEntity[0]);
    }

    public ProductData[] getRequisiteInstallSteps() {
        Vector<ProductData> queue = new Vector<ProductData>();
        for (UpdateEntity entity : this.requisiteInstalls) {
            queue.addAll(entity.getInstallSteps());
        }
        return queue.toArray(new ProductData[0]);
    }

    public boolean updatesRequired() {
        return (!this.requiredInstalls.isEmpty() || !this.requiredMaintenance.isEmpty()) && !Globals.g_resumeChain;
    }

    public boolean isSASUpgrade() {
        return this.upgradeSAS;
    }

    public boolean isSASSIDRequired() {
        return this.sidForSASRequired;
    }

    public boolean isSASSIDRequiredForVAE() {
        return this.sidForVAERequired;
    }

    public boolean isSPDSSIDRequired() {
        return this.sidForSPDSRequired;
    }

    public boolean isJMPSIDRequired() {
        return this.sidForJMPRequired;
    }

    protected boolean isSimStudioSIDRequired() {
        return this.sidForSimStudioRequired;
    }

    protected boolean isMomInstallSIDRequired() {
        return this.sidForMomInstallRequired;
    }

    public boolean isNewerSASHome() {
        return !this.newerInstalledProducts.isEmpty();
    }

    public boolean isEmptySASHome() {
        return this.processedUpdateEntities.isEmpty();
    }

    public boolean isSimStudioInAnUpdateChain() {
        for (UpdateEntity update : this.requiredInstalls) {
            if (!update.getBaseProductData().getProdCode().equals("simstudio")) continue;
            return true;
        }
        for (UpdateEntity update : this.requiredMaintenance) {
            if (!update.getBaseProductData().getProdCode().equals("simstudio")) continue;
            return true;
        }
        return false;
    }

    public boolean isMomInstallInAnUpdateChain() {
        for (UpdateEntity update : this.requiredInstalls) {
            if (!update.getBaseProductData().getProdCode().equals("mominstall")) continue;
            return true;
        }
        for (UpdateEntity update : this.requiredMaintenance) {
            if (!update.getBaseProductData().getProdCode().equals("mominstall")) continue;
            return true;
        }
        return false;
    }

    public boolean isWebinfdsvrRemovedFromUpdateChain() {
        return this.isWebinfdsvrRemovedFromUpdateChain;
    }

    private void setWebinfdsvrRemovedFromUpdateChain(boolean removed) {
        this.isWebinfdsvrRemovedFromUpdateChain = removed;
    }

    public boolean checkForM9(String sasHome) {
        String launcherArgs = this.findSDMLauncherArgs(sasHome);
        String altSku = this.parseArgsForVersion(launcherArgs);
        if (altSku == null) {
            return false;
        }
        return Integer.parseInt(altSku) >= 94614;
    }

    private String parseArgsForVersion(String launcherArgs) {
        if (launcherArgs == null) {
            return null;
        }
        String regex = "^.*-jar .*?deploywiz__(\\d+)__prt__xx__sp0__1.*?deploywiz.*?setup.jar.*$";
        Pattern pattern = Pattern.compile(regex);
        Matcher match = pattern.matcher(Pattern.quote(launcherArgs));
        if (match.find() && match.groupCount() > 0) {
            Logging.log.info("Found deploywiz skuid subdirectory = " + match.group(1));
            return match.group(1);
        }
        Logging.log.info("Did not find deploywiz skuid subdirectory.");
        return null;
    }

    private String findSDMLauncherArgs(String sasHome) {
        String args = null;
        PropsParser sdmProps = new PropsParser(true);
        Path sdmIniPath = Paths.get(sasHome, "SASDeploymentManager", "9.4", "sasdm.ini");
        File sasdmIniFile = new File(sdmIniPath.toString());
        try {
            sdmProps.load(sasdmIniFile, null);
            args = sdmProps.getINIValue("default", "launcherargs", null);
        }
        catch (Exception e) {
            Logging.logStackTrace(e);
        }
        if (args == null) {
            Logging.log.severe("No launcherargs found in [default] section of sasdm.ini: " + sasdmIniFile);
        }
        return args;
    }

    public class UpdateEntity {
        private ProductData baseProductData;
        private boolean updateHidden = false;
        private String existingProductName;
        private String existingProductVersion;
        private String existingCustomerVersion;
        private String existingLastPortDate;
        private String[] existingLanguages;
        private String updatedProductName;
        private String updatedProductVersion;
        private String updatedCustomerVersion;
        private Vector<ProductData> installSteps = new Vector();

        UpdateEntity(ProductData baseProductData) {
            this.baseProductData = baseProductData;
        }

        public void setUpdateHidden(boolean hidden) {
            this.updateHidden = hidden;
        }

        protected void setExistingProductName(String name) {
            this.existingProductName = name;
        }

        protected void setExistingProductVersion(String version) {
            this.existingProductVersion = version;
        }

        protected void setExistingCustomerVersion(String version) {
            this.existingCustomerVersion = version;
        }

        protected void setExistingLastPortDate(String date) {
            this.existingLastPortDate = date;
        }

        protected void setExistingLanguages(String[] languages) {
            this.existingLanguages = languages;
        }

        protected void addInstallStep(ProductData installStep) {
            this.updatedProductName = installStep.getProdName();
            this.updatedProductVersion = installStep.getProdVersion();
            this.updatedCustomerVersion = installStep.getProdCustVersion();
            if (!Globals.g_DocUpdate) {
                this.installSteps.add(installStep);
                Logging.log.fine("Adding required products: " + installStep.getProdCode());
            } else if (Globals.g_deploymentData.getSpsSku(installStep.getSpsSku()).getDoc()) {
                Logging.log.fine("product code: " + installStep.getProdCode() + " is a document product");
                this.installSteps.add(installStep);
            } else {
                Logging.log.fine(installStep.getProdCode() + " is not a document product.");
            }
        }

        protected void removeInstallSteps() {
            this.installSteps.clear();
        }

        protected ProductData getBaseProductData() {
            return this.baseProductData;
        }

        public boolean isUpdateHidden() {
            return this.updateHidden;
        }

        public String getExistingProductName() {
            String productName = this.existingProductName;
            SpsSkuData spsSkuData = Globals.g_deploymentData.getSpsSku(this.baseProductData.getSpsSku());
            String platform = this.baseProductData.getPlatform();
            if (spsSkuData.getIndb()) {
                productName = productName + " (" + SASHomeStatus.this.bundle.getString("Common.Platform" + platform.toUpperCase() + ".txt") + ")";
            } else if (!"prt".equals(spsSkuData.getPlatform()) && (Utils.getOS_Suffix().equals("wx6") || Utils.getOS_Suffix().equals("lax"))) {
                if (platform.equals("wx6") || platform.equals("lax")) {
                    productName = productName + " (" + SASHomeStatus.this.bundle.getString("PanelExecute.64BitTag.txt") + ")";
                } else if (platform.equals("win") || platform.equals("lnx")) {
                    productName = productName + " (" + SASHomeStatus.this.bundle.getString("PanelExecute.32BitTag.txt") + ")";
                }
            }
            return productName;
        }

        public String getExistingProductVersion() {
            return this.existingProductVersion;
        }

        public String getExistingCustomerVersion() {
            return this.existingCustomerVersion;
        }

        public String getExistingLastPortDate() {
            return this.existingLastPortDate;
        }

        public String[] getExistingLanguages() {
            return this.existingLanguages;
        }

        public String getUpdatedProductName() {
            String productName = this.updatedProductName;
            SpsSkuData spsSkuData = Globals.g_deploymentData.getSpsSku(this.baseProductData.getSpsSku());
            String platform = this.baseProductData.getPlatform();
            if (spsSkuData.getIndb()) {
                productName = productName + " (" + SASHomeStatus.this.bundle.getString("Common.Platform" + platform.toUpperCase() + ".txt") + ")";
            } else if (!"prt".equals(spsSkuData.getPlatform()) && (Utils.getOS_Suffix().equals("wx6") || Utils.getOS_Suffix().equals("lax"))) {
                if (platform.equals("wx6") || platform.equals("lax")) {
                    productName = productName + " (" + SASHomeStatus.this.bundle.getString("PanelExecute.64BitTag.txt") + ")";
                } else if (platform.equals("win") || platform.equals("lnx")) {
                    productName = productName + " (" + SASHomeStatus.this.bundle.getString("PanelExecute.32BitTag.txt") + ")";
                }
            }
            return productName;
        }

        public String getUpdatedProductVersion() {
            return this.updatedProductVersion;
        }

        public String getUpdatedCustomerVersion() {
            return this.updatedCustomerVersion;
        }

        public Vector<ProductData> getInstallSteps() {
            return this.installSteps;
        }
    }
}

