/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelSASHome;
import com.sas.ssn.RegistryData;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;

public class RegistryAccess {
    private static File mostRecentTemporaryJarFile = null;
    private Class<?> deployAPI;
    private String registryRoot;
    private String sasHomeRegJarName;
    private boolean isJarLoadedFromSASHome = false;
    private boolean isSasHomeRegMoreCurrent = true;

    public static RegistryAccess getRegistryAccess() {
        RegistryAccess registryAccess = null;
        try {
            File deployRegJar = null;
            if (Globals.g_cmtSASHome != null) {
                deployRegJar = new File(Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg"), "sas.tools.deploymntreg.jar");
            } else {
                String deploymentRegJarFile = RegistryData.getDeployRegJar();
                if (deploymentRegJarFile != null) {
                    deployRegJar = new File(deploymentRegJarFile);
                }
            }
            if (deployRegJar != null && deployRegJar.exists()) {
                registryAccess = new RegistryAccess(deployRegJar.getAbsolutePath());
            }
        }
        catch (Exception e) {
            registryAccess = null;
            Logging.logStackTrace(e);
        }
        return registryAccess;
    }

    public RegistryAccess(String jarFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        this(new File(jarFile));
    }

    public RegistryAccess(File jarFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        String pathToJarDir;
        if (!jarFile.exists()) {
            Logging.log.info("jarFile '" + jarFile.getAbsolutePath() + "' does not exist");
            throw new FileNotFoundException();
        }
        if (!jarFile.canRead()) {
            Logging.log.info("Unable to read jarFile '" + jarFile.getAbsolutePath() + "'");
            throw new IOException();
        }
        this.registryRoot = pathToJarDir = jarFile.getParent();
        String nameOfJar = jarFile.getName();
        String nameOfJarWithoutSuffix = nameOfJar.substring(0, nameOfJar.lastIndexOf(46));
        String jarDirname = nameOfJarWithoutSuffix + "_dir";
        String jarCopyFilename = null;
        File jarDir = new File(Globals.g_tempLocation, jarDirname);
        if (jarDir.exists()) {
            if (!jarDir.isDirectory()) {
                jarDir.delete();
            }
        } else if (!jarDir.mkdir()) {
            Logging.log.severe("Error initializing the deployment registry - could not create: " + jarDir.getAbsolutePath());
            throw new IOException();
        }
        File[] filelist = jarDir.listFiles();
        HashSet<String> filelistHS = new HashSet<String>();
        for (int i = 0; i < filelist.length; ++i) {
            filelistHS.add(filelist[i].getName());
        }
        boolean found = false;
        int i = 0;
        while (!found && filelistHS.contains(jarCopyFilename = nameOfJarWithoutSuffix + "." + i++ + ".jar")) {
            if (i <= 1000) continue;
            Logging.log.severe("Could not find an available registry jar file name in directory '" + jarDir.getAbsolutePath() + "' after " + i + " tries.");
            throw new IOException();
        }
        File newJarFile = new File(jarDir, jarCopyFilename);
        File srcJarFile = null;
        String setupDeployRegDirName = Utils.joinPath(Globals.g_setupLocation, "deploymntreg");
        if (setupDeployRegDirName == null) {
            srcJarFile = jarFile;
        } else {
            String setupDeployRegJarName = Utils.joinPath(setupDeployRegDirName, "sas.tools.deploymntreg.jar");
            File setupDeployRegJarFile = new File(setupDeployRegJarName);
            this.sasHomeRegJarName = Globals.g_cmtSASHome == null ? Utils.joinPath(PanelSASHome.sasHomeDir, "deploymntreg", "sas.tools.deploymntreg.jar") : Utils.joinPath(Globals.g_cmtSASHome, "deploymntreg", "sas.tools.deploymntreg.jar");
            File sasHomeRegJarFile = new File(this.sasHomeRegJarName);
            if (sasHomeRegJarFile.exists() && RegistryData.isMediaRegistryJarMoreRecent(setupDeployRegJarFile, sasHomeRegJarFile)) {
                srcJarFile = setupDeployRegJarFile;
                this.isSasHomeRegMoreCurrent = false;
            } else if (sasHomeRegJarFile.exists() && !RegistryData.isMediaRegistryJarMoreRecent(setupDeployRegJarFile, sasHomeRegJarFile)) {
                this.isJarLoadedFromSASHome = true;
                srcJarFile = sasHomeRegJarFile;
            } else if (sasHomeRegJarFile.exists()) {
                this.isJarLoadedFromSASHome = true;
                srcJarFile = sasHomeRegJarFile;
            } else {
                srcJarFile = setupDeployRegJarFile;
                this.isSasHomeRegMoreCurrent = false;
            }
        }
        File jarToLoadNewClass = null;
        if (null == mostRecentTemporaryJarFile) {
            Utils.copyFile(srcJarFile, newJarFile);
            jarToLoadNewClass = newJarFile;
            mostRecentTemporaryJarFile = newJarFile;
        } else if (RegistryData.isMediaRegistryJarMoreRecent(srcJarFile, mostRecentTemporaryJarFile)) {
            Utils.copyFile(srcJarFile, newJarFile);
            jarToLoadNewClass = newJarFile;
            mostRecentTemporaryJarFile = newJarFile;
        } else {
            jarToLoadNewClass = mostRecentTemporaryJarFile;
        }
        URLClassLoader loader = new URLClassLoader(new URL[]{jarToLoadNewClass.toURI().toURL()});
        this.deployAPI = loader.loadClass("com.sas.deploymntreg.DeployAPI");
    }

    public void setProperty(String key, String value) {
        new Method("setProperty", new String[]{this.registryRoot, key, value}).execute();
    }

    public String getProperty(String key, String defaultValue) {
        return (String)new Method("getProperty", new String[]{this.registryRoot, key, defaultValue}).execute();
    }

    public String getProperty(String key) {
        return (String)new Method("getProperty", new String[]{this.registryRoot, key}).execute();
    }

    public String[] getInstallViews(String product, String version, String host) {
        return (String[])new Method("getInstallViews", new String[]{product, version, host}).execute();
    }

    public boolean open() {
        boolean result = false;
        try {
            if (Globals.g_deploymentRegistryView != null) {
                result = (Boolean)new Method("openView", new String[]{Globals.g_deploymentRegistryView, this.registryRoot}).execute();
                if (!result) {
                    Logging.log.info("openView(" + Globals.g_deploymentRegistryView + ", " + this.registryRoot + ") returned false");
                }
            } else {
                result = (Boolean)new Method("openView", new String[]{Globals.g_majorReleaseVersion, this.registryRoot}).execute();
                if (!result) {
                    Logging.log.info("openView(" + Globals.g_majorReleaseVersion + ", " + this.registryRoot + ") returned false");
                }
            }
        }
        catch (Exception e) {
            Logging.log.severe("Tried to call open() from registry jar, but got exception: ");
            Logging.logStackTrace(e);
        }
        return result;
    }

    public boolean open(String view) {
        boolean result = false;
        try {
            result = (Boolean)new Method("openView", new String[]{view, this.registryRoot}).execute();
        }
        catch (Exception e) {
            Logging.log.severe("Tried to call openView(" + view + ", " + this.registryRoot + ") from registry jar, but got exception: ");
            Logging.logStackTrace(e);
        }
        if (!result) {
            Logging.log.info("openView(" + view + ", " + this.registryRoot + ") returned false");
        }
        return result;
    }

    public boolean close() {
        boolean result = false;
        try {
            result = this.isJarLoadedFromSASHome && this.isSasHomeRegMoreCurrent ? ((Boolean)new Method("close", new String[0]).execute()).booleanValue() : ((Boolean)new Method("closeReadOnly", new String[0]).execute()).booleanValue();
        }
        catch (Exception e) {
            Logging.log.severe("Tried to call close() from registry jar, but got exception: ");
            Logging.logStackTrace(e);
        }
        if (!result) {
            Logging.log.info("close() returned false");
        }
        return result;
    }

    public boolean setSASHome(String sashome) {
        return (Boolean)new Method("setSASHome", new String[]{sashome}).execute();
    }

    public String getSASHome() {
        return (String)new Method("getSASHome", new String[0]).execute();
    }

    public boolean setInstallUser(String user) {
        return (Boolean)new Method("setInstallUser", new String[]{user}).execute();
    }

    public String getInstallUser() {
        return (String)new Method("getInstallUser", new String[0]).execute();
    }

    public boolean addMajorRelease(String release) {
        return (Boolean)new Method("addMajorRelease", new String[]{release}).execute();
    }

    public boolean removeMajorRelease(String release) {
        return (Boolean)new Method("removeMajorRelease", new String[]{release}).execute();
    }

    public String[] getMajorReleases() {
        return (String[])new Method("getMajorReleases", new String[0]).execute();
    }

    public boolean setSashomeLocaleName(String mvaPosixName) {
        return (Boolean)new Method("setSashomeLocaleName", new String[]{mvaPosixName}).execute();
    }

    public String getSashomeLocaleName() {
        return (String)new Method("getSashomeLocaleName", new String[0]).execute();
    }

    public boolean setSashomeEncodingName(String encodingName) {
        return (Boolean)new Method("setSashomeEncodingName", new String[]{encodingName}).execute();
    }

    public String getSashomeEncodingName() {
        return (String)new Method("getSashomeEncodingName", new String[0]).execute();
    }

    public boolean setSashomeEncodingJavaName(String encodingJavaName) {
        return (Boolean)new Method("setSashomeEncodingJavaName", new String[]{encodingJavaName}).execute();
    }

    public String getSashomeEncodingJavaName() {
        return (String)new Method("getSashomeEncodingJavaName", new String[0]).execute();
    }

    public boolean setSashomeEncodingIbmName(String encodingIbmName) {
        return (Boolean)new Method("setSashomeEncodingIbmName", new String[]{encodingIbmName}).execute();
    }

    public String getSashomeEncodingIbmName() {
        return (String)new Method("getSashomeEncodingIbmName", new String[0]).execute();
    }

    public boolean setSashomeEncodingType(String encodingType) {
        return (Boolean)new Method("setSashomeEncodingType", new String[]{encodingType}).execute();
    }

    public String getSashomeEncodingType() {
        return (String)new Method("getSashomeEncodingType", new String[0]).execute();
    }

    public boolean setSashomeEncodingTwoByte(String encodingTwoByte) {
        return (Boolean)new Method("setSashomeEncodingTwoByte", new String[]{encodingTwoByte}).execute();
    }

    public String getSashomeEncodingTwoByte() {
        return (String)new Method("getSashomeEncodingTwoByte", new String[0]).execute();
    }

    public boolean updateInstallTime(String product, String version, String host) {
        return (Boolean)new Method("updateInstallTime", new String[]{product, version, host}).execute();
    }

    public boolean updateInstallTime(String product, String version) {
        return (Boolean)new Method("updateInstallTime", new String[]{product, version}).execute();
    }

    public String getInstallTime(String product, String version, String host) {
        return (String)new Method("getInstallTime", new String[]{product, version, host}).execute();
    }

    public String getInstallTime(String product, String version) {
        return (String)new Method("getInstallTime", new String[]{product, version}).execute();
    }

    public boolean setInstallOrderNum(String product, String version, String host, String order) {
        return (Boolean)new Method("setInstallOrderNum", new String[]{product, version, host, order}).execute();
    }

    public boolean setInstallOrderNum(String product, String version, String order) {
        return (Boolean)new Method("setInstallOrderNum", new String[]{product, version, order}).execute();
    }

    public String getInstallOrderNum(String product, String version, String host) {
        return (String)new Method("getInstallOrderNum", new String[]{product, version, host}).execute();
    }

    public String getInstallOrderNum(String product, String version) {
        return (String)new Method("getInstallOrderNum", new String[]{product, version}).execute();
    }

    public boolean setInstallSetnumid(String product, String version, String host, String setnumid) {
        return (Boolean)new Method("setInstallSetnumid", new String[]{product, version, host, setnumid}).execute();
    }

    public boolean setInstallSetnumid(String product, String version, String setnumid) {
        return (Boolean)new Method("setInstallSetnumid", new String[]{product, version, setnumid}).execute();
    }

    public String getInstallSetnumid(String product, String version, String host) {
        return (String)new Method("getInstallSetnumid", new String[]{product, version, host}).execute();
    }

    public String getInstallSetnumid(String product, String version) {
        return (String)new Method("getInstallSetnumid", new String[]{product, version}).execute();
    }

    public boolean addInstallLanguage(String product, String version, String host, String lang) {
        return (Boolean)new Method("addInstallLanguage", new String[]{product, version, host, lang}).execute();
    }

    public String[] getInstallLanguages(String product, String version, String host) {
        return (String[])new Method("getInstallLanguages", new String[]{product, version, host}).execute();
    }

    public boolean setInstallDisplayName(String product, String version, String host, String name) {
        return (Boolean)new Method("setInstallDisplayName", new String[]{product, version, host, name}).execute();
    }

    public boolean setInstallDisplayName(String product, String version, String name) {
        return (Boolean)new Method("setInstallDisplayName", new String[]{product, version, name}).execute();
    }

    public String getInstallDisplayName(String product, String version, String host) {
        return (String)new Method("getInstallDisplayName", new String[]{product, version, host}).execute();
    }

    public String getInstallDisplayName(String product, String version) {
        return (String)new Method("getInstallDisplayName", new String[]{product, version}).execute();
    }

    public boolean setInstallFamily(String product, String version, String host, String name) {
        return (Boolean)new Method("setInstallFamily", new String[]{product, version, host, name}).execute();
    }

    public boolean setInstallFamily(String product, String version, String name) {
        return (Boolean)new Method("setInstallFamily", new String[]{product, version, name}).execute();
    }

    public String getInstallFamily(String product, String version, String host) {
        return (String)new Method("getInstallFamily", new String[]{product, version, host}).execute();
    }

    public String getInstallFamily(String product, String version) {
        return (String)new Method("getInstallFamily", new String[]{product, version}).execute();
    }

    public boolean setInstallLoc(String product, String version, String host, String path) {
        return (Boolean)new Method("setInstallLoc", new String[]{product, version, host, path}).execute();
    }

    public boolean setInstallLoc(String product, String version, String path) {
        return (Boolean)new Method("setInstallLoc", new String[]{product, version, path}).execute();
    }

    public String getInstallLoc(String product, String version, String host) {
        return (String)new Method("getInstallLoc", new String[]{product, version, host}).execute();
    }

    public String getInstallLoc(String product, String version) {
        return (String)new Method("getInstallLoc", new String[]{product, version}).execute();
    }

    public boolean setInstallKeyFile(String product, String version, String host, String keyFile) {
        return (Boolean)new Method("setInstallKeyFile", new String[]{product, version, host, keyFile}).execute();
    }

    public boolean setInstallKeyFile(String product, String version, String keyFile) {
        return (Boolean)new Method("setInstallKeyFile", new String[]{product, version, keyFile}).execute();
    }

    public String getInstallKeyFile(String product, String version, String host) {
        return (String)new Method("getInstallKeyFile", new String[]{product, version, host}).execute();
    }

    public String getInstallKeyFile(String product, String version) {
        return (String)new Method("getInstallKeyFile", new String[]{product, version}).execute();
    }

    public boolean setInstallLogFile(String product, String version, String host, String logFile) {
        return (Boolean)new Method("setInstallLogFile", new String[]{product, version, host, logFile}).execute();
    }

    public boolean setInstallLogFile(String product, String version, String logFile) {
        return (Boolean)new Method("setInstallLogFile", new String[]{product, version, logFile}).execute();
    }

    public String getInstallLogFile(String product, String version, String host) {
        return (String)new Method("getInstallLogFile", new String[]{product, version, host}).execute();
    }

    public String getInstallLogFile(String product, String version) {
        return (String)new Method("getInstallLogFile", new String[]{product, version}).execute();
    }

    public boolean setInstallGUID(String product, String version, String host, String guid) {
        return (Boolean)new Method("setInstallGUID", new String[]{product, version, host, guid}).execute();
    }

    public boolean setInstallGUID(String product, String version, String guid) {
        return (Boolean)new Method("setInstallGUID", new String[]{product, version, guid}).execute();
    }

    public String getInstallGUID(String product, String version, String host) {
        return (String)new Method("getInstallGUID", new String[]{product, version, host}).execute();
    }

    public String getInstallGUID(String product, String version) {
        return (String)new Method("getInstallGUID", new String[]{product, version}).execute();
    }

    public boolean setInstallStatus(String product, String version, String host, String status) {
        return (Boolean)new Method("setInstallStatus", new String[]{product, version, host, status}).execute();
    }

    public boolean setInstallStatus(String product, String version, String status) {
        return (Boolean)new Method("setInstallStatus", new String[]{product, version, status}).execute();
    }

    public boolean setInstallStatus(String product, String version, String host, String status, String dlgMsg, String logMsg) {
        return (Boolean)new Method("setInstallStatus", new String[]{product, version, host, status, dlgMsg, logMsg}).execute();
    }

    public boolean setInstallStatus(String product, String version, String status, String dlgMsg, String logMsg) {
        return (Boolean)new Method("setInstallStatus", new String[]{product, version, status, dlgMsg, logMsg}).execute();
    }

    public String getInstallStatus(String product, String version, String host) {
        return (String)new Method("getInstallStatus", new String[]{product, version, host}).execute();
    }

    public String getInstallStatus(String product, String version) {
        return (String)new Method("getInstallStatus", new String[]{product, version}).execute();
    }

    public String getInstallStatusDlgMsg(String product, String version, String host) {
        return (String)new Method("getInstallStatusDlgMsg", new String[]{product, version, host}).execute();
    }

    public String getInstallStatusDlgMsg(String product, String version) {
        return (String)new Method("getInstallStatusDlgMsg", new String[]{product, version}).execute();
    }

    public String getInstallStatusLogMsg(String product, String version, String host) {
        return (String)new Method("getInstallStatusLogMsg", new String[]{product, version, host}).execute();
    }

    public String getInstallStatusLogMsg(String product, String version) {
        return (String)new Method("getInstallStatusLogMsg", new String[]{product, version}).execute();
    }

    public boolean setInstallLastPortDate(String product, String version, String host, String date) {
        return (Boolean)new Method("setInstallLastPortDate", new String[]{product, version, host, date}).execute();
    }

    public boolean setInstallLastPortDate(String product, String version, String date) {
        return (Boolean)new Method("setInstallLastPortDate", new String[]{product, version, date}).execute();
    }

    public String getInstallLastPortDate(String product, String version, String host) {
        return (String)new Method("getInstallLastPortDate", new String[]{product, version, host}).execute();
    }

    public String getInstallLastPortDate(String product, String version) {
        return (String)new Method("getInstallLastPortDate", new String[]{product, version}).execute();
    }

    public boolean setInstallServicePack(String product, String version, String host, String servicePack) {
        return (Boolean)new Method("setInstallServicePack", new String[]{product, version, host, servicePack}).execute();
    }

    public boolean setInstallServicePack(String product, String version, String servicePack) {
        return (Boolean)new Method("setInstallServicePack", new String[]{product, version, servicePack}).execute();
    }

    public String getInstallServicePack(String product, String version, String host) {
        return (String)new Method("getInstallServicePack", new String[]{product, version, host}).execute();
    }

    public String getInstallServicePack(String product, String version) {
        return (String)new Method("getInstallServicePack", new String[]{product, version}).execute();
    }

    public boolean setInstallVJRConsumer(String product, String version, String host, Boolean consumer) {
        return (Boolean)new Method("setInstallVJRConsumer", new String[]{product, version, host, consumer.toString()}).execute();
    }

    public boolean setInstallVJRConsumer(String product, String version, Boolean consumer) {
        return (Boolean)new Method("setInstallVJRConsumer", new String[]{product, version, consumer.toString()}).execute();
    }

    public boolean setInstallVJRConsumer(String product, String version, String host, String consumer) {
        return (Boolean)new Method("setInstallVJRConsumer", new String[]{product, version, host, consumer}).execute();
    }

    public boolean setInstallVJRConsumer(String product, String version, String consumer) {
        return (Boolean)new Method("setInstallVJRConsumer", new String[]{product, version, consumer}).execute();
    }

    public boolean getInstallVJRConsumer(String product, String version, String host) {
        return (Boolean)new Method("getInstallVJRConsumer", new String[]{product, version, host}).execute();
    }

    public boolean getInstallVJRConsumer(String product, String version) {
        return (Boolean)new Method("getInstallVJRConsumer", new String[]{product, version}).execute();
    }

    public boolean removeInstall(String product, String version, String host) {
        return (Boolean)new Method("removeInstall", new String[]{product, version, host}).execute();
    }

    public boolean removeInstall(String product, String version) {
        return (Boolean)new Method("removeInstall", new String[]{product, version}).execute();
    }

    public String[] getInstallHosts() {
        return (String[])new Method("getInstallHosts", new String[0]).execute();
    }

    public String[] getInstallCodes(String host) {
        return (String[])new Method("getInstallCodes", new String[]{host}).execute();
    }

    public String[] getInstallCodes() {
        return (String[])new Method("getInstallCodes", new String[0]).execute();
    }

    public String[] getInstallVersions(String product, String host) {
        return (String[])new Method("getInstallVersions", new String[]{product, host}).execute();
    }

    public String[] getInstallVersions(String product) {
        return (String[])new Method("getInstallVersions", new String[]{product}).execute();
    }

    public boolean setMaintLevel(String product, String version, String host, String maintVer) {
        boolean ret = (Boolean)new Method("setMaintLevel", new String[]{product, version, host, maintVer}).execute();
        if (!ret) {
            Logging.log.info("KC stack trace SDW for open is:");
            Logging.log.info(Arrays.toString(Thread.currentThread().getStackTrace()).replace(',', '\n'));
        }
        return ret;
    }

    public String getMaintLevel(String product, String version, String host) {
        return (String)new Method("getMaintLevel", new String[]{product, version, host}).execute();
    }

    public boolean setMaintDisplayName(String product, String version, String host, String maintVer, String name) {
        return (Boolean)new Method("setMaintDisplayName", new String[]{product, version, host, maintVer, name}).execute();
    }

    public String getMaintDisplayName(String product, String version, String host, String maintVer) {
        return (String)new Method("getMaintDisplayName", new String[]{product, version, host, maintVer}).execute();
    }

    public String[] getMaintVersions(String product, String version, String host) {
        return (String[])new Method("getMaintVersions", new String[]{product, version, host}).execute();
    }

    public String[] getMaintLanguages(String product, String version, String maintVer, String host) {
        return (String[])new Method("getMaintLanguages", new String[]{product, version, maintVer, host}).execute();
    }

    public String getMaintUninstallLoc(String product, String version, String host, String maintVer) {
        return (String)new Method("getMaintUninstallLoc", new String[]{product, version, host, maintVer}).execute();
    }

    public String getMaintUninstallLoc(String product, String version, String host, String maintVer, String language) {
        return (String)new Method("getMaintUninstallLoc", new String[]{product, version, host, maintVer, language}).execute();
    }

    public boolean setMaintUninstallLoc(String product, String version, String host, String maintVer, String language, String path) {
        return (Boolean)new Method("setMaintUninstallLoc", new String[]{product, version, host, maintVer, language, path}).execute();
    }

    public boolean setConfigLoc(String configDir, String path) {
        return (Boolean)new Method("setConfigLoc", new String[]{configDir, path}).execute();
    }

    public String getConfigLoc(String configDir) {
        return (String)new Method("getConfigLoc", new String[]{configDir}).execute();
    }

    public String[] getConfigLocs() {
        return (String[])new Method("getConfigLocs", new String[0]).execute();
    }

    public boolean setConfigOrderNum(String configDir, String order) {
        return (Boolean)new Method("setConfigOrderNum", new String[]{configDir, order}).execute();
    }

    public String getConfigOrderNum(String configDir) {
        return (String)new Method("getConfigOrderNum", new String[]{configDir}).execute();
    }

    public boolean setConfigPlanFile(String configDir, String planFile) {
        return (Boolean)new Method("setConfigPlanFile", new String[]{configDir, planFile}).execute();
    }

    public String getConfigPlanFile(String configDir) {
        return (String)new Method("getConfigPlanFile", new String[]{configDir}).execute();
    }

    public boolean setConfigPropFile(String configDir, String propFile) {
        return (Boolean)new Method("setConfigPropFile", new String[]{configDir, propFile}).execute();
    }

    public String getConfigPropFile(String configDir) {
        return (String)new Method("getConfigPropFile", new String[]{configDir}).execute();
    }

    public boolean removeConfig(String configDir) {
        return (Boolean)new Method("removeConfig", new String[]{configDir}).execute();
    }

    public boolean containsMethod(String method, Class[] types) {
        boolean exists = false;
        if (this.deployAPI != null) {
            try {
                exists = this.deployAPI.getMethod(method, types) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return exists;
    }

    public boolean setLastOrder(String order) {
        return (Boolean)new Method("setLastOrder", new String[]{order}).execute();
    }

    public String getLastOrder() {
        return (String)new Method("getLastOrder", new String[0]).execute();
    }

    private class Method {
        private String method;
        private Vector<Object> parameters = new Vector();

        public Method(String method, String[] parameters) {
            this.setMethod(method);
            for (int i = 0; i < parameters.length; ++i) {
                this.addParameter(parameters[i]);
            }
        }

        public void setMethod(String method) {
            this.method = method;
        }

        public void addParameter(Object parameter) {
            this.parameters.add(parameter);
        }

        public Object execute() {
            Object result = null;
            if (RegistryAccess.this.deployAPI != null) {
                Object[] obj = null;
                Class[] types = null;
                if (this.parameters.size() > 0) {
                    obj = new Object[this.parameters.size()];
                    types = new Class[this.parameters.size()];
                    for (int i = 0; i < this.parameters.size(); ++i) {
                        obj[i] = this.parameters.get(i);
                        types[i] = this.parameters.get(i).getClass();
                    }
                }
                try {
                    result = RegistryAccess.this.deployAPI.getMethod(this.method, types).invoke(null, obj);
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }
            return result;
        }
    }
}

