/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.Utils;
import com.sas.tools.deployjni.JNIUtils;
import com.sas.tools.deployjni.saswin.SASWinAPI;
import com.sas.tools.deployjni.winregistry.WinRegAPI;

public class Reboot {
    private String pendingRebootKey = "SYSTEM\\CurrentControlSet\\Control\\Session Manager";
    private String pendingRebootName = "PendingFileRenameOperations";
    private String runOnceKey = "SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\RunOnce";
    private String restartSDWkey = "SASSystemPrep";

    String getRebootPendingValue() {
        String value = null;
        if (Utils.getOS() != 1) {
            return null;
        }
        value = WinRegAPI.getWinRegMultiStrValue(JNIUtils.getWindowsPlatform(), 8, this.pendingRebootKey, this.pendingRebootName);
        Logging.log.fine("Registry pending reboot value=" + value);
        return value;
    }

    public void setRestartSDW() {
        if (Utils.getOS() == 1) {
            String cmd = "\"" + Utils.joinPath(Globals.g_startupLocation, "setup.exe") + "\"";
            String myoption = Globals.g_restartCommandOptions;
            if (myoption != null && myoption.length() > 0) {
                cmd = cmd + " " + Globals.g_restartCommandOptions;
                if (myoption.indexOf("-order") == -1) {
                    cmd = cmd + " -order " + Globals.g_order;
                }
            }
            if (Globals.g_sasHomeStatus != null && !Globals.g_sasHomeStatus.updatesRequired()) {
                cmd = cmd + " -reentry";
            }
            this.setRestartCmd(this.runOnceKey, this.restartSDWkey, cmd);
            String logEntry = "Information for restarting:\n   registry key:   " + this.runOnceKey + "\n   registry value: " + this.restartSDWkey + "\n   command:        " + cmd;
            Logging.log.info(logEntry);
        }
    }

    private void setRestartCmd(String regKey, String regName, String cmd) {
        if (Utils.getOS() == 1) {
            try {
                if (JNIUtils.getWindowsPlatform() == "win") {
                    WinRegAPI.CreateRegKey32(8, regKey);
                    WinRegAPI.SetRegValue32(8, regKey, regName, cmd, 109);
                } else {
                    WinRegAPI.CreateRegKeyWow64(8, regKey);
                    WinRegAPI.SetRegValueWow64(8, regKey, regName, cmd, 109);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Logging.logStackTrace(e);
            }
        }
    }

    boolean setUserInfo(String domainNameValue, String userNameValue, String passwordValue) {
        boolean valid = true;
        if (Utils.getOS() != 1) {
            return false;
        }
        return valid;
    }

    boolean restoreOrgUserInfo() {
        boolean valid = false;
        if (Utils.getOS() == 1) {
            return true;
        }
        return valid;
    }

    boolean setReboot() {
        boolean flag = false;
        if (Utils.getOS() != 1) {
            return false;
        }
        flag = SASWinAPI.SystemShutdown();
        if (flag) {
            Logging.log.info("System shutting down now.");
        } else {
            Logging.log.info("JNI shutdown call failed.");
        }
        return flag;
    }
}

