/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.SSNResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class QuietStatus
extends JFrame {
    private SSNResource bundle = new SSNResource(QuietStatus.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_statusText = null;
    private JScrollPane m_statusScrollPane = null;
    private Timer m_timer = null;
    private ActionListener m_timerAction = null;
    private String m_timerMessage = null;
    private int m_timerCount = 0;

    public QuietStatus() {
        this.initialize();
        this.layoutWidgets();
        this.setIconImage(this.bundle.getImageIcon("Common.icon.image").getImage());
        this.setDefaultCloseOperation(0);
        this.setResizable(false);
        if (Globals.g_mode == 1) {
            this.setTitle(this.bundle.getString("Common.ESDTitle.txt"));
        } else if (Globals.g_mode == 2) {
            this.setTitle(this.bundle.getString("Common.CMTTitle.txt"));
        } else if (Globals.g_mode == 6) {
            this.setTitle(this.bundle.getString("Common.DCUTitle.txt"));
        } else {
            this.setTitle(this.bundle.getString("Common.Title.txt"));
        }
        this.setPreferredSize(new Dimension(500, 75));
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dialogSize = this.getSize();
        this.setLocation(screenSize.width - dialogSize.width, 0);
        this.setVisible(true);
        if (Globals.g_startMinimized) {
            this.setExtendedState(1);
        }
    }

    private void initialize() {
        this.m_statusText = new JTextArea(2, 0);
        this.m_statusText.setOpaque(false);
        this.m_statusText.setEditable(false);
        this.m_statusScrollPane = new JScrollPane(this.m_statusText);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.getContentPane().add((Component)this.m_panel, c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 18;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_statusScrollPane, c);
    }

    public void busyMsgStart(String message) {
        this.m_timerMessage = ConsoleMode.stripEllipses(message);
        this.m_statusText.setText(this.m_timerMessage);
        this.setTitle(this.m_timerMessage);
        if (this.m_timerAction == null) {
            this.m_timerAction = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (QuietStatus.this.m_timerCount < 3) {
                        QuietStatus.this.m_statusText.setText(QuietStatus.this.m_statusText.getText() + ".");
                        QuietStatus.this.m_timerCount++;
                    } else {
                        QuietStatus.this.m_statusText.setText(QuietStatus.this.m_timerMessage);
                        QuietStatus.this.m_timerCount = 0;
                    }
                }
            };
        }
        this.m_timer = new Timer(1000, this.m_timerAction);
        this.m_timer.start();
    }

    public void busyMsgStop() {
        this.m_statusText.setText("");
        this.m_timerMessage = null;
        this.m_timerCount = 0;
        if (this.m_timer != null && this.m_timer.isRunning()) {
            this.m_timer.stop();
        }
    }
}

