/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.SSNResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextArea;

public class ProgressBar
extends JPanel {
    private static final long serialVersionUID = 1714654813165623379L;
    private SSNResource bundle = new SSNResource(ProgressBar.class);
    private JTextArea m_status;
    private JTextArea m_timeRemaining;
    private JProgressBar m_progressBar;
    private double m_maxValue = 0.0;
    private double m_startValue = 0.0;
    private long m_startTime = 0L;
    private long m_totalTime = 0L;
    private long m_nextRefresh = 3000L;
    private boolean m_started = false;
    private boolean m_showStatus = false;
    private boolean m_download = true;
    private boolean m_paused = false;
    private String m_maxValueTxt = null;

    public ProgressBar(double maxValue, boolean showStatus, boolean download) {
        this.m_maxValue = maxValue;
        this.m_maxValueTxt = NumberFormat.getInstance().format(this.m_maxValue);
        this.m_showStatus = showStatus;
        this.m_download = download;
        this.initialize();
        this.layoutWidgets();
    }

    private void initialize() {
        if (this.m_showStatus) {
            this.m_status = new JTextArea();
            this.m_status.setEditable(false);
            this.m_status.setFocusable(false);
            this.m_status.setLineWrap(true);
            this.m_status.setWrapStyleWord(true);
            this.m_status.setOpaque(false);
            if (this.m_download) {
                this.m_status.setText(this.bundle.messageString("ProgressBar.FinishedStatus.txt", "0"));
            } else {
                this.m_status.setText(this.bundle.messageString("ProgressBar.FinishedStatusCopy.txt", "0"));
            }
        }
        this.m_timeRemaining = new JTextArea(this.bundle.getString("ProgressBar.TimeStatus.txt"));
        this.m_timeRemaining.setEditable(false);
        this.m_timeRemaining.setFocusable(false);
        this.m_timeRemaining.setLineWrap(true);
        this.m_timeRemaining.setWrapStyleWord(true);
        this.m_timeRemaining.setOpaque(false);
        this.m_progressBar = new JProgressBar();
        this.m_progressBar.setStringPainted(true);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        c.gridheight = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.anchor = 18;
        c.weighty = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.m_progressBar, c);
        if (this.m_showStatus) {
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 1;
            c.anchor = 18;
            c.weighty = 1.0;
            c.fill = 2;
            c.insets = new Insets(10, 0, 0, 10);
            this.add((Component)this.m_status, c);
            c.gridx = 1;
            c.gridy = 1;
            c.gridwidth = 1;
            c.anchor = 12;
            c.weighty = 0.0;
            c.fill = 2;
            c.insets = new Insets(10, 0, 0, 0);
            this.add((Component)this.m_timeRemaining, c);
        } else {
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 2;
            c.anchor = 18;
            c.weighty = 1.0;
            c.fill = 2;
            c.insets = new Insets(10, 0, 0, 0);
            this.add((Component)this.m_timeRemaining, c);
        }
    }

    public void setCurrentValue(double currentValue) {
        if (currentValue > this.m_maxValue) {
            currentValue = this.m_maxValue;
        }
        if (currentValue > this.m_startValue) {
            if (!this.m_started) {
                this.m_startTime = System.currentTimeMillis();
                this.m_started = true;
            }
            int percent = (int)(currentValue / this.m_maxValue * 100.0);
            this.m_progressBar.setValue(percent);
            if (this.m_showStatus) {
                String currentValueTxt = NumberFormat.getInstance().format(currentValue);
                if (this.m_download) {
                    this.m_status.setText(this.bundle.messageString("ProgressBar.DownloadStatus.txt", currentValueTxt, this.m_maxValueTxt));
                } else {
                    this.m_status.setText(this.bundle.messageString("ProgressBar.DownloadStatusCopy.txt", currentValueTxt, this.m_maxValueTxt));
                }
            }
            long deltaTime = System.currentTimeMillis() - this.m_startTime + this.m_totalTime;
            long remainingTime = (long)((this.m_maxValue - currentValue) / (currentValue - this.m_startValue) * (double)deltaTime / 1000.0);
            if (deltaTime >= this.m_nextRefresh) {
                this.m_nextRefresh = deltaTime + 3000L;
                if (remainingTime < 3600L || deltaTime > 10000L) {
                    String estimatedTime = this.bundle.getString("ProgressBar.TimeStatus.txt");
                    estimatedTime = estimatedTime + " " + this.formatTime(remainingTime);
                    this.m_timeRemaining.setText(estimatedTime);
                }
            } else if (deltaTime < 3000L) {
                this.m_timeRemaining.setText(this.bundle.getString("ProgressBar.TimeStatus.txt") + " " + this.bundle.getString("ProgressBar.Calculating.txt"));
            }
        }
    }

    private String formatTime(long time) {
        String timeText = "";
        long days = time / 86400L;
        if (days == 1L) {
            timeText = timeText + this.bundle.getString("ProgressBar.OneDay.txt") + ", ";
        } else if (days > 1L) {
            timeText = timeText + this.bundle.messageString("ProgressBar.Days.txt", Long.toString(days)) + ", ";
        }
        long hours = time % 86400L / 3600L;
        if (hours == 1L) {
            timeText = timeText + this.bundle.getString("ProgressBar.OneHour.txt") + ", ";
        } else if (hours > 1L) {
            timeText = timeText + this.bundle.messageString("ProgressBar.Hours.txt", Long.toString(hours)) + ", ";
        }
        long minutes = time % 3600L / 60L;
        if (minutes == 1L) {
            timeText = timeText + this.bundle.getString("ProgressBar.OneMinute.txt") + ", ";
        } else if (minutes > 1L) {
            timeText = timeText + this.bundle.messageString("ProgressBar.Minutes.txt", Long.toString(minutes)) + ", ";
        }
        long seconds = time % 60L;
        timeText = seconds == 1L ? timeText + this.bundle.getString("ProgressBar.OneSecond.txt") : timeText + this.bundle.messageString("ProgressBar.Seconds.txt", Long.toString(seconds));
        return timeText;
    }

    public void setMaxValue(double value) {
        this.m_maxValue = value;
        this.m_maxValueTxt = NumberFormat.getInstance().format(this.m_maxValue);
    }

    public void setStartValue(double value) {
        this.m_startValue = value;
    }

    public void pause() {
        if (!this.m_paused && this.m_started) {
            this.m_paused = true;
            this.m_totalTime += System.currentTimeMillis() - this.m_startTime;
        }
    }

    public void resume() {
        if (this.m_paused) {
            this.m_paused = false;
            this.m_startTime = System.currentTimeMillis();
        }
    }

    public boolean isPaused() {
        return this.m_paused;
    }

    public void finished() {
        long totalTime = 0L;
        if (this.m_startTime > 0L) {
            totalTime = (this.m_totalTime + (System.currentTimeMillis() - this.m_startTime)) / 1000L;
        }
        this.m_progressBar.setValue(100);
        if (this.m_showStatus) {
            if (this.m_download) {
                this.m_status.setText(this.bundle.messageString("ProgressBar.FinishedStatus.txt", this.m_maxValueTxt));
            } else {
                this.m_status.setText(this.bundle.messageString("ProgressBar.FinishedStatusCopy.txt", this.m_maxValueTxt));
            }
        }
        this.m_timeRemaining.setText(this.bundle.getString("ProgressBar.TimeStatusFinish.txt") + " " + this.formatTime(totalTime));
    }

    public void stopped() {
        this.m_timeRemaining.setText(this.bundle.getString("ProgressBar.TimeStatus.txt") + " " + this.bundle.getString("ProgressBar.Stopped.txt"));
    }

    public void failed() {
        this.m_timeRemaining.setText(this.bundle.getString("ProgressBar.TimeStatus.txt") + " " + this.bundle.getString("ProgressBar.Failed.txt"));
    }

    public int getValue() {
        return this.m_progressBar.getValue();
    }

    public JTextArea getTimeRemaining() {
        return this.m_timeRemaining;
    }

    public void reset() {
        this.m_startTime = 0L;
        this.m_totalTime = 0L;
        this.m_started = false;
    }
}

