/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.InstanceData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import java.io.File;

public class ProductData
implements Comparable<ProductData> {
    public static final int TYPE_SYSREQ = 0;
    public static final int TYPE_DEPLOY = 1;
    public static final int TYPE_CONFIG = 2;
    public static final int TYPE_UNINSTALL = 3;
    public static final int TYPE_HOTFIX = 4;
    public static final int TYPE_HOTFIX_CONFIG = 5;
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_PREPRODUCTION = 1;
    public static final int SELECTABLE_YES = 1;
    public static final int SELECTABLE_NO = 2;
    public static final int SELECTABLE_STANDALONE = 3;
    private SSNResource bundle = new SSNResource(ProductData.class);
    private String code;
    private String spsSku;
    private String platform;
    private String version;
    private String custVer;
    private String maint;
    private String lastPortDate;
    private String sasRelease;
    private String displayName;
    private int type;
    private int status;
    private int selectable;
    private boolean config_enabled;
    private String interactiveRef;
    private String silentRef;
    private String indexRef;
    private String interactiveArgs;
    private String silentArgs;
    private boolean foundation;
    private boolean use_sasinstall;
    private boolean use_srw;
    private boolean use_jre;
    private boolean required;
    private boolean installed;
    private boolean applicable;
    private boolean prompt;
    private String mediaCode;
    private String mediaName;
    private long sequenceNum;
    private InstanceData m_instanceData = null;
    private String order;
    private String preExecuteAuditLogPath = "";
    private String postExecuteAuditLogPath = "";
    private String updateBackupDirectory = "";
    private boolean isAutoUpdate;

    public ProductData(ProductData prodData) {
        this.code = prodData.getProdCode();
        this.spsSku = prodData.getSpsSku();
        this.platform = prodData.getPlatform();
        this.version = prodData.getProdVersion();
        this.custVer = prodData.getProdCustVersion();
        this.maint = prodData.getProdMaint();
        this.lastPortDate = prodData.getLastPortDate();
        this.sasRelease = prodData.getProdSASRelease();
        this.displayName = prodData.getProdName();
        this.type = prodData.getType();
        this.status = prodData.getStatus();
        this.selectable = prodData.getSelectableType();
        this.config_enabled = prodData.isConfigEnabled();
        this.interactiveRef = prodData.getInteractiveRef();
        this.silentRef = prodData.getSilentRef();
        this.indexRef = prodData.getIndexRef();
        this.interactiveArgs = prodData.getInteractiveCmd();
        this.silentArgs = prodData.getSilentCmd();
        this.foundation = prodData.isFoundation();
        this.use_sasinstall = prodData.getUseSASINSTALL();
        this.use_srw = prodData.getUseSRW();
        this.use_jre = prodData.getUseJRE();
        this.prompt = prodData.getPrompt();
        this.mediaCode = prodData.getMediaCode();
        this.mediaName = prodData.getMediaName();
        this.sequenceNum = prodData.getSequenceNum();
        this.order = prodData.getOrder();
        this.required = false;
        this.installed = false;
        this.applicable = true;
        this.isAutoUpdate = false;
    }

    public ProductData(String code, String spsSku, String platform, String version, String custVer, String maint, String lastPortDate, String sasRelease, String displayName, int type, int status, int selectable, boolean config_enabled, String interactiveRef, String silentRef, String indexRef, String interactiveArgs, String silentArgs, boolean foundation, boolean use_sasinstall, boolean use_srw, boolean use_jre, boolean prompt, String mediaCode, String mediaName, long sequenceNum) {
        this.code = code;
        this.spsSku = spsSku;
        this.platform = !Globals.g_createSSD && Globals.g_mode != 1 && spsSku != null && Globals.g_deploymentData.getSpsSku(spsSku) != null && Globals.g_deploymentData.getSpsSku(spsSku).getIndb() ? Globals.g_deploymentData.getSpsSku(spsSku).getPlatform() : platform;
        this.version = version;
        this.custVer = custVer;
        this.maint = maint;
        this.lastPortDate = lastPortDate;
        this.sasRelease = sasRelease;
        this.displayName = displayName;
        this.type = type;
        this.status = status;
        this.selectable = selectable;
        this.config_enabled = config_enabled;
        this.interactiveRef = interactiveRef;
        this.silentRef = silentRef;
        this.indexRef = indexRef;
        this.interactiveArgs = interactiveArgs;
        this.silentArgs = silentArgs;
        this.foundation = foundation;
        this.use_sasinstall = use_sasinstall;
        this.use_srw = use_srw;
        this.use_jre = use_jre;
        this.prompt = prompt;
        this.mediaCode = mediaCode;
        this.mediaName = mediaName;
        this.sequenceNum = sequenceNum;
        this.required = false;
        this.installed = false;
        this.applicable = true;
        this.isAutoUpdate = false;
    }

    public void setAutoUpdate(boolean isAutoUpdate) {
        this.isAutoUpdate = isAutoUpdate;
    }

    public boolean isAutoUpdate() {
        return this.isAutoUpdate;
    }

    public String getProdCode() {
        return this.code;
    }

    public String getSpsSku() {
        return this.spsSku;
    }

    public void setSpsSku(String sku) {
        this.spsSku = sku;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getProdVersion() {
        return this.version;
    }

    public String getProdCustVersion() {
        return this.custVer;
    }

    public String getProdMaint() {
        return this.maint;
    }

    public void setProdMaint(String mnt) {
        this.maint = mnt;
    }

    public String getLastPortDate() {
        return this.lastPortDate;
    }

    public void setLastPortDate(String lpd) {
        this.lastPortDate = lpd;
    }

    public String getProdSASRelease() {
        return this.sasRelease;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int newType) {
        this.type = newType;
    }

    public int getStatus() {
        return this.status;
    }

    public int getSelectableType() {
        return this.selectable;
    }

    public boolean isConfigEnabled() {
        return this.config_enabled;
    }

    public String getInteractiveRef() {
        return this.interactiveRef;
    }

    public void setInteractiveRef(String ref) {
        this.interactiveRef = ref;
    }

    public String getSilentRef() {
        return this.silentRef;
    }

    public void setSilentRef(String ref) {
        this.silentRef = ref;
    }

    public String getIndexRef() {
        return this.indexRef;
    }

    public String getInteractiveCmd() {
        return this.interactiveArgs;
    }

    public void setInteractiveArgs(String args) {
        this.interactiveArgs = args;
    }

    public String getSilentCmd() {
        return this.silentArgs;
    }

    public void setSilentArgs(String args) {
        this.silentArgs = args;
    }

    public boolean isFoundation() {
        return this.foundation;
    }

    public boolean getUseSASINSTALL() {
        return this.use_sasinstall;
    }

    public boolean getUseSRW() {
        return this.use_srw;
    }

    public boolean getUseJRE() {
        return this.use_jre;
    }

    public boolean getPrompt() {
        return this.prompt;
    }

    public String getProdName() {
        return this.displayName;
    }

    public void setProdName(String prodName) {
        this.displayName = prodName;
    }

    public String getMediaCode() {
        return this.mediaCode;
    }

    public String getMediaName() {
        return this.mediaName;
    }

    public long getSequenceNum() {
        return this.sequenceNum;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isApplicable() {
        return this.applicable;
    }

    public void setApplicable(boolean applicable) {
        this.applicable = applicable;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public String getInstallSuccess() {
        return "return";
    }

    public String getSilentSuccess() {
        return "return";
    }

    public boolean isInteractive() {
        boolean interactive = true;
        if (this.type == 2) {
            interactive = false;
        } else if ("installtool".equalsIgnoreCase(this.code)) {
            interactive = false;
        } else if ("cfgwizard".equalsIgnoreCase(this.code)) {
            interactive = false;
        } else if (!this.getPrompt() && "".equals(this.getIndexRef())) {
            interactive = "".equals(this.getSilentRef());
        }
        return interactive;
    }

    public String getInstallRef(boolean interactive) {
        String ref = this.getSilentRef();
        if (interactive || "".equals(ref)) {
            ref = this.getInteractiveRef();
        }
        return ref;
    }

    public String getInstallCmd(boolean interactive) {
        String cmd = this.getSilentCmd();
        if (interactive || "".equals(this.getSilentRef())) {
            cmd = this.getInteractiveCmd();
        }
        return cmd;
    }

    public String getChainingRef(boolean interactive) {
        String ref = this.getIndexRef();
        if ("".equals(ref)) {
            ref = this.getInstallRef(interactive);
        }
        return ref;
    }

    public String getChainingCmd(boolean interactive) {
        String cmd = "";
        if (interactive || "".equals(this.getIndexRef())) {
            cmd = this.getInstallCmd(interactive);
        }
        return cmd;
    }

    public void setInstanceData(InstanceData data) {
        this.m_instanceData = data;
    }

    public InstanceData getInstanceData() {
        return this.m_instanceData;
    }

    public void setOrder(String orderNum) {
        this.order = orderNum;
    }

    public String getOrder() {
        return this.order;
    }

    public String getProdNameExtended() {
        StringBuffer displayNameExtended = new StringBuffer(this.displayName);
        SpsSkuData skuData = Globals.g_deploymentData.getSpsSku(this.spsSku);
        if (Globals.g_cmtTask == 41 || Globals.g_cmtTask == 40) {
            return displayNameExtended.toString();
        }
        String language = "";
        boolean hotfix = false;
        if (skuData == null) {
            hotfix = true;
            language = new File(new File(this.interactiveRef).getParent()).getName();
        } else {
            language = skuData.getLanguage();
        }
        boolean maintenance = false;
        if (this.maint != null && this.maint.length() > 0 && Integer.parseInt(this.maint) > 0) {
            maintenance = true;
        }
        StringBuffer bitTag = new StringBuffer();
        if (!(hotfix || "prt".equals(skuData.getPlatform()) || "javaruntime".equals(this.code) || !Utils.getOS_Suffix().equals("wx6") && !Utils.getOS_Suffix().equals("lax"))) {
            if (this.platform != null && (this.platform.equals("wx6") || this.platform.equals("lax"))) {
                bitTag.append(this.bundle.getString("PanelExecute.64BitTag.txt"));
            } else if (this.platform != null && (this.platform.equals("win") || this.platform.equals("lnx"))) {
                bitTag.append(this.bundle.getString("PanelExecute.32BitTag.txt"));
            }
        }
        StringBuffer langStringTag = new StringBuffer();
        if (maintenance) {
            if (language == null || language.length() <= 0 || !"xx".equalsIgnoreCase(language)) {
                if (language != null && language.length() > 0 && "ne".equalsIgnoreCase(language)) {
                    langStringTag.append(this.bundle.getString("PanelExecute.MVSNonEncodedTag.txt"));
                } else if (language != null && language.length() > 0 && ("c0".equalsIgnoreCase(language) || "f0".equalsIgnoreCase(language) || "r0".equalsIgnoreCase(language) || "w0".equalsIgnoreCase(language) || "w2".equalsIgnoreCase(language) || "w3".equalsIgnoreCase(language) || "w5".equalsIgnoreCase(language) || "w6".equalsIgnoreCase(language) || "w7".equalsIgnoreCase(language) || "w8".equalsIgnoreCase(language) || "w9".equalsIgnoreCase(language) || "wa".equalsIgnoreCase(language) || "wb".equalsIgnoreCase(language) || "wu".equalsIgnoreCase(language))) {
                    langStringTag.append(this.bundle.getString("PanelExecute.MVSEncodedTag.txt"));
                } else {
                    langStringTag.append(this.bundle.getString("Common.LangCode" + language.toUpperCase() + ".txt"));
                }
            }
        } else if (("mvs".equalsIgnoreCase(this.platform) || "z64".equalsIgnoreCase(this.platform)) && !"sasinstall".equalsIgnoreCase(this.platform)) {
            if (language != null && language.length() > 0 && "ne".equalsIgnoreCase(language)) {
                langStringTag.append(this.bundle.getString("PanelExecute.MVSNonEncodedTag.txt"));
            } else if (language != null && language.length() > 0 && !"xx".equalsIgnoreCase(language)) {
                langStringTag.append(this.bundle.getString("PanelExecute.MVSEncodedTag.txt"));
            }
        } else if (!(Globals.g_cmtTask != 28 && Globals.g_mode == 2 || language == null || language.length() <= 0 || "xx".equalsIgnoreCase(language))) {
            langStringTag.append(this.bundle.getString("Common.LangCode" + language.toUpperCase() + ".txt"));
        }
        if (maintenance && !hotfix && skuData.isDeltaRelease()) {
            if (bitTag.length() > 0 && langStringTag.length() > 0) {
                displayNameExtended.append(" ").append(this.bundle.messageString("PanelExecute.MaintenanceBitAndLangTag.txt", bitTag, langStringTag));
            } else if (bitTag.length() == 0 && langStringTag.length() == 0) {
                displayNameExtended.append(" ").append(this.bundle.getString("PanelExecute.MaintenanceTag.txt"));
            } else {
                displayNameExtended.append(" ").append(this.bundle.messageString("PanelExecute.MaintenanceBitOrLangTag.txt", bitTag.length() > 0 ? bitTag : langStringTag));
            }
        } else if (bitTag.length() > 0 && langStringTag.length() > 0) {
            displayNameExtended.append(" ").append(this.bundle.messageString("PanelExecute.InstallBitAndLangTag.txt", bitTag, langStringTag));
        } else if (bitTag.length() != 0 || langStringTag.length() != 0) {
            displayNameExtended.append(" ").append(this.bundle.messageString("PanelExecute.InstallBitOrLangTag.txt", bitTag.length() > 0 ? bitTag : langStringTag));
        }
        if (!hotfix && skuData.getIndb()) {
            displayNameExtended.append(" (").append(this.bundle.getString("Common.Platform" + this.platform.toUpperCase() + ".txt")).append(")");
        }
        return displayNameExtended.toString();
    }

    public void setPlatform(String plat) {
        this.platform = plat;
    }

    public String getPreExecuteAuditLogPath() {
        return this.preExecuteAuditLogPath;
    }

    public void setPreExecuteAuditLogPath(String preExecuteAuditLogPath) {
        this.preExecuteAuditLogPath = preExecuteAuditLogPath;
    }

    public String getPostExecuteAuditLogPath() {
        return this.postExecuteAuditLogPath;
    }

    public void setPostExecuteAuditLogPath(String postExecuteAuditLogPath) {
        this.postExecuteAuditLogPath = postExecuteAuditLogPath;
    }

    public String getUpdateBackupDirectory() {
        return this.updateBackupDirectory;
    }

    public void setUpdateBackupDirectory(String updateBackupDirectory) {
        this.updateBackupDirectory = updateBackupDirectory;
    }

    @Override
    public int compareTo(ProductData o) {
        long otherNum;
        int ret = 0;
        long thisNum = this.getSequenceNum();
        int n = thisNum < (otherNum = o.getSequenceNum()) ? -1 : (ret = thisNum == otherNum ? 0 : 1);
        if (ret == 0 && (ret = this.getSpsSku().compareTo(o.getSpsSku())) == 0) {
            InstanceData thisInstanceData = this.getInstanceData();
            InstanceData otherInstanceData = o.getInstanceData();
            if (thisInstanceData != null && otherInstanceData != null) {
                ret = thisInstanceData.getFQID().compareTo(otherInstanceData.getFQID());
            }
        }
        return ret;
    }
}

