/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.dplycmn.planning.PlanFactory;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.UnicodeInputStream;
import com.sas.ssn.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TreeMap;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Plan {
    private SSNResource bundle = new SSNResource(Plan.class);
    private static int DEPLOYED = 1;
    private static int CONFIGURED = 2;
    private File planFile;
    private String name;
    private String description;
    private Hashtable properties = new Hashtable();
    private Vector<Machine> machines = new Vector();
    private Hashtable<String, Machine.Component> xmlComponents = new Hashtable();
    private TreeMap<Integer, Machine> deploymentSteps = new TreeMap();
    private boolean hasDeploymentSteps = true;
    private com.sas.dplycmn.planning.Plan properPlan = null;

    public Plan(String file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        this(new File(file));
    }

    public Plan(File file) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        Element group;
        this.planFile = file.isDirectory() ? new File(file, "plan.xml") : file;
        try {
            this.properPlan = PlanFactory.getPlanFromFile(this.planFile);
        }
        catch (ParseException pe) {
            Logging.log.warning(pe.getMessage());
            Logging.logStackTrace(pe);
        }
        Element root = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new UnicodeInputStream(this.planFile)).getDocumentElement();
        if (root != null && "Metadata".equals(root.getTagName()) && (group = (Element)root.getElementsByTagName("Group").item(0)) != null) {
            this.name = group.getAttribute("Name");
            this.description = group.getAttribute("Desc");
            NodeList groups = group.getChildNodes();
            if (groups != null) {
                for (int i = 0; i < groups.getLength(); ++i) {
                    if (groups.item(i).getNodeType() != 1) continue;
                    Element element = (Element)groups.item(i);
                    if ("Properties".equals(element.getTagName())) {
                        this.loadProperties(element);
                        continue;
                    }
                    if (!"Members".equals(element.getTagName())) continue;
                    this.loadMembers(element);
                }
            }
        }
        this.createDeploymentStepInfo();
    }

    private void createDeploymentStepInfo() {
        for (Machine currMachine : this.machines) {
            TreeMap<Integer, String> deploySteps = currMachine.getDeploymentStepLabels();
            for (Integer stepNumber : deploySteps.keySet()) {
                this.deploymentSteps.put(stepNumber, currMachine);
            }
        }
        if (this.deploymentSteps.size() < 1) {
            this.hasDeploymentSteps = false;
            int stepNumber = 0;
            for (Machine currMachine : this.machines) {
                this.deploymentSteps.put(++stepNumber, currMachine);
            }
        }
    }

    public boolean hasDeploymentSteps() {
        return this.hasDeploymentSteps;
    }

    public Vector<String> getMachineSelTitles(boolean useDeploymentSteps) {
        Vector<String> selTitles = new Vector<String>();
        if (useDeploymentSteps && this.hasDeploymentSteps) {
            for (Integer stepNumber : this.deploymentSteps.keySet()) {
                Machine machine = this.deploymentSteps.get(stepNumber);
                selTitles.add(machine.getDeploymentStepTitle(stepNumber));
            }
        } else {
            for (Machine machine : this.machines) {
                selTitles.add(machine.getNamePossiblyOptional());
            }
        }
        return selTitles;
    }

    public Vector<String> getMachineSelTitles() {
        return this.getMachineSelTitles(Globals.g_configure);
    }

    private DeploymentStep getStepFromTitle(String stepTitle, boolean useDeploymentSteps) {
        DeploymentStep foundStep;
        block4: {
            foundStep = null;
            if (stepTitle == null) break block4;
            if (useDeploymentSteps && this.hasDeploymentSteps) {
                Iterator<Integer> stepIt = this.deploymentSteps.keySet().iterator();
                while (foundStep == null && stepIt.hasNext()) {
                    Integer stepNumber = stepIt.next();
                    Machine machine = this.deploymentSteps.get(stepNumber);
                    if (!stepTitle.equals(machine.getDeploymentStepTitle(stepNumber))) continue;
                    foundStep = new DeploymentStep(stepNumber, machine);
                }
            } else {
                Iterator<Machine> machIt = this.machines.iterator();
                while (foundStep == null && machIt.hasNext()) {
                    Machine machine = machIt.next();
                    if (!stepTitle.equals(machine.getNamePossiblyOptional())) continue;
                    foundStep = new DeploymentStep(null, machine);
                }
            }
        }
        return foundStep;
    }

    public Machine getMachineFromTitle(String stepTitle, boolean useDeploymentSteps) {
        Machine foundMachine = null;
        DeploymentStep deployStep = this.getStepFromTitle(stepTitle, useDeploymentSteps);
        if (deployStep != null) {
            foundMachine = deployStep.getMachine();
        }
        return foundMachine;
    }

    public Machine getMachineFromTitle(String stepTitle) {
        return this.getMachineFromTitle(stepTitle, Globals.g_configure);
    }

    public Integer getStepNumberFromTitle(String stepTitle, boolean useDeploymentSteps) {
        Integer foundStepNumber = null;
        DeploymentStep deployStep = this.getStepFromTitle(stepTitle, useDeploymentSteps);
        if (deployStep != null) {
            foundStepNumber = deployStep.getStepNumber();
        }
        return foundStepNumber;
    }

    public Integer getStepNumberFromTitle(String stepTitle) {
        return this.getStepNumberFromTitle(stepTitle, Globals.g_configure);
    }

    private static void dumpVectorMapIntoProps(Hashtable<String, Vector<String>> vectorMap, Hashtable<String, String> props) {
        for (String key : vectorMap.keySet()) {
            Vector<String> values = vectorMap.get(key);
            if (values.size() <= 0) continue;
            props.put(key, values.firstElement());
        }
    }

    private void loadProperties(Element element) {
        Hashtable<String, Vector<String>> propMap = Plan.readPropertyPairs(element);
        Plan.dumpVectorMapIntoProps(propMap, this.properties);
    }

    private void loadMembers(Element element) {
        NodeList machines = element.getChildNodes();
        if (machines != null) {
            for (int i = 0; i < machines.getLength(); ++i) {
                if (machines.item(i).getNodeType() != 1 || !"Machine".equals((element = (Element)machines.item(i)).getTagName())) continue;
                Machine newMachine = new Machine(element);
                if (this.properPlan != null) {
                    List<com.sas.dplycmn.planning.Machine> machList = this.properPlan.getMachines();
                    for (com.sas.dplycmn.planning.Machine currMach : machList) {
                        if (!currMach.getName().trim().equals(newMachine.getName())) continue;
                        newMachine.setIsOptional(currMach.isOptional());
                    }
                }
                this.machines.add(newMachine);
                for (int j = 0; j < 2; ++j) {
                    Machine.Component[] comps = j == 1 ? newMachine.getConfiguredComponents() : newMachine.getDeployedComponents();
                    for (int k = 0; k < comps.length; ++k) {
                        String xmlId = comps[k].getXmlId();
                        if (xmlId == null) continue;
                        this.xmlComponents.put(xmlId, comps[k]);
                    }
                }
            }
            for (Machine currMach : this.machines) {
                currMach.finalize(this);
            }
        }
    }

    private Machine.Component getComponentByXmlId(String xmlId) {
        return this.xmlComponents.get(xmlId);
    }

    private static void addToVectorMap(Hashtable<String, Vector<String>> map, String key, String value) {
        Vector<String> mapEntry = map.get(key);
        if (mapEntry == null) {
            mapEntry = new Vector();
            map.put(key, mapEntry);
        }
        mapEntry.add(value);
    }

    public static Hashtable<String, Vector<String>> readPropertyPairs(Element element) {
        Hashtable<String, Vector<String>> returnProps = new Hashtable<String, Vector<String>>();
        NodeList properties = element.getChildNodes();
        if (properties != null) {
            for (int i = 0; i < properties.getLength(); ++i) {
                if (properties.item(i).getNodeType() != 1 || !"Property".equals((element = (Element)properties.item(i)).getTagName())) continue;
                String key = element.getAttribute("Name");
                String value = element.getAttribute("DefaultValue");
                if (key == null || value == null || key.length() <= 0) continue;
                Plan.addToVectorMap(returnProps, key, value);
            }
        }
        return returnProps;
    }

    public static Hashtable<String, Vector<String>> readImplObjs(Element element) {
        Hashtable<String, Vector<String>> returnImpls = new Hashtable<String, Vector<String>>();
        NodeList implObjs = element.getChildNodes();
        if (implObjs != null) {
            for (int i = 0; i < implObjs.getLength(); ++i) {
                String tagName;
                if (implObjs.item(i).getNodeType() != 1 || !"SoftwareComponent".equals(tagName = (element = (Element)implObjs.item(i)).getTagName()) && !"DeployedComponent".equals(tagName) && !"ConfiguredComponent".equals(tagName)) continue;
                String objRef = element.getAttribute("ObjRef");
                String descrip = element.getAttribute("Desc");
                if (objRef == null || descrip == null) continue;
                String[] verbs = descrip.split("\\s*,\\s*");
                for (int j = 0; j < verbs.length; ++j) {
                    Plan.addToVectorMap(returnImpls, objRef, verbs[j]);
                }
            }
        }
        return returnImpls;
    }

    public String getFile() {
        try {
            return this.planFile.getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getDirectory() {
        try {
            return this.planFile.getParentFile().getCanonicalPath();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getProperty(String property) {
        return (String)this.properties.get(property);
    }

    public Hashtable getProperties() {
        return this.properties;
    }

    public Machine[] getMachines() {
        return this.machines.toArray(new Machine[0]);
    }

    public Machine getMachine(String machine) {
        Machine retVal = null;
        if (machine != null && machine.length() > 0) {
            Machine[] machines = this.getMachines();
            for (int i = 0; retVal == null && i < machines.length; ++i) {
                if (!machine.equals(machines[i].getName())) continue;
                retVal = machines[i];
            }
        }
        return retVal;
    }

    public boolean isSingleUser() {
        return false;
    }

    public static boolean createPlan(String planDir, ProductData[] deployedComponents, ProductData[] configuredComponents) {
        boolean valid = false;
        try {
            File planFile;
            int i;
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element current = doc.createElement("Metadata");
            Element parent = (Element)doc.appendChild(current);
            current = doc.createElement("Group");
            current.setAttribute("Name", "TempPlan");
            current.setAttribute("Desc", "Temporary Sample Plan");
            parent = (Element)parent.appendChild(current);
            current = doc.createElement("Members");
            parent = (Element)parent.appendChild(current);
            current = doc.createElement("Machine");
            current.setAttribute("Id", "$SINGLEMACHINE");
            current.setAttribute("Name", "SingleMachine");
            parent = (Element)parent.appendChild(current);
            current = doc.createElement("DeployedComponents");
            parent = (Element)parent.appendChild(current);
            if (deployedComponents != null) {
                for (i = 0; i < deployedComponents.length; ++i) {
                    if (deployedComponents[i].getSelectableType() == 2 || deployedComponents[i].isFoundation() && !"sasinstall".equalsIgnoreCase(deployedComponents[i].getProdCode())) continue;
                    current = doc.createElement("DeployedComponent");
                    current.setAttribute("Id", "$._" + deployedComponents[i].getProdCode().toUpperCase(Locale.ENGLISH));
                    current.setAttribute("Name", deployedComponents[i].getProdName());
                    current.setAttribute("ProductName", deployedComponents[i].getProdName());
                    current.setAttribute("ProductIdentifier", deployedComponents[i].getProdCode().toUpperCase(Locale.ENGLISH));
                    current.setAttribute("Platform", "WIN");
                    parent.appendChild(current);
                }
            }
            if (configuredComponents != null) {
                for (i = 0; i < configuredComponents.length; ++i) {
                    current = doc.createElement("ConfiguredComponent");
                    current.setAttribute("Id", "$._" + configuredComponents[i].getProdCode().toUpperCase(Locale.ENGLISH));
                    current.setAttribute("Name", configuredComponents[i].getProdName());
                    current.setAttribute("ProductName", configuredComponents[i].getProdName());
                    current.setAttribute("ProductIdentifier", configuredComponents[i].getProdCode().toUpperCase(Locale.ENGLISH));
                    current.setAttribute("Platform", "WIN");
                    parent.appendChild(current);
                }
            }
            if ((planFile = new File(planDir, "plan.xml")).getParentFile().isDirectory() || planFile.getParentFile().mkdirs()) {
                planFile.createNewFile();
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("indent", "yes");
                transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
                transformer.transform(new DOMSource(doc), new StreamResult(new FileOutputStream(planFile)));
                valid = true;
                Utils.removeBlankLines(planFile);
            }
        }
        catch (Exception e) {
            Logging.log.severe(e.getMessage());
        }
        return valid;
    }

    public static boolean createPlan(String planDir, String[] deployedComponents, String[] configuredComponents) {
        boolean valid = false;
        try {
            ProductData[] deployedData = null;
            if (deployedComponents != null) {
                deployedData = Globals.g_deploymentData.getProducts(Globals.g_order, deployedComponents, false);
            }
            ProductData[] configuredData = null;
            if (configuredComponents != null) {
                configuredData = Globals.g_deploymentData.getProducts(Globals.g_order, configuredComponents, false);
            }
            valid = Plan.createPlan(planDir, deployedData, configuredData);
        }
        catch (Exception e) {
            Logging.log.severe(e.getMessage());
        }
        return valid;
    }

    public class Machine {
        private boolean cfgwizAdded = false;
        private String id = null;
        private String name = null;
        private Hashtable properties = new Hashtable();
        private Vector deployIds = new Vector();
        private Vector configIds = new Vector();
        private Vector deploy = new Vector();
        private Vector config = new Vector();
        private TreeMap<Integer, String> deploymentStepLabels = new TreeMap();
        private boolean isOptional = false;

        public Machine(Element root) {
            this.id = root.getAttribute("Id");
            this.name = root.getAttribute("Name").trim();
            NodeList nodes = root.getChildNodes();
            if (nodes != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    if (nodes.item(i).getNodeType() != 1) continue;
                    Element element = (Element)nodes.item(i);
                    if ("Properties".equals(element.getTagName())) {
                        this.loadProperties(element);
                        continue;
                    }
                    if (!"DeployedComponents".equals(element.getTagName())) continue;
                    this.addDeployedComponents(element);
                }
            }
        }

        private void loadProperties(Element element) {
            Hashtable<String, Vector<String>> propMap = Plan.readPropertyPairs(element);
            Plan.dumpVectorMapIntoProps(propMap, this.properties);
            String prefix = "StepLabel_";
            int offset = prefix.length();
            for (String key : propMap.keySet()) {
                if (!key.startsWith(prefix)) continue;
                try {
                    Integer stepNumber = new Integer(key.substring(offset));
                    String stepLabel = propMap.get(key).firstElement();
                    this.deploymentStepLabels.put(stepNumber, stepLabel);
                }
                catch (Exception exception) {}
            }
        }

        private void addDeployedComponents(Element root) {
            NodeList nodes = root.getChildNodes();
            if (nodes != null) {
                int i;
                for (i = 0; i < nodes.getLength(); ++i) {
                    if (nodes.item(i).getNodeType() != 1) continue;
                    Element element = (Element)nodes.item(i);
                    if ("DeployedComponent".equals(element.getTagName())) {
                        this.addDeployedComponent(element.getAttribute("Id"), element.getAttribute("ProductIdentifier"), element.getAttribute("ProductName"));
                        continue;
                    }
                    if (!"ConfiguredComponent".equals(element.getTagName())) continue;
                    this.addConfiguredComponent(element);
                }
                if (Globals.g_planAddList != null && Globals.g_planAddList.length > 0) {
                    for (i = 0; i < Globals.g_planAddList.length; ++i) {
                        this.addDeployedComponent(Globals.g_planAddList[i], Globals.g_planAddList[i], "");
                        this.addConfiguredComponent(Globals.g_planAddList[i], Globals.g_planAddList[i], "");
                    }
                }
            }
        }

        public Component addDeployedComponent(String xmlId, String id, String name) {
            Component component = null;
            if (!(this.deployIds.contains(id.toLowerCase(Locale.ENGLISH)) || "cfgwizard".equalsIgnoreCase(id) || "privatejre".equalsIgnoreCase(id) || "javaruntime".equalsIgnoreCase(id) || "platformpm".equalsIgnoreCase(id) || "platformgms".equalsIgnoreCase(id))) {
                String platform = Utils.getOS_Suffix();
                ProductData data = "mvs".equals(platform) && Globals.g_z64 ? Globals.g_deploymentData.getProduct(Globals.g_order, id, "z64", false) : Globals.g_deploymentData.getProduct(Globals.g_order, id, false);
                if (data == null) {
                    if ("wx6".equals(platform)) {
                        data = Globals.g_deploymentData.getProduct(Globals.g_order, id, "win", false);
                    } else if ("lax".equals(platform)) {
                        data = Globals.g_deploymentData.getProduct(Globals.g_order, id, "lnx", false);
                    }
                }
                if (data == null || !data.isFoundation()) {
                    component = new Component(id, name, DEPLOYED);
                } else if ("sasinstall".equalsIgnoreCase(id) || "base".equalsIgnoreCase(id)) {
                    component = new Component("sasinstall", "SAS Foundation", DEPLOYED);
                }
                if (component != null) {
                    component.setXmlId(xmlId);
                    component.setMachId(this.id);
                    this.deployIds.add(component.getId());
                    this.deploy.add(component);
                }
            }
            return component;
        }

        private Component addConfiguredComponent(String xmlId, String id, String name) {
            Component component = null;
            if (!this.configIds.contains(id.toLowerCase(Locale.ENGLISH)) && !"cfgwizard".equalsIgnoreCase(id)) {
                if (!this.cfgwizAdded) {
                    this.cfgwizAdded = true;
                    component = new Component("cfgwizard", "", CONFIGURED);
                    component.setMachId(this.id);
                    this.configIds.add(component.getId());
                    this.config.add(component);
                }
                component = new Component(id, name, CONFIGURED);
                component.setXmlId(xmlId);
                component.setMachId(this.id);
                this.configIds.add(component.getId());
                this.config.add(component);
            }
            return component;
        }

        private Component addConfiguredComponent(Element root) {
            NodeList nodes;
            String name;
            String id;
            String xmlId = root.getAttribute("Id");
            Component component = this.addConfiguredComponent(xmlId, id = root.getAttribute("ProductIdentifier"), name = root.getAttribute("ProductName"));
            if (component != null && (nodes = root.getChildNodes()) != null) {
                for (int i = 0; i < nodes.getLength(); ++i) {
                    if (nodes.item(i).getNodeType() != 1) continue;
                    Element element = (Element)nodes.item(i);
                    String tagName = element.getTagName();
                    if ("Properties".equals(tagName)) {
                        component.updateWithProperties(Plan.readPropertyPairs(element));
                        continue;
                    }
                    if (!"ImplementedObjects".equals(tagName)) continue;
                    component.updateWithImplObjs(Plan.readImplObjs(element));
                }
            }
            return component;
        }

        public void finalize(Plan plan) {
            for (int j = 0; j < 2; ++j) {
                Component[] comps = j == 1 ? this.getConfiguredComponents() : this.getDeployedComponents();
                for (int k = 0; k < comps.length; ++k) {
                    comps[k].finalize(plan);
                }
            }
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getProperty(String property) {
            return (String)this.properties.get(property);
        }

        public String getNamePossiblyOptional() {
            if (this.getIsOptional()) {
                return Plan.this.bundle.messageString("Plan.OptMachDisplayName.txt", this.name);
            }
            return this.name;
        }

        public TreeMap<Integer, String> getDeploymentStepLabels() {
            return this.deploymentStepLabels;
        }

        public boolean isStepFirstOnMachine(Integer stepNumber) {
            boolean isFirst = true;
            Integer firstKey = this.deploymentStepLabels.firstKey();
            if (firstKey != null) {
                isFirst = firstKey.compareTo(stepNumber) == 0;
            }
            return isFirst;
        }

        public String getDeploymentStepTitle(Integer stepNumber) {
            boolean stepIsOnThisMachine = true;
            String stepLabel = this.deploymentStepLabels.get(stepNumber);
            if (stepLabel == null) {
                if (this.deploymentStepLabels.size() > 0) {
                    stepIsOnThisMachine = false;
                }
            } else if (this.deploymentStepLabels.size() < 2) {
                stepLabel = null;
            }
            String stepTitle = null;
            if (stepIsOnThisMachine) {
                String propPrefix = "Plan." + (this.getIsOptional() ? "OptMach" : "") + "StepTitle";
                if (stepLabel == null) {
                    stepTitle = Plan.this.bundle.messageString(propPrefix + "WithoutLabel.txt", stepNumber, this.getName());
                } else {
                    if ("initial".equals(stepLabel)) {
                        stepLabel = Plan.this.bundle.getString("Plan.InitialLabel.txt");
                    }
                    stepTitle = Plan.this.bundle.messageString(propPrefix + "WithLabel.txt", stepNumber, this.getName(), stepLabel);
                }
            }
            return stepTitle;
        }

        public Component[] getConfiguredComponentsForStep(Integer stepNumber) {
            Vector<Component> componentsInStep = new Vector<Component>();
            for (Component currComp : this.config) {
                if (!currComp.isInDeploymentStep(stepNumber)) continue;
                componentsInStep.add(currComp);
            }
            return componentsInStep.toArray(new Component[0]);
        }

        public Hashtable getProperties() {
            return this.properties;
        }

        public Component[] getDeployedComponents() {
            return this.deploy.toArray(new Component[0]);
        }

        public Component[] getConfiguredComponents() {
            return this.config.toArray(new Component[0]);
        }

        public String[] getDeployedComponentIds() {
            return this.deployIds.toArray(new String[0]);
        }

        public String[] getConfiguredComponentIds() {
            return this.configIds.toArray(new String[0]);
        }

        public boolean isDeployedSupported() {
            boolean supported = true;
            Component[] components = this.getDeployedComponents();
            for (int i = 0; supported && i < components.length; ++i) {
                supported = components[i].isSupported();
            }
            return supported;
        }

        public boolean isConfiguredFullySupported() {
            boolean supported = true;
            Component[] components = this.getConfiguredComponents();
            for (int i = 0; supported && i < components.length; ++i) {
                supported = components[i].isSupported();
            }
            return supported;
        }

        public boolean getIsOptional() {
            return this.isOptional;
        }

        public void setIsOptional(boolean isOptional) {
            this.isOptional = isOptional;
        }

        public class Component {
            private String xmlId;
            private String id;
            private String name;
            private String machId = null;
            private boolean prompted = false;
            private boolean supported = false;
            private Vector<Integer> deploymentSteps = new Vector();
            private Vector<String> signalConfigXmlIds = new Vector();
            private Vector<String> signalConfigs = new Vector();

            public Component(String id, String name, int type) {
                this.id = id.toLowerCase(Locale.ENGLISH);
                this.name = name;
                String platform = Utils.getOS_Suffix();
                ProductData data = "mvs".equals(platform) && Globals.g_z64 ? Globals.g_deploymentData.getProduct(Globals.g_order, id, "z64", false) : Globals.g_deploymentData.getProduct(Globals.g_order, id, false);
                if (data == null && "sasinstall".equalsIgnoreCase(id)) {
                    if ("wx6".equals(platform)) {
                        data = Globals.g_deploymentData.getProduct(Globals.g_order, id, "win", false);
                    } else if ("lax".equals(platform)) {
                        data = Globals.g_deploymentData.getProduct(Globals.g_order, id, "lnx", false);
                    }
                } else if (data == null && "jmp".equalsIgnoreCase(id)) {
                    if ("wx6".equals(platform)) {
                        data = Globals.g_deploymentData.getProduct(Globals.g_order, id, "win", false);
                    } else if ("lax".equals(platform)) {
                        data = Globals.g_deploymentData.getProduct(Globals.g_order, id, "lnx", false);
                    }
                } else if (data == null && "pcfilesrv".equalsIgnoreCase(id)) {
                    if ("wx6".equals(platform)) {
                        data = Globals.g_deploymentData.getProduct(Globals.g_order, id, "win", false);
                    }
                } else if (data == null && "eguide".equalsIgnoreCase(id)) {
                    if ("wx6".equals(platform)) {
                        data = Globals.g_deploymentData.getProduct(Globals.g_order, id, "win", false);
                    }
                } else if (data == null && "msofficeint".equalsIgnoreCase(id) && "wx6".equals(platform)) {
                    data = Globals.g_deploymentData.getProduct(Globals.g_order, id, "win", false);
                }
                if (data != null) {
                    this.name = data.getProdName();
                    if (type == DEPLOYED) {
                        this.prompted = data.getPrompt();
                        this.supported = this.prompted || !"".equals(data.getChainingRef(false));
                    } else if (type == CONFIGURED) {
                        this.supported = true;
                    }
                }
            }

            public void updateWithProperties(Hashtable<String, Vector<String>> props) {
                for (String key : props.keySet()) {
                    if (!"StepNumber".equals(key)) continue;
                    Vector<String> numbers = props.get(key);
                    Iterator<String> numbIt = numbers.iterator();
                    while (numbIt.hasNext()) {
                        try {
                            Integer stepNumber = Integer.valueOf(numbIt.next());
                            this.addDeploymentStep(stepNumber);
                        }
                        catch (Exception exception) {}
                    }
                }
            }

            public void updateWithImplObjs(Hashtable<String, Vector<String>> impls) {
                for (String key : impls.keySet()) {
                    Vector<String> verbs = impls.get(key);
                    for (String currentVerb : verbs) {
                        if (!"signals additional instance".equals(currentVerb) && !"signals reconfiguration".equals(currentVerb)) continue;
                        this.signalConfigXmlIds.add(key);
                    }
                }
            }

            public void finalize(Plan plan) {
                for (String currXmlId : this.signalConfigXmlIds) {
                    String targetMachId;
                    Component targetComp = plan.getComponentByXmlId(currXmlId);
                    if (targetComp == null || (targetMachId = targetComp.getMachId()) == null || !targetMachId.equals(this.machId)) continue;
                    this.signalConfigs.add(targetComp.getId());
                }
            }

            public void addDeploymentStep(Integer stepNumber) {
                this.deploymentSteps.add(stepNumber);
            }

            public void addDeploymentStep(int stepNumber) {
                this.addDeploymentStep((Integer)stepNumber);
            }

            public boolean isInDeploymentStep(int stepNumber) {
                for (Integer inStep : this.deploymentSteps) {
                    if (inStep != stepNumber) continue;
                    return true;
                }
                return false;
            }

            public boolean isInDeploymentStep(Integer stepNumber) {
                return this.isInDeploymentStep((int)stepNumber);
            }

            public Vector<String> getSignalConfigs() {
                return this.signalConfigs;
            }

            public String getId() {
                return this.id;
            }

            public String getName() {
                return this.name;
            }

            public String getMachId() {
                return this.machId;
            }

            public String getXmlId() {
                return this.xmlId;
            }

            public boolean isPrompted() {
                return this.prompted;
            }

            public boolean isSupported() {
                return this.supported;
            }

            public void setMachId(String machId) {
                this.machId = machId;
            }

            public void setXmlId(String xmlId) {
                this.xmlId = xmlId;
            }
        }
    }

    private class DeploymentStep {
        private Integer m_stepNumber = null;
        private Machine m_machine = null;

        public DeploymentStep(Integer stepNumber, Machine machine) {
            this.m_stepNumber = stepNumber;
            this.m_machine = machine;
        }

        public Integer getStepNumber() {
            return this.m_stepNumber;
        }

        public Machine getMachine() {
            return this.m_machine;
        }
    }
}

