/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.SearchFile;
import com.sas.ssn.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class PickList {
    private HashMap<String, Item> jarMap = new HashMap();

    private static String getPickListLocation(ProductData prodData) {
        String maintDataDir;
        String prodCode = prodData.getProdCode();
        String prodOrder = null;
        String prodDataLoc = "";
        File picklistFile = null;
        prodOrder = Globals.g_mode == 2 && Globals.g_cmtTask != 5 && Globals.g_cmtTask != 26 && prodData.getInstanceData() != null ? prodData.getInstanceData().getOrder() : Globals.g_order;
        ProductData maintData = Globals.g_deploymentData.getMaintenance(prodOrder, prodCode, Utils.getOS_Suffix(), "xx", true);
        if (maintData != null && (maintDataDir = Globals.g_deploymentData.getSpsSkuDataDir(prodOrder, maintData.getSpsSku(), true)) != null) {
            picklistFile = new File(maintDataDir, "picklist");
            if (picklistFile.isFile()) {
                prodDataLoc = Utils.joinPath(maintDataDir, "picklist");
                Logging.log.fine("Maintenance picklist location=" + prodDataLoc);
            } else {
                Logging.log.fine("Maintenance picklist location not found=" + prodDataLoc);
            }
        }
        if (prodDataLoc.length() == 0) {
            String spsSku = null;
            spsSku = Globals.g_mode == 2 && Globals.g_cmtTask == 5 ? Globals.g_deploymentData.getProduct(Globals.g_order, prodCode, true).getSpsSku() : prodData.getSpsSku();
            prodDataLoc = Utils.joinPath(Utils.joinPath(Globals.g_startupLocation, "product_data"), spsSku);
            prodDataLoc = Utils.joinPath(prodDataLoc, "picklist");
            Logging.log.fine("picklist Location=" + prodDataLoc);
        }
        return prodDataLoc;
    }

    public PickList(ProductData prodData) {
        this(PickList.getPickListLocation(prodData));
    }

    public PickList(String pickListFile) {
        this(new File(pickListFile));
    }

    public PickList(File pickListFile) {
        if (pickListFile.exists()) {
            try {
                BufferedReader in = new BufferedReader(new FileReader(pickListFile));
                String sLine = in.readLine();
                while (sLine != null) {
                    int iHash = sLine.indexOf("#");
                    if (iHash != -1) {
                        sLine = sLine.substring(0, iHash);
                    }
                    String jarName = sLine.trim();
                    String version = null;
                    int colon = sLine.indexOf(":");
                    if (colon != -1) {
                        version = jarName.substring(colon + 1);
                        jarName = jarName.substring(0, colon);
                    }
                    File temp = null;
                    temp = version == null ? SearchFile.FindNewestJar(jarName, Globals.g_vjrHome, true) : SearchFile.FindVersionedJar(jarName, version, Globals.g_vjrHome, true);
                    if (temp == null) {
                        Logging.log.warning(jarName + " was not found in " + Globals.g_vjrHome + "  per pickListFile " + pickListFile.getPath());
                    } else {
                        this.addItem(jarName, version, temp.getParent());
                    }
                    sLine = in.readLine();
                }
                in.close();
            }
            catch (FileNotFoundException e) {
                Logging.log.severe("Failed to File Not Found: " + pickListFile.getPath() + ": " + e.getLocalizedMessage());
            }
            catch (IOException e) {
                Logging.log.severe("Failed to IO Exception for file: " + pickListFile.getPath() + ": " + e.getLocalizedMessage());
            }
        }
    }

    public void addItem(String jarName, String jarVersion, String resolvedParentPath) {
        Item item = new Item(jarName, jarVersion, resolvedParentPath);
        this.jarMap.put(jarName, item);
    }

    public Item getItem(String jarName) {
        return this.jarMap.get(jarName);
    }

    public Item removeItem(String jarName) {
        return this.jarMap.remove(jarName);
    }

    public Iterator<Item> iterator() {
        return this.jarMap.values().iterator();
    }

    public int size() {
        return this.jarMap.size();
    }

    public String getCombinedPickListPath() {
        StringBuffer sb = new StringBuffer();
        Iterator<Item> it = this.iterator();
        while (it.hasNext()) {
            if (sb.length() > 0) {
                sb.append(System.getProperty("path.separator"));
            }
            sb.append(it.next().getResolvedParentPath());
        }
        return sb.toString();
    }

    public String toString() {
        return this.getCombinedPickListPath();
    }

    public static class Item {
        String jarName;
        String jarVersion;
        String resolvedParentPath;

        private Item() {
        }

        private Item(String jarName, String jarVersion, String resolvedParentPath) {
            this.jarName = jarName;
            this.jarVersion = jarVersion;
            this.resolvedParentPath = resolvedParentPath;
        }

        public String getJarName() {
            return this.jarName;
        }

        private void setJarName(String jarName) {
            this.jarName = jarName;
        }

        public String getJarVersion() {
            return this.jarVersion;
        }

        private void setJarVersion(String jarVersion) {
            this.jarVersion = jarVersion;
        }

        public String getResolvedParentPath() {
            return this.resolvedParentPath;
        }

        private void setResolvedParentPath(String resolvedParentPath) {
            this.resolvedParentPath = resolvedParentPath;
        }
    }
}

