/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class PanelZOS
implements WizardPanelIface {
    private final String RESPONSE_ZOS = "zos";
    private final String RESPONSE_WINDOWS = "windows";
    private SSNResource bundle = new SSNResource(PanelZOS.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_infoText = null;
    private JRadioButton m_zosOption = null;
    private JTextArea m_zosText = null;
    private JRadioButton m_windowsOption = null;
    private JTextArea m_windowsText = null;
    private boolean m_panelLoaded = false;
    private boolean m_zosCommand = false;
    private boolean m_commandSet = false;

    public PanelZOS() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelZOS.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelZOS.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        Globals.g_zos = this.m_zosOption.isSelected();
        return true;
    }

    @Override
    public boolean displayPanel() {
        boolean display = false;
        if (!(Globals.g_depotManager != null && Globals.g_depotManager.isPreSPSDepot() || Globals.g_order == null)) {
            if (!this.m_commandSet) {
                this.m_commandSet = true;
                this.m_zosCommand = Globals.g_zos;
            }
            if (!this.m_zosCommand && Utils.getOS() == 1) {
                ProductData zOSInstWiz = Globals.g_deploymentData.getProduct(Globals.g_order, "zosinstwiz", false);
                if (zOSInstWiz != null) {
                    ProductData[] winProds = Globals.g_deploymentData.getProdsForPlat(Globals.g_order, Utils.getOS_Suffix(), false);
                    if (winProds != null && winProds.length > 0) {
                        display = true;
                    } else {
                        Globals.g_zos = true;
                    }
                } else {
                    Globals.g_zos = false;
                }
            }
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        return "sashome";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_zosOption.setSelected(true);
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JRadioButton focus = null;
        if (this.m_zosOption.isSelected()) {
            focus = this.m_zosOption;
        } else if (this.m_windowsOption.isSelected()) {
            focus = this.m_windowsOption;
        }
        return focus;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        if (Globals.g_quietMode && Globals.g_recordMode) {
            return null;
        }
        String[] data = new String[]{"#ZOS_OPTION=zos/windows", " ZOS_OPTION=zos"};
        if (this.m_panelLoaded && this.m_windowsOption.isSelected()) {
            data[1] = " ZOS_OPTION=windows";
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_zosOption, this.m_windowsOption};
        JTextArea[] infos = new JTextArea[]{this.m_zosText, this.m_windowsText};
        return ConsoleMode.promptRadioButtons(options, infos);
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("ZOS_OPTION", null);
        if (response != null) {
            if (response.equalsIgnoreCase("zos")) {
                valid = true;
                this.m_zosOption.setSelected(true);
            } else if (response.equalsIgnoreCase("windows")) {
                valid = true;
                this.m_windowsOption.setSelected(true);
            } else if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "ZOS_OPTION", response, null);
            }
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "ZOS_OPTION");
        }
        return valid;
    }

    private void initialize() {
        this.m_infoText = new JTextArea(this.bundle.getString("PanelZOS.Instructions.txt"));
        this.m_infoText.setEditable(false);
        this.m_infoText.setFocusable(false);
        this.m_infoText.setLineWrap(true);
        this.m_infoText.setWrapStyleWord(true);
        this.m_infoText.setOpaque(false);
        String mtxt = this.bundle.getString("PanelZOS.ZOSOption.txt");
        String txt = Util.getLabelWithoutMnemonic(mtxt);
        this.m_zosOption = new JRadioButton(txt);
        this.m_zosOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_zosOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_zosOption.getFont();
        this.m_zosOption.setFont(optionFont.deriveFont(1));
        this.m_zosText = new JTextArea(this.bundle.getString("PanelZOS.ZOSText.txt"));
        this.m_zosText.setEditable(false);
        this.m_zosText.setFocusable(false);
        this.m_zosText.setLineWrap(true);
        this.m_zosText.setWrapStyleWord(true);
        this.m_zosText.setOpaque(false);
        mtxt = this.bundle.getString("PanelZOS.WindowsOption.txt");
        txt = Util.getLabelWithoutMnemonic(mtxt);
        this.m_windowsOption = new JRadioButton(txt);
        this.m_windowsOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_windowsOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_windowsOption.getFont();
        this.m_windowsOption.setFont(optionFont.deriveFont(1));
        this.m_windowsText = new JTextArea(this.bundle.getString("PanelZOS.WindowsText.txt"));
        this.m_windowsText.setEditable(false);
        this.m_windowsText.setFocusable(false);
        this.m_windowsText.setLineWrap(true);
        this.m_windowsText.setWrapStyleWord(true);
        this.m_windowsText.setOpaque(false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_zosOption);
        group.add(this.m_windowsOption);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 18;
        c.fill = 2;
        c.gridy = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_infoText, c);
        c.gridy = 1;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_zosOption, c);
        c.gridy = 2;
        c.insets = new Insets(5, 20, 0, 0);
        this.m_panel.add((Component)this.m_zosText, c);
        c.gridy = 3;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_windowsOption, c);
        c.gridy = 4;
        c.insets = new Insets(5, 20, 0, 0);
        this.m_panel.add((Component)this.m_windowsText, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

