/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public abstract class PanelWarning
implements WizardPanelIface,
ActionListener {
    private final SSNResource bundle = new SSNResource(PanelWarning.class);
    private static final String SHORT_CLASSNAME = PanelWarning.class.getName().substring(PanelWarning.class.getPackage().getName().length() + 1, PanelWarning.class.getName().length());
    private final JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_warning_txt = null;
    private JCheckBox m_checkbox = null;
    private boolean m_panelLoaded = false;

    protected abstract String getSubClassName();

    public PanelWarning() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString(this.getSubClassName() + ".Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString(this.getSubClassName() + ".HeaderDesc.txt");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj == this.m_checkbox) {
            boolean enabled = this.m_checkbox.isSelected();
            Globals.g_wizard.getNextButton().setEnabled(enabled);
        }
    }

    @Override
    public boolean validateData() {
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return "finish";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_warning_txt.setText(this.bundle.getString(this.getSubClassName() + ".Warning.txt"));
            String mtxt = this.bundle.getString(this.getSubClassName() + ".CheckboxLabel.txt");
            this.m_checkbox.setText(Util.getLabelWithoutMnemonic(mtxt));
            this.m_checkbox.setMnemonic(Util.getDisplayedMnemonic(mtxt));
            this.m_checkbox.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            this.m_panelLoaded = true;
        }
        boolean enabled = this.m_checkbox.isSelected();
        Globals.g_wizard.getNextButton().setEnabled(enabled);
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return this.m_checkbox;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#SKIP_WARNING=<YES|NO>", " SKIP_WARNING="};
        if (this.m_panelLoaded) {
            data[1] = " SKIP_WARNING=" + (this.m_checkbox.isSelected() ? "yes" : "no");
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        Globals.g_wizard.getNextButton().setEnabled(true);
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptBoolean(this.m_checkbox);
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        String checkboxChoice = Wizard.getResponse("SKIP_WARNING", null);
        if (checkboxChoice != null) {
            if (checkboxChoice.equalsIgnoreCase("yes")) {
                this.m_checkbox.setSelected(true);
            } else if (checkboxChoice.equalsIgnoreCase("no")) {
                this.m_checkbox.setSelected(false);
            } else {
                valid = false;
                Wizard.logResponseInvalid(this.getHeader(), "SKIP_WARNING", checkboxChoice, null);
            }
        } else {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "SKIP_WARNING");
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_warning_txt = new JTextArea();
        this.m_warning_txt.setEditable(false);
        this.m_warning_txt.setFocusable(false);
        this.m_warning_txt.setLineWrap(true);
        this.m_warning_txt.setWrapStyleWord(true);
        this.m_warning_txt.setOpaque(false);
        this.m_warning_txt.setEnabled(true);
        this.m_warning_txt.setVisible(true);
        this.m_checkbox = new JCheckBox();
        this.m_checkbox.setEnabled(true);
        this.m_checkbox.setVisible(true);
        this.m_checkbox.addActionListener(this);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(0, 0, 5, 0);
        c.gridy = 0;
        this.m_panel.add((Component)this.m_warning_txt, c);
        c.gridy = 1;
        this.m_panel.add((Component)this.m_checkbox, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getSubClassName();
    }
}

