/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.KitBrowseButton;
import com.sas.ssn.KitTextField;
import com.sas.ssn.Language;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.ThirdParty;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.ssn.WizardPromptedIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class PanelThirdParty
implements WizardPanelIface,
WizardPromptedIface {
    private final String JDK6_LEVCHECK_FILE = "levcheck1.6.xml";
    private final String JDK5OR6_LEVCHECK_FILE = "levcheck5or6.xml";
    private SSNResource bundle = new SSNResource(PanelThirdParty.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_description = null;
    private JTextArea m_productName = null;
    private JTextArea m_description2 = null;
    private KitTextField m_thirdPartyDir = null;
    private KitBrowseButton m_browseButton = null;
    private boolean m_panelLoaded = false;
    private int m_index = 0;
    private int m_level = -1;
    private String m_code = null;
    private String m_version = null;
    private String m_name = null;
    private String m_location = null;
    private String m_responseValueName = null;
    private String m_selectedVersion = null;
    private boolean m_jdkVersion6 = false;
    private boolean m_jdkVersion5or6 = false;
    private String m_lastThirdPartyPath = "";
    private String m_lastThirdPartyVer = "";
    private String m_recommendedVer = "";

    public PanelThirdParty(int index, String prodCode, String prodVersion, String prodName) {
        this.m_index = index;
        this.m_code = prodCode;
        this.m_version = prodVersion;
        this.m_name = prodName;
        this.m_responseValueName = "REQUIRED_SOFTWARE_" + this.m_code.toUpperCase(Locale.ENGLISH);
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelThirdParty.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelThirdParty.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        boolean valid = true;
        String errMsg = null;
        String thirdPartyDir = this.m_thirdPartyDir.getText().trim();
        this.m_thirdPartyDir.setText(thirdPartyDir);
        this.m_level = -1;
        if (thirdPartyDir.length() == 0) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), this.m_responseValueName);
            } else {
                errMsg = this.bundle.getString("PanelThirdParty.RequiredField.txt");
            }
        } else if (Utils.pathContainsValidChars(thirdPartyDir)) {
            valid = Utils.validatePath(thirdPartyDir);
            if (!valid) {
                if (Globals.g_quietMode) {
                    Wizard.logResponseInvalid(this.getHeader(), this.m_responseValueName, thirdPartyDir, null);
                } else {
                    errMsg = this.bundle.getString("PanelThirdParty.InvalidPath.txt");
                }
            }
        } else {
            valid = false;
            if (Globals.g_quietMode) {
                String quietMsg = null;
                quietMsg = Utils.getOS() == 1 ? "The following characters are invalid: / : * ? \" < > |" : (Utils.getOS() == 9 ? "The following characters are invalid: \\ :" : "The following characters are invalid: <space> % * \" & ? : < > \\ | ( )");
                Wizard.logResponseInvalid(this.getHeader(), this.m_responseValueName, thirdPartyDir, quietMsg);
            } else {
                errMsg = Utils.getOS() == 1 ? this.bundle.messageString("Common.Error.InvalidChars.Windows.txt", this.m_responseValueName) : (Utils.getOS() == 9 ? this.bundle.messageString("Common.Error.InvalidChars.Mac.txt", this.m_responseValueName) : this.bundle.messageString("Common.Error.InvalidChars.UNIX.txt", this.m_responseValueName));
            }
        }
        if (valid && this.m_code.equalsIgnoreCase("jdk") && (Utils.getOS_Suffix() == "wx6" || Utils.getOS_Suffix() == "lax") && new File(thirdPartyDir, "jre/lib/i386/jvm.cfg").isFile()) {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), this.m_responseValueName, thirdPartyDir, null);
            } else {
                errMsg = this.bundle.getString("PanelThirdParty.64BitJDKRequired.txt");
            }
        }
        if (valid) {
            String version = ThirdParty.getVersion(this.m_code, thirdPartyDir);
            if (version == null) {
                if (this.skipThirdPartyCheck() && new File(thirdPartyDir).isDirectory()) {
                    this.m_level = 2;
                } else {
                    valid = false;
                    if (Globals.g_quietMode) {
                        Wizard.logResponseInvalid(this.getHeader(), this.m_responseValueName, thirdPartyDir, null);
                    } else {
                        errMsg = this.m_code.equalsIgnoreCase("platformlsf") ? this.bundle.getString("PanelThirdParty.LSFNotInstalledCorrectly.txt") : this.bundle.getString("PanelThirdParty.BadPath.txt");
                    }
                }
            } else if (!Globals.g_quietMode && !Globals.g_partialPrompt) {
                File fileThirdPartyPath;
                this.m_level = this.m_jdkVersion6 ? ThirdParty.getLevel(Globals.g_order, this.m_code, version, "levcheck1.6.xml") : (this.m_jdkVersion5or6 ? ThirdParty.getLevel(Globals.g_order, this.m_code, version, "levcheck5or6.xml") : ThirdParty.getLevel(this.m_code, version));
                if (!(this.skipThirdPartyCheck() || this.m_level == 0 || this.m_level == 1 || this.m_lastThirdPartyPath.equals((fileThirdPartyPath = new File(thirdPartyDir)).getAbsolutePath()) && this.m_lastThirdPartyVer.equals(version))) {
                    if (this.m_code.equalsIgnoreCase("pythoncfg") && this.m_level != 2) {
                        CustMsgBox.showConfirmRetryNoQuitPrompt("The version " + version + " selected does not meet the required version of " + this.m_recommendedVer + " Please select an alternative that meets the requirements. ");
                        valid = false;
                    } else if (CustMsgBox.showConfirmDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelThirdParty.BadVersion.txt", version, this.m_recommendedVer), Globals.g_wizard.getWizardTitle(), 0, 3, 1) == 1) {
                        valid = false;
                    }
                    if (valid) {
                        this.m_lastThirdPartyPath = fileThirdPartyPath.getAbsolutePath();
                        this.m_lastThirdPartyVer = version;
                    }
                }
            }
        }
        if (valid) {
            String beaHome;
            this.m_location = thirdPartyDir;
            this.m_selectedVersion = ThirdParty.getVersion(this.m_code, thirdPartyDir, true);
            if (this.m_code.equalsIgnoreCase("weblogic") && (beaHome = ThirdParty.getBEAHomePath(thirdPartyDir)) == null) {
                this.m_location = ThirdParty.getWebLogicPath(thirdPartyDir);
            }
        } else if (!Globals.g_quietMode) {
            if (errMsg != null) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errMsg, Globals.g_wizard.getWizardTitle(), 2);
            }
            this.m_thirdPartyDir.requestFocus();
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        boolean display = true;
        if (Globals.g_remoteWebApps && (this.m_code.equalsIgnoreCase("jboss") || this.m_code.equalsIgnoreCase("vfabrictcsvr") || this.m_code.equalsIgnoreCase("tcsclusterc") || this.m_code.equalsIgnoreCase("weblogic") || this.m_code.equalsIgnoreCase("websphereba") || this.m_code.equalsIgnoreCase("webspherend") || this.m_code.equalsIgnoreCase("jdk"))) {
            display = false;
        }
        return display;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        panelID = this.m_index < Globals.g_promptedInstalls.length - 1 ? Globals.g_promptedInstalls[this.m_index + 1] : (Globals.g_planConfigs != null && Globals.g_planConfigs.length > 0 ? "accounttype" : "execute");
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        boolean jdk6Supported = false;
        boolean jdk5or6Supported = false;
        this.m_jdkVersion6 = false;
        String jdkDataDir = Globals.g_deploymentData.getProductDataDir(Globals.g_order, "jdk", true, false);
        File levCheckFile = new File(jdkDataDir, "levcheck1.6.xml");
        if (levCheckFile.isFile()) {
            jdk6Supported = true;
            if (this.m_code.equalsIgnoreCase("jdk") && Globals.g_promptedInstalls != null) {
                WizardPromptedIface promptedPanel = null;
                for (int i = 0; i < Globals.g_promptedInstalls.length; ++i) {
                    promptedPanel = (WizardPromptedIface)Globals.g_wizard.getPanel(Globals.g_promptedInstalls[i]);
                    if (promptedPanel == null || !promptedPanel.getProductCode().equalsIgnoreCase("weblogic") || !promptedPanel.getSelectedVersion().equalsIgnoreCase("10.3")) continue;
                    this.m_jdkVersion6 = true;
                }
            }
        }
        this.m_jdkVersion5or6 = false;
        File levCheck5or6File = new File(jdkDataDir, "levcheck5or6.xml");
        if (levCheck5or6File.isFile()) {
            jdk5or6Supported = true;
            if (this.m_code.equalsIgnoreCase("jdk") && Globals.g_promptedInstalls != null) {
                WizardPromptedIface promptedPanel = null;
                for (int i = 0; i < Globals.g_promptedInstalls.length; ++i) {
                    promptedPanel = (WizardPromptedIface)Globals.g_wizard.getPanel(Globals.g_promptedInstalls[i]);
                    if (promptedPanel == null || !promptedPanel.getProductCode().equalsIgnoreCase("jboss") || !promptedPanel.getSelectedVersion().equalsIgnoreCase("4.3")) continue;
                    this.m_jdkVersion5or6 = true;
                }
            }
        }
        String displayText = null;
        displayText = jdk6Supported && this.m_code.equalsIgnoreCase("weblogic") ? this.m_name + " " + this.bundle.getString("Common.WebLogicVersion.txt") : (this.m_jdkVersion6 && this.m_code.equalsIgnoreCase("jdk") ? this.m_name + " Java 6" : (jdk5or6Supported && this.m_code.equalsIgnoreCase("jboss") ? this.m_name + " " + this.bundle.getString("Common.JBossVersion.txt") : (this.m_jdkVersion5or6 && this.m_code.equalsIgnoreCase("jdk") ? this.m_name + " Java 5 or 6" : this.m_name + " " + this.m_version)));
        this.m_productName.setText(displayText);
        this.m_recommendedVer = this.m_jdkVersion6 ? "Java 6" : (this.m_jdkVersion5or6 ? "Java 5 or 6" : ThirdParty.getRecommendedVersion(this.m_code));
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            if (this.m_thirdPartyDir.getText().trim().length() == 0) {
                String thirdPartyDir = RegistryData.getInstallLoc(this.m_code, Globals.g_majorReleaseVersion);
                if (thirdPartyDir == null) {
                    thirdPartyDir = this.m_jdkVersion6 ? ThirdParty.getInstalledPath(Globals.g_order, this.m_code, "levcheck1.6.xml") : (this.m_jdkVersion5or6 ? ThirdParty.getInstalledPath(Globals.g_order, this.m_code, "levcheck5or6.xml") : ThirdParty.getInstalledPath(this.m_code));
                }
                if (thirdPartyDir != null) {
                    this.m_thirdPartyDir.setText(thirdPartyDir);
                }
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#" + this.m_responseValueName + "=<full path to " + this.m_name + " " + this.m_version + ">", " " + this.m_responseValueName + "="};
        if (this.m_panelLoaded) {
            data[1] = " " + this.m_responseValueName + "=" + this.m_thirdPartyDir.getText();
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptText(this.m_productName.getText(), this.m_thirdPartyDir);
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse(this.m_responseValueName, null);
        if (response != null) {
            valid = true;
            this.m_thirdPartyDir.setText(response);
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), this.m_responseValueName);
        }
        return valid;
    }

    @Override
    public String getProductCode() {
        return this.m_code;
    }

    @Override
    public String getVersion() {
        return this.m_version;
    }

    @Override
    public String getProductName() {
        return this.m_name;
    }

    @Override
    public String getLocation() {
        return this.m_location;
    }

    @Override
    public int getLevel() {
        return this.m_level;
    }

    @Override
    public String getSelectedVersion() {
        return this.m_selectedVersion;
    }

    private void initialize() {
        this.m_description = new JTextArea(this.bundle.getString("PanelThirdParty.Description.txt"));
        this.m_description.setEditable(false);
        this.m_description.setFocusable(false);
        this.m_description.setLineWrap(true);
        this.m_description.setWrapStyleWord(true);
        this.m_description.setOpaque(false);
        this.m_productName = new JTextArea();
        this.m_productName.setEditable(false);
        this.m_productName.setFocusable(false);
        this.m_productName.setLineWrap(true);
        this.m_productName.setWrapStyleWord(true);
        this.m_productName.setOpaque(false);
        Font textFont = this.m_productName.getFont();
        this.m_productName.setFont(textFont.deriveFont(1));
        this.m_description2 = new JTextArea(this.bundle.getString("PanelThirdParty.Description2.txt"));
        this.m_description2.setEditable(false);
        this.m_description2.setFocusable(false);
        this.m_description2.setLineWrap(true);
        this.m_description2.setWrapStyleWord(true);
        this.m_description2.setOpaque(false);
        this.m_thirdPartyDir = new KitTextField();
        String mtxt = this.bundle.getString("Common.Browse1.txt");
        this.m_browseButton = new KitBrowseButton(Util.getLabelWithoutMnemonic(mtxt), "", 0, this.m_thirdPartyDir);
        this.m_browseButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_browseButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_browseButton.setFileSelectionMode(1);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_description, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 10, 5, 0);
        this.m_panel.add((Component)this.m_productName, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 0, 5, 0);
        this.m_panel.add((Component)this.m_description2, c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 0, 0, 0);
        this.m_panel.add((Component)this.m_thirdPartyDir, c);
        c.gridx = 1;
        c.gridy = 3;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 12;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_browseButton, c);
    }

    public void setIndex(int index) {
        this.m_index = index;
    }

    @Override
    public String getHelpTopic() {
        String id = this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
        String lang = Language.gs_SelectedLanguage;
        String page = "/doc/" + lang + "/deploywiz/html/" + id + "_" + this.m_code + ".html";
        URL url = this.getClass().getResource(page);
        if (url == null) {
            page = "/doc/en/deploywiz/html/" + id + "_" + this.m_code + ".html";
            url = this.getClass().getResource(page);
        }
        if (url != null) {
            id = id + "_" + this.m_code;
        }
        return id;
    }

    private boolean skipThirdPartyCheck() {
        boolean skip = Globals.g_skipThirdPartyCheck && !this.m_code.equalsIgnoreCase("jboss") && !this.m_code.equalsIgnoreCase("vfabrictcsvr") && !this.m_code.equalsIgnoreCase("tcsclusterc") && !this.m_code.equalsIgnoreCase("weblogic") && !this.m_code.equalsIgnoreCase("websphereba") && !this.m_code.equalsIgnoreCase("webspherend") && !this.m_code.equalsIgnoreCase("jdk");
        return skip;
    }
}

