/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.metadata.remote.TextStore;
import com.sas.ssn.ConfigStatus;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PanelTLSInternalConnection
implements WizardPanelIface,
ActionListener {
    private final SSNResource bundle = new SSNResource(PanelTLSInternalConnection.class);
    private final JPanel m_panel = new JPanel(new GridBagLayout());
    private final JComboBox<String> m_tlsStateCombo = new JComboBox<String>(new String[]{"Enable", "Disable"});
    private final JTextArea m_requiredLabel;
    private final JEditorPane m_requiredPane = new JEditorPane();
    private final JScrollPane m_scrollPane = new JScrollPane(this.m_requiredPane);
    private boolean m_panelLoaded = false;

    public PanelTLSInternalConnection() {
        Globals.g_internalTLSProps = new Properties();
        this.m_requiredLabel = new JTextArea(this.bundle.getString("PanelTLSInternalConnection.InternalPreviewLabel.txt"));
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelTLSInternalConnection.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelTLSInternalConnection.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        String tlsState = (String)this.m_tlsStateCombo.getSelectedItem();
        boolean enable = "Enable".equalsIgnoreCase(tlsState);
        if (enable) {
            String[] certProps;
            for (String propName : certProps = new String[]{"sas.certframe.cust.public.ca.certs.int.pem.fqfn", "sas.certframe.cust.public.ca.certs.int.p12.fqfn", "sas.certframe.cust.server.certs.int.p12.fqfn", "sas.certframe.cust.server.certs.int.pem.fqfn", "sas.certframe.cust.server.private.key.int.fqfn"}) {
                String property = this.getTextStoreProperty(propName, "levdirroot");
                if (property != null && !property.trim().isEmpty()) continue;
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelTLSInternalConnection.NoCertError.txt") + "\nMissing or empty: " + propName, this.bundle.getString("Common.Error.txt"), 0);
                return false;
            }
        }
        String internalState = "Enable".equalsIgnoreCase(tlsState) ? "ON" : "OFF";
        this.setTlsState(internalState);
        this.updateTargetProperties(enable);
        Globals.g_configData.setProperty("global.certframe.tls.int.state", internalState);
        Globals.g_configData.save();
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        if (Globals.g_internalTLSProps.size() == 0) {
            return "finish";
        }
        return "execute";
    }

    @Override
    public String getHelpTopic() {
        return "PanelTLSInternalConnection";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        boolean enable = this.isTlsEnabled();
        boolean hasMeta = this.hasMetadata();
        this.m_tlsStateCombo.setSelectedItem(enable ? "Enable" : "Disable");
        this.m_tlsStateCombo.setEnabled(hasMeta);
        this.m_requiredPane.setText("<html><table cellspacing=0 cellpadding=0 style=\"border-collapse: collapse;\">" + this.getDisplayTargets(enable) + "</table></html>");
        if (!this.m_panelLoaded) {
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String value = this.m_tlsStateCombo.getSelectedItem().toString().equalsIgnoreCase("Enable") ? "yes" : "no";
        String[] data = new String[]{"#ENABLE_INTERNAL_TLS=<YES|NO>", " ENABLE_INTERNAL_TLS=" + value};
        return data;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        String response = Wizard.getResponse("ENABLE_INTERNAL_TLS", null);
        if (response != null) {
            this.m_tlsStateCombo.setSelectedItem(response.equalsIgnoreCase("yes") ? "Enable" : "Disable");
        } else {
            valid = false;
            if (Globals.g_quietMode) {
                Wizard.logResponseMissing(this.getHeader(), "ENABLE_INTERNAL_TLS");
            }
        }
        return valid;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        int returnCode = ConsoleMode.promptComboBox(this.m_tlsStateCombo);
        return returnCode;
    }

    private void initialize() {
        this.m_tlsStateCombo.addActionListener(this);
        this.m_requiredLabel.setEditable(false);
        this.m_requiredLabel.setFocusable(false);
        this.m_requiredLabel.setLineWrap(false);
        this.m_requiredLabel.setOpaque(false);
        this.m_requiredPane.setOpaque(false);
        this.m_requiredPane.setEditable(false);
        this.m_requiredPane.setContentType("text/html");
        this.m_requiredPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_tlsStateCombo) {
            String tlsState = (String)this.m_tlsStateCombo.getSelectedItem();
            String internalState = "Enable".equalsIgnoreCase(tlsState) ? "ON" : "OFF";
            boolean enable = "Enable".equalsIgnoreCase(tlsState);
            this.setTlsState(internalState);
            this.updateTargetProperties(enable);
        }
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 0.0;
        c.insets = new Insets(0, 12, 4, 10);
        JLabel comboLabel = new JLabel(this.bundle.getString("PanelTLSInternalConnection.EnableLabel.txt"));
        this.m_panel.add((Component)comboLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        c.anchor = 17;
        c.fill = 0;
        c.weightx = 1.0;
        c.insets = new Insets(0, 12, 16, 10);
        this.m_tlsStateCombo.setPreferredSize(new Dimension(340, this.m_tlsStateCombo.getPreferredSize().height));
        this.m_panel.add(this.m_tlsStateCombo, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(5, 12, 0, 10);
        c.fill = 2;
        this.m_panel.add((Component)this.m_requiredLabel, c);
        c.gridy = 3;
        c.weighty = 1.0;
        c.insets = new Insets(5, 12, 10, 10);
        c.fill = 1;
        this.m_panel.add((Component)this.m_scrollPane, c);
    }

    private boolean isTlsEnabled() {
        String property = this.getTextStoreProperty("global.certframe.tls.int.state", "globalroot");
        return "ON".equalsIgnoreCase(property);
    }

    private void setTlsState(String value) {
        this.setTextStoreProperty("global.certframe.tls.int.state", value);
    }

    private String getTextStoreProperty(String key, String identifier) {
        List stores = MetadataAccess.getMetadataObjects(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, "TextStore", "<XMLSelect search=\"TextStore[@Name='Public Configuration Properties'][Objects/SoftwareComponent[@ClassIdentifier='" + identifier + "']]\" />");
        return !stores.isEmpty() ? MetadataAccess.getTextStoreProperty((TextStore)stores.get(0), key) : null;
    }

    private void setTextStoreProperty(String key, String value) {
        List stores = MetadataAccess.getMetadataObjects(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, "TextStore", "<XMLSelect search=\"TextStore[@Name='Public Configuration Properties'][Objects/SoftwareComponent[@ClassIdentifier='globalroot']]\" />");
        if (!stores.isEmpty()) {
            MetadataAccess.setTextStoreProperty((TextStore)stores.get(0), key, value);
            try {
                ((TextStore)stores.get(0)).updateMetadataAll();
            }
            catch (Exception e) {
                Logging.log.severe("Error updating TLS property: " + e.getMessage());
                Logging.logStackTrace(e);
            }
        }
    }

    private void updateTargetProperties(boolean newState) {
        ConfigStatus.StatusEntry[] entries;
        for (ConfigStatus.StatusEntry entry : entries = Globals.g_configStatus.getStatusEntries()) {
            String code = entry.getCode();
            String targetProp = Globals.g_configDefaults.getDefault(code + ".changeTLSint.target.is_called", "");
            if (!"true".equalsIgnoreCase(targetProp)) continue;
            String key = code + ".changeTLSint";
            String value = newState ? "ON" : "OFF";
            Globals.g_internalTLSProps.remove(key);
            Globals.g_internalTLSProps.setProperty(key, value);
        }
    }

    private String isInternalStateEnabled(String prodCode) {
        String property = this.getTextStoreProperty(prodCode + ".tls.int.state", "globalroot");
        if (property == null) {
            return "(unknown)";
        }
        return "ON".equalsIgnoreCase(property) ? "(already configured)" : "";
    }

    private String getDisplayTargets(boolean enabled) {
        ConfigStatus.StatusEntry[] entries;
        ArrayList<String> targets = new ArrayList<String>();
        for (ConfigStatus.StatusEntry entry : entries = Globals.g_configStatus.getStatusEntries()) {
            String code = entry.getCode();
            String targetProp = Globals.g_configDefaults.getDefault(code + ".changeTLSint.target.is_called", "");
            if (!"true".equalsIgnoreCase(targetProp)) continue;
            String status = this.isInternalStateEnabled(code);
            ProductData prodData = Globals.g_deploymentData.getProduct(Globals.g_order, code, true);
            if (prodData == null) continue;
            targets.add(prodData.getProdName() + " " + status);
        }
        if (targets.isEmpty()) {
            return "No SAS components are available on this tier that can be TLS configured for internal SAS connections.";
        }
        return targets.stream().map(t -> "<tr><td>" + t + "</td></tr>").collect(Collectors.joining());
    }

    private boolean hasMetadata() {
        ConfigStatus.StatusEntry[] statusEntries = Globals.g_configStatus.getStatusEntries();
        for (int i = 0; i < statusEntries.length; ++i) {
            String code = statusEntries[i].getCode();
            if (!code.equalsIgnoreCase("metadatasrv")) continue;
            return true;
        }
        return false;
    }
}

