/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.metadata.remote.TextStore;
import com.sas.ssn.ConfigStatus;
import com.sas.ssn.ConsoleMode;
import com.sas.ssn.DynamicDialogs;
import com.sas.ssn.Globals;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class PanelTLSExternalConnection
implements WizardPanelIface,
ActionListener {
    private SSNResource bundle = new SSNResource(PanelTLSExternalConnection.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTable m_componentTable = null;
    private ComponentTableModel m_componentTableModel = null;
    private JTextArea m_optionalLabel = null;
    private ActionListener m_installColumnActionListener = null;
    private JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    private JButton m_selectAllButton = null;
    private JButton m_clearAllButton = null;
    private JScrollPane m_tablePane = null;
    private boolean m_panelLoaded = false;

    public PanelTLSExternalConnection() {
        this.m_componentTableModel = new ComponentTableModel();
        Globals.g_externalTLSProps = new Properties();
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelTLSExternalConnection.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelTLSExternalConnection.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        DynamicDialogs.loadSDMConfigDialogs();
        return true;
    }

    @Override
    public boolean displayPanel() {
        return false;
    }

    @Override
    public String getNextPanelID() {
        if (Globals.g_internalTLSProps.size() == 0 && Globals.g_externalTLSProps.size() == 0) {
            return "finish";
        }
        if (Globals.g_dynamicConfigDialogs != null && Globals.g_dynamicConfigDialogs.length > 0) {
            return Globals.g_dynamicConfigDialogs[0];
        }
        return "execute";
    }

    @Override
    public String getHelpTopic() {
        return "PanelTLSExternalConnection";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        int rowHeight;
        this.m_buttonPanel.setVisible(true);
        if (!this.m_panelLoaded) {
            this.m_componentTableModel.load();
            this.loadResponseData();
            this.m_panelLoaded = true;
        }
        if ((rowHeight = Utils.getPreferredRowHeight(this.m_componentTable)) > 0) {
            this.m_componentTable.setRowHeight(rowHeight);
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        this.m_componentTableModel.load();
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#EXTERNAL_TLS_SELECTION=<comma delimited products>", " EXTERNAL_TLS_SELECTION="};
        if (this.m_panelLoaded) {
            ArrayList<String> componentIds = this.m_componentTableModel.getComponentIds();
            String response = "";
            for (int i = 0; i < componentIds.size(); ++i) {
                String id = componentIds.get(i);
                ComponentData componentData = this.m_componentTableModel.getComponents().get(id);
                if (componentData == null || !componentData.doInstall()) continue;
                if (response.length() > 0) {
                    response = response + ",";
                }
                response = response + componentData.getProdName();
            }
            data[1] = " EXTERNAL_TLS_SELECTION=" + response;
        }
        return data;
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("EXTERNAL_TLS_SELECTION", null);
        if (response != null) {
            String[] componentCodes = response.split(",");
            for (int i = 0; i < componentCodes.length; ++i) {
                ComponentData componentData = this.m_componentTableModel.getComponents().get(componentCodes[i]);
                if (componentData == null) continue;
                valid = true;
                componentData.setInstall(true);
            }
        }
        if (Globals.g_quietMode && !valid) {
            Wizard.logResponseMissing(this.getHeader(), "EXTERNAL_TLS_SELECTION");
        }
        return valid;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        ArrayList<String> componentIds = this.m_componentTableModel.getComponentIds();
        HashMap<String, ComponentData> m_components = this.m_componentTableModel.getComponents();
        ConsoleMode.SelectionItem[] options = new ConsoleMode.SelectionItem[componentIds.size()];
        ComponentData data = null;
        String id = null;
        for (int i = 0; i < options.length; ++i) {
            id = componentIds.get(i);
            data = this.m_componentTableModel.getComponents().get(id);
            options[i] = new ConsoleMode.SelectionItem(data.getProdName(), data.doInstall(), false);
        }
        int returnCode = ConsoleMode.promptMultiChoice(options, null);
        if (returnCode > -1) {
            for (int i = 0; i < options.length; ++i) {
                id = componentIds.get(i);
                data = m_components.get(id);
                data.setInstall(options[i].getSelected());
            }
        }
        return returnCode;
    }

    private void initialize() {
        this.m_optionalLabel = new JTextArea(this.bundle.getString("PanelTLSExternalConnection.ExternalPreviewLabel.txt"));
        this.m_optionalLabel.setEditable(false);
        this.m_optionalLabel.setFocusable(false);
        this.m_optionalLabel.setLineWrap(false);
        this.m_optionalLabel.setOpaque(false);
        this.m_componentTable = new JTable(this.m_componentTableModel);
        this.m_componentTable.setCellSelectionEnabled(true);
        this.m_componentTable.setSelectionMode(0);
        this.m_componentTable.getTableHeader().setUI(null);
        this.m_tablePane = new JScrollPane(this.m_componentTable);
        this.m_tablePane.setPreferredSize(new Dimension(450, 350));
        String mtxt = this.bundle.getString("Common.SelectAll.txt");
        this.m_selectAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_selectAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_selectAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        mtxt = this.bundle.getString("Common.ClearAll.txt");
        this.m_clearAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_clearAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_clearAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_installColumnActionListener = new InstallColumnActionListener();
        this.m_selectAllButton.addActionListener(this.m_installColumnActionListener);
        this.m_clearAllButton.addActionListener(this.m_installColumnActionListener);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.anchor = 16;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_optionalLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_tablePane, c);
        this.initButtonPanel();
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_buttonPanel, c);
    }

    private void initButtonPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 5);
        this.m_buttonPanel.add((Component)this.m_selectAllButton, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_buttonPanel.add((Component)this.m_clearAllButton, c);
        if (this.m_selectAllButton.getPreferredSize().getWidth() < this.m_clearAllButton.getPreferredSize().getWidth()) {
            this.m_selectAllButton.setPreferredSize(this.m_clearAllButton.getPreferredSize());
        } else if (this.m_clearAllButton.getPreferredSize().getWidth() < this.m_selectAllButton.getPreferredSize().getWidth()) {
            this.m_clearAllButton.setPreferredSize(this.m_selectAllButton.getPreferredSize());
        }
    }

    private void installRenderers() {
        this.m_componentTable.getColumnModel().getColumn(0).setCellRenderer(new ComponentDataCellRenderer());
        this.m_componentTable.getColumnModel().getColumn(0).setCellEditor(new ComponentDataCellEditor(new JCheckBox()));
        this.m_componentTable.getTableHeader().setResizingAllowed(false);
        this.m_componentTable.getTableHeader().setReorderingAllowed(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private class ComponentTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 8283934554498211136L;
        public static final int COMPONENT_NAME_COLUMN = 0;
        protected String[] m_columnNames;
        protected HashMap<String, ComponentData> m_components = new HashMap();
        protected ArrayList<String> m_componentIds = new ArrayList();

        public ComponentTableModel() {
            this.m_columnNames = new String[]{""};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        @Override
        public int getRowCount() {
            return this.m_components.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            String id = this.m_componentIds.get(rowIndex);
            if (id != null) {
                ComponentData component = this.m_components.get(id);
                if (colIndex == 0) {
                    return component.doInstall();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            boolean editable = false;
            String id = this.m_componentIds.get(rowIndex);
            if (id != null) {
                ComponentData component = this.m_components.get(id);
                if (colIndex == 0) {
                    editable = component.isInstallable();
                }
            }
            return editable;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int colIndex) {
            String id = this.m_componentIds.get(rowIndex);
            if (id != null && value instanceof Boolean && colIndex == 0) {
                ComponentData component = this.m_components.get(id);
                component.setInstall((Boolean)value);
                this.fireTableCellUpdated(rowIndex, colIndex);
            }
        }

        public void load() {
            this.m_components.clear();
            this.m_componentIds.clear();
            ConfigStatus.StatusEntry[] statusEntries = Globals.g_configStatus.getStatusEntries();
            for (int i = 0; i < statusEntries.length; ++i) {
                String prodCode = statusEntries[i].getCode();
                String targetProp = Globals.g_configDefaults.getDefault(prodCode + ".changeTLSext.target.is_called", "");
                if (targetProp.isEmpty()) continue;
                boolean installed = PanelTLSExternalConnection.this.m_panelLoaded ? this.getPropertyValue(prodCode) : this.isExternalStateEnabled(prodCode);
                ComponentData data = new ComponentData(statusEntries[i]);
                data.setInstall(installed);
                data.setInstallable(true);
                data.setProdName(prodCode);
                this.m_componentIds.add(prodCode);
                this.m_components.put(prodCode, data);
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelTLSExternalConnection.this.installRenderers();
            PanelTLSExternalConnection.this.m_selectAllButton.setEnabled(this.m_components.size() > 0);
            PanelTLSExternalConnection.this.m_clearAllButton.setEnabled(this.m_components.size() > 0);
            PanelTLSExternalConnection.this.m_panelLoaded = true;
        }

        public void selectAllInstall(boolean value) {
            String id = null;
            ComponentData data = null;
            for (int i = 0; i < this.m_componentIds.size(); ++i) {
                id = this.m_componentIds.get(i);
                data = this.m_components.get(id);
                if (data == null || !data.isInstallable()) continue;
                data.setInstall(value);
            }
            this.fireTableDataChanged();
        }

        public ArrayList<String> getComponentIds() {
            return this.m_componentIds;
        }

        public HashMap<String, ComponentData> getComponents() {
            return this.m_components;
        }

        private boolean isExternalStateEnabled(String prodCode) {
            String query = "<XMLSelect search=\"TextStore[@Name='Public Configuration Properties'][Objects/SoftwareComponent[@ClassIdentifier='globalroot']]\" />";
            List components = MetadataAccess.getMetadataObjects(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, "TextStore", query);
            if (!components.isEmpty()) {
                String value = prodCode + ".tls.ext.state";
                String property = MetadataAccess.getTextStoreProperty((TextStore)components.get(0), value);
                if (property != null) {
                    return property.equalsIgnoreCase("ON");
                }
            }
            return false;
        }

        private boolean getPropertyValue(String prodCode) {
            String key = prodCode + ".changeTLSext";
            if (Globals.g_externalTLSProps != null && Globals.g_externalTLSProps.containsKey(key)) {
                String value = Globals.g_externalTLSProps.getProperty(key);
                return Boolean.parseBoolean(value);
            }
            return false;
        }
    }

    private class ComponentData {
        private ConfigStatus.StatusEntry m_statusEntry;
        private boolean m_installable = false;
        private boolean m_install = false;
        private boolean m_modified = false;
        private Boolean m_initial = null;
        private String m_prodName = null;

        public ComponentData(ConfigStatus.StatusEntry statusEntry) {
            this.m_statusEntry = statusEntry;
        }

        public boolean isInstallable() {
            return this.m_installable;
        }

        public void setInstallable(boolean installable) {
            this.m_installable = installable;
        }

        public boolean doInstall() {
            return this.m_install;
        }

        public void setInstall(boolean install) {
            String value;
            if (this.m_initial == null) {
                this.m_initial = install;
            }
            this.m_modified = this.m_initial != install;
            String key = this.m_prodName + ".changeTLSext";
            String string = value = install ? "ON" : "OFF";
            if (this.m_modified) {
                Globals.g_externalTLSProps.setProperty(key, value);
                Globals.g_configData.getProperties().setProperty(key.toLowerCase(), value);
            } else {
                Globals.g_externalTLSProps.remove(key);
                Globals.g_configData.getProperties().remove(key.toLowerCase());
            }
            this.m_install = install;
        }

        public String getProdName() {
            if (this.m_prodName != null && this.m_prodName.length() > 0) {
                return this.m_prodName;
            }
            return this.m_statusEntry.getCode();
        }

        public void setProdName(String prodNameExtended) {
            this.m_prodName = prodNameExtended;
        }
    }

    private class InstallColumnActionListener
    implements ActionListener {
        private InstallColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelTLSExternalConnection.this.m_selectAllButton) {
                PanelTLSExternalConnection.this.m_componentTableModel.selectAllInstall(true);
            } else if (e.getSource() == PanelTLSExternalConnection.this.m_clearAllButton) {
                PanelTLSExternalConnection.this.m_componentTableModel.selectAllInstall(false);
            }
        }
    }

    private class ComponentDataCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -2422980246659985705L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setSelected(false);
                this.setEnabled(false);
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = PanelTLSExternalConnection.this.m_componentTableModel.getComponentIds().get(row);
                    ComponentData data = PanelTLSExternalConnection.this.m_componentTableModel.getComponents().get(id);
                    this.setText(data.getProdName());
                    this.setSelected(data.doInstall());
                    this.setEnabled(data.isInstallable());
                }
            }
            return this;
        }
    }

    private class ComponentDataCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -1039755031254835968L;
        private JCheckBox m_checkBox;

        public ComponentDataCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = checkBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_checkBox.setText("");
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setEnabled(false);
            } else {
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = PanelTLSExternalConnection.this.m_componentTableModel.getComponentIds().get(row);
                    ComponentData data = PanelTLSExternalConnection.this.m_componentTableModel.getComponents().get(id);
                    this.m_checkBox.setText(data.getProdName());
                    this.m_checkBox.setSelected(data.doInstall());
                    this.m_checkBox.setEnabled(data.isInstallable());
                }
            }
            return this.m_checkBox;
        }
    }
}

