/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.Globals;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PanelSystemRequisitesRequired
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelSystemRequisitesRequired.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTextArea m_requiredLabel = null;
    private JEditorPane m_requiredPane = null;
    private JScrollPane m_scrollPane = null;
    private HashMap<String, ?> m_responseSRWs = null;

    public PanelSystemRequisitesRequired() {
        this.initialize();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSystemRequisitesRequired.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSystemRequisitesRequired.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        this.populate();
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        return "systemrequisitesoptional";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        String sysReq = "";
        this.m_requiredPane.setText("");
        this.populate();
        Collections.sort(Globals.g_requiredSRWs, new Comparator<ProductData>(){

            @Override
            public int compare(ProductData pd1, ProductData pd2) {
                Pattern pattern = Pattern.compile("(\\d+(\\.\\d+)?|\\D+)");
                Matcher matcher1 = pattern.matcher(pd1.getProdName());
                Matcher matcher2 = pattern.matcher(pd2.getProdName());
                int result = 0;
                while (result == 0) {
                    boolean found1 = matcher1.find();
                    boolean found2 = matcher2.find();
                    if (!found1 && !found2) {
                        return pd1.getProdName().compareTo(pd2.getProdName());
                    }
                    if (!found1) {
                        result = -1;
                        continue;
                    }
                    if (!found2) {
                        result = 1;
                        continue;
                    }
                    String segment1 = matcher1.group();
                    String segment2 = matcher2.group();
                    if (Character.isDigit(segment1.toCharArray()[0])) {
                        result = new Double(segment1).compareTo(new Double(segment2));
                        continue;
                    }
                    result = segment1.compareToIgnoreCase(segment2);
                }
                return result;
            }
        });
        for (ProductData productData : Globals.g_requiredSRWs) {
            sysReq = sysReq + "<tr><td>" + productData.getProdName() + "</tr></td>";
        }
        if (Globals.g_requiredSRWs.isEmpty()) {
            sysReq = "No system requisites are required for the products selected.";
        }
        this.m_requiredPane.setText("<html><table cellspacing=0 cellpadding=0 style=\"border-collapse: collapse;\">" + sysReq + "</table></html>");
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        this.populate();
        return true;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        return 0;
    }

    private void populate() {
        ProductData[] fullProductList = Globals.g_deploymentData.getProdsForPlat(Globals.g_order, Utils.getOS_Suffix(), false);
        Globals.g_requiredSRWs = new ArrayList();
        Globals.g_optionalSRWs = new ArrayList();
        block0: for (int i = 0; i < fullProductList.length; ++i) {
            if (this.m_responseSRWs != null && this.m_responseSRWs.containsKey(fullProductList[i].getProdCode().toLowerCase(Locale.ENGLISH))) {
                Globals.g_requiredSRWs.add(fullProductList[i]);
                fullProductList[i].setRequired(true);
            }
            if (!Globals.g_deploymentData.getSpsSku(fullProductList[i].getSpsSku()).isSysReq() || this.m_responseSRWs != null) continue;
            for (int j = 0; j < Globals.g_selectedInstalls.length; ++j) {
                if (Globals.g_deploymentData.getFullSkuRequirements(Utils.getOS_Suffix(), Globals.g_selectedInstalls[j].getSpsSku(), null, "triggers_install").contains(fullProductList[i].getSpsSku())) {
                    fullProductList[i].setRequired(true);
                    Globals.g_requiredSRWs.add(fullProductList[i]);
                    Globals.g_optionalSRWs.remove(fullProductList[i]);
                    continue block0;
                }
                fullProductList[i].setRequired(false);
                Globals.g_requiredSRWs.remove(fullProductList[i]);
                if (Globals.g_optionalSRWs.contains(fullProductList[i])) continue;
                Globals.g_optionalSRWs.add(fullProductList[i]);
            }
        }
        this.requireLatestDotnet();
        this.requireLatestVcredist();
    }

    private void requireLatestDotnet() {
        final ProductData dotnet46 = Globals.g_deploymentData.getProduct(Globals.g_order, "dotnet46", false);
        final ProductData dotnet461 = Globals.g_deploymentData.getProduct(Globals.g_order, "dotnet461", false);
        final ProductData dotnet471 = Globals.g_deploymentData.getProduct(Globals.g_order, "dotnet471", false);
        final ProductData dotnet48 = Globals.g_deploymentData.getProduct(Globals.g_order, "dotnet48", false);
        ArrayList<ProductData> dotnets = new ArrayList<ProductData>(){
            {
                this.add(dotnet48);
                this.add(dotnet471);
                this.add(dotnet461);
                this.add(dotnet46);
            }
        };
        for (int j = 0; j < dotnets.size() - 1; ++j) {
            if (dotnets.get(j) == null || !Globals.g_requiredSRWs.contains(dotnets.get(j))) continue;
            for (int k = j + 1; k < dotnets.size(); ++k) {
                if (dotnets.get(k) == null || !Globals.g_requiredSRWs.contains(dotnets.get(k))) continue;
                Globals.g_requiredSRWs.remove(dotnets.get(k));
                if (Globals.g_optionalSRWs.contains(dotnets.get(k))) continue;
                ((ProductData)dotnets.get(k)).setRequired(false);
                Globals.g_optionalSRWs.add((ProductData)dotnets.get(k));
            }
        }
    }

    private void requireLatestVcredist() {
        final ProductData vcredist2015 = Globals.g_deploymentData.getProduct(Globals.g_order, "vcredist2015", false);
        final ProductData vcredist2017 = Globals.g_deploymentData.getProduct(Globals.g_order, "vcredist2017", false);
        final ProductData vcredist2019 = Globals.g_deploymentData.getProduct(Globals.g_order, "vcredist2019", false);
        ArrayList<ProductData> vcredists = new ArrayList<ProductData>(){
            {
                this.add(vcredist2019);
                this.add(vcredist2017);
                this.add(vcredist2015);
            }
        };
        for (int j = 0; j < vcredists.size() - 1; ++j) {
            if (vcredists.get(j) == null || !Globals.g_requiredSRWs.contains(vcredists.get(j))) continue;
            for (int k = j + 1; k < vcredists.size(); ++k) {
                if (vcredists.get(k) == null || !Globals.g_requiredSRWs.contains(vcredists.get(k))) continue;
                Globals.g_requiredSRWs.remove(vcredists.get(k));
                if (Globals.g_optionalSRWs.contains(vcredists.get(k))) continue;
                ((ProductData)vcredists.get(k)).setRequired(false);
                Globals.g_optionalSRWs.add((ProductData)vcredists.get(k));
            }
        }
    }

    private void initialize() {
        this.m_requiredLabel = new JTextArea(this.bundle.getString("PanelSystemRequisitesRequired.RequisitesPreviewLabel.txt"));
        this.m_requiredLabel.setEditable(false);
        this.m_requiredLabel.setFocusable(false);
        this.m_requiredLabel.setLineWrap(false);
        this.m_requiredLabel.setOpaque(false);
        this.m_requiredPane = new JEditorPane();
        this.m_requiredPane.setOpaque(false);
        this.m_requiredPane.setEditable(false);
        this.m_requiredPane.setContentType("text/html");
        this.m_requiredPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        GridBagConstraints c = new GridBagConstraints();
        this.m_scrollPane = new JScrollPane(this.m_requiredPane);
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.anchor = 16;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_requiredLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 2;
        c.anchor = 18;
        c.fill = 1;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)this.m_scrollPane, c);
    }

    @Override
    public String getHelpTopic() {
        return "PanelSystemRequisitesRequired";
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void focusGained(FocusEvent e) {
        Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
    }

    public void focusLost(FocusEvent e) {
        Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
    }
}

