/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelSystemRequisitesRequired;
import com.sas.ssn.ProductData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class PanelSystemRequisitesOptional
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelSystemRequisitesRequired.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTable m_componentTable = null;
    private ComponentTableModel m_componentTableModel = null;
    private ProductData[] m_productData = null;
    private JTextArea m_optionalLabel = null;
    private ActionListener m_installColumnActionListener = null;
    private JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    private JButton m_selectAllButton = null;
    private JButton m_clearAllButton = null;
    private boolean m_panelLoaded = false;
    private ArrayList<ProductData> installComponents = null;
    private HashMap<String, ?> m_responseSRWs = null;

    public PanelSystemRequisitesOptional() {
        this.m_componentTableModel = new ComponentTableModel();
        this.initialize();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSystemRequisitesOptional.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSystemRequisitesOptional.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        ArrayList componentIds = this.m_componentTableModel.getComponentIds();
        HashMap components = this.m_componentTableModel.getComponents();
        this.installComponents = new ArrayList();
        for (int i = 0; i < componentIds.size(); ++i) {
            String id = (String)componentIds.get(i);
            ComponentData data = (ComponentData)components.get(id);
            if (!data.doInstall()) continue;
            this.installComponents.add(data.getProductData());
        }
        for (ProductData requiredSRW : Globals.g_requiredSRWs) {
            this.installComponents.add(requiredSRW);
        }
        Globals.g_selectedSRWs = this.installComponents.toArray(new ProductData[0]);
        if (Globals.g_selectedSRWs.length == 0) {
            if (Globals.g_quietMode) {
                Logging.log.severe("No system requisites are selected for installation. You must select at least one system requisite.");
            } else {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSystemRequisitesOptional.NoInstallError.txt"), this.bundle.getString("Common.Warning.txt"), 2);
                this.m_componentTable.requestFocus();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        if (Globals.g_optionalSRWs.size() > 0 && (this.containsNonDotnetProducts() || this.containsNonVcredistProducts())) {
            return true;
        }
        Globals.g_selectedSRWs = Globals.g_requiredSRWs.toArray(new ProductData[0]);
        return false;
    }

    private boolean containsNonDotnetProducts() {
        boolean has471 = false;
        boolean has461 = false;
        boolean has46 = false;
        for (ProductData productData : Globals.g_optionalSRWs) {
            if (productData.getProdCode().equals("dotnet471")) {
                has471 = true;
                continue;
            }
            if (productData.getProdCode().equals("dotnet461")) {
                has461 = true;
                continue;
            }
            if (productData.getProdCode().equals("dotnet46")) {
                has46 = true;
                continue;
            }
            if (productData.getProdCode().equals("vcredist2015") || productData.getProdCode().equals("vcredist2017")) continue;
            return true;
        }
        return has461 && has46 && has471;
    }

    private boolean containsNonVcredistProducts() {
        boolean has2017 = false;
        boolean has2015 = false;
        for (ProductData productData : Globals.g_optionalSRWs) {
            if (productData.getProdCode().equals("vcredist2017")) {
                has2017 = true;
                continue;
            }
            if (productData.getProdCode().equals("vcredist2015")) {
                has2015 = true;
                continue;
            }
            if (productData.getProdCode().equals("dotnet461") || productData.getProdCode().equals("dotnet46") || productData.getProdCode().equals("dotnet471")) continue;
            return true;
        }
        return has2017 && has2015;
    }

    @Override
    public String getNextPanelID() {
        return "systemcheck";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            this.loadResponseData();
        }
        this.m_buttonPanel.setVisible(true);
        this.populate();
        int rowHeight = Utils.getPreferredRowHeight(this.m_componentTable);
        if (rowHeight > 0) {
            this.m_componentTable.setRowHeight(rowHeight);
        }
        this.m_panelLoaded = true;
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            this.populate();
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        ArrayList<String> data = new ArrayList<String>();
        if (Globals.g_quietMode && Globals.g_recordMode) {
            data.add(" SRW_OPTIONAL_SELECTION1=");
        } else {
            ArrayList componentIds = this.m_componentTableModel.getComponentIds();
            HashMap components = this.m_componentTableModel.getComponents();
            int index = 1;
            for (int i = 0; i < componentIds.size(); ++i) {
                String id = (String)componentIds.get(i);
                ComponentData cData = (ComponentData)components.get(id);
                if (!cData.doInstall()) continue;
                data.add(" SRW_OPTIONAL_SELECTION" + Integer.toString(index++) + "=" + cData.getIdentifier());
            }
        }
        return data.toArray(new String[0]);
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
        if (this.installComponents != null) {
            for (ProductData requiredSRW : Globals.g_requiredSRWs) {
                this.installComponents.remove(requiredSRW);
            }
        }
    }

    @Override
    public int consoleEvent() {
        return 0;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        if (valid) {
            this.m_responseSRWs = null;
            boolean found = true;
            int productCount = 1;
            String responseProduct = null;
            while (found) {
                responseProduct = Wizard.getResponse("SRW_OPTIONAL_SELECTION" + Integer.toString(productCount), null);
                if (responseProduct != null) {
                    if (productCount == 1) {
                        this.m_responseSRWs = new HashMap();
                    }
                    this.m_responseSRWs.put(responseProduct.toLowerCase(Locale.ENGLISH), null);
                } else {
                    found = false;
                }
                ++productCount;
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_optionalLabel = new JTextArea(this.bundle.getString("PanelSystemRequisitesOptional.RequisitesPreviewLabel.txt"));
        this.m_optionalLabel.setEditable(false);
        this.m_optionalLabel.setFocusable(false);
        this.m_optionalLabel.setLineWrap(false);
        this.m_optionalLabel.setOpaque(false);
        this.m_componentTable = new JTable(this.m_componentTableModel);
        this.m_componentTable.setCellSelectionEnabled(true);
        this.m_componentTable.setSelectionMode(0);
        JScrollPane tablePane = new JScrollPane(this.m_componentTable);
        tablePane.setPreferredSize(new Dimension(450, 350));
        String mtxt = this.bundle.getString("Common.SelectAll.txt");
        this.m_selectAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_selectAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_selectAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        mtxt = this.bundle.getString("Common.ClearAll.txt");
        this.m_clearAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_clearAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_clearAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_installColumnActionListener = new InstallColumnActionListener();
        this.m_selectAllButton.addActionListener(this.m_installColumnActionListener);
        this.m_clearAllButton.addActionListener(this.m_installColumnActionListener);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridwidth = 2;
        c.anchor = 16;
        c.fill = 2;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_panel.add((Component)this.m_optionalLabel, c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)tablePane, c);
        this.initButtonPanel();
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_buttonPanel, c);
    }

    private void initButtonPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 5);
        this.m_buttonPanel.add((Component)this.m_selectAllButton, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_buttonPanel.add((Component)this.m_clearAllButton, c);
        if (this.m_selectAllButton.getPreferredSize().getWidth() < this.m_clearAllButton.getPreferredSize().getWidth()) {
            this.m_selectAllButton.setPreferredSize(this.m_clearAllButton.getPreferredSize());
        } else if (this.m_clearAllButton.getPreferredSize().getWidth() < this.m_selectAllButton.getPreferredSize().getWidth()) {
            this.m_clearAllButton.setPreferredSize(this.m_selectAllButton.getPreferredSize());
        }
    }

    private void installRenderers() {
        this.m_componentTable.getColumnModel().getColumn(0).setCellRenderer(new ComponentDataCellRenderer());
        this.m_componentTable.getColumnModel().getColumn(0).setCellEditor(new ComponentDataCellEditor(new JCheckBox()));
        this.m_componentTable.getTableHeader().setResizingAllowed(false);
        this.m_componentTable.getTableHeader().setReorderingAllowed(false);
    }

    @Override
    public String getHelpTopic() {
        return "PanelSystemRequisitesOptional";
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void focusGained(FocusEvent e) {
        Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
    }

    public void focusLost(FocusEvent e) {
        Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
    }

    private void populate() {
        this.m_componentTableModel.load();
    }

    static /* synthetic */ ProductData[] access$102(PanelSystemRequisitesOptional x0, ProductData[] x1) {
        x0.m_productData = x1;
        return x1;
    }

    class ComponentTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 8283934554498211136L;
        public static final int COMPONENT_NAME_COLUMN = 0;
        protected String[] m_columnNames;
        protected HashMap m_components = new HashMap();
        protected ArrayList m_componentIds = new ArrayList();

        public ComponentTableModel() {
            this.m_columnNames = new String[]{PanelSystemRequisitesOptional.this.bundle.getString("PanelSystemRequisitesOptional.ComponentTable.NameColumn.Title.txt")};
        }

        @Override
        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.m_columnNames[index];
        }

        public Class getColumnClass(int index) {
            if (index == 0) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.m_components.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            String id = (String)this.m_componentIds.get(rowIndex);
            if (id != null) {
                ComponentData component = (ComponentData)this.m_components.get(id);
                if (colIndex == 0) {
                    return component.doInstall();
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            boolean editable = false;
            String id = (String)this.m_componentIds.get(rowIndex);
            if (id != null) {
                ComponentData component = (ComponentData)this.m_components.get(id);
                if (colIndex == 0) {
                    editable = component.isInstallable();
                }
            }
            return editable;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int colIndex) {
            String id = (String)this.m_componentIds.get(rowIndex);
            if (id != null && value instanceof Boolean && colIndex == 0) {
                ComponentData component = (ComponentData)this.m_components.get(id);
                component.setInstall((Boolean)value);
                this.fireTableCellUpdated(rowIndex, colIndex);
            }
        }

        public void load() {
            this.m_components.clear();
            this.m_componentIds.clear();
            ProductData[] fullProductList = Globals.g_deploymentData.getProdsForPlat(Globals.g_order, Utils.getOS_Suffix(), false);
            ArrayList<String> newOptionalList = new ArrayList<String>();
            for (int i = 0; i < fullProductList.length; ++i) {
                if (!Globals.g_deploymentData.getSpsSku(fullProductList[i].getSpsSku()).isSysReq() || fullProductList[i].isRequired()) continue;
                newOptionalList.add(fullProductList[i].getProdCode());
            }
            Collections.sort(newOptionalList, new Comparator<String>(){

                @Override
                public int compare(String pd1, String pd2) {
                    Pattern pattern = Pattern.compile("(\\d+(\\.\\d+)?|\\D+)");
                    String string1 = Globals.g_deploymentData.getProduct(Globals.g_order, pd1, false).getProdName();
                    String string2 = Globals.g_deploymentData.getProduct(Globals.g_order, pd2, false).getProdName();
                    Matcher matcher1 = pattern.matcher(string1);
                    Matcher matcher2 = pattern.matcher(string2);
                    int result = 0;
                    while (result == 0) {
                        boolean found1 = matcher1.find();
                        boolean found2 = matcher2.find();
                        if (!found1 && !found2) {
                            return string1.compareTo(string2);
                        }
                        if (!found1) {
                            result = -1;
                            continue;
                        }
                        if (!found2) {
                            result = 1;
                            continue;
                        }
                        String segment1 = matcher1.group();
                        String segment2 = matcher2.group();
                        if (Character.isDigit(segment1.toCharArray()[0])) {
                            result = new Double(segment1).compareTo(new Double(segment2));
                            continue;
                        }
                        result = segment1.compareToIgnoreCase(segment2);
                    }
                    return result;
                }
            });
            PanelSystemRequisitesOptional.access$102(PanelSystemRequisitesOptional.this, Globals.g_deploymentData.getProducts(Globals.g_order, newOptionalList.toArray(new String[0]), false));
            String prodCode = null;
            String prodName = null;
            ComponentData data = null;
            for (int i = 0; i < PanelSystemRequisitesOptional.this.m_productData.length; ++i) {
                prodCode = PanelSystemRequisitesOptional.this.m_productData[i].getProdCode();
                prodName = PanelSystemRequisitesOptional.this.m_productData[i].getProdName();
                data = new ComponentData(PanelSystemRequisitesOptional.this.m_productData[i]);
                this.m_componentIds.add(prodCode);
                if (PanelSystemRequisitesOptional.this.m_responseSRWs != null && !PanelSystemRequisitesOptional.this.m_panelLoaded) {
                    if (PanelSystemRequisitesOptional.this.m_responseSRWs.containsKey(prodCode.toLowerCase(Locale.ENGLISH))) {
                        data.setInstall(true);
                        data.setInstallable(true);
                    } else {
                        data.setInstall(false);
                        data.setInstallable(true);
                    }
                } else {
                    data.setInstall(this.hasSelected(PanelSystemRequisitesOptional.this.m_productData[i]));
                    data.setInstallable(true);
                }
                data.setExtendedProdName(prodName);
                this.m_components.put(prodCode, data);
            }
            boolean previousDotnet = false;
            ArrayList<String> dotnets = new ArrayList<String>(){
                {
                    this.add("dotnet48");
                    this.add("dotnet471");
                    this.add("dotnet461");
                    this.add("dotnet46");
                }
            };
            for (int j = 0; j < dotnets.size(); ++j) {
                ProductData product = Globals.g_deploymentData.getProduct(Globals.g_order, (String)dotnets.get(j), false);
                if (!previousDotnet && this.m_components.containsKey(dotnets.get(j)) || Globals.g_requiredSRWs.contains(product)) {
                    previousDotnet = true;
                    continue;
                }
                if (!this.m_components.containsKey(dotnets.get(j))) continue;
                ((ComponentData)this.m_components.get(dotnets.get(j))).setInstall(false);
                ((ComponentData)this.m_components.get(dotnets.get(j))).setInstallable(false);
            }
            boolean previousVcredist = false;
            ArrayList<String> vcredists = new ArrayList<String>(){
                {
                    this.add("vcredist2019");
                    this.add("vcredist2017");
                    this.add("vcredist2015");
                }
            };
            for (int j = 0; j < vcredists.size(); ++j) {
                ProductData product = Globals.g_deploymentData.getProduct(Globals.g_order, (String)vcredists.get(j), false);
                if (!previousVcredist && this.m_components.containsKey(vcredists.get(j)) || Globals.g_requiredSRWs.contains(product)) {
                    previousVcredist = true;
                    continue;
                }
                if (!this.m_components.containsKey(vcredists.get(j))) continue;
                ((ComponentData)this.m_components.get(vcredists.get(j))).setInstall(false);
                ((ComponentData)this.m_components.get(vcredists.get(j))).setInstallable(false);
            }
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelSystemRequisitesOptional.this.installRenderers();
            PanelSystemRequisitesOptional.this.m_selectAllButton.setEnabled(this.m_components.size() > 0);
            PanelSystemRequisitesOptional.this.m_clearAllButton.setEnabled(this.m_components.size() > 0);
        }

        boolean hasSelected(ProductData productData) {
            if (PanelSystemRequisitesOptional.this.installComponents != null) {
                return PanelSystemRequisitesOptional.this.installComponents.contains(productData);
            }
            return false;
        }

        public void selectAllInstall(boolean value) {
            String id = null;
            ComponentData data = null;
            for (int i = 0; i < this.m_componentIds.size(); ++i) {
                id = (String)this.m_componentIds.get(i);
                data = (ComponentData)this.m_components.get(id);
                if (data == null || !data.isInstallable()) continue;
                data.setInstall(value);
            }
            this.fireTableDataChanged();
        }

        public void clear() {
            this.m_components.clear();
            this.m_componentIds.clear();
            this.fireTableDataChanged();
        }

        public ArrayList getComponentIds() {
            return this.m_componentIds;
        }

        public HashMap getComponents() {
            return this.m_components;
        }
    }

    class ComponentData {
        protected ProductData m_productData;
        protected boolean m_installable = false;
        protected boolean m_install = false;
        protected String m_prodNameExtended = null;

        public ComponentData(ProductData productData) {
            this.m_productData = productData;
        }

        public ProductData getProductData() {
            return this.m_productData;
        }

        public String getIdentifier() {
            return this.m_productData.getProdCode();
        }

        public String getName() {
            return this.m_productData.getProdName();
        }

        public boolean isInstallable() {
            return this.m_installable;
        }

        public void setInstallable(boolean installable) {
            this.m_installable = installable;
        }

        public boolean doInstall() {
            return this.m_install;
        }

        public void setInstall(boolean install) {
            this.m_install = install;
        }

        public String getExtendedProdName() {
            if (this.m_prodNameExtended != null && this.m_prodNameExtended.length() > 0) {
                return this.m_prodNameExtended;
            }
            return this.m_productData.getProdName();
        }

        public void setExtendedProdName(String prodNameExtended) {
            this.m_prodNameExtended = prodNameExtended;
        }
    }

    class InstallColumnActionListener
    implements ActionListener {
        InstallColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelSystemRequisitesOptional.this.m_selectAllButton) {
                PanelSystemRequisitesOptional.this.m_componentTableModel.selectAllInstall(true);
            } else if (e.getSource() == PanelSystemRequisitesOptional.this.m_clearAllButton) {
                PanelSystemRequisitesOptional.this.m_componentTableModel.selectAllInstall(false);
            }
        }
    }

    private class ComponentDataCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -2422980246659985705L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setSelected(false);
                this.setEnabled(false);
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelSystemRequisitesOptional.this.m_componentTableModel.getComponentIds().get(row);
                    ComponentData data = (ComponentData)PanelSystemRequisitesOptional.this.m_componentTableModel.getComponents().get(id);
                    this.setText(data.getExtendedProdName());
                    this.setSelected(data.doInstall());
                    this.setEnabled(data.isInstallable());
                }
            }
            return this;
        }
    }

    private class ComponentDataCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -1039755031254835968L;
        private JCheckBox m_checkBox;

        public ComponentDataCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = checkBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_checkBox.setText("");
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setEnabled(false);
            } else {
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = (String)PanelSystemRequisitesOptional.this.m_componentTableModel.getComponentIds().get(row);
                    ComponentData data = (ComponentData)PanelSystemRequisitesOptional.this.m_componentTableModel.getComponents().get(id);
                    this.m_checkBox.setText(data.getExtendedProdName());
                    this.m_checkBox.setSelected(data.doInstall());
                    this.m_checkBox.setEnabled(data.isInstallable());
                }
            }
            return this.m_checkBox;
        }
    }
}

