/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.HotFix;
import com.sas.ssn.InstallToolConnector;
import com.sas.ssn.Language;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelConfigMaint;
import com.sas.ssn.PanelExecute;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.SpsSkuData;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import com.sas.tools.deployjni.disk.DiskInfoAPI;
import com.sas.tools.installs.it.Controller;
import com.sas.tools.installs.it.NotificationHandler;
import com.sas.tools.installs.it.PreExecuteRunnable;
import com.sas.tools.installs.it.PreExecuteThread;
import com.sas.tools.installs.it.listener.InstallationSetupListener;
import com.sas.tools.installs.it.schema.metadata.EntryData;
import com.sas.tools.installs.it.tasks.TaskHelper;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import jakarta.xml.bind.JAXBException;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class PanelSystemCheck
implements WizardPanelIface,
InstallationSetupListener {
    private SSNResource _bundle = new SSNResource(PanelSystemCheck.class);
    private JPanel _containerPanel = new JPanel(new GridBagLayout());
    private JTextArea _headerText = null;
    private JLabel _verifyingLabel = null;
    private JLabel _calculatingLabel = null;
    private JProgressBar _verifyingProgressBar = null;
    private JProgressBar _calculatingProgressBar = null;
    protected ArrayList<ProductData> _productData = null;
    private JLabel _problemFileReportLabel = null;
    private JLabel _diskSpaceReportLabel = null;
    protected JLabel _freeDiskSpaceReportLabel = null;
    private JLabel _refreshInstructionsLabel = null;
    protected final String diskSpacePrefix;
    protected final String problemFilePrefix;
    protected Long _totalSize = new Long(512000000L);
    protected Long _itTotalSize = new Long(0L);
    protected Vector<EntryData> _problemFiles = null;
    private boolean _recalculationNeeded = true;
    protected int numFilesProcessed = 0;
    protected HashMap<String, Long> checkedInstallSizes = null;
    private JEditorPane _problemFileListArea = new JEditorPane();
    JScrollPane _lockedScroll = new JScrollPane();
    JScrollPane _unwritableScroll = new JScrollPane();
    protected long _freeDiskSpace;
    protected static final int Megabyte = 0x100000;
    protected int _overallFileCount = 0;
    private long INSTALL_LOG_PADDING = 0x200000L;
    private MakeWithTheNext makeWithTheNext = null;
    public Object obj = new Object();
    private InstallInitializationThread m_initThread = null;
    private StringBuffer m_problemFileListText = new StringBuffer();
    private boolean m_cannotProceed = false;
    private boolean m_notEnoughDiskSpace = false;
    protected boolean m_silent = false;
    protected ProductData[] previousSelectedProducts;
    protected boolean isProductSelectionIdentical = false;
    protected boolean uipSpaceAlreadyCalculated = false;
    private Set<String> _checkedFiles = new HashSet<String>();
    private Set<String> _lockCheckedFiles = new HashSet<String>();
    private List<String> unfulfilledRequirements = new ArrayList<String>();
    private static final String VALIDATION_FILE = "Validation file: ";
    protected PanelExecute _panelExecute = null;

    public PanelSystemCheck() {
        this.setCalculatingLabel(new JLabel());
        this.setVerifyingLabel(new JLabel());
        this.setVerifyingProgressBar(new JProgressBar(0, 1));
        this.setCalculatingProgressBar(new JProgressBar(0, 1));
        this.getVerifyingProgressBar().setValue(0);
        this.getCalculatingProgressBar().setValue(0);
        this.getVerifyingProgressBar().setStringPainted(true);
        this.getCalculatingProgressBar().setStringPainted(true);
        this.setProblemFileReportLabel(new JLabel());
        this.setDiskSpaceReportLabel(new JLabel());
        this.setFreeDiskSpaceReportLabel(new JLabel());
        this.setRefreshInstructionsLabel(new JLabel());
        this.diskSpacePrefix = this.getBundle().getString("PanelSystemCheck.DiskSpace");
        this.problemFilePrefix = this.getBundle().getString("PanelSystemCheck.ProblemFiles");
        NotificationHandler.defaultHandler().addSetupListener(this);
        this.getProblemFileListArea().setEditable(false);
        this.getProblemFileListArea().setMinimumSize(new Dimension(500, 550));
        this.getProblemFileListArea().setText("");
        this.getProblemFileListArea().setVisible(false);
        this._lockedScroll.setVisible(false);
        this._unwritableScroll.setVisible(false);
        this.getRefreshInstructionsLabel().setText("<html><p>" + this.getBundle().getString("PanelSystemCheck.RefreshInstructions") + "</p></html>");
        this.getRefreshInstructionsLabel().setVisible(false);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 11;
        c.fill = 2;
        c.insets = new Insets(2, 0, 2, 0);
        this.getContainerPanel().add((Component)this.getCalculatingLabel(), c);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 11;
        c.fill = 2;
        this.getContainerPanel().add((Component)this.getCalculatingProgressBar(), c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 11;
        c.fill = 2;
        this.getContainerPanel().add((Component)this.getVerifyingLabel(), c);
        c.gridx = 0;
        c.gridy = 3;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 11;
        c.fill = 2;
        this.getContainerPanel().add((Component)this.getVerifyingProgressBar(), c);
        c.gridx = 0;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.anchor = 11;
        c.fill = 2;
        this.getContainerPanel().add((Component)this.getDiskSpaceReportLabel(), c);
        c.gridx = 1;
        c.gridy = 4;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 11;
        c.fill = 2;
        this.getContainerPanel().add((Component)this.getFreeDiskSpaceReportLabel(), c);
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.anchor = 11;
        c.fill = 2;
        this.getContainerPanel().add((Component)this.getRefreshInstructionsLabel(), c);
        c.gridx = 0;
        c.gridy = 6;
        c.gridwidth = 2;
        c.weightx = 1.0;
        c.weighty = 0.1;
        c.anchor = 11;
        c.fill = 2;
        this.getContainerPanel().add((Component)this.getProblemFileReportLabel(), c);
        c.gridx = 0;
        c.gridy = 7;
        c.gridwidth = 2;
        c.weightx = 0.0;
        c.weighty = 1.0;
        c.anchor = 11;
        c.fill = 1;
        this._lockedScroll.getViewport().add(this.getProblemFileListArea());
        this._lockedScroll.setPreferredSize(new Dimension(250, 550));
        this.getPanel().add((Component)this._lockedScroll, c);
    }

    @Override
    public void backEvent(String backPanelID) {
        this.previousSelectedProducts = Globals.g_selectedInstalls;
        if (Globals.g_uip) {
            this.uipSpaceAlreadyCalculated = true;
        }
        this.m_initThread.setCancel(true);
        try {
            this.m_initThread.join();
        }
        catch (InterruptedException e) {
            Logging.logStackTrace(e);
        }
        if (Utils.getOS() == 8) {
            InstallToolConnector.resetITMvsextractTask();
        }
        Globals.g_installToolBasedProds.clear();
        InstallToolConnector.clearITController();
        Vector<PreExecuteRunnable> preExecuteRunnables = InstallToolConnector.getConnector().getPreExecuteRunnables();
        preExecuteRunnables.clear();
        this._recalculationNeeded = true;
        String mtxt = this.getBundle().getString("Wizard.Next.txt");
        Globals.g_wizard.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
        Globals.g_wizard.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
        Globals.g_wizard.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Globals.g_wizard.getNextButton().setSize(new JButton(mtxt).getPreferredSize());
        Globals.g_wizard.getNextButton().setEnabled(true);
        Globals.g_wizard.getNextButton().requestFocus();
    }

    @Override
    public boolean displayPanel() {
        return Globals.g_cmtTask == 11 || !Globals.g_recordMode || !Globals.g_recordOnly || Globals.g_srwOnly;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public String getHeader() {
        if (Globals.g_consoleMode) {
            return this.getBundle().getString("PanelSystemCheck.InstallHeader");
        }
        return null;
    }

    @Override
    public String getHeaderDesc() {
        if (Globals.g_consoleMode) {
            return this.getBundle().getString("PanelSystemCheck.InstallHeaderDesc");
        }
        return null;
    }

    @Override
    public String getHelpTopic() {
        return null;
    }

    @Override
    public JPanel getPanel() {
        return this.getContainerPanel();
    }

    @Override
    public JComponent initialFocus() {
        if (Globals.g_wizard == null) {
            return null;
        }
        return Globals.g_wizard.getNextButton();
    }

    public void setupUserProperties() {
        if (Globals.g_installDefaults != null) {
            String name = null;
            String value = null;
            Enumeration e = Globals.g_installDefaults.getNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                if (Globals.g_installKnownProps.containsKey(name)) continue;
                value = Globals.g_installDefaults.getDefault(name, null);
                if (Globals.g_mode == 2) {
                    if (Globals.g_installData.getProperty(name, null) != null || value == null) continue;
                    Globals.g_installData.setProperty(name, value);
                    continue;
                }
                if (value == null) continue;
                Globals.g_installData.setProperty(name, value);
            }
        }
        Controller.setInstallProperties(InstallToolConnector.getProperties());
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.isProductSelectionIdentical = this.previousSelectedProducts == null & Globals.g_selectedInstalls == null & !this.uipSpaceAlreadyCalculated ? false : Arrays.equals(this.previousSelectedProducts, Globals.g_selectedInstalls);
        if (!this._recalculationNeeded) {
            return;
        }
        this.resetState();
        this.setupUserProperties();
        this.layoutWidgets();
        Globals.g_wizard.getHeader().setText(this.getBundle().getString("PanelSystemCheck.InstallHeader"));
        if (Globals.g_cmtTask == 28) {
            Globals.g_wizard.getHeaderDesc().setText(this.getBundle().getString("PanelSystemCheck.UninstallHeaderDesc"));
            this.getRefreshInstructionsLabel().setText("<html><p>" + this.getBundle().getString("PanelSystemCheck.RefreshInstructionsUninst") + "</p></html>");
        } else {
            Globals.g_wizard.getHeaderDesc().setText(this.getBundle().getString("PanelSystemCheck.InstallHeaderDesc"));
        }
        Globals.g_wizard.getNextButton().setEnabled(false);
        this._overallFileCount = 0;
        this.m_initThread = new InstallInitializationThread();
        this.getCalculatingProgressBar().setValue(0);
        this.getCalculatingProgressBar().setMaximum(this.getProductData().size());
        if (!this.isProductSelectionIdentical && this._totalSize > 0L) {
            this._totalSize = this._totalSize + (long)this.getProductData().size() * this.INSTALL_LOG_PADDING;
            this._totalSize = this._totalSize + this.getUniqueProductsSizes(this._totalSize);
        }
        this.getVerifyingProgressBar().setVisible(false);
        this.getCalculatingProgressBar().setVisible(true);
        this.getCalculatingProgressBar().repaint();
        this.getVerifyingProgressBar().setValue(0);
        this.setProblemFileListText(new StringBuffer());
        this.getProblemFileListArea().setText("");
        this.m_cannotProceed = false;
        if (Globals.g_partialPrompt && !Globals.g_consoleMode) {
            this.makeWithTheNext = new MakeWithTheNext();
            this.makeWithTheNext.start();
        }
        if (!Globals.g_consoleMode) {
            this.m_initThread.start();
        }
    }

    public void resetState() {
        File sashome = new File(Globals.g_wizardData.getPreference("SASHome", ""));
        while (!sashome.exists()) {
            sashome = sashome.getParentFile();
        }
        this._freeDiskSpace = DiskInfoAPI.getFreeDiskSpace(sashome.getAbsolutePath());
        if (Globals.g_cmtTask == 28) {
            this._totalSize = new Long(0L);
        } else if (!this.isProductSelectionIdentical) {
            this._totalSize = new Long(512000000L);
        }
        this._itTotalSize = new Long(0L);
        this.setProblemFiles(new Vector<EntryData>());
        this.numFilesProcessed = 0;
        this.checkedInstallSizes = new HashMap();
        this._lockCheckedFiles = new HashSet<String>();
        this._checkedFiles = new HashSet<String>();
        this.unfulfilledRequirements.clear();
        if (Globals.g_cmtTask == 28) {
            this.setProductData(Globals.g_selectedProductsToUninstall);
        } else if (Globals.g_cmtTask == 11) {
            this.setProductData(Globals.g_selectedHotFixesToInstall);
        } else if (Globals.g_srwOnly) {
            this.setProductData(new ArrayList<ProductData>(Arrays.asList(Globals.g_selectedSRWs)));
        } else {
            this.setProductData(this.getPanelExecute().getInstallProducts(true));
        }
        if (Globals.g_resumeChain) {
            for (int i = 0; i < this._productData.size(); ++i) {
                String curSpssku = this._productData.get(i).getSpsSku();
                String mySku = "";
                boolean found = false;
                for (int stage = 0; stage < Globals.g_chainData.getStageCount(); ++stage) {
                    for (int step = 0; step < Globals.g_chainData.getStageStepCount(stage); ++step) {
                        mySku = Globals.g_chainData.getProductSpsSku(stage, step);
                        if (!mySku.equalsIgnoreCase(curSpssku)) continue;
                        found = true;
                        break;
                    }
                    if (found) break;
                }
                if (found) continue;
                Logging.log.info("system requirement removed due to resume chain:  " + this._productData.get(i).getSpsSku());
                this._productData.remove(i);
                --i;
            }
        }
    }

    @Override
    public void initializePanel() {
        this.resetState();
    }

    private boolean badValidationFile(Exception e) {
        String msg;
        Throwable cause = e.getCause();
        if (e instanceof RuntimeException && cause instanceof JAXBException && (msg = e.getMessage()) != null && msg.startsWith(VALIDATION_FILE)) {
            String validationFileListPath = msg.replace(VALIDATION_FILE, "");
            String failureDescription = this.getBundle().messageString("PanelSystemCheck.BadValidationFileList", validationFileListPath);
            String logDescription = "An issue has been encountered with the validation file list that cannot be corrected.";
            String parseMsg = this.getBundle().messageString("PanelSystemCheck.ValidationFileParseError", validationFileListPath);
            String causeMsg = cause.getLocalizedMessage();
            while (causeMsg == null && (cause = cause.getCause()) != null) {
                causeMsg = cause.getLocalizedMessage();
            }
            causeMsg = causeMsg == null ? parseMsg : parseMsg.concat(" ").concat(causeMsg);
            failureDescription = failureDescription + "<BR>" + this.getBundle().messageString("PanelSystemCheck.ErrorDetails", InstallToolConnector.itController().getITLog()) + "<BR><BR>" + causeMsg;
            logDescription = logDescription + " \nThe details of the error are shown below. \n\n" + causeMsg;
            this.displayError(failureDescription, logDescription);
            return true;
        }
        return false;
    }

    private void displayError(String failureDescription, String logDescription) {
        Logging.log.severe(logDescription);
        if (!this.m_silent) {
            if (Globals.g_consoleMode) {
                ConsoleMode.errorMsg(Utils.removeHTMLTags(failureDescription));
            } else {
                JEditorPane content = new JEditorPane("text/html", failureDescription);
                content.setEditable(false);
                content.setPreferredSize(new Dimension(600, 200));
                com.sas.tools.installs.it.view.CustMsgBox.showMessageDialog(null, new JScrollPane(content), null, 1);
            }
        }
    }

    protected PanelExecute getPanelExecute() {
        if (this._panelExecute == null) {
            this._panelExecute = (PanelExecute)Globals.g_wizard.getPanel("execute");
        }
        return this._panelExecute;
    }

    @Override
    public String[] responseData() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        if (Globals.g_partialPrompt) {
            return false;
        }
        this.m_silent = true;
        this.setupUserProperties();
        Logging.log.info("Starting thread to evaluate filesystem");
        this.m_initThread = new InstallInitializationThread();
        this.m_initThread.start();
        try {
            this.m_initThread.join();
        }
        catch (InterruptedException e) {
            Logging.logStackTrace(e);
        }
        return !this.m_cannotProceed;
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public boolean validateData() {
        try {
            this.m_initThread.join();
        }
        catch (InterruptedException e) {
            Logging.logStackTrace(e);
        }
        if (this.m_cannotProceed) {
            this.preShowUpdates(Globals.g_wizard);
            return false;
        }
        this._recalculationNeeded = false;
        this.getPanelExecute().setTotalSize(this._itTotalSize);
        return true;
    }

    @Override
    public int consoleEvent() {
        int i;
        String buffer;
        if (this._recalculationNeeded) {
            ConsoleMode.busyMsgStart(this.getBundle().getString("PanelSystemCheck.CheckingSystem"));
            this.m_initThread.run();
            ConsoleMode.busyMsgStop();
        }
        String[] requiredSpaceParts = null;
        String[] freeSpaceParts = null;
        ArrayList<String> consoleTable = new ArrayList<String>();
        if (this._diskSpaceReportLabel != null && (requiredSpaceParts = this._diskSpaceReportLabel.getText().split(":")).length != 2) {
            requiredSpaceParts = null;
        }
        if (this._freeDiskSpaceReportLabel != null && (freeSpaceParts = this._freeDiskSpaceReportLabel.getText().split(":")).length != 2) {
            freeSpaceParts = null;
        }
        if (requiredSpaceParts != null) {
            buffer = "";
            if (freeSpaceParts != null && freeSpaceParts[1].length() > requiredSpaceParts[1].length()) {
                for (i = 0; i < freeSpaceParts[1].length() - requiredSpaceParts[1].length(); ++i) {
                    buffer = buffer + " ";
                }
            }
            consoleTable.add(requiredSpaceParts[0] + ":" + "~" + buffer + requiredSpaceParts[1]);
        }
        if (freeSpaceParts != null) {
            buffer = "";
            if (requiredSpaceParts != null && requiredSpaceParts[1].length() > freeSpaceParts[1].length()) {
                for (i = 0; i < requiredSpaceParts[1].length() - freeSpaceParts[1].length(); ++i) {
                    buffer = buffer + " ";
                }
            }
            consoleTable.add(freeSpaceParts[0] + ":" + "~" + buffer + freeSpaceParts[1]);
        }
        ConsoleMode.printTable(consoleTable.toArray(new String[0]));
        if (this.m_cannotProceed) {
            ConsoleMode.println();
            ConsoleMode.println(this.getBundle().getString("PanelSystemCheck.ConsoleInstructions.txt"));
            ConsoleMode.println(this.getProblemFileListArea().getText());
        }
        int returnCode = 0;
        if (!Globals.g_partialPrompt) {
            returnCode = ConsoleMode.promptPause();
        }
        return returnCode;
    }

    @Override
    public String getNextPanelID() {
        if (Globals.g_mode == 2) {
            if (Globals.g_cmtTask == 11) {
                return "hotfixpreinstallsummary";
            }
            return "execute";
        }
        return "tpsummary";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupAction(String action, EntryData metaData) {
        if (Thread.currentThread() instanceof PreExecuteThread) {
            boolean incrementFileCount = true;
            PreExecuteThread thread = (PreExecuteThread)Thread.currentThread();
            PreExecuteRunnable preExecute = thread.getPreExecuteRunnable();
            if (preExecute == null) {
                return;
            }
            String installXML = preExecute.getInstallXML().getAbsolutePath();
            Long checkedSize = this.checkedInstallSizes.get(installXML);
            if (!this.isProductSelectionIdentical && metaData.getSize() != null) {
                String file = metaData.getDestination().getAbsolutePath();
                if (action.equals("Added") || action.equals("Changed") || action.equals("Backed up")) {
                    Set<String> set = this._checkedFiles;
                    synchronized (set) {
                        if (!this._checkedFiles.contains(file)) {
                            this.setTotalSize(this.getTotalSize() + metaData.getSize());
                            this._checkedFiles.add(file);
                        }
                    }
                    incrementFileCount = false;
                } else if (action.equals("Removed")) {
                    this.setTotalSize(this.getTotalSize() - metaData.getSize());
                    this._itTotalSize = this._itTotalSize - metaData.getSize();
                    checkedSize = checkedSize - metaData.getSize();
                } else if (action.equals("Checked")) {
                    this._itTotalSize = this._itTotalSize + metaData.getSize();
                    checkedSize = checkedSize + metaData.getSize();
                }
                this.checkedInstallSizes.put(installXML, checkedSize);
            }
            String path = null;
            try {
                path = metaData.getDestination().getCanonicalPath();
            }
            catch (IOException e) {
                path = metaData.getDestination().getAbsolutePath();
            }
            boolean checkForLock = true;
            Set<String> set = this._lockCheckedFiles;
            synchronized (set) {
                if (!this._lockCheckedFiles.contains(path)) {
                    this._lockCheckedFiles.add(path);
                } else {
                    checkForLock = false;
                }
            }
            if (checkForLock) {
                boolean writeable = metaData.destinationWriteable();
                boolean running = false;
                String testPostgresFile = "\\bin\\pg_ctl.exe";
                if (path.contains(testPostgresFile)) {
                    running = this.isProcessRunning(testPostgresFile);
                    Logging.log.info("Will not be able to proceed.  " + path + " is running");
                }
                if (path.contains(testPostgresFile = "\\bin\\postgres.exe")) {
                    running = this.isProcessRunning(testPostgresFile);
                    Logging.log.info("Will not be able to proceed.  " + path + " is running");
                }
                if (path.contains(testPostgresFile = "/bin/pg_ctl")) {
                    running = this.isProcessRunning(testPostgresFile);
                }
                boolean locked = metaData.destinationLocked();
                if ((!writeable || locked || running) && (action.equals("Added") || action.equals("Changed") || action.equals("Checked"))) {
                    if (!writeable) {
                        Logging.log.info("Will not be able to proceed.  " + path + " is unwriteable");
                    }
                    if (locked) {
                        Logging.log.info("Will not be able to proceed.  " + path + " is locked");
                    }
                    if (!this.m_silent) {
                        this.getProblemFiles().add(metaData);
                        this.getProblemFileListArea().setVisible(true);
                        if (this.getProblemFileListText().length() > 0) {
                            this.getProblemFileListText().append("\n" + path);
                        } else {
                            this.getProblemFileListText().append(path);
                        }
                        this.getProblemFileListArea().setText(this.getProblemFileListText().toString());
                    }
                    Logging.log.info("Will not be able to proceed.  Cannot write " + path);
                    if (!Globals.g_skipLockCheck) {
                        this.m_cannotProceed = true;
                    }
                    if (this.m_cannotProceed && Globals.g_uip) {
                        this.uipSpaceAlreadyCalculated = true;
                    }
                }
            }
            if (incrementFileCount) {
                this.checkDiskSpace(false);
            }
        }
    }

    private boolean isProcessRunning(String testFile) {
        File tmpFile = new File(testFile);
        String tmpName = tmpFile.getName();
        if (Utils.getOS() == 1) {
            try {
                String winCommand = System.getenv("windir") + "\\system32\\tasklist.exe";
                File taskListFile = new File(winCommand);
                if (taskListFile.exists()) {
                    Process proc = Runtime.getRuntime().exec(winCommand);
                    BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    String in = input.readLine();
                    while (in != null) {
                        if (in.contains(tmpName)) {
                            return true;
                        }
                        in = input.readLine();
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        if (TaskHelper.isUnix()) {
            File regFile = new File(RegistryData.getDeployRegJar());
            if (!regFile.exists()) {
                return false;
            }
            PanelConfigMaint cfgMaint = new PanelConfigMaint();
            ArrayList listData = cfgMaint.loadConfigDirs();
            PanelConfigMaint.ListData listElement = null;
            String pg_ctlCommand = Globals.g_wizardData.getPreference("SASHome", "") + "/SASWebInfrastructurePlatformDataServer/9.4/bin/" + tmpName;
            for (int i = 0; i < listData.size(); ++i) {
                try {
                    listElement = (PanelConfigMaint.ListData)listData.get(i);
                    File cfgDir = new File(listElement.getConfigDir() + "/" + listElement.getConfigLev() + "/WebInfrastructurePlatformDataServer/data");
                    if (!cfgDir.exists()) continue;
                    String[] command = new String[]{pg_ctlCommand, "status", "-D", cfgDir.getAbsolutePath()};
                    Process proc = Runtime.getRuntime().exec(command);
                    BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    String in = input.readLine();
                    while (in != null) {
                        if (in.contains("server is running")) {
                            return true;
                        }
                        in = input.readLine();
                    }
                    continue;
                }
                catch (IOException e) {
                    return false;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setupAction(String description) {
        if (Thread.currentThread() instanceof PreExecuteThread) {
            PreExecuteThread thread = (PreExecuteThread)Thread.currentThread();
            PreExecuteRunnable preExecute = thread.getPreExecuteRunnable();
            if (preExecute == null) {
                return;
            }
            String prodCode = preExecute.getInstallProperty("12ByteCode");
            String matchstr = "sysReq." + prodCode;
            String altSku = preExecute.getAltSku();
            if (description.startsWith(matchstr)) {
                ProductData curData = null;
                for (int i = 0; i < this._productData.size(); ++i) {
                    Object object = this.obj;
                    synchronized (object) {
                        curData = this._productData.get(i);
                        if (curData.getProdCode().compareToIgnoreCase(prodCode) == 0) {
                            curData.setType(0);
                            if (!Globals.g_resumeChain) {
                                if (description.startsWith(matchstr + ".willInstall")) {
                                    if (Globals.g_skipSRW) {
                                        Logging.log.info("system requirement check skipped:  " + prodCode);
                                        Globals.g_installToolBasedProds.remove(altSku);
                                        this._productData.remove(i);
                                        --i;
                                    } else if (Globals.g_dotnetDetect) {
                                        if (Pattern.compile("^dotnet(\\d.*)*", 2).matcher(prodCode).matches()) {
                                            this.unfulfilledRequirements.add(altSku);
                                            this.m_cannotProceed = true;
                                        }
                                    } else {
                                        Logging.log.info("system requirement to be installed:  " + prodCode);
                                    }
                                } else if (description.startsWith(matchstr + ".willNotInstall")) {
                                    Logging.log.info("system requirement already exist on system:  " + prodCode);
                                    Globals.g_installToolBasedProds.remove(altSku);
                                    curData.setInstalled(true);
                                    this._productData.remove(i);
                                    --i;
                                } else if (description.startsWith(matchstr + ".isNotApplicable")) {
                                    if (Globals.g_srwOnly) {
                                        Logging.log.info("system requirement is not applicable on system:  " + prodCode);
                                        curData.setApplicable(false);
                                    }
                                    Globals.g_installToolBasedProds.remove(altSku);
                                    this._productData.remove(i);
                                    --i;
                                }
                            }
                        }
                        continue;
                    }
                }
            }
        }
    }

    public JPanel getContainerPanel() {
        return this._containerPanel;
    }

    public void setContainerPanel(JPanel containerPanel) {
        this._containerPanel = containerPanel;
    }

    public JTextArea getHeaderText() {
        return this._headerText;
    }

    public void setHeaderText(JTextArea headerText) {
        this._headerText = headerText;
    }

    public JLabel getVerifyingLabel() {
        return this._verifyingLabel;
    }

    public void setVerifyingLabel(JLabel verifyingText) {
        this._verifyingLabel = verifyingText;
    }

    public JLabel getCalculatingLabel() {
        return this._calculatingLabel;
    }

    public void setCalculatingLabel(JLabel calculatingText) {
        this._calculatingLabel = calculatingText;
    }

    public JProgressBar getVerifyingProgressBar() {
        return this._verifyingProgressBar;
    }

    public void setVerifyingProgressBar(JProgressBar verifyingProgressBar) {
        this._verifyingProgressBar = verifyingProgressBar;
    }

    public JProgressBar getCalculatingProgressBar() {
        return this._calculatingProgressBar;
    }

    public void setCalculatingProgressBar(JProgressBar calculatingProgressBar) {
        this._calculatingProgressBar = calculatingProgressBar;
    }

    public SSNResource getBundle() {
        return this._bundle;
    }

    public void setBundle(SSNResource bundle) {
        this._bundle = bundle;
    }

    public ArrayList<? extends ProductData> getProductData() {
        return this._productData;
    }

    public void setProductData(ArrayList<ProductData> productData) {
        this._productData = productData;
    }

    public JLabel getDiskSpaceReportLabel() {
        return this._diskSpaceReportLabel;
    }

    public void setDiskSpaceReportLabel(JLabel diskSpaceReportText) {
        this._diskSpaceReportLabel = diskSpaceReportText;
    }

    public Long getTotalSize() {
        return this._totalSize;
    }

    public void setTotalSize(Long totalSize) {
        this._totalSize = totalSize;
    }

    public Vector<EntryData> getProblemFiles() {
        return this._problemFiles;
    }

    public void setProblemFiles(Vector<EntryData> problemFiles) {
        this._problemFiles = problemFiles;
    }

    protected JLabel getProblemFileReportLabel() {
        return this._problemFileReportLabel;
    }

    protected void setProblemFileReportLabel(JLabel problemFileReportLabel) {
        this._problemFileReportLabel = problemFileReportLabel;
    }

    protected JLabel getRefreshInstructionsLabel() {
        return this._refreshInstructionsLabel;
    }

    protected void setRefreshInstructionsLabel(JLabel refreshInstructionsLabel) {
        this._refreshInstructionsLabel = refreshInstructionsLabel;
    }

    protected JLabel getFreeDiskSpaceReportLabel() {
        return this._freeDiskSpaceReportLabel;
    }

    protected void setFreeDiskSpaceReportLabel(JLabel freeDiskSpaceReportLabel) {
        this._freeDiskSpaceReportLabel = freeDiskSpaceReportLabel;
    }

    public JEditorPane getProblemFileListArea() {
        return this._problemFileListArea;
    }

    public void setProblemFileListArea(JEditorPane problemFileListArea) {
        this._problemFileListArea = problemFileListArea;
    }

    public StringBuffer getProblemFileListText() {
        return this.m_problemFileListText;
    }

    public void setProblemFileListText(StringBuffer problemFileListText) {
        this.m_problemFileListText = problemFileListText;
    }

    private void checkDiskSpace(boolean suppressProgressBar) {
        String nextTxt = "";
        if (!this.m_silent) {
            nextTxt = Util.getLabelWithoutMnemonic(this.getBundle().getString("Wizard.Next.txt"));
        }
        if (this.getTotalSize() > this._freeDiskSpace) {
            Logging.log.info("Will not be able to proceed.  The total size of the install  (" + this.getTotalSize() + ") exceeds the amount of available space on disk  (" + this._freeDiskSpace + ")");
            if (!Globals.g_skipSpaceCheck) {
                this.m_cannotProceed = true;
                this.m_notEnoughDiskSpace = true;
            }
            this.previousSelectedProducts = Globals.g_selectedInstalls;
            if (this.m_notEnoughDiskSpace && Globals.g_uip) {
                this.uipSpaceAlreadyCalculated = true;
            }
        }
        if (!this.m_silent) {
            if (this.m_cannotProceed && Globals.g_wizard.getNextButton().getText().equals(nextTxt)) {
                String mtxt = this.getBundle().getString("PanelSystemCheck.Refresh");
                Globals.g_wizard.getNextButton().setText(Util.getLabelWithoutMnemonic(mtxt));
                Globals.g_wizard.getNextButton().setMnemonic(Util.getDisplayedMnemonic(mtxt));
                Globals.g_wizard.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
                Globals.g_wizard.getNextButton().setSize(new JButton(mtxt).getPreferredSize());
                Globals.g_wizard.resizeButtons();
            }
            NumberFormat formatter = new DecimalFormat("###,###.##");
            this.getProblemFileReportLabel().setText(this.problemFilePrefix + ": " + this.getProblemFiles().size());
            this.getDiskSpaceReportLabel().setText(this.diskSpacePrefix + ": " + formatter.format(this.getTotalSize() / 0x100000L) + " MB");
            NumberFormat intFormatter = NumberFormat.getIntegerInstance();
            this.getFreeDiskSpaceReportLabel().setText(this.getBundle().getString("PanelSystemCheck.FreeDiskSpace") + ": " + intFormatter.format((int)(this._freeDiskSpace / 0x100000L)) + " MB");
            if (suppressProgressBar) {
                this.getVerifyingProgressBar().setVisible(false);
                this.getVerifyingLabel().setVisible(false);
            } else {
                this.getVerifyingProgressBar().setValue(this.numFilesProcessed++);
                formatter = NumberFormat.getIntegerInstance();
                this.getVerifyingProgressBar().setString(formatter.format(this.getVerifyingProgressBar().getValue()) + " / " + formatter.format(this.getVerifyingProgressBar().getMaximum()) + " (" + (int)(this.getVerifyingProgressBar().getPercentComplete() * 100.0) + "%)");
                this.getVerifyingProgressBar().repaint();
            }
        }
    }

    private long getUniqueProductsSizes(long currentSize) {
        String[] dbcs = new String[]{"_ja_", "_ko_", "_zt_", "_zx_"};
        String[] sbcs = new String[]{"_ar_", "_da_", "_en_", "_es_", "_fr_", "_it_", "_iw_", "_nl_", "_pl_", "_sv_", "_tr_"};
        String prt = "_prt_";
        for (ProductData prod : this._productData) {
            String skuname = prod.getSpsSku();
            if ((skuname = skuname.toLowerCase()).contains("eguide")) {
                for (String s : sbcs) {
                    if (!skuname.contains(s)) continue;
                    currentSize += 11000000L;
                    break;
                }
                for (String d : dbcs) {
                    if (!skuname.contains(d)) continue;
                    currentSize += 30000000L;
                    break;
                }
                if (skuname.contains(prt)) {
                    currentSize += 108000000L;
                }
            }
            if (!skuname.contains("msofficeint")) continue;
            for (String s : sbcs) {
                if (!skuname.contains(s)) continue;
                currentSize += 9000000L;
                break;
            }
            for (String d : dbcs) {
                if (!skuname.contains(d)) continue;
                currentSize += 30000000L;
                break;
            }
            if (!skuname.contains(prt)) continue;
            currentSize += 140000000L;
        }
        return currentSize;
    }

    private void showMissingDiskSpaceMsg() {
        if (this.m_cannotProceed) {
            if (this.m_notEnoughDiskSpace) {
                if (!this.m_silent) {
                    String errorMsg = this.getBundle().messageString("PanelSystemCheck.DiskSpaceErrorDetails", this.getTotalSize(), this._freeDiskSpace);
                    if (errorMsg != null) {
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), errorMsg, this.getBundle().messageString("Common.Error.txt"), 0);
                    }
                } else {
                    Logging.log.severe("Cannot proceed because there is not enough disk space for the installation.");
                    Globals.g_kit.exitKit(1);
                }
            }
        } else if (this.m_notEnoughDiskSpace) {
            Logging.log.info("Preceeding with not enough disk space because -skipspacecheck parameter used.");
        }
    }

    @SuppressWarnings(value={"WA_NOT_IN_LOOP", "UW_UNCOND_WAIT"}, justification="Cannot put wait in while loop. This was difficult to code initially, it works, don't break it")
    protected class MakeWithTheNext
    extends Thread {
        protected MakeWithTheNext() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = PanelSystemCheck.this.obj;
            synchronized (object) {
                try {
                    PanelSystemCheck.this.obj.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            Globals.g_wizard.getNextButton().doClick();
        }
    }

    protected class InstallInitializationThread
    extends Thread {
        protected boolean _cancel = false;

        public void setCancel(boolean newValue) {
            this._cancel = newValue;
        }

        public boolean isCancel() {
            return this._cancel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            void var7_12;
            InstallToolConnector.itController().setAllInstallAltskus(new Vector<String>());
            String[] langList = new String[]{Language.gs_SelectedLanguage};
            HashMap<File, Object> installData = new HashMap<File, Object>();
            HashMap<File, String> altskuData = new HashMap<File, String>();
            int counter = 0;
            for (ProductData productData : PanelSystemCheck.this.getProductData()) {
                if (this.isCancel()) {
                    return;
                }
                if (!PanelSystemCheck.this.m_silent) {
                    PanelSystemCheck.this.getCalculatingLabel().setText(PanelSystemCheck.this.getBundle().messageString("PanelSystemCheck.Initializing", productData.getProdName()));
                    PanelSystemCheck.this.getCalculatingProgressBar().setValue(counter);
                    NumberFormat formatter = NumberFormat.getIntegerInstance();
                    PanelSystemCheck.this.getCalculatingProgressBar().setString(formatter.format(PanelSystemCheck.this.getCalculatingProgressBar().getValue()) + " / " + formatter.format(PanelSystemCheck.this.getCalculatingProgressBar().getMaximum()) + " (" + (int)(PanelSystemCheck.this.getCalculatingProgressBar().getPercentComplete() * 100.0) + "%)");
                    PanelSystemCheck.this.getCalculatingProgressBar().repaint();
                }
                ++counter;
                File installXML = null;
                if (productData.getType() == 4) {
                    String extractLocation = Utils.joinPath(Globals.g_tempLocation, "hotfixes", "extracted");
                    if (Utils.getOS() == 8) {
                        String string = Utils.joinPath("InstallMisc", "hotfixes");
                        extractLocation = Utils.joinPath(Globals.g_wizardData.getPreference("SASHome", ""), string, "extracted");
                    }
                    if (((HotFix)productData).extractHotFix(extractLocation)) {
                        installXML = new File(productData.getInstallRef(false));
                    } else {
                        String string = PanelSystemCheck.this.getBundle().messageString("PanelSystemCheck.InstallationFailure");
                        String logDescription = "An issue has been encountered with your depot that cannot be corrected";
                        String string2 = string + "<BR>" + PanelSystemCheck.this.getBundle().messageString("PanelSystemCheck.HotFixError") + "<BR>" + PanelSystemCheck.this.getBundle().messageString("PanelSystemCheck.HotFixErrorDetails", ((HotFix)productData).getProdNameExtended(), ((HotFix)productData).getHotFixPackageFile().getAbsolutePath());
                        logDescription = logDescription + "\nThe details of the error are shown below.\nAn error occurred while extracting package files for hot fix " + ((HotFix)productData).getHotFixPackageFile().getAbsolutePath() + " from the hot fix package: " + ((HotFix)productData).getHotFixPackageFile().getAbsolutePath();
                        PanelSystemCheck.this.displayError(string2, logDescription);
                        Globals.g_kit.exitKit(1);
                    }
                } else {
                    installXML = Globals.g_cmtTask == 28 ? new File(productData.getInstallRef(false)) : new File(Globals.g_startupLocation, productData.getInstallRef(false));
                }
                if (!installXML.getName().equalsIgnoreCase("install.xml")) {
                    SpsSkuData spsSkuData = Globals.g_deploymentData.getSpsSku(productData.getSpsSku());
                    if (spsSkuData == null || "deploywiz".equals(spsSkuData.getProdCode()) || "cfgwizard".equals(spsSkuData.getProdCode()) || PanelSystemCheck.this.isProductSelectionIdentical) continue;
                    PanelSystemCheck.this.setTotalSize(PanelSystemCheck.this.getTotalSize() + spsSkuData.getInstalledSize(Utils.getOS_Suffix(), langList));
                    continue;
                }
                File productXML = new File(Globals.g_deploymentData.getSpsSkuDataDir(Globals.g_order, productData.getSpsSku(), true), "product.xml");
                String string = installXML.getAbsolutePath();
                try {
                    InstallToolConnector.primeInstallTool(string, productData, true);
                    Globals.g_installToolBasedProds.add(productData.getSpsSku());
                }
                catch (Exception e) {
                    Controller.logStackTrace(e);
                    if (!PanelSystemCheck.this.badValidationFile(e)) {
                        String failureDescription = PanelSystemCheck.this.getBundle().messageString("PanelSystemCheck.InstallationFailure");
                        String logDescription = "An issue has been encountered with your depot that cannot be corrected";
                        if (e.getMessage() != null) {
                            failureDescription = failureDescription + "<BR>" + PanelSystemCheck.this.getBundle().messageString("PanelSystemCheck.ErrorDetails", InstallToolConnector.itController().getITLog()) + "<BR><BR>" + e.getLocalizedMessage();
                            logDescription = logDescription + "\nThe details of the error are shown below.\n\n" + e.getLocalizedMessage();
                        }
                        PanelSystemCheck.this.displayError(failureDescription, logDescription);
                    }
                    Globals.g_kit.exitKit(1);
                }
                installData.put(installXML, productXML);
                altskuData.put(installXML, productData.getSpsSku());
                PanelSystemCheck.this._overallFileCount += InstallToolConnector.getProcessedFileCountForInstall(productData.getSpsSku());
                PanelSystemCheck.this.checkedInstallSizes.put(string, 0L);
            }
            if (!PanelSystemCheck.this.m_silent) {
                PanelSystemCheck.this.getCalculatingProgressBar().setValue(counter);
                NumberFormat formatter = NumberFormat.getIntegerInstance();
                PanelSystemCheck.this.getCalculatingProgressBar().setString(formatter.format(PanelSystemCheck.this.getCalculatingProgressBar().getValue()) + " / " + formatter.format(PanelSystemCheck.this.getCalculatingProgressBar().getMaximum()) + " (" + (int)(PanelSystemCheck.this.getCalculatingProgressBar().getPercentComplete() * 100.0) + "%)");
                PanelSystemCheck.this.getCalculatingProgressBar().repaint();
                PanelSystemCheck.this.getCalculatingLabel().setText(PanelSystemCheck.this.getBundle().messageString("PanelSystemCheck.InitializationComplete"));
            }
            for (File file : installData.keySet()) {
                File productXML = (File)installData.get(file);
                InstallToolConnector.getConnector().preExecute(file, productXML, (String)altskuData.get(file));
            }
            if (!PanelSystemCheck.this.m_silent) {
                PanelSystemCheck.this.getVerifyingProgressBar().setMaximum(PanelSystemCheck.this._overallFileCount);
                PanelSystemCheck.this.getRefreshInstructionsLabel().setVisible(true);
                PanelSystemCheck.this.getVerifyingProgressBar().setVisible(true);
                PanelSystemCheck.this.getProblemFileListArea().setVisible(true);
                PanelSystemCheck.this._lockedScroll.setVisible(true);
                PanelSystemCheck.this._unwritableScroll.setVisible(true);
                PanelSystemCheck.this.getVerifyingProgressBar().repaint();
                PanelSystemCheck.this.getVerifyingLabel().setVisible(true);
                PanelSystemCheck.this.getProblemFileReportLabel().setText(PanelSystemCheck.this.problemFilePrefix + ": 0");
                PanelSystemCheck.this.getDiskSpaceReportLabel().setText(PanelSystemCheck.this.diskSpacePrefix + ": 0 MB");
            }
            int countCompleted = 0;
            boolean bl = false;
            Vector<PreExecuteRunnable> preExecuteRunnables = InstallToolConnector.getConnector().getPreExecuteRunnables();
            for (PreExecuteRunnable preExecuteRunnable : preExecuteRunnables) {
                String productName;
                if (this.isCancel()) {
                    return;
                }
                if (!PanelSystemCheck.this.m_silent && (productName = preExecuteRunnable.getInstallProperty("ProductName")) != null) {
                    PanelSystemCheck.this.getVerifyingLabel().setText(PanelSystemCheck.this.getBundle().messageString("PanelSystemCheck.CheckingSystem"));
                }
                preExecuteRunnable.waitForCompletion();
                if (preExecuteRunnable.hasCompletedRun()) {
                    ++countCompleted;
                }
                if (preExecuteRunnable.getPreExecuteReturnCode() == 0) continue;
                ++var7_12;
                Logging.log.info("failure in preExecute for " + preExecuteRunnable.getInstallXML().getAbsolutePath());
            }
            Logging.log.info("Total PreExecute actions (" + preExecuteRunnables.size() + "), completed (" + countCompleted + "), failed (" + (int)var7_12 + ")");
            if (Globals.g_installToolBasedProds.isEmpty() || Globals.g_srwOnly) {
                PanelSystemCheck.this.checkDiskSpace(true);
            }
            if (!PanelSystemCheck.this.m_silent) {
                PanelSystemCheck.this.getVerifyingProgressBar().setValue(PanelSystemCheck.this.getVerifyingProgressBar().getMaximum());
                NumberFormat formatter = NumberFormat.getIntegerInstance();
                PanelSystemCheck.this.getVerifyingProgressBar().setString(formatter.format(PanelSystemCheck.this.getVerifyingProgressBar().getValue()) + " / " + formatter.format(PanelSystemCheck.this.getVerifyingProgressBar().getMaximum()) + " (" + (int)(PanelSystemCheck.this.getVerifyingProgressBar().getPercentComplete() * 100.0) + "%)");
                PanelSystemCheck.this.getVerifyingProgressBar().repaint();
            }
            PanelSystemCheck.this.getPanelExecute().setCheckedSizes(PanelSystemCheck.this.checkedInstallSizes);
            if (!PanelSystemCheck.this.m_silent) {
                Globals.g_wizard.getNextButton().setEnabled(true);
                Globals.g_wizard.getNextButton().requestFocus();
                if (Globals.g_wizard.getFrame() != null) {
                    Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
                }
            }
            if (!PanelSystemCheck.this.m_cannotProceed && !PanelSystemCheck.this.m_silent) {
                String nextTxt = Util.getLabelWithoutMnemonic(PanelSystemCheck.this.getBundle().getString("Wizard.Next.txt"));
                Globals.g_wizard.getNextButton().setText(Util.getLabelWithoutMnemonic(nextTxt));
                Globals.g_wizard.getNextButton().setMnemonic(Util.getDisplayedMnemonic(nextTxt));
                Globals.g_wizard.getNextButton().setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(nextTxt));
                Globals.g_wizard.getNextButton().setSize(new JButton(nextTxt).getPreferredSize());
                Globals.g_wizard.resizeButtons();
                if (Globals.g_partialPrompt) {
                    Object object = PanelSystemCheck.this.obj;
                    synchronized (object) {
                        PanelSystemCheck.this.obj.notifyAll();
                    }
                }
            }
            PanelSystemCheck.this.showMissingDiskSpaceMsg();
            if (!PanelSystemCheck.this.unfulfilledRequirements.isEmpty()) {
                String list = "";
                for (String altSku : PanelSystemCheck.this.unfulfilledRequirements) {
                    list = list + "\n     " + Globals.g_deploymentData.getSpsSku(altSku).getDisplayName("en");
                }
                Logging.log.warning("The following requirements must be met before deploying your SAS Software.\n" + list);
                if (!PanelSystemCheck.this.m_silent) {
                    String string = PanelSystemCheck.this._bundle.getString("PanelSystemCheck.Requirements.txt") + list;
                    if (Globals.g_consoleMode) {
                        ConsoleMode.warningMsg(string);
                    } else {
                        CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), string, PanelSystemCheck.this._bundle.getString("Common.Warning.txt"), 2);
                    }
                }
            }
            PanelSystemCheck.this._lockCheckedFiles = new HashSet();
        }
    }
}

