/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.OrderData;
import com.sas.ssn.OsLevelConfirm;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class PanelStart
implements WizardPanelIface {
    private final String RESPONSE_INSTALL = "install";
    private final String RESPONSE_DEPOT = "depot";
    private final String RESPONSE_MANAGE = "manage";
    private SSNResource bundle = new SSNResource(PanelStart.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JPanel m_endUserPanel = new JPanel(new GridBagLayout());
    private JPanel m_adminPanel = new JPanel(new GridBagLayout());
    private JTextArea m_endUserLabel = null;
    private JSeparator m_endUserSeparator = new JSeparator();
    private JRadioButton m_installOption = null;
    private JTextArea m_installInfo = null;
    private JTextArea m_adminLabel = null;
    private JSeparator m_adminSeparator = new JSeparator();
    private JRadioButton m_manageOption = null;
    private JTextArea m_manageInfo = null;
    private JRadioButton m_depotOption = null;
    private JTextArea m_depotInfo = null;
    private boolean m_panelLoaded = false;
    private boolean m_allowInstall = true;
    private boolean m_installByDefault = true;

    public PanelStart() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelStart.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelStart.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        String user;
        boolean valid = true;
        if (Globals.g_deploymentData.getOrderCount() == 1 && this.m_installOption.isSelected() && !OsLevelConfirm.checkOsVersion()) {
            if (!Globals.g_quietMode) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), OsLevelConfirm.getErrorMessage(), this.bundle.getString("Common.Warning.txt"), 2);
            }
            valid = false;
        }
        if (this.m_installOption.isSelected() && Utils.getOS(true) == 1 && !Globals.g_skipAdminCheck && !Utils.isAdmin(user = Utils.getUserDomain() + "\\" + System.getProperty("user.name"))) {
            valid = false;
            Logging.log.severe("The user account (" + user + ") does not have sufficient rights to install SAS software.");
            if (!Globals.g_quietMode) {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString("PanelStart.NotAdmin.txt", user), this.bundle.getString("Common.Warning.txt"), 2);
            }
        }
        return valid;
    }

    @Override
    public boolean displayPanel() {
        return this.m_allowInstall && !Globals.g_forceInstall && !Globals.g_zos && !Globals.g_srwOnly;
    }

    @Override
    public String getNextPanelID() {
        String panelID = null;
        Globals.g_createSSD = false;
        if (Globals.g_forceInstall) {
            panelID = "selectorder";
        } else if (!this.m_allowInstall) {
            Globals.g_createSSD = true;
            panelID = "selectorder";
        } else if (this.m_installOption.isSelected()) {
            panelID = "selectorder";
        } else if (this.m_manageOption != null && this.m_manageOption.isSelected()) {
            panelID = "manageorhotfix";
        } else if (this.m_depotOption != null && this.m_depotOption.isSelected()) {
            Globals.g_createSSD = true;
            panelID = "selectorder";
        } else {
            panelID = Globals.g_srwOnly ? "createbatch" : "selectorder";
        }
        return panelID;
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                if (this.m_installByDefault) {
                    this.m_installOption.setSelected(true);
                } else {
                    this.m_depotOption.setSelected(true);
                }
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JRadioButton focus = null;
        if (this.m_installOption.isSelected()) {
            focus = this.m_installOption;
        } else if (this.m_manageOption != null && this.m_manageOption.isSelected()) {
            focus = this.m_manageOption;
        } else if (this.m_depotOption != null && this.m_depotOption.isSelected()) {
            focus = this.m_depotOption;
        }
        return focus;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        String[] data = new String[]{"#START_TASK=install/depot/manage", " START_TASK=install"};
        if (this.m_panelLoaded) {
            if (this.m_manageOption != null && this.m_manageOption.isSelected()) {
                data[1] = " START_TASK=manage";
            } else if (this.m_depotOption != null && this.m_depotOption.isSelected()) {
                data[1] = " START_TASK=depot";
            }
        }
        return data;
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_installOption, this.m_manageOption, this.m_depotOption};
        JTextArea[] infos = new JTextArea[]{this.m_installInfo, this.m_manageInfo, this.m_depotInfo};
        return ConsoleMode.promptRadioButtons(options, infos);
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("START_TASK", null);
        if (response != null) {
            if (response.equalsIgnoreCase("install")) {
                valid = true;
                this.m_installOption.setSelected(true);
            } else if (response.equalsIgnoreCase("manage") && this.m_manageOption != null) {
                valid = true;
                this.m_manageOption.setSelected(true);
            } else if (response.equalsIgnoreCase("depot") && this.m_depotOption != null) {
                valid = true;
                this.m_depotOption.setSelected(true);
            } else if (Globals.g_quietMode) {
                Wizard.logResponseInvalid(this.getHeader(), "START_TASK", response, null);
            }
        } else if (Globals.g_quietMode) {
            Wizard.logResponseMissing(this.getHeader(), "START_TASK");
        }
        return valid;
    }

    private void initialize() {
        this.allowInstall();
        this.m_endUserLabel = new JTextArea(this.bundle.getString("PanelStart.EndUserLabel.txt"));
        this.m_endUserLabel.setEditable(false);
        this.m_endUserLabel.setFocusable(false);
        this.m_endUserLabel.setLineWrap(false);
        this.m_endUserLabel.setOpaque(false);
        String mtxt = this.bundle.getString("PanelStart.InstallLabel.txt");
        this.m_installOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_installOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_installOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_installOption.getFont();
        this.m_installOption.setFont(optionFont.deriveFont(1));
        this.m_installInfo = new JTextArea(this.bundle.getString("PanelStart.InstallInfo.txt"));
        this.m_installInfo.setEditable(false);
        this.m_installInfo.setFocusable(false);
        this.m_installInfo.setLineWrap(true);
        this.m_installInfo.setWrapStyleWord(true);
        this.m_installInfo.setOpaque(false);
        this.m_adminLabel = new JTextArea(this.bundle.getString("PanelStart.AdministratorLabel.txt"));
        this.m_adminLabel.setEditable(false);
        this.m_adminLabel.setFocusable(false);
        this.m_adminLabel.setLineWrap(false);
        this.m_adminLabel.setOpaque(false);
        if (Globals.g_sourceSSD) {
            mtxt = this.bundle.getString("PanelStart.ManageLabel.txt");
            this.m_manageOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
            this.m_manageOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
            this.m_manageOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            optionFont = this.m_manageOption.getFont();
            this.m_manageOption.setFont(optionFont.deriveFont(1));
            this.m_manageInfo = new JTextArea();
            if (Globals.g_depotManager == null || Globals.g_depotManager.isWritable() && Globals.g_depotManager.getDepotType() == 0) {
                this.m_manageInfo.setText(this.bundle.getString("PanelStart.ManageInfo.txt"));
            } else {
                this.m_manageInfo.setText(this.bundle.getString("PanelStart.ManageSAWInfo.txt"));
            }
            this.m_manageInfo.setEditable(false);
            this.m_manageInfo.setFocusable(false);
            this.m_manageInfo.setLineWrap(true);
            this.m_manageInfo.setWrapStyleWord(true);
            this.m_manageInfo.setOpaque(false);
        }
        if (Globals.g_depotManager == null || Globals.g_depotManager.getDepotType() == 0) {
            mtxt = Globals.g_sourceSSD ? this.bundle.getString("PanelStart.DepotNewLabel.txt") : this.bundle.getString("PanelStart.DepotLabel.txt");
            this.m_depotOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
            this.m_depotOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
            this.m_depotOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
            optionFont = this.m_depotOption.getFont();
            this.m_depotOption.setFont(optionFont.deriveFont(1));
            this.m_depotInfo = new JTextArea();
            if (Globals.g_sourceSSD) {
                this.m_depotInfo.setText(this.bundle.getString("PanelStart.DepotNewInfo.txt"));
            } else {
                this.m_depotInfo.setText(this.bundle.getString("PanelStart.DepotInfo.txt"));
            }
            this.m_depotInfo.setEditable(false);
            this.m_depotInfo.setFocusable(false);
            this.m_depotInfo.setLineWrap(true);
            this.m_depotInfo.setWrapStyleWord(true);
            this.m_depotInfo.setOpaque(false);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_installOption);
        if (this.m_manageOption != null) {
            group.add(this.m_manageOption);
        }
        if (this.m_depotOption != null) {
            group.add(this.m_depotOption);
        }
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        this.layoutEndUserSeparator();
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_endUserPanel, c);
        c.gridy = 1;
        c.insets = new Insets(5, 20, 5, 0);
        this.m_panel.add((Component)this.m_installOption, c);
        c.gridy = 2;
        c.insets = new Insets(5, 40, 5, 0);
        this.m_panel.add((Component)this.m_installInfo, c);
        this.layoutAdminSeparator();
        c.gridy = 3;
        c.insets = new Insets(15, 0, 5, 0);
        this.m_panel.add((Component)this.m_adminPanel, c);
        if (this.m_manageOption != null) {
            c.gridy = 4;
            c.insets = new Insets(5, 20, 5, 0);
            this.m_panel.add((Component)this.m_manageOption, c);
            c.gridy = 5;
            c.insets = new Insets(5, 40, 10, 0);
            this.m_panel.add((Component)this.m_manageInfo, c);
        }
        if (this.m_depotOption != null) {
            c.gridy = 6;
            c.insets = new Insets(5, 20, 5, 0);
            this.m_panel.add((Component)this.m_depotOption, c);
            c.gridy = 7;
            c.insets = new Insets(5, 40, 0, 0);
            this.m_panel.add((Component)this.m_depotInfo, c);
        }
    }

    private void layoutEndUserSeparator() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.anchor = 18;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_endUserPanel.add((Component)this.m_endUserLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_endUserPanel.add((Component)this.m_endUserSeparator, c);
    }

    private void layoutAdminSeparator() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.anchor = 18;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_adminPanel.add((Component)this.m_adminLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_adminPanel.add((Component)this.m_adminSeparator, c);
    }

    private void allowInstall() {
        if (!Globals.g_sourceSSD) {
            String osSuffix = Utils.getOS_Suffix();
            OrderData[] orders = Globals.g_deploymentData.getOrders();
            for (int i = 0; this.m_allowInstall && i < orders.length; ++i) {
                if ("cdrm".equals(orders[i].getMediaType())) {
                    this.m_allowInstall = false;
                } else if (!osSuffix.equalsIgnoreCase("win") && !osSuffix.equalsIgnoreCase("wx6") && orders[i].getVolsers(orders[i].getMediaType()).length > 1) {
                    this.m_allowInstall = false;
                }
                if (!orders[i].isPlanning()) continue;
                this.m_installByDefault = false;
            }
        }
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

