/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.InstallToolConnector;
import com.sas.ssn.Logging;
import com.sas.ssn.ProductData;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Utils;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import com.sas.tools.installs.it.Controller;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class PanelSelectSASFoundationTask
implements WizardPanelIface {
    private SSNResource bundle = new SSNResource(PanelSelectSASFoundationTask.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JTable m_componentTable = null;
    private ComponentTableModel m_componentTableModel = null;
    private ActionListener m_installColumnActionListener = null;
    private JPanel m_buttonPanel = new JPanel(new GridBagLayout());
    private JButton m_selectAllButton = null;
    private JButton m_clearAllButton = null;
    private ArrayList<ProductData> installComponents = null;
    private HashMap<String, ?> m_responseProducts = null;
    private ProductData client_font = null;
    private final String TASK_FONT_REGISTER = "task_fontregister";
    private final String TASK_DESKTOP = "task_desktop";
    private final String TASK_HELP_INDEX = "task_helpindex";
    private final String TASK_FONT_CLIENT = "ttfontsvert";

    public PanelSelectSASFoundationTask() {
        this.m_componentTableModel = new ComponentTableModel();
        this.initialize();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectSASFoundationTask.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectSASFoundationTask.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        String id;
        int i;
        ArrayList<String> componentIds = this.m_componentTableModel.getComponentIds();
        HashMap<String, RepairTasks> components = this.m_componentTableModel.getComponents();
        this.installComponents = new ArrayList();
        Globals.g_sdm_saslicense_required = false;
        for (i = 0; i < componentIds.size(); ++i) {
            id = componentIds.get(i);
            RepairTasks repairTasks = components.get(id);
            if (!repairTasks.doInstall()) continue;
            this.installComponents.add(repairTasks.getRepairTasks());
            if (!repairTasks.getRepairTaskCode().endsWith("task_fontregister")) continue;
            this.installComponents.add(this.client_font);
        }
        Globals.g_repairTasks = this.installComponents;
        if (this.m_componentTableModel.noTasksForRepair()) {
            return false;
        }
        if (this.installComponents.size() == 0) {
            if (Globals.g_quietMode) {
                Logging.log.severe("No tasks are selected for repair.");
            } else {
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectSASFoundationTask.NoTaskSelectedMsg.txt"), this.bundle.getString("Common.Warning.txt"), 2);
                this.m_componentTable.requestFocus();
            }
            return false;
        }
        Globals.g_selectedInstalls = this.installComponents.toArray(new ProductData[0]);
        Globals.g_sdm_saslicense_required = false;
        for (i = 0; i < Globals.g_selectedInstalls.length; ++i) {
            id = Globals.g_selectedInstalls[i].getProdCode();
            if (!id.equals("task_fontregister") && !id.equals("task_desktop") && !id.equals("task_helpindex")) continue;
            Globals.g_sdm_saslicense_required = true;
        }
        if (Globals.g_bitnessSASLocation != null && Globals.g_sdm_saslicense_required && Utils.isSASLicenseValidated(Globals.g_bitnessSASLocation) == 528) {
            if (Globals.g_quietMode) {
                Logging.log.severe("The Base SAS Software product is either not licensed for your system or the product license has expired. Please contact your SAS installation representative.");
            } else {
                Logging.log.severe("The Base SAS Software product is either not licensed for your system or the product license has expired. Please contact your SAS installation representative.");
                CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.getString("PanelSelectSASFoundationTask.InvalidSASLicenseMsg.txt"), this.bundle.getString("Common.Warning.txt"), 2);
                this.m_componentTable.requestFocus();
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        Globals.g_cmtTask = 40;
        return "selectmode";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        this.m_buttonPanel.setVisible(true);
        this.loadResponseData();
        this.populate();
        int rowHeight = Utils.getPreferredRowHeight(this.m_componentTable);
        if (rowHeight > 0) {
            this.m_componentTable.setRowHeight(rowHeight);
        }
    }

    @Override
    public boolean staticHeight() {
        return false;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        return null;
    }

    @Override
    public boolean silentEvent() {
        boolean valid = this.loadResponseData();
        if (valid) {
            this.populate();
            valid = this.validateData();
        }
        return valid;
    }

    @Override
    public String[] responseData() {
        ArrayList<String> data = new ArrayList<String>();
        if (Globals.g_quietMode && Globals.g_recordMode) {
            data.add(" TASK_SELECTION1=");
        } else {
            ArrayList<String> componentIds = this.m_componentTableModel.getComponentIds();
            HashMap<String, RepairTasks> components = this.m_componentTableModel.getComponents();
            int index = 1;
            for (int i = 0; i < componentIds.size(); ++i) {
                String id = componentIds.get(i);
                RepairTasks repairTasks = components.get(id);
                if (!repairTasks.doInstall()) continue;
                data.add(" TASK_SELECTION" + Integer.toString(index++) + "=" + repairTasks.getRepairTaskCode());
            }
        }
        return data.toArray(new String[0]);
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        ConsoleMode.SelectionItem[] options = new ConsoleMode.SelectionItem[this.m_componentTableModel.getComponentIds().size()];
        String id = null;
        RepairTasks repairTasks = null;
        for (int i = 0; i < options.length; ++i) {
            id = this.m_componentTableModel.getComponentIds().get(i);
            repairTasks = this.m_componentTableModel.getComponents().get(id);
            options[i] = new ConsoleMode.SelectionItem(repairTasks.getRepairTasks().getProdName(), repairTasks.doInstall(), true);
        }
        int returnCode = ConsoleMode.promptMultiChoice(options, null);
        if (returnCode > -1) {
            for (int i = 0; i < options.length; ++i) {
                id = this.m_componentTableModel.getComponentIds().get(i);
                repairTasks = this.m_componentTableModel.getComponents().get(id);
                repairTasks.setInstall(options[i].getSelected());
            }
        }
        return returnCode;
    }

    private boolean loadResponseData() {
        boolean valid = true;
        if (valid) {
            this.m_responseProducts = null;
            boolean found = true;
            int productCount = 1;
            String responseProduct = null;
            while (found) {
                responseProduct = Wizard.getResponse("TASK_SELECTION" + Integer.toString(productCount), null);
                if (responseProduct != null) {
                    if (productCount == 1) {
                        this.m_responseProducts = new HashMap();
                    }
                    this.m_responseProducts.put(responseProduct.toLowerCase(Locale.ENGLISH), null);
                } else {
                    if (productCount == 1) {
                        valid = false;
                        if (Globals.g_quietMode) {
                            Wizard.logResponseMissing(this.getHeader(), "TASK_SELECTION" + Integer.toString(productCount));
                        }
                    }
                    found = false;
                }
                ++productCount;
            }
        }
        return valid;
    }

    private void initialize() {
        this.m_componentTable = new JTable(this.m_componentTableModel);
        this.m_componentTable.setCellSelectionEnabled(true);
        this.m_componentTable.setSelectionMode(0);
        this.m_componentTable.setTableHeader(null);
        this.m_componentTable.setShowGrid(false);
        this.m_componentTable.setFillsViewportHeight(true);
        JScrollPane tablePane = new JScrollPane(this.m_componentTable);
        tablePane.setPreferredSize(new Dimension(450, 350));
        String mtxt = this.bundle.getString("Common.SelectAll.txt");
        this.m_selectAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_selectAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_selectAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        mtxt = this.bundle.getString("Common.ClearAll.txt");
        this.m_clearAllButton = new JButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_clearAllButton.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_clearAllButton.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        this.m_installColumnActionListener = new InstallColumnActionListener();
        this.m_selectAllButton.addActionListener(this.m_installColumnActionListener);
        this.m_clearAllButton.addActionListener(this.m_installColumnActionListener);
        GridBagConstraints c = new GridBagConstraints();
        c.gridheight = 1;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 1;
        c.anchor = 18;
        c.insets = new Insets(10, 0, 0, 0);
        this.m_panel.add((Component)tablePane, c);
        this.initButtonPanel();
        c.gridx = 0;
        c.gridy = 5;
        c.gridwidth = 3;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_panel.add((Component)this.m_buttonPanel, c);
    }

    private void initButtonPanel() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 0, 0, 5);
        this.m_buttonPanel.add((Component)this.m_selectAllButton, c);
        c.gridx = 1;
        c.gridy = 0;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 0;
        c.anchor = 17;
        c.insets = new Insets(0, 5, 0, 0);
        this.m_buttonPanel.add((Component)this.m_clearAllButton, c);
        if (this.m_selectAllButton.getPreferredSize().getWidth() < this.m_clearAllButton.getPreferredSize().getWidth()) {
            this.m_selectAllButton.setPreferredSize(this.m_clearAllButton.getPreferredSize());
        } else if (this.m_clearAllButton.getPreferredSize().getWidth() < this.m_selectAllButton.getPreferredSize().getWidth()) {
            this.m_clearAllButton.setPreferredSize(this.m_selectAllButton.getPreferredSize());
        }
    }

    private void installRenderers() {
        this.m_componentTable.getColumnModel().getColumn(0).setCellRenderer(new ComponentDataCellRenderer());
        this.m_componentTable.getColumnModel().getColumn(0).setCellEditor(new ComponentDataCellEditor(new JCheckBox()));
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void focusGained(FocusEvent e) {
        Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
    }

    public void focusLost(FocusEvent e) {
        Globals.g_wizard.getFrame().getRootPane().setDefaultButton(Globals.g_wizard.getNextButton());
    }

    private void populate() {
        this.m_componentTableModel.load();
    }

    public void setupUserProperties() {
        if (Globals.g_installDefaults != null) {
            String name = null;
            String value = null;
            Enumeration e = Globals.g_installDefaults.getNames();
            while (e.hasMoreElements()) {
                name = (String)e.nextElement();
                if (Globals.g_installKnownProps.containsKey(name)) continue;
                value = Globals.g_installDefaults.getDefault(name, null);
                if (Globals.g_mode == 2) {
                    if (Globals.g_installData.getProperty(name, null) != null || value == null) continue;
                    Globals.g_installData.setProperty(name, value);
                    continue;
                }
                if (value == null) continue;
                Globals.g_installData.setProperty(name, value);
            }
        }
        Controller.setInstallProperties(InstallToolConnector.getProperties());
    }

    class ComponentTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 8283934554498211136L;
        public static final int COMPONENT_NAME_COLUMN = 0;
        protected HashMap<String, RepairTasks> m_components = new HashMap();
        protected ArrayList<String> m_componentIds = new ArrayList();

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public String getColumnName(int index) {
            return null;
        }

        public Class<Boolean> getColumnClass(int index) {
            return Boolean.class;
        }

        @Override
        public int getRowCount() {
            return this.m_components.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int colIndex) {
            String id = this.m_componentIds.get(rowIndex);
            boolean selected = false;
            if (id != null) {
                RepairTasks repairTasks = this.m_components.get(id);
                selected = repairTasks.doInstall();
            }
            return selected;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int colIndex) {
            return true;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int colIndex) {
            String id = this.m_componentIds.get(rowIndex);
            if (id != null && value instanceof Boolean && colIndex == 0) {
                RepairTasks repairTasks = this.m_components.get(id);
                repairTasks.setInstall((Boolean)value);
                this.fireTableCellUpdated(rowIndex, colIndex);
            }
        }

        public void load() {
            this.m_components.clear();
            this.m_componentIds.clear();
            Globals.g_repairTasks = this.getSASFounationTasksForRepair();
            this.fireTableDataChanged();
            this.fireTableStructureChanged();
            PanelSelectSASFoundationTask.this.installRenderers();
            PanelSelectSASFoundationTask.this.m_selectAllButton.setEnabled(this.m_components.size() > 0);
            PanelSelectSASFoundationTask.this.m_clearAllButton.setEnabled(this.m_components.size() > 0);
            if (this.noTasksForRepair()) {
                return;
            }
        }

        boolean hasSelected(ProductData productData) {
            if (PanelSelectSASFoundationTask.this.installComponents != null) {
                return PanelSelectSASFoundationTask.this.installComponents.contains(productData);
            }
            return false;
        }

        public void selectAllInstall(boolean value) {
            String id = null;
            RepairTasks repairTasks = null;
            for (int i = 0; i < this.m_componentIds.size(); ++i) {
                id = this.m_componentIds.get(i);
                repairTasks = this.m_components.get(id);
                if (repairTasks == null) continue;
                repairTasks.setInstall(value);
            }
            this.fireTableDataChanged();
        }

        public void clear() {
            this.m_components.clear();
            this.m_componentIds.clear();
            this.fireTableDataChanged();
        }

        public ArrayList<String> getComponentIds() {
            return this.m_componentIds;
        }

        public HashMap<String, RepairTasks> getComponents() {
            return this.m_components;
        }

        public boolean noTasksForRepair() {
            if (this.m_componentIds.size() == 0) {
                if (Globals.g_quietMode) {
                    Logging.log.severe("No tasks are available for repair.");
                } else {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), PanelSelectSASFoundationTask.this.bundle.getString("PanelSelectSASFoundationTask.NoTaskAvailableMsg.txt"), PanelSelectSASFoundationTask.this.bundle.getString("Common.Warning.txt"), 2);
                    PanelSelectSASFoundationTask.this.m_componentTable.requestFocus();
                }
                return true;
            }
            return false;
        }

        private ArrayList<ProductData> getSASFounationTasksForRepair() {
            ArrayList<ProductData> products = new ArrayList<ProductData>();
            File deploymntRegJar = new File(Globals.g_wizardData.getPreference("SASHome", "") + File.separator + "deploymntreg", "sas.tools.deploymntreg.jar");
            String taskName = null;
            if (deploymntRegJar.exists()) {
                RegistryAccess registryAccess = null;
                try {
                    RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                    registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                    registryAccess.open();
                    for (ProductData product : Globals.g_cmtDeploymentData.getAllProducts("000000", true)) {
                        PanelSelectSASFoundationTask.this.client_font = Globals.g_cmtDeploymentData.getProduct("000000", "ttfontsvert", true);
                        PanelSelectSASFoundationTask.this.client_font.setProdName(PanelSelectSASFoundationTask.this.bundle.getString("PanelSelectSASFoundationTask." + PanelSelectSASFoundationTask.this.client_font.getProdCode() + ".label.txt"));
                        if (!product.getProdCode().startsWith("task") || !this.isProductInstalled(registryAccess, "base")) continue;
                        RepairTasks data = new RepairTasks(product, product.getProdCode());
                        if (PanelSelectSASFoundationTask.this.m_responseProducts != null) {
                            if (PanelSelectSASFoundationTask.this.m_responseProducts.containsKey(product.getProdCode())) {
                                data.setInstall(true);
                            } else {
                                data.setInstall(false);
                            }
                        } else {
                            data.setInstall(true);
                        }
                        taskName = PanelSelectSASFoundationTask.this.bundle.getString("PanelSelectSASFoundationTask." + product.getProdCode() + ".label.txt");
                        product.setProdName(taskName);
                        if (Utils.getOS() == 1) {
                            this.m_components.put(product.getProdCode(), data);
                            this.m_componentIds.add(product.getProdCode());
                            products.add(product);
                            continue;
                        }
                        if (product.getProdCode().equals("task_fontregister")) continue;
                        this.m_components.put(product.getProdCode(), data);
                        this.m_componentIds.add(product.getProdCode());
                        products.add(product);
                    }
                }
                catch (FileNotFoundException e) {
                    Logging.logStackTrace(e);
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
                registryAccess.close();
            }
            return products;
        }

        private boolean isProductInstalled(RegistryAccess registryAccess, String code) {
            String[] hosts = registryAccess.getInstallHosts();
            for (int h = 0; hosts != null && hosts.length > 0 && h < hosts.length; ++h) {
                String[] versions = registryAccess.getInstallVersions(code, hosts[h]);
                for (int i = 0; versions != null && versions.length > 0 && i < versions.length; ++i) {
                    File installDir;
                    String installLoc = registryAccess.getInstallLoc(code, versions[i], hosts[h]);
                    if (installLoc == null || !(installDir = new File(installLoc)).exists()) continue;
                    return true;
                }
            }
            return false;
        }
    }

    class RepairTasks {
        protected ProductData m_repairTasks = null;
        protected String m_repairtaskCode = null;
        protected boolean m_install = true;

        public RepairTasks(ProductData repairTasks, String repairtaskCode) {
            this.m_repairTasks = repairTasks;
            this.m_repairtaskCode = repairtaskCode;
        }

        public ProductData getRepairTasks() {
            return this.m_repairTasks;
        }

        public String getRepairTaskCode() {
            return this.m_repairtaskCode;
        }

        public boolean doInstall() {
            return this.m_install;
        }

        public void setInstall(boolean install) {
            this.m_install = install;
        }
    }

    class InstallColumnActionListener
    implements ActionListener {
        InstallColumnActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PanelSelectSASFoundationTask.this.m_selectAllButton) {
                PanelSelectSASFoundationTask.this.m_componentTableModel.selectAllInstall(true);
            } else if (e.getSource() == PanelSelectSASFoundationTask.this.m_clearAllButton) {
                PanelSelectSASFoundationTask.this.m_componentTableModel.selectAllInstall(false);
            }
        }
    }

    private class ComponentDataCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -2422980246659985705L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value == null) {
                this.setText("");
                this.setSelected(false);
                this.setVisible(false);
            } else {
                if (isSelected) {
                    this.setForeground(table.getSelectionForeground());
                    this.setBackground(table.getSelectionBackground());
                } else {
                    this.setForeground(table.getForeground());
                    this.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = PanelSelectSASFoundationTask.this.m_componentTableModel.getComponentIds().get(row);
                    RepairTasks repairTasks = PanelSelectSASFoundationTask.this.m_componentTableModel.getComponents().get(id);
                    this.setText(repairTasks.getRepairTasks().getProdName());
                    this.setSelected(repairTasks.doInstall());
                }
            }
            return this;
        }
    }

    private class ComponentDataCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = -1039755031254835968L;
        private JCheckBox m_checkBox;

        public ComponentDataCellEditor(JCheckBox checkBox) {
            super(checkBox);
            this.m_checkBox = checkBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                this.m_checkBox.setText("");
                this.m_checkBox.setSelected(false);
                this.m_checkBox.setVisible(false);
            } else {
                if (isSelected) {
                    this.m_checkBox.setForeground(table.getSelectionForeground());
                    this.m_checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.m_checkBox.setForeground(table.getForeground());
                    this.m_checkBox.setBackground(table.getBackground());
                }
                if (value instanceof Boolean) {
                    String id = PanelSelectSASFoundationTask.this.m_componentTableModel.getComponentIds().get(row);
                    RepairTasks repairTasks = PanelSelectSASFoundationTask.this.m_componentTableModel.getComponents().get(id);
                    this.m_checkBox.setText(repairTasks.getRepairTasks().getProdName());
                    this.m_checkBox.setSelected(repairTasks.doInstall());
                }
            }
            return this.m_checkBox;
        }
    }
}

