/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConsoleMode;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.PanelStart;
import com.sas.ssn.RegistryAccess;
import com.sas.ssn.RegistryData;
import com.sas.ssn.SSNResource;
import com.sas.ssn.Wizard;
import com.sas.ssn.WizardPanelIface;
import com.sas.swing.visuals.util.Util;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class PanelSelectRenewal
implements WizardPanelIface {
    private final String RESPONSE_RENEWAL = "renewal";
    private final String RESPONSE_UPDATE = "update";
    private SSNResource bundle = new SSNResource(PanelStart.class);
    private JPanel m_panel = new JPanel(new GridBagLayout());
    private JPanel m_renewalPanel = new JPanel(new GridBagLayout());
    private JSeparator m_renewalSeparator = new JSeparator();
    private JTextArea m_renewalLabel = null;
    private JRadioButton m_renewalOption = null;
    private JRadioButton m_updateOption = null;
    private JTextArea m_renewalInfo = null;
    private JTextArea m_updateInfo = null;
    private boolean m_panelLoaded = false;

    public PanelSelectRenewal() {
        this.initialize();
        this.layoutWidgets();
    }

    @Override
    public JPanel getPanel() {
        return this.m_panel;
    }

    @Override
    public String getHeader() {
        return this.bundle.getString("PanelSelectRenewal.Header.txt");
    }

    @Override
    public String getHeaderDesc() {
        return this.bundle.getString("PanelSelectRenewal.HeaderDesc.txt");
    }

    @Override
    public boolean validateData() {
        return true;
    }

    @Override
    public boolean displayPanel() {
        return true;
    }

    @Override
    public String getNextPanelID() {
        if (this.m_renewalOption.isSelected()) {
            Globals.g_cmtTask = 41;
            return "selectlicensestorenew";
        }
        Globals.g_cmtTask = 3;
        return "selectconfigdir";
    }

    @Override
    public void preShowUpdates(Wizard wizardFramework) {
        if (!this.m_panelLoaded) {
            if (!this.loadResponseData()) {
                this.m_renewalOption.setSelected(true);
            }
            this.m_panelLoaded = true;
        }
    }

    @Override
    public boolean staticHeight() {
        return true;
    }

    @Override
    public String getCancelMsg() {
        return null;
    }

    @Override
    public JComponent initialFocus() {
        JRadioButton focus = null;
        focus = this.m_renewalOption.isSelected() ? this.m_renewalOption : this.m_updateOption;
        return focus;
    }

    @Override
    public boolean silentEvent() {
        this.loadResponseData();
        this.validateData();
        return true;
    }

    @Override
    public String[] responseData() {
        if (this.m_renewalOption.isSelected()) {
            return new String[]{" SELECT_RENEWAL=renewal"};
        }
        return new String[]{" SELECT_RENEWAL=update"};
    }

    @Override
    public void initializePanel() {
    }

    @Override
    public void backEvent(String backPanelID) {
    }

    @Override
    public int consoleEvent() {
        JRadioButton[] options = new JRadioButton[]{this.m_renewalOption, this.m_updateOption};
        JTextArea[] infos = new JTextArea[]{this.m_renewalInfo, this.m_updateInfo};
        return ConsoleMode.promptRadioButtons(options, infos);
    }

    private boolean loadResponseData() {
        boolean valid = false;
        String response = Wizard.getResponse("SELECT_RENEWAL", null);
        if (response != null) {
            if (response.equalsIgnoreCase("renewal")) {
                valid = true;
                this.m_renewalOption.setSelected(true);
            } else if (response.equalsIgnoreCase("update")) {
                valid = true;
                this.m_updateOption.setSelected(true);
            } else if (Globals.g_quietMode) {
                this.m_renewalOption.setSelected(true);
            }
        } else if (Globals.g_quietMode) {
            this.m_renewalOption.setSelected(true);
        }
        return valid;
    }

    private boolean isConfigInstalled() {
        File deploymntRegJar = new File(Globals.g_wizardData.getPreference("SASHome", "") + File.separator + "deploymntreg", "sas.tools.deploymntreg.jar");
        if (deploymntRegJar.exists()) {
            RegistryAccess registryAccess = null;
            try {
                RegistryData.setRegistry(Globals.g_wizardData.getPreference("SASHome", ""));
                registryAccess = new RegistryAccess(RegistryData.getDeployRegJar());
                registryAccess.open();
                String[] versions = registryAccess.getConfigLocs();
                if (versions != null && versions.length > 0) {
                    for (int i = 0; i < versions.length; ++i) {
                        File installDir = new File(versions[i]);
                        if (!installDir.exists()) continue;
                        registryAccess.close();
                        return true;
                    }
                }
            }
            catch (FileNotFoundException e) {
                Logging.logStackTrace(e);
            }
            catch (Exception e) {
                Logging.logStackTrace(e);
            }
            registryAccess.close();
        }
        return false;
    }

    private void initialize() {
        boolean isConfigInstalled = this.isConfigInstalled();
        this.m_renewalLabel = new JTextArea(this.bundle.getString("PanelSelectRenewal.renewalLabel.txt"));
        this.m_renewalLabel.setEditable(false);
        this.m_renewalLabel.setFocusable(false);
        this.m_renewalLabel.setLineWrap(false);
        this.m_renewalLabel.setOpaque(false);
        String mtxt = this.bundle.getString("PanelSelectRenewal.renewalOptionLabel.txt");
        this.m_renewalOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_renewalOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_renewalOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        Font optionFont = this.m_renewalOption.getFont();
        this.m_renewalOption.setFont(optionFont.deriveFont(1));
        this.m_renewalInfo = new JTextArea(this.bundle.getString("PanelSelectRenewal.renewalOptionInfo.txt"));
        this.m_renewalInfo.setEditable(false);
        this.m_renewalInfo.setFocusable(false);
        this.m_renewalInfo.setLineWrap(true);
        this.m_renewalInfo.setWrapStyleWord(true);
        this.m_renewalInfo.setOpaque(false);
        mtxt = this.bundle.getString("PanelSelectRenewal.updateOptionLabel.txt");
        this.m_updateOption = new JRadioButton(Util.getLabelWithoutMnemonic(mtxt));
        this.m_updateOption.setMnemonic(Util.getDisplayedMnemonic(mtxt));
        this.m_updateOption.setDisplayedMnemonicIndex(Util.getDisplayedMnemonicIndex(mtxt));
        optionFont = this.m_updateOption.getFont();
        this.m_updateOption.setFont(optionFont.deriveFont(1));
        this.m_updateOption.setEnabled(isConfigInstalled);
        this.m_updateInfo = new JTextArea(this.bundle.getString("PanelSelectRenewal.updateOptionInfo.txt"));
        this.m_updateInfo.setEditable(false);
        this.m_updateInfo.setFocusable(false);
        this.m_updateInfo.setLineWrap(true);
        this.m_updateInfo.setWrapStyleWord(true);
        this.m_updateInfo.setOpaque(false);
        this.m_updateInfo.setEnabled(isConfigInstalled);
        ButtonGroup group = new ButtonGroup();
        group.add(this.m_renewalOption);
        group.add(this.m_updateOption);
    }

    private void layoutWidgets() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.fill = 2;
        c.anchor = 18;
        this.layoutEndUserSeparator();
        c.gridy = 0;
        c.insets = new Insets(0, 0, 5, 0);
        this.m_panel.add((Component)this.m_renewalPanel, c);
        c.gridy = 1;
        c.insets = new Insets(5, 20, 5, 0);
        this.m_panel.add((Component)this.m_renewalOption, c);
        c.gridy = 2;
        c.insets = new Insets(5, 40, 5, 0);
        this.m_panel.add((Component)this.m_renewalInfo, c);
        c.gridy = 3;
        c.insets = new Insets(5, 20, 5, 0);
        this.m_panel.add((Component)this.m_updateOption, c);
        c.gridy = 4;
        c.insets = new Insets(5, 40, 5, 0);
        this.m_panel.add((Component)this.m_updateInfo, c);
    }

    private void layoutEndUserSeparator() {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weighty = 0.0;
        c.anchor = 18;
        c.gridx = 0;
        c.weightx = 0.0;
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        this.m_renewalPanel.add((Component)this.m_renewalLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(5, 5, 0, 0);
        this.m_renewalPanel.add((Component)this.m_renewalSeparator, c);
    }

    @Override
    public String getHelpTopic() {
        return this.getClass().getName().substring(this.getClass().getPackage().getName().length() + 1, this.getClass().getName().length());
    }
}

