/*
 * Decompiled with CFR 0.152.
 */
package com.sas.ssn;

import com.sas.ssn.ConfigStatus;
import com.sas.ssn.CustMsgBox;
import com.sas.ssn.Globals;
import com.sas.ssn.Logging;
import com.sas.ssn.MetadataAccess;
import com.sas.ssn.PanelSelectInstances;
import java.awt.Component;

public class PanelSelectRemoveInstances
extends PanelSelectInstances {
    protected String[] m_columns = null;

    @Override
    protected boolean includeProductsWithNoFQID() {
        return true;
    }

    @Override
    protected String getSubClassName() {
        return PanelSelectRemoveInstances.class.getSimpleName();
    }

    @Override
    protected String[] getColumns() {
        if (this.m_columns == null) {
            this.m_columns = Globals.g_debug ? new String[]{"Instance", "Type", "ID"} : new String[]{"Instance", "Type"};
        }
        return this.m_columns;
    }

    @Override
    protected String getConfigTargetListPropertyName() {
        return "cfgwizard.unconfigure.target.list";
    }

    @Override
    protected boolean validateTableData(PanelSelectInstances.TableData data) {
        boolean valid = true;
        if (data != null && data.getSelected()) {
            String id = data.getValue("ID");
            String prodName = null;
            String prodList = null;
            String[] dependencies = null;
            if (!Globals.g_skipDependencyCheck) {
                dependencies = this.getDependencies(id);
            }
            if (dependencies != null && dependencies.length > 0) {
                valid = false;
                prodName = data.getName();
                prodList = "";
                for (int j = 0; j < dependencies.length; ++j) {
                    if (prodList.length() > 0) {
                        prodList = Globals.g_quietMode ? prodList + ", " : prodList + "\n";
                    }
                    prodList = prodList + MetadataAccess.getObjectName(Globals.g_cmtConnectHost, Globals.g_cmtConnectPort, Globals.g_cmtConnectRepos, Globals.g_cmtConnectUser, Globals.g_cmtConnectPassword, dependencies[j]);
                }
                if (Globals.g_quietMode) {
                    Logging.log.severe("The configuration for " + prodName + " cannot be removed until the following configurations are removed or selected for removal: " + prodList + "\n   Panel: " + this.getHeader() + "\n   Field: " + "CONFIGURATION" + "#");
                } else {
                    CustMsgBox.showMessageDialog((Component)Globals.g_wizard.getFrame(), this.bundle.messageString(this.getSubClassName() + ".DependencyError.txt", prodName, prodList), this.bundle.getString("Common.Warning.txt"), 2);
                    this.m_instanceTable.requestFocus();
                }
            }
        }
        return valid;
    }

    @Override
    public boolean validateData() {
        boolean ret = super.validateData();
        if (ret) {
            Globals.g_cmtUnconfigureAll = this.isAllSelected();
            if (Globals.g_configStatus == null) {
                try {
                    Globals.g_configStatus = ConfigStatus.loadDefaultConfigStatus();
                }
                catch (Exception e) {
                    Logging.logStackTrace(e);
                }
            }
        }
        return ret;
    }

    @Override
    public String getNextPanelID() {
        return "removecontent";
    }
}

